/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.jetbrains.annotations.NotNull;

public class BuiltinWebServerAccess {
    private static final String TOKEN_FILE = "user.token";
    private static String ourUserAuthenticationToken = null;
    private static final Object LOCK = new Object();

    @NotNull
    public static String getUserAuthenticationToken() throws IOException {
        Object object = LOCK;
        synchronized (object) {
            if (ourUserAuthenticationToken != null) {
                return ourUserAuthenticationToken;
            }
            File tokenFile = BuiltinWebServerAccess.getTokenFile();
            if (tokenFile.exists()) {
                ourUserAuthenticationToken = FileUtil.loadFile(tokenFile);
                return ourUserAuthenticationToken;
            }
            throw new IOException("User Authentication Token not found");
        }
    }

    private static File getTokenFile() {
        String configPath = PathManager.getConfigPath();
        File tokenFile = new File(configPath + File.separator + TOKEN_FILE);
        return tokenFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureUserAuthenticationToken() throws NoSuchAlgorithmException, IOException {
        File tokenFile = BuiltinWebServerAccess.getTokenFile();
        if (!tokenFile.exists()) {
            PathManager.ensureConfigFolderExists();
            byte[] seed = SecureRandom.getInstance("SHA1PRNG").generateSeed(24);
            BigInteger intSeed = new BigInteger(seed);
            Object object = LOCK;
            synchronized (object) {
                ourUserAuthenticationToken = intSeed.toString(36);
                FileUtil.writeToFile(tokenFile, ourUserAuthenticationToken);
            }
        }
    }
}

