/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.awt;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativePoint {
    private Component myComponent;
    private Point myPointOnComponent;
    private Component myOriginalComponent;
    private Point myOriginalPoint;

    public RelativePoint(@NotNull MouseEvent event) {
        this.init(event.getComponent(), event.getPoint());
        this.myOriginalComponent = event.getComponent();
        this.myOriginalPoint = event.getPoint();
    }

    public RelativePoint(@NotNull Component aComponent, Point aPointOnComponent) {
        this.init(aComponent, aPointOnComponent);
    }

    public RelativePoint(@NotNull Point screenPoint) {
        Point p = new Point(screenPoint.x, screenPoint.y);
        Window[] windows = Window.getWindows();
        Window targetWindow = null;
        for (Window each : windows) {
            if (!each.isActive()) continue;
            targetWindow = each;
            break;
        }
        if (targetWindow == null) {
            targetWindow = JOptionPane.getRootFrame();
        }
        SwingUtilities.convertPointFromScreen(p, targetWindow);
        this.init(targetWindow, p);
    }

    private void init(@NotNull Component aComponent, Point aPointOnComponent) {
        if (aComponent.isShowing()) {
            this.myComponent = SwingUtilities.getRootPane(aComponent);
            this.myPointOnComponent = SwingUtilities.convertPoint(aComponent, aPointOnComponent, this.myComponent);
        } else {
            this.myComponent = aComponent;
            this.myPointOnComponent = aPointOnComponent;
        }
        this.myOriginalComponent = this.myComponent;
        this.myOriginalPoint = this.myPointOnComponent;
    }

    public Component getComponent() {
        return this.myComponent;
    }

    public Point getPoint() {
        return this.myPointOnComponent;
    }

    public Point getPoint(@Nullable Component aTargetComponent) {
        boolean window = aTargetComponent instanceof Window;
        if (aTargetComponent == null || !window && (aTargetComponent.getParent() == null || SwingUtilities.getWindowAncestor(aTargetComponent) == null)) {
            return new Point();
        }
        return SwingUtilities.convertPoint(this.getComponent(), this.getPoint(), aTargetComponent);
    }

    @NotNull
    public RelativePoint getPointOn(@NotNull Component aTargetComponent) {
        Point point = this.getPoint(aTargetComponent);
        return new RelativePoint(aTargetComponent, point);
    }

    @NotNull
    public Point getScreenPoint() {
        Point point = (Point)this.getPoint().clone();
        SwingUtilities.convertPointToScreen(point, this.getComponent());
        return point;
    }

    @NotNull
    public MouseEvent toMouseEvent() {
        return new MouseEvent(this.myComponent, 0, 0L, 0, this.myPointOnComponent.x, this.myPointOnComponent.y, 1, false);
    }

    @NotNull
    public String toString() {
        return this.getPoint() + " on " + this.getComponent().toString();
    }

    @NotNull
    public static RelativePoint getCenterOf(@NotNull JComponent component) {
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
        return new RelativePoint(component, point);
    }

    @NotNull
    public static RelativePoint getSouthEastOf(@NotNull JComponent component) {
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width, visibleRect.y + visibleRect.height);
        return new RelativePoint(component, point);
    }

    @NotNull
    public static RelativePoint getSouthWestOf(@NotNull JComponent component) {
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x, visibleRect.y + visibleRect.height);
        return new RelativePoint(component, point);
    }

    @NotNull
    public static RelativePoint getNorthWestOf(@NotNull JComponent component) {
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x, visibleRect.y);
        return new RelativePoint(component, point);
    }

    @NotNull
    public static RelativePoint getNorthEastOf(@NotNull JComponent component) {
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width, visibleRect.y);
        return new RelativePoint(component, point);
    }

    @NotNull
    public static RelativePoint fromScreen(Point screenPoint) {
        Frame root = JOptionPane.getRootFrame();
        SwingUtilities.convertPointFromScreen(screenPoint, root);
        return new RelativePoint(root, screenPoint);
    }

    public Component getOriginalComponent() {
        return this.myOriginalComponent;
    }

    public Point getOriginalPoint() {
        return this.myOriginalPoint;
    }
}

