/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Colored;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorUtil {
    private ColorUtil() {
    }

    public static Color softer(@NotNull Color color) {
        if (color.getBlue() > 220 && color.getRed() > 220 && color.getGreen() > 220) {
            return color;
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor(hsb[0], 0.6f * hsb[1], hsb[2]);
    }

    public static Color darker(@NotNull Color color, int tones) {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float brightness = hsb[2];
        for (int i = 0; i < tones && (brightness = Math.max(0.0f, brightness / 1.1f)) != 0.0f; ++i) {
        }
        return Color.getHSBColor(hsb[0], hsb[1], brightness);
    }

    public static Color brighter(@NotNull Color color, int tones) {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float brightness = hsb[2];
        for (int i = 0; i < tones && (brightness = Math.min(1.0f, brightness * 1.1f)) != 1.0f; ++i) {
        }
        return Color.getHSBColor(hsb[0], hsb[1], brightness);
    }

    public static Color dimmer(@NotNull Color color) {
        float[] rgb = color.getRGBColorComponents(null);
        float alpha = 0.8f;
        float rem = 1.0f - alpha;
        return new Color(rgb[0] * alpha + rem, rgb[1] * alpha + rem, rgb[2] * alpha + rem);
    }

    private static int shift(int colorComponent, double d) {
        int n = (int)((double)colorComponent * d);
        return n > 255 ? 255 : (n < 0 ? 0 : n);
    }

    public static Color shift(Color c, double d) {
        return new Color(ColorUtil.shift(c.getRed(), d), ColorUtil.shift(c.getGreen(), d), ColorUtil.shift(c.getBlue(), d), c.getAlpha());
    }

    public static Color withAlpha(Color c, double a) {
        return ColorUtil.toAlpha(c, (int)(255.0 * a));
    }

    public static Color toAlpha(Color color, int a) {
        Color c = color != null ? color : Color.black;
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), a);
    }

    public static Color withAlphaAdjustingDarkness(Color c, double d) {
        return ColorUtil.shift(ColorUtil.withAlpha(c, d), d);
    }

    public static String toHex(@NotNull Color c) {
        String R = Integer.toHexString(c.getRed());
        String G = Integer.toHexString(c.getGreen());
        String B = Integer.toHexString(c.getBlue());
        return (R.length() < 2 ? "0" : "") + R + (G.length() < 2 ? "0" : "") + G + (B.length() < 2 ? "0" : "") + B;
    }

    public static Color fromHex(String str) {
        if ((str = StringUtil.trimStart(str, "#")).length() == 3) {
            return new Color(17 * Integer.valueOf(String.valueOf(str.charAt(0)), 16), 17 * Integer.valueOf(String.valueOf(str.charAt(1)), 16), 17 * Integer.valueOf(String.valueOf(str.charAt(2)), 16));
        }
        if (str.length() == 6) {
            return Color.decode("0x" + str);
        }
        throw new IllegalArgumentException("Should be String of 3 or 6 chars length.");
    }

    @Nullable
    public static Color fromHex(String str, @Nullable Color defaultValue) {
        try {
            return ColorUtil.fromHex(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Nullable
    public static Color getColor(@NotNull Class<?> cls) {
        Colored annotation = cls.getAnnotation(Colored.class);
        if (annotation instanceof Colored) {
            Colored colored = annotation;
            return ColorUtil.fromHex(UIUtil.isUnderDarcula() ? colored.darkVariant() : colored.color(), null);
        }
        return null;
    }

    public static boolean isDark(@NotNull Color c) {
        return 1.0 - (0.299 * (double)c.getRed() + 0.587 * (double)c.getGreen() + 0.114 * (double)c.getBlue()) / 255.0 >= 0.5;
    }

    @NotNull
    public static Color mix(@NotNull Color c1, @NotNull Color c2, double balance) {
        balance = Math.min(1.0, Math.max(0.0, balance));
        return new Color((int)((1.0 - balance) * (double)c1.getRed() + (double)c2.getRed() * balance + 0.5), (int)((1.0 - balance) * (double)c1.getGreen() + (double)c2.getGreen() * balance + 0.5), (int)((1.0 - balance) * (double)c1.getBlue() + (double)c2.getBlue() * balance + 0.5), (int)((1.0 - balance) * (double)c1.getAlpha() + (double)c2.getAlpha() * balance + 0.5));
    }
}

