/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.reference.SoftReference;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.ref.WeakReference;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FocusWatcher
implements ContainerListener,
FocusListener {
    private Component myTopComponent;
    private WeakReference<Component> myFocusedComponent;
    private WeakReference<Component> myNearestFocusableComponent;

    public Component getTopComponent() {
        return this.myTopComponent;
    }

    @Override
    public final void componentAdded(ContainerEvent e) {
        this.installImpl(e.getChild());
    }

    @Override
    public final void componentRemoved(ContainerEvent e) {
        Component removedChild = e.getChild();
        if (this.getNearestFocusableComponent() != null && SwingUtilities.isDescendingFrom(this.getNearestFocusableComponent(), removedChild)) {
            this.setNearestFocusableComponent(null);
        }
        if (this.getFocusedComponent() != null && SwingUtilities.isDescendingFrom(this.getFocusedComponent(), removedChild)) {
            this.setNearestFocusableComponent(e.getContainer());
        }
        this.deinstall(removedChild, e);
    }

    public final void deinstall(Component component) {
        this.deinstall(component, null);
    }

    public final void deinstall(Component component, @Nullable AWTEvent cause) {
        if (component instanceof Container) {
            Container container = (Container)component;
            int componentCount = container.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                this.deinstall(container.getComponent(i));
            }
            container.removeContainerListener(this);
        }
        component.removeFocusListener(this);
        if (this.getFocusedComponent() == component) {
            this.setFocusedComponentImpl(null, cause);
        }
    }

    @Override
    public final void focusGained(FocusEvent e) {
        Component component = e.getComponent();
        if (e.isTemporary() || !component.isShowing()) {
            return;
        }
        if (component instanceof JTextComponent) {
            UIUtil.addUndoRedoActions((JTextComponent)component);
        }
        this.setFocusedComponentImpl(component, e);
        this.setNearestFocusableComponent(component.getParent());
    }

    @Override
    public final void focusLost(FocusEvent e) {
        Component component = e.getOppositeComponent();
        if (component != null && !SwingUtilities.isDescendingFrom(component, this.myTopComponent)) {
            this.focusLostImpl(e);
        }
    }

    public final Component getFocusedComponent() {
        return SoftReference.dereference(this.myFocusedComponent);
    }

    public final Component getNearestFocusableComponent() {
        return SoftReference.dereference(this.myNearestFocusableComponent);
    }

    public final void install(@NotNull Component component) {
        this.myTopComponent = component;
        this.installImpl(component);
    }

    private void installImpl(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            int componentCount = container.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                this.installImpl(container.getComponent(i));
            }
            container.addContainerListener(this);
        }
        if (component instanceof JMenuItem || component instanceof JMenuBar) {
            return;
        }
        component.addFocusListener(this);
    }

    public void setFocusedComponentImpl(Component component) {
        this.setFocusedComponentImpl(component, null);
    }

    public void setFocusedComponentImpl(Component component, @Nullable AWTEvent cause) {
        if (!this.isFocusedComponentChangeValid(component, cause)) {
            return;
        }
        if (UIUtil.isFocusProxy(component)) {
            this._setFocused(this.getFocusedComponent(), cause);
            return;
        }
        this._setFocused(component, cause);
    }

    private void _setFocused(Component component, AWTEvent cause) {
        this.setFocusedComponent(component);
        this.focusedComponentChanged(component, cause);
    }

    protected boolean isFocusedComponentChangeValid(Component comp, AWTEvent cause) {
        return comp != null || cause != null;
    }

    protected void focusedComponentChanged(Component component, @Nullable AWTEvent cause) {
    }

    protected void focusLostImpl(FocusEvent e) {
    }

    private void setFocusedComponent(Component focusedComponent) {
        this.myFocusedComponent = new WeakReference<Component>(focusedComponent);
    }

    private void setNearestFocusableComponent(Component nearestFocusableComponent) {
        this.myNearestFocusableComponent = new WeakReference<Component>(nearestFocusableComponent);
    }
}

