/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.openapi.util.text.StringUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceableDisposable {
    private final Throwable CREATE_TRACE;
    private Throwable KILL_TRACE;

    public TraceableDisposable(boolean debug) {
        this.CREATE_TRACE = debug ? ThrowableInterner.intern(new Throwable()) : null;
    }

    public void kill(@NonNls @Nullable String msg) {
        if (this.CREATE_TRACE != null) {
            this.KILL_TRACE = ThrowableInterner.intern(new Throwable(msg));
        }
    }

    public void killExceptionally(@NotNull Throwable throwable) {
        if (this.CREATE_TRACE != null) {
            this.KILL_TRACE = throwable;
        }
    }

    public void throwObjectNotDisposedError(@NonNls @NotNull String msg) {
        throw new ObjectNotDisposedException(msg);
    }

    public void throwDisposalError(@NonNls String msg) throws RuntimeException {
        throw new DisposalException(msg);
    }

    @NotNull
    public String getStackTrace() {
        StringWriter out = new StringWriter();
        new DisposalException("").printStackTrace(new PrintWriter(out));
        return out.toString();
    }

    private class DisposalException
    extends AbstractDisposalException {
        private DisposalException(String message) {
            super(message);
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            if (TraceableDisposable.this.CREATE_TRACE != null) {
                s.println("--------------Creation trace: ");
                TraceableDisposable.this.CREATE_TRACE.printStackTrace(s);
            }
            if (TraceableDisposable.this.KILL_TRACE != null) {
                s.println("--------------Kill trace: ");
                TraceableDisposable.this.KILL_TRACE.printStackTrace(s);
            }
            s.println("-------------Own trace:");
            super.printStackTrace(s);
        }
    }

    private abstract class AbstractDisposalException
    extends RuntimeException {
        protected AbstractDisposalException(String message) {
            super(message);
        }

        @Override
        public void printStackTrace(@NotNull PrintStream s) {
            PrintWriter writer = new PrintWriter(s);
            this.printStackTrace(writer);
            writer.flush();
        }
    }

    private class ObjectNotDisposedException
    extends AbstractDisposalException {
        ObjectNotDisposedException(String msg) {
            super(msg);
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>(Arrays.asList(TraceableDisposable.this.CREATE_TRACE.getStackTrace()));
            stack.remove(0);
            s.write(ObjectNotDisposedException.class.getCanonicalName() + ": See stack trace responsible for creation of unreleased object below \n\tat " + StringUtil.join(stack, "\n\tat "));
        }
    }
}

