/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import org.jetbrains.annotations.NotNull;

public abstract class NotNullLazyValue<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("NotNullLazyValue");
    private T myValue;

    @NotNull
    protected abstract T compute();

    @NotNull
    public T getValue() {
        T result = this.myValue;
        if (result == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            result = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = result;
            }
        }
        return result;
    }

    @NotNull
    public static <T> NotNullLazyValue<T> createConstantValue(final @NotNull T value) {
        return new NotNullLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                return value;
            }
        };
    }
}

