/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LoggerRt {
    private static Factory ourFactory;

    private static synchronized Factory getFactory() {
        if (ourFactory == null) {
            try {
                ourFactory = new IdeaFactory();
            }
            catch (Throwable t) {
                ourFactory = new JavaFactory();
            }
        }
        return ourFactory;
    }

    @NotNull
    public static LoggerRt getInstance(@NotNull String category) {
        return LoggerRt.getFactory().getInstance(category);
    }

    @NotNull
    public static LoggerRt getInstance(@NotNull Class<?> clazz) {
        return LoggerRt.getInstance('#' + clazz.getName());
    }

    public void info(@Nullable String message) {
        this.info(message, null);
    }

    public void info(@NotNull Throwable t) {
        this.info(t.getMessage(), t);
    }

    public void warn(@Nullable String message) {
        this.warn(message, null);
    }

    public void warn(@NotNull Throwable t) {
        this.warn(t.getMessage(), t);
    }

    public void error(@Nullable String message) {
        this.error(message, null);
    }

    public void error(@NotNull Throwable t) {
        this.error(t.getMessage(), t);
    }

    public abstract void info(@Nullable String var1, @Nullable Throwable var2);

    public abstract void warn(@Nullable String var1, @Nullable Throwable var2);

    public abstract void error(@Nullable String var1, @Nullable Throwable var2);

    private static class IdeaFactory
    implements Factory {
        private final Method myGetInstance;
        private final Method myInfo;
        private final Method myWarn;
        private final Method myError;

        private IdeaFactory() throws Exception {
            Class<?> loggerClass = Class.forName("com.intellij.openapi.diagnostic.Logger");
            this.myGetInstance = loggerClass.getMethod("getInstance", String.class);
            this.myGetInstance.setAccessible(true);
            this.myInfo = loggerClass.getMethod("info", String.class, Throwable.class);
            this.myInfo.setAccessible(true);
            this.myWarn = loggerClass.getMethod("warn", String.class, Throwable.class);
            this.myInfo.setAccessible(true);
            this.myError = loggerClass.getMethod("error", String.class, Throwable.class);
            this.myError.setAccessible(true);
        }

        public LoggerRt getInstance(@NotNull String category) {
            try {
                final Object logger = this.myGetInstance.invoke(null, category);
                return new LoggerRt(){

                    public void info(@Nullable String message, @Nullable Throwable t) {
                        try {
                            IdeaFactory.this.myInfo.invoke(logger, message, t);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    public void warn(@Nullable String message, @Nullable Throwable t) {
                        try {
                            IdeaFactory.this.myWarn.invoke(logger, message, t);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    public void error(@Nullable String message, @Nullable Throwable t) {
                        try {
                            IdeaFactory.this.myError.invoke(logger, message, t);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class JavaFactory
    implements Factory {
        private JavaFactory() {
        }

        public LoggerRt getInstance(@NotNull String category) {
            final Logger logger = Logger.getLogger(category);
            return new LoggerRt(){

                public void info(@Nullable String message, @Nullable Throwable t) {
                    logger.log(Level.INFO, message, t);
                }

                public void warn(@Nullable String message, @Nullable Throwable t) {
                    logger.log(Level.WARNING, message, t);
                }

                public void error(@Nullable String message, @Nullable Throwable t) {
                    logger.log(Level.SEVERE, message, t);
                }
            };
        }
    }

    private static interface Factory {
        public LoggerRt getInstance(@NotNull String var1);
    }
}

