/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.ThreadDump;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadDumper {
    private ThreadDumper() {
    }

    @NotNull
    public static String dumpThreadsToString() {
        StringWriter writer = new StringWriter();
        ThreadDumper.dumpThreadsToFile(ManagementFactory.getThreadMXBean(), writer);
        return writer.toString();
    }

    @NotNull
    public static ThreadDump getThreadDumpInfo(@NotNull ThreadMXBean threadMXBean) {
        StringWriter writer = new StringWriter();
        StackTraceElement[] edtStack = ThreadDumper.dumpThreadsToFile(threadMXBean, writer);
        return new ThreadDump(writer.toString(), edtStack);
    }

    @Nullable
    private static StackTraceElement[] dumpThreadsToFile(@NotNull ThreadMXBean threadMXBean, @NotNull Writer f) {
        StackTraceElement[] edtStack = null;
        boolean dumpSuccessful = false;
        try {
            ThreadInfo[] threads = ThreadDumper.sort(threadMXBean.dumpAllThreads(false, false));
            edtStack = ThreadDumper.dumpThreadInfos(threads, f);
            dumpSuccessful = true;
        }
        catch (Exception threads) {
            // empty catch block
        }
        if (!dumpSuccessful) {
            long[] threadIds = threadMXBean.getAllThreadIds();
            ThreadInfo[] threadInfo = ThreadDumper.sort(threadMXBean.getThreadInfo(threadIds, Integer.MAX_VALUE));
            edtStack = ThreadDumper.dumpThreadInfos(threadInfo, f);
        }
        return edtStack;
    }

    private static StackTraceElement[] dumpThreadInfos(@NotNull ThreadInfo[] threadInfo, @NotNull Writer f) {
        StackTraceElement[] edtStack = null;
        for (ThreadInfo info : threadInfo) {
            if (info == null) continue;
            if (info.getThreadName().equals("AWT-EventQueue-1")) {
                edtStack = info.getStackTrace();
            }
            ThreadDumper.dumpThreadInfo(info, f);
        }
        return edtStack;
    }

    @NotNull
    private static ThreadInfo[] sort(@NotNull ThreadInfo[] threads) {
        Arrays.sort(threads, new Comparator<ThreadInfo>(){

            @Override
            public int compare(ThreadInfo o1, ThreadInfo o2) {
                boolean r2;
                String t1 = o1.getThreadName();
                String t2 = o2.getThreadName();
                if (t1.startsWith("AWT-EventQueue")) {
                    return -1;
                }
                if (t2.startsWith("AWT-EventQueue")) {
                    return 1;
                }
                boolean r1 = o1.getThreadState() == Thread.State.RUNNABLE;
                boolean bl = r2 = o2.getThreadState() == Thread.State.RUNNABLE;
                if (r1 && !r2) {
                    return -1;
                }
                if (r2 && !r1) {
                    return 1;
                }
                return 0;
            }
        });
        return threads;
    }

    private static void dumpThreadInfo(@NotNull ThreadInfo info, @NotNull Writer f) {
        ThreadDumper.dumpCallStack(info, f, info.getStackTrace());
    }

    private static void dumpCallStack(@NotNull ThreadInfo info, @NotNull Writer f, @NotNull StackTraceElement[] stackTraceElements) {
        try {
            StringBuilder sb = new StringBuilder("\"").append(info.getThreadName()).append("\"");
            sb.append(" prio=0 tid=0x0 nid=0x0 ").append(ThreadDumper.getReadableState(info.getThreadState())).append("\n");
            sb.append("     java.lang.Thread.State: ").append((Object)info.getThreadState()).append("\n");
            if (info.getLockName() != null) {
                sb.append(" on ").append(info.getLockName());
            }
            if (info.getLockOwnerName() != null) {
                sb.append(" owned by \"").append(info.getLockOwnerName()).append("\" Id=").append(info.getLockOwnerId());
            }
            if (info.isSuspended()) {
                sb.append(" (suspended)");
            }
            if (info.isInNative()) {
                sb.append(" (in native)");
            }
            f.write(sb + "\n");
            for (StackTraceElement element : stackTraceElements) {
                f.write("\tat " + element.toString() + "\n");
            }
            f.write("\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getReadableState(@NotNull Thread.State state) {
        switch (state) {
            case BLOCKED: {
                return "blocked";
            }
            case TIMED_WAITING: 
            case WAITING: {
                return "waiting on condition";
            }
            case RUNNABLE: {
                return "runnable";
            }
            case NEW: {
                return "new";
            }
            case TERMINATED: {
                return "terminated";
            }
        }
        return null;
    }
}

