/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.util.SystemInfoRt;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BundleBase {
    public static final char MNEMONIC = '\u001b';
    public static boolean assertKeyIsFound = false;

    public static String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue, Object ... params) {
        String value;
        block4: {
            if (bundle == null) {
                return defaultValue;
            }
            try {
                value = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (defaultValue != null) {
                    value = defaultValue;
                }
                value = "!" + key + "!";
                if (!assertKeyIsFound || $assertionsDisabled) break block4;
                throw new AssertionError((Object)("'" + key + "' is not found in " + bundle));
            }
        }
        value = BundleBase.replaceMnemonicAmpersand(value);
        return BundleBase.format(value, params);
    }

    @NotNull
    public static String format(@NotNull String value, Object ... params) {
        if (params.length > 0 && value.indexOf(123) >= 0) {
            return MessageFormat.format(value, params);
        }
        return value;
    }

    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        return BundleBase.messageOrDefault(bundle, key, null, params);
    }

    public static String replaceMnemonicAmpersand(@Nullable String value) {
        if (value == null) {
            return null;
        }
        if (value.indexOf(38) >= 0) {
            boolean useMacMnemonic = value.contains("&&");
            StringBuilder realValue = new StringBuilder();
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '\\') {
                    if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                        realValue.append('&');
                        ++i;
                        continue;
                    }
                    realValue.append(c);
                    continue;
                }
                if (c == '&') {
                    if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                        if (SystemInfoRt.isMac) {
                            realValue.append('\u001b');
                        }
                        ++i;
                        continue;
                    }
                    if (SystemInfoRt.isMac && useMacMnemonic) continue;
                    realValue.append('\u001b');
                    continue;
                }
                realValue.append(c);
            }
            return realValue.toString();
        }
        return value;
    }
}

