/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.internal.web;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.web.WebConfiguration;

public class WebResourceImpl
implements WebConfiguration.WebResource {
    @NotNull
    private final String myWarDirectory;
    @NotNull
    private final String myRelativePath;
    @NotNull
    private final File file;

    public WebResourceImpl(@NotNull String warDirectory, @NotNull String relativePath, @NotNull File file) {
        this.myWarDirectory = warDirectory;
        this.myRelativePath = relativePath;
        this.file = file;
    }

    @NotNull
    public String getWarDirectory() {
        return this.myWarDirectory;
    }

    @NotNull
    public String getRelativePath() {
        return this.myRelativePath;
    }

    @NotNull
    public File getFile() {
        return this.file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebResourceImpl)) {
            return false;
        }
        WebResourceImpl resource = (WebResourceImpl)o;
        if (!this.file.getPath().equals(resource.file.getPath())) {
            return false;
        }
        if (this.myWarDirectory != resource.myWarDirectory) {
            return false;
        }
        return this.myRelativePath.equals(resource.myRelativePath);
    }

    public int hashCode() {
        int result = this.myWarDirectory.hashCode();
        result = 31 * result + this.myRelativePath.hashCode();
        result = 31 * result + this.file.getPath().hashCode();
        return result;
    }

    public String toString() {
        return "WebResourceImpl{myWarDirectory=" + this.myWarDirectory + ", warRelativePath='" + this.myRelativePath + '\'' + ", file=" + this.file + '}';
    }
}

