/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.DefaultExternalFilter;
import org.jetbrains.plugins.gradle.model.ExternalFilter;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;

public class DefaultExternalSourceDirectorySet
implements ExternalSourceDirectorySet {
    private static final long serialVersionUID = 1L;
    @NotNull
    private String myName;
    @NotNull
    private Set<File> mySrcDirs = new HashSet<File>();
    @NotNull
    private File myOutputDir;
    @NotNull
    private Set<String> myExcludes = new HashSet<String>();
    @NotNull
    private Set<String> myIncludes = new HashSet<String>();
    @NotNull
    private List<ExternalFilter> myFilters = new ArrayList<ExternalFilter>();
    private boolean myInheritedCompilerOutput;

    public DefaultExternalSourceDirectorySet() {
    }

    public DefaultExternalSourceDirectorySet(ExternalSourceDirectorySet sourceDirectorySet) {
        this();
        this.myName = sourceDirectorySet.getName();
        this.mySrcDirs = new HashSet<File>(sourceDirectorySet.getSrcDirs());
        this.myOutputDir = sourceDirectorySet.getOutputDir();
        this.myExcludes = new HashSet<String>(sourceDirectorySet.getExcludes());
        this.myIncludes = new HashSet<String>(sourceDirectorySet.getIncludes());
        for (ExternalFilter filter : sourceDirectorySet.getFilters()) {
            this.myFilters.add(new DefaultExternalFilter(filter));
        }
        this.myInheritedCompilerOutput = sourceDirectorySet.isCompilerOutputPathInherited();
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public void setName(@NotNull String name) {
        this.myName = name;
    }

    @NotNull
    public Set<File> getSrcDirs() {
        return this.mySrcDirs;
    }

    public void setSrcDirs(@NotNull Set<File> srcDirs) {
        this.mySrcDirs = srcDirs;
    }

    @NotNull
    public File getOutputDir() {
        return this.myOutputDir;
    }

    public boolean isCompilerOutputPathInherited() {
        return this.myInheritedCompilerOutput;
    }

    public void setInheritedCompilerOutput(boolean inheritedCompilerOutput) {
        this.myInheritedCompilerOutput = inheritedCompilerOutput;
    }

    @NotNull
    public Set<String> getIncludes() {
        return this.myIncludes;
    }

    public void setIncludes(@NotNull Set<String> includes) {
        this.myIncludes = includes;
    }

    @NotNull
    public Set<String> getExcludes() {
        return this.myExcludes;
    }

    public void setExcludes(@NotNull Set<String> excludes) {
        this.myExcludes = excludes;
    }

    @NotNull
    public List<ExternalFilter> getFilters() {
        return this.myFilters;
    }

    public void setFilters(@NotNull List<ExternalFilter> filters) {
        this.myFilters = filters;
    }

    public void setOutputDir(@NotNull File outputDir) {
        this.myOutputDir = outputDir;
    }
}

