/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.sdk;

import com.android.repository.api.Downloader;
import com.android.repository.api.RepoManager;
import com.android.repository.api.SettingsController;
import com.google.common.base.Preconditions;

public class SdkLibData {
    private Downloader mDownloader;
    private SettingsController mSettings;
    private boolean mUseSdkDownload = false;
    private long cacheExpirationPeriod = RepoManager.DEFAULT_EXPIRATION_PERIOD_MS;

    private SdkLibData() {
    }

    private SdkLibData(Downloader downloader, SettingsController settings) {
        this.mDownloader = downloader;
        this.mSettings = settings;
        this.mUseSdkDownload = true;
    }

    public static SdkLibData dontDownload() {
        return new SdkLibData();
    }

    public static SdkLibData download(Downloader downloader, SettingsController settings) {
        return new SdkLibData(downloader, settings);
    }

    public boolean useSdkDownload() {
        return this.mUseSdkDownload;
    }

    public Downloader getDownloader() {
        Preconditions.checkState((boolean)this.mUseSdkDownload, (Object)"The downloader should not be used in this build.");
        return this.mDownloader;
    }

    public SettingsController getSettings() {
        Preconditions.checkState((boolean)this.mUseSdkDownload, (Object)"The settings should not be used in this build.");
        return this.mSettings;
    }

    public void setCacheExpirationPeriod(long cacheExpirationPeriod) {
        this.cacheExpirationPeriod = cacheExpirationPeriod;
    }

    public long getCacheExpirationPeriod() {
        return this.cacheExpirationPeriod;
    }
}

