/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.profile;

import com.android.builder.profile.MemoryStats;
import com.android.builder.profile.NameAnonymizer;
import com.android.builder.profile.ProcessRecorderFactory;
import com.android.builder.profile.ThreadRecorder;
import com.android.tools.analytics.UsageTracker;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.stream.JsonWriter;
import com.google.wireless.android.sdk.stats.AndroidStudioStats;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class ProcessRecorder {
    private final AndroidStudioStats.GradleBuildMemorySample mStartMemoryStats;
    private final NameAnonymizer mNameAnonymizer;
    private final AndroidStudioStats.GradleBuildProfile.Builder mBuild;
    private final LoadingCache<String, Project> mProjects;
    private final ExecutionRecordWriter mExecutionRecordWriter;
    private String benchmarkName;
    private String benchmarkMode;
    private static final AtomicLong lastRecordId = new AtomicLong(1L);

    static long allocateRecordId() {
        return lastRecordId.incrementAndGet();
    }

    @VisibleForTesting
    static void resetForTests() {
        lastRecordId.set(1L);
    }

    static ProcessRecorder get() {
        return ProcessRecorderFactory.sINSTANCE.get();
    }

    ProcessRecorder(ExecutionRecordWriter outWriter, ILogger iLogger) {
        this.mExecutionRecordWriter = outWriter;
        this.mNameAnonymizer = new NameAnonymizer();
        this.mBuild = AndroidStudioStats.GradleBuildProfile.newBuilder();
        this.mStartMemoryStats = this.createAndRecordMemorySample();
        this.mProjects = CacheBuilder.newBuilder().build((CacheLoader)new ProjectCacheLoader(this.mNameAnonymizer));
    }

    void writeRecord(String project, String variant, AndroidStudioStats.GradleBuildProfileSpan.Builder executionRecord) {
        executionRecord.setProject(this.mNameAnonymizer.anonymizeProjectName(project));
        executionRecord.setVariant(this.mNameAnonymizer.anonymizeVariant(project, variant));
        this.mBuild.addSpan(executionRecord.build());
    }

    void finish() throws InterruptedException {
        AndroidStudioStats.GradleBuildMemorySample memoryStats = this.createAndRecordMemorySample();
        this.mBuild.setBuildTime(memoryStats.getTimestamp() - this.mStartMemoryStats.getTimestamp());
        this.mBuild.setGcCount(memoryStats.getGcCount() - this.mStartMemoryStats.getGcCount());
        this.mBuild.setGcTime(memoryStats.getGcTimeMs() - this.mStartMemoryStats.getGcTimeMs());
        for (Project project : this.mProjects.asMap().values()) {
            for (AndroidStudioStats.GradleBuildVariant.Builder variant : project.variants.values()) {
                project.properties.addVariant(variant);
            }
            if (project.properties == null) continue;
            this.mBuild.addProject(project.properties);
        }
        AndroidStudioStats.AndroidStudioEvent.Builder studioStats = AndroidStudioStats.AndroidStudioEvent.newBuilder();
        studioStats.setCategory(AndroidStudioStats.AndroidStudioEvent.EventCategory.GRADLE);
        studioStats.setKind(AndroidStudioStats.AndroidStudioEvent.EventKind.GRADLE_BUILD_PROFILE);
        studioStats.setGradleBuildProfile(this.mBuild.build());
        UsageTracker.getInstance().log(studioStats);
        if (this.mExecutionRecordWriter != null) {
            try {
                this.writeDebugRecords(this.mExecutionRecordWriter);
            }
            catch (IOException e) {
                System.err.println(Throwables.getStackTraceAsString((Throwable)e));
            }
        }
    }

    private void writeDebugRecords(ExecutionRecordWriter writer) throws IOException {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)"build_id", (Object)UUID.randomUUID().toString());
        properties.put((Object)"os_name", (Object)this.mBuild.getOsName());
        properties.put((Object)"os_version", (Object)this.mBuild.getOsVersion());
        properties.put((Object)"java_version", (Object)this.mBuild.getJavaVersion());
        properties.put((Object)"java_vm_version", (Object)this.mBuild.getJavaVmVersion());
        properties.put((Object)"max_memory", (Object)Long.toString(this.mBuild.getMaxMemory()));
        if (this.benchmarkName != null) {
            properties.put((Object)"benchmark_name", (Object)this.benchmarkName);
        }
        if (this.benchmarkMode != null) {
            properties.put((Object)"benchmark_mode", (Object)this.benchmarkMode);
        }
        writer.write(AndroidStudioStats.GradleBuildProfileSpan.newBuilder().setId(1L).setStartTimeInMs(this.mStartMemoryStats.getTimestamp()).setType(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType.INITIAL_METADATA).build(), (Map<String, String>)properties.build());
        Map<Long, Pair<String, Map<Long, String>>> originalNames = this.mNameAnonymizer.createDeanonymizer();
        for (AndroidStudioStats.GradleBuildProfileSpan span : this.mBuild.getSpanList()) {
            Pair<String, Map<Long, String>> project;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            if (span.getProject() != 0L && (project = originalNames.get(span.getProject())) != null) {
                String variant;
                builder.put((Object)"project", project.getFirst());
                if (span.getVariant() != 0L && (variant = (String)((Map)project.getSecond()).get(span.getVariant())) != null) {
                    builder.put((Object)"variant", (Object)variant);
                }
            }
            writer.write(span, (Map<String, String>)builder.build());
        }
        writer.write(AndroidStudioStats.GradleBuildProfileSpan.newBuilder().setId(ThreadRecorder.get().allocationRecordId()).setStartTimeInMs(this.mStartMemoryStats.getTimestamp()).setType(AndroidStudioStats.GradleBuildProfileSpan.ExecutionType.FINAL_METADATA).build(), (Map<String, String>)ImmutableMap.of((Object)"build_time", (Object)Long.toString(this.mBuild.getBuildTime()), (Object)"gc_count", (Object)Long.toString(this.mBuild.getGcCount()), (Object)"gc_time", (Object)Long.toString(this.mBuild.getGcTime())));
    }

    public static AndroidStudioStats.GradleBuildProfile.Builder getGlobalProperties() {
        return ProcessRecorder.get().getProperties();
    }

    AndroidStudioStats.GradleBuildProfile.Builder getProperties() {
        return this.mBuild;
    }

    public static AndroidStudioStats.GradleBuildProject.Builder getProject(String projectPath) {
        return ((Project)ProcessRecorder.get().mProjects.getUnchecked((Object)projectPath)).properties;
    }

    public static AndroidStudioStats.GradleBuildVariant.Builder addVariant(String projectPath, String variantName) {
        AndroidStudioStats.GradleBuildVariant.Builder properties = AndroidStudioStats.GradleBuildVariant.newBuilder();
        ProcessRecorder.get().addVariant(projectPath, variantName, properties);
        return properties;
    }

    private void addVariant(String projectPath, String variantName, AndroidStudioStats.GradleBuildVariant.Builder properties) {
        Project project = (Project)this.mProjects.getUnchecked((Object)projectPath);
        properties.setId(this.mNameAnonymizer.anonymizeVariant(projectPath, variantName));
        project.variants.put(variantName, properties);
    }

    public static void setBenchmark(String benchmarkName, String benchmarkMode) {
        ProcessRecorder recorder = ProcessRecorder.get();
        recorder.benchmarkName = benchmarkName;
        recorder.benchmarkMode = benchmarkMode;
    }

    private AndroidStudioStats.GradleBuildMemorySample createAndRecordMemorySample() {
        AndroidStudioStats.GradleBuildMemorySample stats = MemoryStats.getCurrentProperties();
        if (stats != null) {
            this.mBuild.addMemorySample(stats);
        }
        return stats;
    }

    public static void recordMemorySample() {
        ProcessRecorder.get().createAndRecordMemorySample();
    }

    static class JsonRecordWriter
    implements ExecutionRecordWriter {
        private final Writer writer;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        public JsonRecordWriter(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void write(AndroidStudioStats.GradleBuildProfileSpan executionRecord, Map<String, String> attributes) throws IOException {
            if (this.closed.get()) {
                return;
            }
            JsonWriter mJsonWriter = new JsonWriter(this.writer);
            mJsonWriter.beginObject();
            mJsonWriter.name("id").value(executionRecord.getId());
            mJsonWriter.name("parentId").value(executionRecord.getParentId());
            mJsonWriter.name("startTimeInMs").value(executionRecord.getStartTimeInMs());
            mJsonWriter.name("durationInMs").value(executionRecord.getDurationInMs());
            String type = executionRecord.getType().toString();
            if (executionRecord.hasTask()) {
                type = type + "_" + executionRecord.getTask().getType().toString();
            } else if (executionRecord.hasTransform()) {
                type = type + "_" + executionRecord.getTransform().getType().toString();
            }
            mJsonWriter.name("type").value(type);
            mJsonWriter.name("attributes");
            mJsonWriter.beginArray();
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                mJsonWriter.beginObject();
                mJsonWriter.name("name").value(entry.getKey());
                mJsonWriter.name("value").value(entry.getValue());
                mJsonWriter.endObject();
            }
            mJsonWriter.endArray();
            mJsonWriter.endObject();
            mJsonWriter.flush();
            this.writer.append("\n");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            JsonRecordWriter jsonRecordWriter = this;
            synchronized (jsonRecordWriter) {
                if (this.closed.get()) {
                    return;
                }
                this.closed.set(true);
            }
            this.writer.flush();
            this.writer.close();
        }
    }

    private static class Project {
        final Map<String, AndroidStudioStats.GradleBuildVariant.Builder> variants = Maps.newConcurrentMap();
        final AndroidStudioStats.GradleBuildProject.Builder properties = AndroidStudioStats.GradleBuildProject.newBuilder();

        Project(long id) {
            this.properties.setId(id);
        }
    }

    private static class ProjectCacheLoader
    extends CacheLoader<String, Project> {
        private final NameAnonymizer mNameAnonymizer;

        ProjectCacheLoader(NameAnonymizer nameAnonymizer) {
            this.mNameAnonymizer = nameAnonymizer;
        }

        public Project load(String name) throws Exception {
            return new Project(this.mNameAnonymizer.anonymizeProjectName(name));
        }
    }

    public static interface ExecutionRecordWriter {
        public void write(AndroidStudioStats.GradleBuildProfileSpan var1, Map<String, String> var2) throws IOException;

        public void close() throws IOException;
    }
}

