/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.utils;

import com.google.common.base.Objects;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;

public class CachedFileContents<T> {
    private File mFile;
    private long mLastClosed;
    private long mSize;
    private HashCode mHash;
    private T mCache;

    public CachedFileContents(File file) {
        this.mFile = file;
    }

    public void closed(T cache) {
        this.mCache = cache;
        this.mLastClosed = this.mFile.lastModified();
        this.mSize = this.mFile.length();
        this.mHash = this.hashFile();
    }

    public boolean isValid() {
        boolean valid = true;
        if (!this.mFile.exists()) {
            valid = false;
        }
        if (valid && this.mFile.lastModified() != this.mLastClosed) {
            valid = false;
        }
        if (valid && this.mFile.length() != this.mSize) {
            valid = false;
        }
        if (valid && !Objects.equal((Object)this.mHash, (Object)this.hashFile())) {
            valid = false;
        }
        if (!valid) {
            this.mCache = null;
        }
        return valid;
    }

    public T getCache() {
        return this.mCache;
    }

    private HashCode hashFile() {
        try {
            return Files.hash((File)this.mFile, (HashFunction)Hashing.crc32());
        }
        catch (IOException e) {
            return null;
        }
    }

    public File getFile() {
        return this.mFile;
    }
}

