/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zfile;

import com.android.builder.internal.packaging.zfile.ZFiles;
import com.android.builder.internal.packaging.zip.AlignmentRule;
import com.android.builder.internal.packaging.zip.AlignmentRules;
import com.android.builder.internal.packaging.zip.StoredEntry;
import com.android.builder.internal.packaging.zip.ZFile;
import com.android.builder.internal.packaging.zip.ZFileOptions;
import com.android.builder.packaging.ApkCreator;
import com.android.builder.packaging.ApkCreatorFactory;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.function.Function;
import java.util.function.Predicate;

class ApkZFileCreator
implements ApkCreator {
    private static final AlignmentRule SO_RULE = AlignmentRules.constantForSuffix(".so", 4096);
    private final ZFile mZip;
    private boolean mClosed;
    private final Predicate<String> mNoCompressPredicate;

    ApkZFileCreator(ApkCreatorFactory.CreationData creationData, ZFileOptions options) throws IOException {
        switch (creationData.getNativeLibrariesPackagingMode()) {
            case COMPRESSED: {
                this.mNoCompressPredicate = creationData.getNoCompressPredicate();
                break;
            }
            case UNCOMPRESSED_AND_ALIGNED: {
                this.mNoCompressPredicate = creationData.getNoCompressPredicate().or(name -> name.endsWith(".so"));
                options.setAlignmentRule(AlignmentRules.compose(SO_RULE, options.getAlignmentRule()));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.mZip = ZFiles.apk(creationData.getApkPath(), options, creationData.getPrivateKey(), creationData.getCertificate(), creationData.isV1SigningEnabled(), creationData.isV2SigningEnabled(), creationData.getBuiltBy(), creationData.getCreatedBy(), creationData.getMinSdkVersion());
        this.mClosed = false;
    }

    @Override
    public void writeZip(File zip, Function<String, String> transform, Predicate<String> isIgnored) throws IOException {
        Preconditions.checkState((!this.mClosed ? 1 : 0) != 0, (Object)"mClosed == true");
        Preconditions.checkArgument((boolean)zip.isFile(), (Object)"!zip.isFile()");
        try (Closer closer = Closer.create();){
            ZFile toMerge = (ZFile)closer.register((Closeable)new ZFile(zip));
            Predicate<String> predicate = isIgnored == null ? s -> false : isIgnored;
            this.mZip.mergeFrom(toMerge, predicate);
        }
    }

    @Override
    public void writeFile(File inputFile, String apkPath) throws IOException {
        Preconditions.checkState((!this.mClosed ? 1 : 0) != 0, (Object)"mClosed == true");
        boolean mayCompress = !this.mNoCompressPredicate.test(apkPath);
        try (Closer closer = Closer.create();){
            FileInputStream inputFileStream = (FileInputStream)closer.register((Closeable)new FileInputStream(inputFile));
            this.mZip.add(apkPath, inputFileStream, mayCompress);
        }
    }

    @Override
    public void deleteFile(String apkPath) throws IOException {
        Preconditions.checkState((!this.mClosed ? 1 : 0) != 0, (Object)"mClosed == true");
        StoredEntry entry = this.mZip.get(apkPath);
        if (entry != null) {
            entry.delete();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mZip.close();
        this.mClosed = true;
    }
}

