/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.compiling.DependencyFileProcessor;
import com.android.builder.core.ApkInfoParser;
import com.android.builder.core.BootClasspathBuilder;
import com.android.builder.core.BuildToolsServiceLoader;
import com.android.builder.core.DexByteCodeConverter;
import com.android.builder.core.DexOptions;
import com.android.builder.core.DexProcessBuilder;
import com.android.builder.core.ErrorReporter;
import com.android.builder.core.JackProcessBuilder;
import com.android.builder.core.JackProcessOptions;
import com.android.builder.core.LibraryRequest;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.core.VariantType;
import com.android.builder.files.FileModificationType;
import com.android.builder.files.NativeLibraryAbiPredicate;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.RelativeFiles;
import com.android.builder.internal.SymbolLoader;
import com.android.builder.internal.SymbolWriter;
import com.android.builder.internal.TestManifestGenerator;
import com.android.builder.internal.aapt.Aapt;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.compiler.AidlProcessor;
import com.android.builder.internal.compiler.LeafFolderGatherer;
import com.android.builder.internal.compiler.PreDexCache;
import com.android.builder.internal.compiler.RenderScriptProcessor;
import com.android.builder.internal.compiler.ShaderProcessor;
import com.android.builder.internal.compiler.SourceSearcher;
import com.android.builder.internal.packaging.OldPackager;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.ApkCreatorFactory;
import com.android.builder.packaging.NativeLibrariesPackagingMode;
import com.android.builder.packaging.PackagerException;
import com.android.builder.packaging.SealedPackageException;
import com.android.builder.packaging.ZipAbortException;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.TargetInfo;
import com.android.builder.signing.SignedJarApkCreator;
import com.android.builder.signing.SigningException;
import com.android.ide.common.internal.LoggedErrorException;
import com.android.ide.common.process.CachedProcessOutputHandler;
import com.android.ide.common.process.JavaProcessExecutor;
import com.android.ide.common.process.JavaProcessInfo;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfo;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.signing.KeytoolException;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import com.android.jack.api.ConfigNotSupportedException;
import com.android.jack.api.JackProvider;
import com.android.jack.api.v01.Api01CompilationTask;
import com.android.jack.api.v01.CompilationException;
import com.android.jack.api.v01.ConfigurationException;
import com.android.jack.api.v01.DebugInfoLevel;
import com.android.jack.api.v01.MultiDexKind;
import com.android.jack.api.v01.ReporterKind;
import com.android.jack.api.v01.UnrecoverableException;
import com.android.jack.api.v02.Api02Config;
import com.android.jack.api.v03.Api03Config;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.ManifestSystemProperty;
import com.android.manifmerger.MergingReport;
import com.android.repository.Revision;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.LineCollector;
import com.android.utils.Pair;
import com.android.xml.AndroidManifest;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AndroidBuilder {
    public static final Revision MIN_BUILD_TOOLS_REV = new Revision(19, 1, 0);
    private static final int API_LEVEL_SPLIT_APK = 21;
    private final String mProjectId;
    private final ILogger mLogger;
    private final ProcessExecutor mProcessExecutor;
    private final JavaProcessExecutor mJavaProcessExecutor;
    private final ErrorReporter mErrorReporter;
    private final boolean mVerboseExec;
    private String mCreatedBy;
    private SdkInfo mSdkInfo;
    private TargetInfo mTargetInfo;
    private List<File> mBootClasspathFiltered;
    private List<File> mBootClasspathAll;
    private List<LibraryRequest> mLibraryRequests = ImmutableList.of();
    private DexByteCodeConverter mDexByteCodeConverter = null;

    public AndroidBuilder(String projectId, String createdBy, ProcessExecutor processExecutor, JavaProcessExecutor javaProcessExecutor, ErrorReporter errorReporter, ILogger logger, boolean verboseExec) {
        this.mProjectId = (String)Preconditions.checkNotNull((Object)projectId);
        this.mCreatedBy = createdBy;
        this.mProcessExecutor = (ProcessExecutor)Preconditions.checkNotNull((Object)processExecutor);
        this.mJavaProcessExecutor = (JavaProcessExecutor)Preconditions.checkNotNull((Object)javaProcessExecutor);
        this.mErrorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
        this.mLogger = (ILogger)Preconditions.checkNotNull((Object)logger);
        this.mVerboseExec = verboseExec;
    }

    public void setTargetInfo(TargetInfo targetInfo) {
        this.mTargetInfo = targetInfo;
        this.mDexByteCodeConverter = new DexByteCodeConverter(this.getLogger(), this.mTargetInfo, this.mJavaProcessExecutor, this.mVerboseExec);
        if (this.mTargetInfo.getBuildTools().getRevision().compareTo(MIN_BUILD_TOOLS_REV) < 0) {
            throw new IllegalArgumentException(String.format("The SDK Build Tools revision (%1$s) is too low for project '%2$s'. Minimum required is %3$s", this.mTargetInfo.getBuildTools().getRevision(), this.mProjectId, MIN_BUILD_TOOLS_REV));
        }
    }

    public void setSdkInfo(SdkInfo sdkInfo) {
        this.mSdkInfo = sdkInfo;
    }

    public void setLibraryRequests(Collection<LibraryRequest> libraryRequests) {
        this.mLibraryRequests = ImmutableList.copyOf(libraryRequests);
    }

    public SdkInfo getSdkInfo() {
        return this.mSdkInfo;
    }

    public TargetInfo getTargetInfo() {
        return this.mTargetInfo;
    }

    public ILogger getLogger() {
        return this.mLogger;
    }

    public ErrorReporter getErrorReporter() {
        return this.mErrorReporter;
    }

    public IAndroidTarget getTarget() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getTarget() before setTargetInfo() is called.");
        return this.mTargetInfo.getTarget();
    }

    public boolean isPreviewTarget() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call isTargetAPreview() before setTargetInfo() is called.");
        return this.mTargetInfo.getTarget().getVersion().isPreview();
    }

    public String getTargetCodename() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getTargetCodename() before setTargetInfo() is called.");
        return this.mTargetInfo.getTarget().getVersion().getCodename();
    }

    public List<File> getBootClasspath(boolean includeOptionalLibraries) {
        if (includeOptionalLibraries) {
            return this.computeFullBootClasspath();
        }
        return this.computeFilteredBootClasspath();
    }

    private List<File> computeFilteredBootClasspath() {
        if (this.mBootClasspathFiltered == null) {
            Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getBootClasspath() before setTargetInfo() is called.");
            this.mBootClasspathFiltered = BootClasspathBuilder.computeFilteredClasspath(this.mTargetInfo.getTarget(), this.mLibraryRequests, this.mErrorReporter, this.mSdkInfo.getAnnotationsJar());
        }
        return this.mBootClasspathFiltered;
    }

    private List<File> computeFullBootClasspath() {
        if (this.mBootClasspathAll == null) {
            Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getBootClasspath() before setTargetInfo() is called.");
            this.mBootClasspathAll = BootClasspathBuilder.computeFullBootClasspath(this.mTargetInfo.getTarget(), this.mSdkInfo.getAnnotationsJar());
        }
        return this.mBootClasspathAll;
    }

    public List<String> getBootClasspathAsStrings(boolean includeOptionalLibraries) {
        List<File> classpath = this.getBootClasspath(includeOptionalLibraries);
        ArrayList results = Lists.newArrayListWithCapacity((int)classpath.size());
        for (File f : classpath) {
            results.add(f.getAbsolutePath());
        }
        return results;
    }

    public File getRenderScriptSupportJar() {
        if (this.mTargetInfo != null) {
            return RenderScriptProcessor.getSupportJar(this.mTargetInfo.getBuildTools().getLocation().getAbsolutePath());
        }
        return null;
    }

    public Set<File> getCompileClasspath(VariantConfiguration<?, ?, ?> variantConfiguration) {
        LinkedHashSet compileClasspath = variantConfiguration.getCompileClasspath();
        if (variantConfiguration.getRenderscriptSupportModeEnabled()) {
            File renderScriptSupportJar = this.getRenderScriptSupportJar();
            LinkedHashSet fullJars = Sets.newLinkedHashSetWithExpectedSize((int)(compileClasspath.size() + 1));
            fullJars.addAll(compileClasspath);
            if (renderScriptSupportJar != null) {
                fullJars.add(renderScriptSupportJar);
            }
            compileClasspath = fullJars;
        }
        return compileClasspath;
    }

    public Set<File> getAllPackagedJars(VariantConfiguration<?, ?, ?> variantConfiguration) {
        File renderScriptSupportJar;
        HashSet packagedJars = Sets.newHashSet(variantConfiguration.getAllPackagedJars());
        if (variantConfiguration.getRenderscriptSupportModeEnabled() && (renderScriptSupportJar = this.getRenderScriptSupportJar()) != null) {
            packagedJars.add(renderScriptSupportJar);
        }
        return packagedJars;
    }

    public Set<File> getAdditionalPackagedJars(VariantConfiguration<?, ?, ?> variantConfiguration) {
        File renderScriptSupportJar;
        if (variantConfiguration.getRenderscriptSupportModeEnabled() && (renderScriptSupportJar = this.getRenderScriptSupportJar()) != null) {
            return ImmutableSet.of((Object)renderScriptSupportJar);
        }
        return ImmutableSet.of();
    }

    public File getSupportNativeLibFolder() {
        if (this.mTargetInfo != null) {
            return RenderScriptProcessor.getSupportNativeLibFolder(this.mTargetInfo.getBuildTools().getLocation().getAbsolutePath());
        }
        return null;
    }

    public File getSupportBlasLibFolder() {
        if (this.mTargetInfo != null) {
            return RenderScriptProcessor.getSupportBlasLibFolder(this.mTargetInfo.getBuildTools().getLocation().getAbsolutePath());
        }
        return null;
    }

    public ProcessExecutor getProcessExecutor() {
        return this.mProcessExecutor;
    }

    public ProcessResult executeProcess(ProcessInfo processInfo, ProcessOutputHandler handler) {
        return this.mProcessExecutor.execute(processInfo, handler);
    }

    public void mergeManifestsForApplication(File mainManifest, List<File> manifestOverlays, List<? extends AndroidLibrary> libraries, String packageOverride, int versionCode, String versionName, String minSdkVersion, String targetSdkVersion, Integer maxSdkVersion, String outManifestLocation, String outAaptSafeManifestLocation, String outInstantRunManifestLocation, ManifestMerger2.MergeType mergeType, Map<String, Object> placeHolders, List<ManifestMerger2.Invoker.Feature> optionalFeatures, File reportFile) {
        try {
            ManifestMerger2.Invoker manifestMergerInvoker = ManifestMerger2.newMerger((File)mainManifest, (ILogger)this.mLogger, (ManifestMerger2.MergeType)mergeType).setPlaceHolderValues(placeHolders).addFlavorAndBuildTypeManifests(manifestOverlays.toArray(new File[manifestOverlays.size()])).addLibraryManifests(AndroidBuilder.collectLibraries(libraries)).withFeatures(optionalFeatures.toArray(new ManifestMerger2.Invoker.Feature[optionalFeatures.size()])).setMergeReportFile(reportFile);
            if (mergeType == ManifestMerger2.MergeType.APPLICATION) {
                manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS});
            }
            if (outAaptSafeManifestLocation != null) {
                manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.MAKE_AAPT_SAFE});
            }
            AndroidBuilder.setInjectableValues(manifestMergerInvoker, packageOverride, versionCode, versionName, minSdkVersion, targetSdkVersion, maxSdkVersion);
            MergingReport mergingReport = manifestMergerInvoker.merge();
            this.mLogger.info("Merging result:" + mergingReport.getResult(), new Object[0]);
            switch (mergingReport.getResult()) {
                case WARNING: {
                    mergingReport.log(this.mLogger);
                }
                case SUCCESS: {
                    String instantRunMergedManifest;
                    String xmlDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.MERGED);
                    String annotatedDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.BLAME);
                    if (annotatedDocument != null) {
                        this.mLogger.verbose(annotatedDocument, new Object[0]);
                    }
                    AndroidBuilder.save(xmlDocument, new File(outManifestLocation));
                    this.mLogger.info("Merged manifest saved to " + outManifestLocation, new Object[0]);
                    if (outAaptSafeManifestLocation != null) {
                        AndroidBuilder.save(mergingReport.getMergedDocument(MergingReport.MergedManifestKind.AAPT_SAFE), new File(outAaptSafeManifestLocation));
                    }
                    if (outInstantRunManifestLocation != null && (instantRunMergedManifest = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.INSTANT_RUN)) != null) {
                        AndroidBuilder.save(instantRunMergedManifest, new File(outInstantRunManifestLocation));
                    }
                    break;
                }
                case ERROR: {
                    mergingReport.log(this.mLogger);
                    throw new RuntimeException(mergingReport.getReportString());
                }
                default: {
                    throw new RuntimeException("Unhandled result type : " + mergingReport.getResult());
                }
            }
        }
        catch (ManifestMerger2.MergeFailureException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setInjectableValues(ManifestMerger2.Invoker<?> invoker, String packageOverride, int versionCode, String versionName, String minSdkVersion, String targetSdkVersion, Integer maxSdkVersion) {
        if (!Strings.isNullOrEmpty((String)packageOverride)) {
            invoker.setOverride(ManifestSystemProperty.PACKAGE, packageOverride);
        }
        if (versionCode > 0) {
            invoker.setOverride(ManifestSystemProperty.VERSION_CODE, String.valueOf(versionCode));
        }
        if (!Strings.isNullOrEmpty((String)versionName)) {
            invoker.setOverride(ManifestSystemProperty.VERSION_NAME, versionName);
        }
        if (!Strings.isNullOrEmpty((String)minSdkVersion)) {
            invoker.setOverride(ManifestSystemProperty.MIN_SDK_VERSION, minSdkVersion);
        }
        if (!Strings.isNullOrEmpty((String)targetSdkVersion)) {
            invoker.setOverride(ManifestSystemProperty.TARGET_SDK_VERSION, targetSdkVersion);
        }
        if (maxSdkVersion != null) {
            invoker.setOverride(ManifestSystemProperty.MAX_SDK_VERSION, maxSdkVersion.toString());
        }
    }

    private static void save(String xmlDocument, File out) {
        try {
            Files.createParentDirs((File)out);
            Files.write((CharSequence)xmlDocument, (File)out, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static ImmutableList<Pair<String, File>> collectLibraries(List<? extends AndroidLibrary> libraries) {
        ImmutableList.Builder manifestFiles = ImmutableList.builder();
        if (libraries != null) {
            AndroidBuilder.collectLibraries(libraries, (ImmutableList.Builder<Pair<String, File>>)manifestFiles);
        }
        return manifestFiles.build();
    }

    private static void collectLibraries(List<? extends AndroidLibrary> libraries, ImmutableList.Builder<Pair<String, File>> manifestFiles) {
        for (AndroidLibrary androidLibrary : libraries) {
            if (androidLibrary.isProvided()) continue;
            manifestFiles.add((Object)Pair.of((Object)androidLibrary.getName(), (Object)androidLibrary.getManifest()));
            List manifestDependencies = androidLibrary.getLibraryDependencies();
            if (manifestDependencies.isEmpty()) continue;
            AndroidBuilder.collectLibraries(manifestDependencies, manifestFiles);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mergeManifestsForTestVariant(String testApplicationId, String minSdkVersion, String targetSdkVersion, String testedApplicationId, String instrumentationRunner, Boolean handleProfiling, Boolean functionalTest, String testLabel, File testManifestFile, List<? extends AndroidLibrary> libraries, Map<String, Object> manifestPlaceholders, File outManifest, File tmpDir) throws IOException {
        Preconditions.checkNotNull((Object)testApplicationId, (Object)"testApplicationId cannot be null.");
        Preconditions.checkNotNull((Object)testedApplicationId, (Object)"testedApplicationId cannot be null.");
        Preconditions.checkNotNull((Object)instrumentationRunner, (Object)"instrumentationRunner cannot be null.");
        Preconditions.checkNotNull((Object)handleProfiling, (Object)"handleProfiling cannot be null.");
        Preconditions.checkNotNull((Object)functionalTest, (Object)"functionalTest cannot be null.");
        Preconditions.checkNotNull(libraries, (Object)"libraries cannot be null.");
        Preconditions.checkNotNull((Object)outManifest, (Object)"outManifestLocation cannot be null.");
        File tempFile1 = null;
        File tempFile2 = null;
        try {
            FileUtils.mkdirs((File)tmpDir);
            File generatedTestManifest = libraries.isEmpty() && testManifestFile == null ? outManifest : (tempFile1 = File.createTempFile("manifestMerger", ".xml", tmpDir));
            this.mLogger.verbose("Generating in %1$s", new Object[]{generatedTestManifest.getAbsolutePath()});
            AndroidBuilder.generateTestManifest(testApplicationId, minSdkVersion, targetSdkVersion.equals("-1") ? null : targetSdkVersion, testedApplicationId, instrumentationRunner, handleProfiling, functionalTest, generatedTestManifest);
            if (testManifestFile != null && testManifestFile.exists()) {
                ManifestMerger2.Invoker invoker = ManifestMerger2.newMerger((File)testManifestFile, (ILogger)this.mLogger, (ManifestMerger2.MergeType)ManifestMerger2.MergeType.APPLICATION).setPlaceHolderValues(manifestPlaceholders).setPlaceHolderValue("instrumentationRunner", instrumentationRunner).addLibraryManifest(generatedTestManifest);
                invoker.setOverride(ManifestSystemProperty.PACKAGE, testApplicationId);
                invoker.setOverride(ManifestSystemProperty.MIN_SDK_VERSION, minSdkVersion);
                invoker.setOverride(ManifestSystemProperty.NAME, instrumentationRunner);
                invoker.setOverride(ManifestSystemProperty.TARGET_PACKAGE, testedApplicationId);
                invoker.setOverride(ManifestSystemProperty.FUNCTIONAL_TEST, functionalTest.toString());
                invoker.setOverride(ManifestSystemProperty.HANDLE_PROFILING, handleProfiling.toString());
                if (testLabel != null) {
                    invoker.setOverride(ManifestSystemProperty.LABEL, testLabel);
                }
                if (!targetSdkVersion.equals("-1")) {
                    invoker.setOverride(ManifestSystemProperty.TARGET_SDK_VERSION, targetSdkVersion);
                }
                MergingReport mergingReport = invoker.merge();
                if (libraries.isEmpty()) {
                    this.handleMergingResult(mergingReport, outManifest);
                } else {
                    tempFile2 = File.createTempFile("manifestMerger", ".xml", tmpDir);
                    this.handleMergingResult(mergingReport, tempFile2);
                    generatedTestManifest = tempFile2;
                }
            }
            if (!libraries.isEmpty()) {
                MergingReport mergingReport = ManifestMerger2.newMerger((File)generatedTestManifest, (ILogger)this.mLogger, (ManifestMerger2.MergeType)ManifestMerger2.MergeType.APPLICATION).withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS}).setOverride(ManifestSystemProperty.PACKAGE, testApplicationId).addLibraryManifests(AndroidBuilder.collectLibraries(libraries)).setPlaceHolderValues(manifestPlaceholders).merge();
                this.handleMergingResult(mergingReport, outManifest);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Unable to create the temporary file", e);
                catch (ManifestMerger2.MergeFailureException e2) {
                    throw new RuntimeException("Manifest merging exception", e2);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (tempFile1 != null) {
                        FileUtils.delete(tempFile1);
                    }
                    if (tempFile2 == null) throw throwable;
                    FileUtils.delete(tempFile2);
                    throw throwable;
                }
                catch (IOException e3) {
                    this.mLogger.error((Throwable)e3, "Unable to clean up the temporary files.", new Object[0]);
                }
                throw throwable;
            }
        }
        try {
            if (tempFile1 != null) {
                FileUtils.delete((File)tempFile1);
            }
            if (tempFile2 == null) return;
            FileUtils.delete(tempFile2);
            return;
        }
        catch (IOException e) {
            this.mLogger.error((Throwable)e, "Unable to clean up the temporary files.", new Object[0]);
            return;
        }
    }

    private void handleMergingResult(MergingReport mergingReport, File outFile) {
        switch (mergingReport.getResult()) {
            case WARNING: {
                mergingReport.log(this.mLogger);
            }
            case SUCCESS: {
                try {
                    String annotatedDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.BLAME);
                    if (annotatedDocument != null) {
                        this.mLogger.verbose(annotatedDocument, new Object[0]);
                    } else {
                        this.mLogger.verbose("No blaming records from manifest merger", new Object[0]);
                    }
                }
                catch (Exception e) {
                    this.mLogger.error((Throwable)e, "cannot print resulting xml", new Object[0]);
                }
                String finalMergedDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.MERGED);
                if (finalMergedDocument == null) {
                    throw new RuntimeException("No result from manifest merger");
                }
                try {
                    Files.write((CharSequence)finalMergedDocument, (File)outFile, (Charset)Charsets.UTF_8);
                }
                catch (IOException e) {
                    this.mLogger.error((Throwable)e, "Cannot write resulting xml", new Object[0]);
                    throw new RuntimeException(e);
                }
                this.mLogger.info("Merged manifest saved to " + outFile, new Object[0]);
                break;
            }
            case ERROR: {
                mergingReport.log(this.mLogger);
                throw new RuntimeException(mergingReport.getReportString());
            }
            default: {
                throw new RuntimeException("Unhandled result type : " + mergingReport.getResult());
            }
        }
    }

    private static void generateTestManifest(String testApplicationId, String minSdkVersion, String targetSdkVersion, String testedApplicationId, String instrumentationRunner, Boolean handleProfiling, Boolean functionalTest, File outManifestLocation) {
        TestManifestGenerator generator = new TestManifestGenerator(outManifestLocation, testApplicationId, minSdkVersion, targetSdkVersion, testedApplicationId, instrumentationRunner, handleProfiling, functionalTest);
        try {
            generator.generate();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processResources(Aapt aapt, AaptPackageConfig.Builder aaptConfigBuilder, boolean enforceUniquePackageName) throws IOException, InterruptedException, ProcessException {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call processResources() before setTargetInfo() is called.");
        aaptConfigBuilder.setBuildToolInfo(this.mTargetInfo.getBuildTools());
        aaptConfigBuilder.setAndroidTarget(this.mTargetInfo.getTarget());
        aaptConfigBuilder.setLogger(this.mLogger);
        AaptPackageConfig aaptConfig = aaptConfigBuilder.build();
        try {
            aapt.link(aaptConfig).get();
        }
        catch (Exception e) {
            throw new ProcessException("Failed to execute aapt", (Throwable)e);
        }
        if (aaptConfig.getSourceOutputDir() != null && !aaptConfig.getLibraries().isEmpty()) {
            String msg;
            File manifestFile;
            SymbolLoader fullSymbolValues = null;
            String appPackageName = aaptConfig.getCustomPackageForR();
            if (appPackageName == null && (manifestFile = aaptConfig.getManifestFile()) != null) {
                try {
                    appPackageName = AndroidManifest.getPackage((IAbstractFile)new FileWrapper(manifestFile));
                }
                catch (StreamException streamException) {
                    // empty catch block
                }
            }
            ArrayListMultimap libMap = ArrayListMultimap.create();
            for (AndroidLibrary androidLibrary : aaptConfig.getLibraries()) {
                String packageName;
                if (androidLibrary.isProvided() || Strings.isNullOrEmpty((String)appPackageName)) continue;
                try {
                    packageName = AndroidManifest.getPackage((IAbstractFile)new FileWrapper(androidLibrary.getManifest()));
                }
                catch (StreamException e) {
                    packageName = null;
                }
                if (appPackageName.equals(packageName)) {
                    if (!enforceUniquePackageName) continue;
                    msg = String.format("Error: A library uses the same package as this project: %s", packageName);
                    throw new RuntimeException(msg);
                }
                File rFile = androidLibrary.getSymbolFile();
                if (!rFile.isFile()) continue;
                if (fullSymbolValues == null) {
                    fullSymbolValues = new SymbolLoader(new File(aaptConfig.getSymbolOutputDir(), "R.txt"), this.mLogger);
                    fullSymbolValues.load();
                }
                SymbolLoader libSymbols = new SymbolLoader(rFile, this.mLogger);
                libSymbols.load();
                libMap.put((Object)packageName, (Object)libSymbols);
            }
            for (String string : libMap.keySet()) {
                Collection symbols = libMap.get((Object)string);
                if (enforceUniquePackageName && symbols.size() > 1) {
                    msg = String.format("Error: more than one library with package name '%s'", string);
                    throw new RuntimeException(msg);
                }
                SymbolWriter writer = new SymbolWriter(aaptConfig.getSourceOutputDir().getAbsolutePath(), string, fullSymbolValues, aaptConfig.getVariantType() != VariantType.LIBRARY);
                for (SymbolLoader symbolLoader : symbols) {
                    writer.addSymbolsToWrite(symbolLoader);
                }
                writer.write();
            }
        }
    }

    public void generateApkData(File apkFile, File outResFolder, String mainPkgName, String resName) throws ProcessException, IOException {
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        String aapt = buildToolInfo.getPath(BuildToolInfo.PathId.AAPT);
        if (aapt == null) {
            throw new IllegalStateException("Unable to get aapt location from Build Tools " + buildToolInfo.getRevision());
        }
        ApkInfoParser parser = new ApkInfoParser(new File(aapt), this.mProcessExecutor);
        ApkInfoParser.ApkInfo apkInfo = parser.parseApk(apkFile);
        if (!apkInfo.getPackageName().equals(mainPkgName)) {
            throw new RuntimeException("The main and the micro apps do not have the same package name.");
        }
        String content = String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<wearableApp package=\"%1$s\">\n    <versionCode>%2$s</versionCode>\n    <versionName>%3$s</versionName>\n    <rawPathResId>%4$s</rawPathResId>\n</wearableApp>", apkInfo.getPackageName(), apkInfo.getVersionCode(), apkInfo.getVersionName(), resName);
        File resXmlFile = new File(outResFolder, "xml");
        FileUtils.mkdirs((File)resXmlFile);
        Files.write((CharSequence)content, (File)new File(resXmlFile, "android_wear_micro_apk.xml"), (Charset)Charsets.UTF_8);
    }

    public void generateUnbundledWearApkData(File outResFolder, String mainPkgName) throws ProcessException, IOException {
        String content = String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<wearableApp package=\"%1$s\">\n    <unbundled />\n</wearableApp>", mainPkgName);
        File resXmlFile = new File(outResFolder, "xml");
        FileUtils.mkdirs((File)resXmlFile);
        Files.write((CharSequence)content, (File)new File(resXmlFile, "android_wear_micro_apk.xml"), (Charset)Charsets.UTF_8);
    }

    public static void generateApkDataEntryInManifest(int minSdkVersion, int targetSdkVersion, File manifestFile) throws InterruptedException, LoggedErrorException, IOException {
        StringBuilder content = new StringBuilder();
        content.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n").append("<manifest package=\"\" xmlns:android=\"http://schemas.android.com/apk/res/android\">\n").append("            <uses-sdk android:minSdkVersion=\"").append(minSdkVersion).append("\"");
        if (targetSdkVersion != -1) {
            content.append(" android:targetSdkVersion=\"").append(targetSdkVersion).append("\"");
        }
        content.append("/>\n");
        content.append("    <application>\n").append("        <meta-data android:name=\"com.google.android.wearable.beta.app\"\n").append("                   android:resource=\"@xml/android_wear_micro_apk").append("\" />\n").append("   </application>\n").append("</manifest>\n");
        Files.write((CharSequence)content, (File)manifestFile, (Charset)Charsets.UTF_8);
    }

    public void compileAllAidlFiles(List<File> sourceFolders, File sourceOutputDir, File packagedOutputDir, Collection<String> packageWhiteList, List<File> importFolders, DependencyFileProcessor dependencyFileProcessor, ProcessOutputHandler processOutputHandler) throws IOException, InterruptedException, LoggedErrorException, ProcessException {
        Preconditions.checkNotNull(sourceFolders, (Object)"sourceFolders cannot be null.");
        Preconditions.checkNotNull((Object)sourceOutputDir, (Object)"sourceOutputDir cannot be null.");
        Preconditions.checkNotNull(importFolders, (Object)"importFolders cannot be null.");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call compileAllAidlFiles() before setTargetInfo() is called.");
        IAndroidTarget target = this.mTargetInfo.getTarget();
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        String aidl = buildToolInfo.getPath(BuildToolInfo.PathId.AIDL);
        if (aidl == null || !new File(aidl).isFile()) {
            throw new IllegalStateException("aidl is missing");
        }
        ArrayList fullImportList = Lists.newArrayListWithCapacity((int)(sourceFolders.size() + importFolders.size()));
        fullImportList.addAll(sourceFolders);
        fullImportList.addAll(importFolders);
        AidlProcessor processor = new AidlProcessor(aidl, target.getPath(2), fullImportList, sourceOutputDir, packagedOutputDir, packageWhiteList, dependencyFileProcessor != null ? dependencyFileProcessor : DependencyFileProcessor.NO_OP, this.mProcessExecutor, processOutputHandler);
        SourceSearcher searcher = new SourceSearcher(sourceFolders, "aidl");
        searcher.setUseExecutor(true);
        searcher.search(processor);
    }

    public void compileAidlFile(File sourceFolder, File aidlFile, File sourceOutputDir, File packagedOutputDir, Collection<String> packageWhitelist, List<File> importFolders, DependencyFileProcessor dependencyFileProcessor, ProcessOutputHandler processOutputHandler) throws IOException, InterruptedException, LoggedErrorException, ProcessException {
        Preconditions.checkNotNull((Object)aidlFile, (Object)"aidlFile cannot be null.");
        Preconditions.checkNotNull((Object)sourceOutputDir, (Object)"sourceOutputDir cannot be null.");
        Preconditions.checkNotNull(importFolders, (Object)"importFolders cannot be null.");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call compileAidlFile() before setTargetInfo() is called.");
        IAndroidTarget target = this.mTargetInfo.getTarget();
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        String aidl = buildToolInfo.getPath(BuildToolInfo.PathId.AIDL);
        if (aidl == null || !new File(aidl).isFile()) {
            throw new IllegalStateException("aidl is missing");
        }
        AidlProcessor processor = new AidlProcessor(aidl, target.getPath(2), importFolders, sourceOutputDir, packagedOutputDir, packageWhitelist, dependencyFileProcessor != null ? dependencyFileProcessor : DependencyFileProcessor.NO_OP, this.mProcessExecutor, processOutputHandler);
        processor.processFile(sourceFolder, aidlFile);
    }

    public void compileAllShaderFiles(File sourceFolder, File outputDir, List<String> defaultArgs, Map<String, List<String>> scopedArgs, File nkdLocation, ProcessOutputHandler processOutputHandler) throws IOException, InterruptedException, LoggedErrorException, ProcessException {
        Preconditions.checkNotNull((Object)sourceFolder, (Object)"sourceFolder cannot be null.");
        Preconditions.checkNotNull((Object)outputDir, (Object)"outputDir cannot be null.");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call compileAllShaderFiles() before setTargetInfo() is called.");
        ShaderProcessor processor = new ShaderProcessor(nkdLocation, sourceFolder, outputDir, defaultArgs, scopedArgs, this.mProcessExecutor, processOutputHandler);
        SourceSearcher searcher = new SourceSearcher(sourceFolder, "vert", "tesc", "tese", "geom", "frag", "comp");
        searcher.setUseExecutor(true);
        searcher.search(processor);
    }

    public void compileShaderFile(File sourceFolder, File shaderFile, File outputDir, List<String> defaultArgs, Map<String, List<String>> scopedArgs, File nkdLocation, ProcessOutputHandler processOutputHandler) throws IOException, InterruptedException, LoggedErrorException, ProcessException {
        Preconditions.checkNotNull((Object)sourceFolder, (Object)"sourceFolder cannot be null.");
        Preconditions.checkNotNull((Object)shaderFile, (Object)"aidlFile cannot be null.");
        Preconditions.checkNotNull((Object)outputDir, (Object)"outputDir cannot be null.");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call compileAidlFile() before setTargetInfo() is called.");
        ShaderProcessor processor = new ShaderProcessor(nkdLocation, sourceFolder, outputDir, defaultArgs, scopedArgs, this.mProcessExecutor, processOutputHandler);
        processor.processFile(sourceFolder, shaderFile);
    }

    public void compileAllRenderscriptFiles(List<File> sourceFolders, List<File> importFolders, File sourceOutputDir, File resOutputDir, File objOutputDir, File libOutputDir, int targetApi, boolean debugBuild, int optimLevel, boolean ndkMode, boolean supportMode, Set<String> abiFilters, ProcessOutputHandler processOutputHandler) throws InterruptedException, ProcessException, LoggedErrorException, IOException {
        Preconditions.checkNotNull(sourceFolders, (Object)"sourceFolders cannot be null.");
        Preconditions.checkNotNull(importFolders, (Object)"importFolders cannot be null.");
        Preconditions.checkNotNull((Object)sourceOutputDir, (Object)"sourceOutputDir cannot be null.");
        Preconditions.checkNotNull((Object)resOutputDir, (Object)"resOutputDir cannot be null.");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call compileAllRenderscriptFiles() before setTargetInfo() is called.");
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        String renderscript = buildToolInfo.getPath(BuildToolInfo.PathId.LLVM_RS_CC);
        if (renderscript == null || !new File(renderscript).isFile()) {
            throw new IllegalStateException("llvm-rs-cc is missing");
        }
        RenderScriptProcessor processor = new RenderScriptProcessor(sourceFolders, importFolders, sourceOutputDir, resOutputDir, objOutputDir, libOutputDir, buildToolInfo, targetApi, debugBuild, optimLevel, ndkMode, supportMode, abiFilters, this.mLogger);
        processor.build(this.mProcessExecutor, processOutputHandler);
    }

    @SafeVarargs
    public static List<File> getLeafFolders(String extension, List<File> ... importFolders) {
        ArrayList results = Lists.newArrayList();
        if (importFolders != null) {
            for (List<File> folders : importFolders) {
                SourceSearcher searcher = new SourceSearcher(folders, extension);
                searcher.setUseExecutor(false);
                LeafFolderGatherer processor = new LeafFolderGatherer();
                try {
                    searcher.search(processor);
                }
                catch (LoggedErrorException | ProcessException | IOException | InterruptedException throwable) {
                    // empty catch block
                }
                results.addAll(processor.getFolders());
            }
        }
        return results;
    }

    public DexByteCodeConverter getDexByteCodeConverter() {
        Preconditions.checkState((this.mDexByteCodeConverter != null ? 1 : 0) != 0, (Object)"Cannot call getDexByteCodeConverter() before setTargetInfo() is called.");
        return this.mDexByteCodeConverter;
    }

    public void convertByteCode(Collection<File> inputs, File outDexFolder, boolean multidex, File mainDexList, DexOptions dexOptions, boolean optimize, ProcessOutputHandler processOutputHandler) throws IOException, InterruptedException, ProcessException {
        this.getDexByteCodeConverter().convertByteCode(inputs, outDexFolder, multidex, mainDexList, dexOptions, optimize, processOutputHandler);
    }

    public Set<String> createMainDexList(File allClassesJarFile, File jarOfRoots, EnumSet<MainDexListOption> options) throws ProcessException {
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        String dx = buildToolInfo.getPath(BuildToolInfo.PathId.DX_JAR);
        if (dx == null || !new File(dx).isFile()) {
            throw new IllegalStateException("dx.jar is missing");
        }
        builder.setClasspath(dx);
        builder.setMain("com.android.multidex.ClassReferenceListBuilder");
        if (options.contains((Object)MainDexListOption.DISABLE_ANNOTATION_RESOLUTION_WORKAROUND)) {
            builder.addArgs("--disable-annotation-resolution-workaround");
        }
        builder.addArgs(jarOfRoots.getAbsolutePath());
        builder.addArgs(allClassesJarFile.getAbsolutePath());
        CachedProcessOutputHandler processOutputHandler = new CachedProcessOutputHandler();
        this.mJavaProcessExecutor.execute(builder.createJavaProcess(), (ProcessOutputHandler)processOutputHandler).rethrowFailure().assertNormalExitValue();
        LineCollector lineCollector = new LineCollector();
        processOutputHandler.getProcessOutput().processStandardOutputLines((LineProcessor)lineCollector);
        return ImmutableSet.copyOf((Collection)lineCollector.getResult());
    }

    public void preDexLibrary(File inputFile, File outFile, boolean multiDex, DexOptions dexOptions, boolean optimize, ProcessOutputHandler processOutputHandler) throws IOException, InterruptedException, ProcessException {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call preDexLibrary() before setTargetInfo() is called.");
        this.getLogger().info("AndroidBuilder::preDexLibrary %s", new Object[]{inputFile.getAbsolutePath()});
        if (inputFile.isFile()) {
            PreDexCache.getCache().preDexLibrary(this, inputFile, outFile, multiDex, dexOptions, optimize, processOutputHandler);
        } else {
            this.preDexLibraryNoCache(inputFile, outFile, multiDex, dexOptions, optimize, processOutputHandler);
        }
    }

    public ImmutableList<File> preDexLibraryNoCache(File inputFile, File outFile, boolean multiDex, DexOptions dexOptions, boolean optimize, ProcessOutputHandler processOutputHandler) throws ProcessException, IOException, InterruptedException {
        Preconditions.checkNotNull((Object)inputFile, (Object)"inputFile cannot be null.");
        Preconditions.checkNotNull((Object)outFile, (Object)"outFile cannot be null.");
        Preconditions.checkNotNull((Object)dexOptions, (Object)"dexOptions cannot be null.");
        this.getLogger().info("AndroidBuilder::preDexLibraryNoCache %s", new Object[]{inputFile.getAbsolutePath()});
        try {
            if (!AndroidBuilder.checkLibraryClassesJar(inputFile)) {
                return ImmutableList.of();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while checking library jar", e);
        }
        DexProcessBuilder builder = new DexProcessBuilder(outFile);
        builder.setVerbose(this.mVerboseExec).setMultiDex(multiDex).setNoOptimize(!optimize).addInput(inputFile);
        this.getDexByteCodeConverter().runDexer(builder, dexOptions, processOutputHandler);
        if (multiDex) {
            Object[] files = outFile.listFiles((file, name) -> name.endsWith(".dex"));
            if (files == null || files.length == 0) {
                throw new RuntimeException("No dex files created at " + outFile.getAbsolutePath());
            }
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of((Object)outFile);
    }

    private static boolean checkLibraryClassesJar(File input) throws IOException {
        if (!input.exists()) {
            return false;
        }
        if (input.isDirectory()) {
            return AndroidBuilder.checkFolder(input);
        }
        try (ZipFile zipFile = new ZipFile(input);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.endsWith(".class") && !name.endsWith(".dex")) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private static boolean checkFolder(File folder) {
        File[] subFolders = folder.listFiles();
        if (subFolders != null) {
            for (File childFolder : subFolders) {
                String name;
                if (childFolder.isFile() && ((name = childFolder.getName()).endsWith(".class") || name.endsWith(".dex"))) {
                    return true;
                }
                if (!childFolder.isDirectory() || !AndroidBuilder.checkFolder(childFolder)) continue;
                return true;
            }
        }
        return false;
    }

    public void convertByteCodeUsingJack(JackProcessOptions options, boolean isInProcess) throws ConfigNotSupportedException, ClassNotFoundException, CompilationException, ConfigurationException, UnrecoverableException, ProcessException {
        Revision revision = this.getTargetInfo().getBuildTools().getRevision();
        if (revision.compareTo(JackProcessOptions.JACK_MIN_REV, Revision.PreviewComparison.IGNORE) < 0) {
            throw new ConfigNotSupportedException("Jack requires Build Tools " + JackProcessOptions.JACK_MIN_REV.toString() + " or later");
        }
        if (options.getDexOutputDirectory() != null) {
            FileUtils.mkdirs((File)options.getDexOutputDirectory());
        }
        if (options.getOutputFile() != null) {
            FileUtils.mkdirs((File)options.getOutputFile().getParentFile());
        }
        if (options.getCoverageMetadataFile() != null) {
            try {
                FileUtils.mkdirs((File)options.getCoverageMetadataFile().getParentFile());
            }
            catch (RuntimeException ignored) {
                this.getLogger().warning("Cannot create %1$s directory.", new Object[]{options.getCoverageMetadataFile().getParent()});
            }
        }
        if (options.getIncrementalDir() != null) {
            try {
                FileUtils.mkdirs((File)options.getIncrementalDir());
            }
            catch (RuntimeException ignored) {
                this.getLogger().warning("Cannot create %1$s directory, jack incremental support disabled", new Object[]{options.getIncrementalDir()});
                options.setIncrementalDir(null);
            }
        }
        if (isInProcess) {
            long DEFAULT_SUGGESTED_HEAP_SIZE = 0x60000000L;
            long maxMemory = DexByteCodeConverter.getUserDefinedHeapSize();
            if (0x60000000L > maxMemory) {
                this.mLogger.warning("\nA larger heap for the Gradle daemon is recommended for running jack.\n\nIt currently has %1$d MB.\nFor faster builds, increase the maximum heap size for the Gradle daemon to at least %2$s MB.\nTo do this set org.gradle.jvmargs=-Xmx%2$sM in the project gradle.properties.\nFor more information see https://docs.gradle.org/current/userguide/build_environment.html\n", new Object[]{maxMemory / 0x100000L, 1536L});
            }
            this.convertByteCodeUsingJackApis(options);
        } else {
            this.convertByteCodeUsingJackCli(options, (ProcessOutputHandler)new LoggedProcessOutputHandler(this.getLogger()));
        }
    }

    public void convertByteCodeUsingJackApis(JackProcessOptions options) throws ConfigNotSupportedException, ConfigurationException, CompilationException, UnrecoverableException, ClassNotFoundException {
        boolean isApi03Supported = this.mTargetInfo.getBuildTools().getRevision().compareTo(JackProcessOptions.DOUARN_REV) >= 0;
        BuildToolsServiceLoader.BuildToolServiceLoader buildToolServiceLoader = BuildToolsServiceLoader.INSTANCE.forVersion(this.mTargetInfo.getBuildTools());
        Api01CompilationTask compilationTask = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Optional<JackProvider> jackProvider = buildToolServiceLoader.getSingleService(this.getLogger(), BuildToolsServiceLoader.JACK);
        if (jackProvider.isPresent()) {
            try {
                Api02Config config02;
                Api03Config config03 = null;
                if (isApi03Supported) {
                    config03 = (Api03Config)((JackProvider)jackProvider.get()).createConfig(Api03Config.class);
                    config02 = config03;
                } else {
                    config02 = (Api02Config)((JackProvider)jackProvider.get()).createConfig(Api02Config.class);
                }
                config02.setDebugInfoLevel(options.isDebuggable() ? DebugInfoLevel.FULL : DebugInfoLevel.NONE);
                config02.setClasspath(options.getClasspaths());
                if (options.getDexOutputDirectory() != null) {
                    config02.setOutputDexDir(options.getDexOutputDirectory());
                }
                if (options.getOutputFile() != null) {
                    config02.setOutputJackFile(options.getOutputFile());
                }
                config02.setImportedJackLibraryFiles(options.getImportFiles());
                if (options.getMinSdkVersion() > 0) {
                    config02.setAndroidMinApiLevel(options.getMinSdkVersion());
                }
                config02.setProguardConfigFiles(options.getProguardFiles());
                config02.setJarJarConfigFiles(options.getJarJarRuleFiles());
                if (options.isMultiDex()) {
                    if (options.getMinSdkVersion() < 21) {
                        config02.setMultiDexKind(MultiDexKind.LEGACY);
                    } else {
                        config02.setMultiDexKind(MultiDexKind.NATIVE);
                    }
                }
                config02.setSourceEntries(options.getInputFiles());
                if (options.getMappingFile() != null) {
                    config02.setProperty("jack.obfuscation.mapping.dump", "true");
                    config02.setObfuscationMappingOutputFile(options.getMappingFile());
                }
                config02.setProperty("jack.import.type.policy", "keep-first");
                config02.setProperty("jack.import.resource.policy", "keep-first");
                config02.setReporter(ReporterKind.DEFAULT, (OutputStream)outputStream);
                if (options.getSourceCompatibility() != null) {
                    config02.setProperty("jack.java.source.version", options.getSourceCompatibility());
                }
                if (options.getIncrementalDir() != null && options.getIncrementalDir().exists()) {
                    config02.setIncrementalDir(options.getIncrementalDir());
                }
                ImmutableList.Builder resourcesDir = ImmutableList.builder();
                for (File file : options.getResourceDirectories()) {
                    if (!file.exists()) continue;
                    resourcesDir.add((Object)file);
                }
                config02.setResourceDirs((List)resourcesDir.build());
                config02.setProperty("jack.dex.optimize", Boolean.toString(options.getDexOptimize()));
                if (!options.getAnnotationProcessorNames().isEmpty()) {
                    config02.setProcessorNames(options.getAnnotationProcessorNames());
                }
                if (options.getAnnotationProcessorOutputDirectory() != null) {
                    FileUtils.mkdirs((File)options.getAnnotationProcessorOutputDirectory());
                    config02.setProperty("jack.annotation-processor.source.output", options.getAnnotationProcessorOutputDirectory().getAbsolutePath());
                }
                try {
                    config02.setProcessorPath(options.getAnnotationProcessorClassPath());
                }
                catch (Exception e) {
                    this.mLogger.error((Throwable)e, "Could not resolve annotation processor path.", new Object[0]);
                    throw new RuntimeException(e);
                }
                config02.setProcessorOptions(options.getAnnotationProcessorOptions());
                for (String paramKey : options.getAdditionalParameters().keySet()) {
                    String paramValue = options.getAdditionalParameters().get(paramKey);
                    config02.setProperty(paramKey, paramValue);
                }
                if (options.getCoverageMetadataFile() != null) {
                    if (isApi03Supported) {
                        String coveragePluginPath = this.mTargetInfo.getBuildTools().getPath(BuildToolInfo.PathId.JACK_COVERAGE_PLUGIN);
                        if (coveragePluginPath == null) {
                            this.mLogger.warning("Unknown path id %s.  Disabling code coverage.", new Object[]{BuildToolInfo.PathId.JACK_COVERAGE_PLUGIN});
                        } else {
                            File coveragePlugin = new File(coveragePluginPath);
                            if (coveragePlugin.isFile()) {
                                this.mLogger.warning("Unable to find coverage plugin '%s'.  Disabling code coverage.", new Object[]{coveragePlugin.getAbsolutePath()});
                            } else {
                                config03.setPluginPath((List)ImmutableList.of((Object)new File(coveragePluginPath)));
                                config03.setPluginNames((List)ImmutableList.of((Object)"com.android.jack.coverage.CodeCoveragePlugin"));
                                config03.setProperty("jack.coverage.metadata.file", options.getCoverageMetadataFile().getAbsolutePath());
                            }
                        }
                    } else {
                        config02.setProperty("jack.coverage", "true");
                        config02.setProperty("jack.coverage.metadata.file", options.getCoverageMetadataFile().getAbsolutePath());
                    }
                }
                compilationTask = config02.getTask();
            }
            catch (ConfigNotSupportedException e) {
                this.mLogger.error((Throwable)e, "jack.jar from build tools " + this.mTargetInfo.getBuildTools().getRevision() + " does not support Jack API v02.", new Object[0]);
                throw e;
            }
            catch (ConfigurationException e) {
                this.mLogger.error((Throwable)e, "Jack APIs v02 configuration failed", new Object[0]);
                throw e;
            }
        }
        Preconditions.checkNotNull(compilationTask);
        try {
            compilationTask.run();
            this.mLogger.info(outputStream.toString(), new Object[0]);
        }
        catch (CompilationException | ConfigurationException e) {
            this.mLogger.error(e, outputStream.toString(), new Object[0]);
            throw e;
        }
        catch (UnrecoverableException e) {
            this.mLogger.error((Throwable)e, "Something out of Jack control has happened: " + e.getMessage(), new Object[0]);
            throw e;
        }
    }

    public void convertByteCodeUsingJackCli(JackProcessOptions options, ProcessOutputHandler processOutputHandler) throws ProcessException {
        JackProcessBuilder builder = new JackProcessBuilder(options);
        this.mJavaProcessExecutor.execute(builder.build(this.mTargetInfo.getBuildTools()), processOutputHandler).rethrowFailure().assertNormalExitValue();
    }

    public void createJacocoReportWithJackReporter(File coverageFile, File reportDir, List<File> sourceDirs, String reportName, File metadataFile) throws ProcessException {
        String reporter;
        Preconditions.checkNotNull((Object)coverageFile, (Object)"coverageFile cannot be null.");
        Preconditions.checkNotNull((Object)reportDir, (Object)"reportDir cannot be null.");
        Preconditions.checkNotNull(sourceDirs, (Object)"sourceDir cannot be null.");
        Preconditions.checkNotNull((Object)reportName, (Object)"reportName cannot be null.");
        Preconditions.checkNotNull((Object)metadataFile, (Object)"metadataFile cannot be null.");
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        String jackLocation = System.getenv("USE_JACK_LOCATION");
        String string = reporter = jackLocation != null ? jackLocation + File.separator + "jack-jacoco-reporter.jar" : buildToolInfo.getPath(BuildToolInfo.PathId.JACK_JACOCO_REPORTER);
        if (reporter == null || !new File(reporter).isFile()) {
            throw new IllegalStateException("jack-jacoco-reporter.jar is missing: " + reporter);
        }
        builder.setClasspath(reporter);
        builder.setMain("com.android.jack.tools.jacoco.Main");
        builder.addArgs("--coverage-file", coverageFile.getAbsolutePath());
        builder.addArgs("--metadata-file", metadataFile.getAbsolutePath());
        builder.addArgs("--report-dir", reportDir.getAbsolutePath());
        builder.addArgs("--report-name", reportName);
        for (File sourceDir : sourceDirs) {
            builder.addArgs("--source-dir", sourceDir.getAbsolutePath());
        }
        JavaProcessInfo javaProcessInfo = builder.createJavaProcess();
        ProcessResult result = this.mJavaProcessExecutor.execute(javaProcessInfo, (ProcessOutputHandler)new LoggedProcessOutputHandler(this.getLogger()));
        result.rethrowFailure().assertNormalExitValue();
    }

    public void oldPackageApk(String androidResPkgLocation, Set<File> dexFolders, Collection<File> javaResourcesLocations, Collection<File> jniLibsLocations, File assetsFolder, Set<String> abiFilters, boolean jniDebugBuild, SigningConfig signingConfig, File outApkLocation, int minSdkVersion, Predicate<String> noCompressPredicate) throws KeytoolException, PackagerException, com.android.builder.packaging.SigningException, IOException {
        boolean v2SigningEnabled;
        boolean v1SigningEnabled;
        X509Certificate certificate;
        PrivateKey key;
        Set<RelativeFile> assets;
        Preconditions.checkNotNull((Object)androidResPkgLocation, (Object)"androidResPkgLocation cannot be null.");
        Preconditions.checkNotNull((Object)outApkLocation, (Object)"outApkLocation cannot be null.");
        FileUtils.deleteIfExists((File)outApkLocation);
        HashMap javaResourceMods = Maps.newHashMap();
        HashMap javaResourceArchiveMods = Maps.newHashMap();
        for (File resourceLocation : javaResourcesLocations) {
            if (resourceLocation.isFile()) {
                javaResourceArchiveMods.put(resourceLocation, FileModificationType.NEW);
                continue;
            }
            ImmutableSet<RelativeFile> files = RelativeFiles.fromDirectory(resourceLocation, RelativeFiles.IS_FILE);
            javaResourceMods.putAll(Maps.asMap(files, (Function)Functions.constant((Object)((Object)FileModificationType.NEW))));
        }
        NativeLibraryAbiPredicate nativeLibraryPredicate = new NativeLibraryAbiPredicate(abiFilters, jniDebugBuild);
        HashMap jniMods = Maps.newHashMap();
        HashMap jniArchiveMods = Maps.newHashMap();
        for (File jniLoc : jniLibsLocations) {
            if (jniLoc.isFile()) {
                jniArchiveMods.put(jniLoc, FileModificationType.NEW);
                continue;
            }
            ImmutableSet<RelativeFile> files = RelativeFiles.fromDirectory(jniLoc, RelativeFiles.fromPathPredicate(nativeLibraryPredicate));
            jniMods.putAll(Maps.asMap(files, (Function)Functions.constant((Object)((Object)FileModificationType.NEW))));
        }
        Set<RelativeFile> set = assets = assetsFolder == null ? Collections.emptySet() : RelativeFiles.fromDirectory(assetsFolder, RelativeFiles.IS_FILE);
        if (signingConfig != null && signingConfig.isSigningReady()) {
            CertificateInfo certificateInfo = KeystoreHelper.getCertificateInfo((String)signingConfig.getStoreType(), (File)((File)Preconditions.checkNotNull((Object)signingConfig.getStoreFile())), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getStorePassword())), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getKeyPassword())), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getKeyAlias())));
            key = certificateInfo.getKey();
            certificate = certificateInfo.getCertificate();
            v1SigningEnabled = signingConfig.isV1SigningEnabled();
            v2SigningEnabled = signingConfig.isV2SigningEnabled();
        } else {
            key = null;
            certificate = null;
            v1SigningEnabled = false;
            v2SigningEnabled = false;
        }
        ApkCreatorFactory.CreationData creationData = new ApkCreatorFactory.CreationData(outApkLocation, key, certificate, v1SigningEnabled, v2SigningEnabled, null, this.mCreatedBy, minSdkVersion, NativeLibrariesPackagingMode.COMPRESSED, arg_0 -> noCompressPredicate.apply(arg_0));
        try (OldPackager packager = new OldPackager(creationData, androidResPkgLocation, this.mLogger);){
            if (!dexFolders.isEmpty()) {
                packager.addDexFiles(dexFolders);
            }
            for (Map.Entry resourceUpdate : javaResourceMods.entrySet()) {
                packager.updateResource((RelativeFile)resourceUpdate.getKey(), (FileModificationType)((Object)resourceUpdate.getValue()));
            }
            for (Map.Entry resourceArchiveUpdate : javaResourceArchiveMods.entrySet()) {
                packager.updateResourceArchive((File)resourceArchiveUpdate.getKey(), (FileModificationType)((Object)resourceArchiveUpdate.getValue()), (Predicate<String>)Predicates.alwaysFalse());
            }
            for (Map.Entry jniLibUpdates : jniMods.entrySet()) {
                packager.updateResource((RelativeFile)jniLibUpdates.getKey(), (FileModificationType)((Object)jniLibUpdates.getValue()));
            }
            for (Map.Entry resourceArchiveUpdate : jniArchiveMods.entrySet()) {
                packager.updateResourceArchive((File)resourceArchiveUpdate.getKey(), (FileModificationType)((Object)resourceArchiveUpdate.getValue()), (Predicate<String>)Predicates.not((Predicate)nativeLibraryPredicate));
            }
            for (RelativeFile asset : assets) {
                packager.addFile(asset.getFile(), "assets/" + asset.getOsIndependentRelativePath());
            }
        }
    }

    public void packageCodeSplitApk(String androidResPkgLocation, File dexFile, SigningConfig signingConfig, File outApkLocation) throws KeytoolException, PackagerException, IOException {
        boolean v2SigningEnabled;
        boolean v1SigningEnabled;
        X509Certificate certificate;
        PrivateKey key;
        if (signingConfig != null && signingConfig.isSigningReady()) {
            CertificateInfo certificateInfo = KeystoreHelper.getCertificateInfo((String)signingConfig.getStoreType(), (File)((File)Preconditions.checkNotNull((Object)signingConfig.getStoreFile())), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getStorePassword())), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getKeyPassword())), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getKeyAlias())));
            key = certificateInfo.getKey();
            certificate = certificateInfo.getCertificate();
            v1SigningEnabled = signingConfig.isV1SigningEnabled();
            v2SigningEnabled = signingConfig.isV2SigningEnabled();
        } else {
            key = null;
            certificate = null;
            v1SigningEnabled = false;
            v2SigningEnabled = false;
        }
        ApkCreatorFactory.CreationData creationData = new ApkCreatorFactory.CreationData(outApkLocation, key, certificate, v1SigningEnabled, v2SigningEnabled, null, this.mCreatedBy, 21, NativeLibrariesPackagingMode.COMPRESSED, s -> false);
        try (OldPackager packager = new OldPackager(creationData, androidResPkgLocation, this.mLogger);){
            packager.addFile(dexFile, "classes.dex");
        }
        catch (SealedPackageException e) {
            throw new RuntimeException(e);
        }
    }

    public static void signApk(File in, SigningConfig signingConfig, File out) throws KeytoolException, com.android.builder.packaging.SigningException, NoSuchAlgorithmException, ZipAbortException, SigningException, IOException {
        boolean v2SigningEnabled;
        boolean v1SigningEnabled;
        X509Certificate certificate;
        PrivateKey key;
        if (signingConfig != null && signingConfig.isSigningReady()) {
            CertificateInfo certificateInfo = KeystoreHelper.getCertificateInfo((String)signingConfig.getStoreType(), (File)((File)Preconditions.checkNotNull((Object)signingConfig.getStoreFile())), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getStorePassword())), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getKeyPassword())), (String)((String)Preconditions.checkNotNull((Object)signingConfig.getKeyAlias())));
            key = certificateInfo.getKey();
            certificate = certificateInfo.getCertificate();
            v1SigningEnabled = signingConfig.isV1SigningEnabled();
            v2SigningEnabled = signingConfig.isV2SigningEnabled();
        } else {
            key = null;
            certificate = null;
            v1SigningEnabled = false;
            v2SigningEnabled = false;
        }
        ApkCreatorFactory.CreationData creationData = new ApkCreatorFactory.CreationData(out, key, certificate, v1SigningEnabled, v2SigningEnabled, null, null, 1, NativeLibrariesPackagingMode.COMPRESSED, s -> false);
        try (SignedJarApkCreator signedJarBuilder = new SignedJarApkCreator(creationData);){
            signedJarBuilder.writeZip(in);
        }
    }

    public String getCreatedBy() {
        return this.mCreatedBy;
    }

    public static enum MainDexListOption {
        DISABLE_ANNOTATION_RESOLUTION_WORKAROUND;

    }
}

