/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp;

import com.android.tools.ndk.run.lldb.renderers.TemplateParamsParser;
import com.android.tools.ndk.run.lldb.renderers.TypeNameFormatterCategory;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class StringTypeNameFormatter
implements TypeNameFormatterCategory.TypeNameFormatter {
    private static final HashMap<String, String> myCharTypeToStringTypeMap = new HashMap();

    @Override
    public String format(@NotNull String input) {
        ArrayList<String> templateParams = TemplateParamsParser.getTemplateParams(input);
        if (templateParams == null || templateParams.size() == 0) {
            return input;
        }
        String charType = templateParams.get(0);
        if (templateParams.size() > 1 && !templateParams.get(1).contentEquals("std::char_traits<" + charType + ">")) {
            return input;
        }
        if (templateParams.size() > 2 && !templateParams.get(2).contentEquals("std::allocator<" + charType + ">")) {
            return input;
        }
        if (templateParams.size() > 3) {
            return input;
        }
        String output = (String)myCharTypeToStringTypeMap.get((Object)charType);
        if (output != null) {
            return output;
        }
        return input;
    }

    static {
        myCharTypeToStringTypeMap.put((Object)"char", (Object)"std::string");
        myCharTypeToStringTypeMap.put((Object)"wchar_t", (Object)"std::wstring");
        myCharTypeToStringTypeMap.put((Object)"char16_t", (Object)"std::u16string");
        myCharTypeToStringTypeMap.put((Object)"char32_t", (Object)"std::u32string");
    }
}

