/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.ndk.run.AttachProgressReporter;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.FutureResult;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class SessionStarter {
    private static final Logger LOG = Logger.getInstance(SessionStarter.class);
    protected final JdwpConnector myJdwpConnector;
    protected final Client myClient;
    protected final NativeAndroidDebuggerState myDebuggerState;
    private final String myPlatformSocketName;
    protected final AttachProgressReporter myProgressReporter;
    protected final ProcessHandlerLaunchStatus myLaunchStatus;
    protected final ConsolePrinter myPrinter;
    protected final File myLocalServerFile;
    protected final File myLocalStartScriptFile;
    protected FileStat myServerTempFile;
    protected FileStat myStartScriptTempFile;

    protected SessionStarter(@NotNull JdwpConnector jdwpConnector, @NotNull Client client, @NotNull File localServerFile, @NotNull File localStartScriptFile, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull AttachProgressReporter progressReporter, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws com.intellij.execution.ExecutionException {
        this.myJdwpConnector = jdwpConnector;
        this.myClient = client;
        this.myDebuggerState = debuggerState;
        this.myPlatformSocketName = String.format("platform-%d.sock", System.currentTimeMillis());
        this.myProgressReporter = progressReporter;
        this.myLaunchStatus = launchStatus;
        this.myPrinter = printer;
        this.myLocalServerFile = localServerFile;
        this.myLocalStartScriptFile = localStartScriptFile;
    }

    public void pushFilesToDevice() throws com.intellij.execution.ExecutionException {
        try (SyncService syncService = null;){
            syncService = this.myClient.getDevice().getSyncService();
            if (syncService == null) {
                throw new com.intellij.execution.ExecutionException("Failed to get SyncService");
            }
            this.myServerTempFile = this.pushDebuggerFile(syncService, this.myLocalServerFile);
            this.myStartScriptTempFile = this.pushDebuggerFile(syncService, this.myLocalStartScriptFile);
        }
    }

    @NotNull
    public Attachment getLogFilesFromDevice() throws com.intellij.execution.ExecutionException {
        try {
            StringBuilder builder = new StringBuilder();
            for (String targetFile : new String[]{"gdb-server.log", "platform.log"}) {
                String targetPath = this.getTargetLogFilePath(targetFile);
                CollectingOutputReceiver receiver = new CollectingOutputReceiver();
                this.myClient.getDevice().executeShellCommand("cat '" + targetPath + "'", (IShellOutputReceiver)receiver, 30L, TimeUnit.SECONDS);
                builder.append(targetPath).append(":\n").append(receiver.getOutput());
            }
            return new Attachment(this.getTargetLogDirectory(), builder.toString());
        }
        catch (Exception e) {
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
    }

    protected void connectJdwp() throws com.intellij.execution.ExecutionException {
        final FutureResult connectResult = new FutureResult();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    SessionStarter.this.myJdwpConnector.Connect();
                    connectResult.set(null);
                }
                catch (com.intellij.execution.ExecutionException e) {
                    connectResult.setException((Throwable)e);
                }
            }
        }, ModalityState.any());
        try {
            connectResult.get();
        }
        catch (InterruptedException e) {
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof com.intellij.execution.ExecutionException) {
                throw (com.intellij.execution.ExecutionException)cause;
            }
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
    }

    public String startServer() throws com.intellij.execution.ExecutionException {
        String startCmd = this.getStartCommandLine();
        LOG.info("Starting LLDB server: " + startCmd);
        this.myProgressReporter.step("Starting LLDB server");
        this.myPrinter.stdout("Starting LLDB server: " + startCmd);
        this.internalStartServer();
        return this.getConnectUrl();
    }

    protected abstract void internalStartServer() throws com.intellij.execution.ExecutionException;

    public abstract void resumeVm() throws com.intellij.execution.ExecutionException;

    @NotNull
    protected String getStartCommandLine() {
        return String.format("%s %s %s %s %s \"%s\"", this.getStartScriptTargetPath(), this.getTargetRootDirectory(), "unix-abstract", this.getTargetSocketDirectory(), this.myPlatformSocketName, this.myDebuggerState.getTargetLoggingChannels());
    }

    @NotNull
    protected String getConnectUrl() {
        return String.format("%s-connect://[%s]%s/%s", "unix-abstract", this.myClient.getDevice().getSerialNumber(), this.getTargetSocketDirectory(), this.myPlatformSocketName);
    }

    @NotNull
    protected String getTargetDataDir() {
        return this.myClient.getClientData().getDataDir();
    }

    @NotNull
    protected String getTargetRootDirectory() {
        return SessionStarter.joinPaths(this.getTargetDataDir(), "lldb");
    }

    @NotNull
    protected String getTargetBinDirectory() {
        return SessionStarter.joinPaths(this.getTargetRootDirectory(), "bin");
    }

    @NotNull
    protected String getTargetLogDirectory() {
        return SessionStarter.joinPaths(this.getTargetRootDirectory(), "log");
    }

    @NotNull
    protected String getTargetLogFilePath(@NotNull String file) {
        return SessionStarter.joinPaths(this.getTargetLogDirectory(), file);
    }

    @NotNull
    protected String getTargetBinFilePath(@NotNull String filePath) {
        return SessionStarter.joinPaths(this.getTargetBinDirectory(), filePath);
    }

    @NotNull
    protected String getStartScriptTargetPath() {
        return this.getTargetBinFilePath("start_lldb_server.sh");
    }

    @NotNull
    protected String getTargetSocketDirectory() {
        return SessionStarter.joinPaths(this.getTargetRootDirectory(), "tmp");
    }

    @NotNull
    protected static String joinPaths(String ... paths) {
        return StringUtil.join((String[])paths, (String)"/");
    }

    @NotNull
    private FileStat pushDebuggerFile(@NotNull SyncService syncService, @NotNull File localFile) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException, ShellCommandUnresponsiveException {
        IDevice device = this.myClient.getDevice();
        String fileName = localFile.getName();
        String tmpDestFile = SessionStarter.joinPaths("/data/local/tmp", fileName);
        Date localFileLmt = new Date(localFile.lastModified() / 1000L * 1000L);
        SyncService.FileStat destFileStat = syncService.statFile(tmpDestFile);
        if (destFileStat == null || destFileStat.getMode() == 0 || !localFileLmt.equals(destFileStat.getLastModified()) || localFile.length() != (long)destFileStat.getSize()) {
            LOG.info("Pushing to the device: " + localFile + " => " + tmpDestFile);
            device.pushFile(localFile.getAbsolutePath(), tmpDestFile);
        } else {
            LOG.info("Remote file " + tmpDestFile + " is up-to-date.");
        }
        return new FileStat(tmpDestFile, destFileStat == null ? 0L : destFileStat.getLastModified().getTime());
    }

    @NotNull
    public JdwpConnector getJdwpConnector() {
        return this.myJdwpConnector;
    }

    protected static class FileStat {
        private final String myFilePath;
        private final long myLastModified;

        public FileStat(@NotNull String filePath, long lastModified) {
            this.myFilePath = filePath;
            this.myLastModified = lastModified;
        }

        @NotNull
        public String getFilePath() {
            return this.myFilePath;
        }

        public long getLastModified() {
            return this.myLastModified;
        }
    }
}

