/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.ndk.run.AndroidNativeDeviceException;
import com.android.tools.ndk.run.AttachProgressReporter;
import com.android.tools.ndk.run.ClientShellHelper;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.RootSessionStarterImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class RunAsSessionStarterImpl
extends RootSessionStarterImpl {
    private static final Logger LOG = Logger.getInstance(RunAsSessionStarterImpl.class);
    private final ClientShellHelper myShellHelper;

    public RunAsSessionStarterImpl(@NotNull JdwpConnector jdwpConnector, @NotNull Client client, @NotNull File localServerFile, @NotNull File localStartScriptFile, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull AttachProgressReporter progressReporter, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        super(jdwpConnector, client, localServerFile, localStartScriptFile, debuggerState, progressReporter, launchStatus, printer);
        try {
            this.myShellHelper = new ClientShellHelper(client);
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    @Override
    @NotNull
    protected String executeCommand(@NotNull String command, long maxTimeToOutputResponse, TimeUnit maxTimeUnits) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, AndroidNativeDeviceException {
        String output = super.executeCommand(command, maxTimeToOutputResponse, maxTimeUnits);
        String runAsBrokenMessage = String.format("run-as: Package '%s' is unknown", this.myClient.getClientData().getClientDescription());
        if (output.startsWith(runAsBrokenMessage)) {
            String errorMessage = "run-as is broken (please see http://b.android.com/187955 for details)";
            LOG.error("run-as is broken (please see http://b.android.com/187955 for details)");
            throw new AndroidNativeDeviceException("run-as is broken (please see http://b.android.com/187955 for details)");
        }
        return output;
    }

    @Override
    @NotNull
    protected String getClientCommand(@NotNull String command) {
        return this.myShellHelper.getRunAsCommand(command);
    }

    @Override
    @NotNull
    protected String getTargetDataDir() {
        return this.myClient.getClientData().getDataDir();
    }
}

