/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.ErrorMatchingReceiver;
import com.android.tools.idea.run.tasks.ShellCommandLauncher;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.ndk.run.AndroidNativeDeviceException;
import com.android.tools.ndk.run.AttachProgressReporter;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class RootSessionStarterImpl
extends SessionStarter {
    private static final Logger LOG = Logger.getInstance(RootSessionStarterImpl.class);

    public RootSessionStarterImpl(@NotNull JdwpConnector jdwpConnector, @NotNull Client client, @NotNull File localServerFile, @NotNull File localStartScriptFile, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull AttachProgressReporter progressReporter, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        super(jdwpConnector, client, localServerFile, localStartScriptFile, debuggerState, progressReporter, launchStatus, printer);
    }

    @Override
    public void internalStartServer() throws ExecutionException {
        try {
            String mkdirOutput = this.executeCommand(this.getClientCommand(String.format("sh -c 'mkdir %s; mkdir %s'", this.getTargetRootDirectory(), this.getTargetBinDirectory())), 5L, TimeUnit.SECONDS);
            if (!mkdirOutput.isEmpty()) {
                LOG.warn(mkdirOutput);
            }
            this.copyFileToTargetBinDirectory(this.myServerTempFile.getFilePath());
            this.copyFileToTargetBinDirectory(this.myStartScriptTempFile.getFilePath());
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    String output = this.executeCommand(this.getClientCommand(this.getStartCommandLine()), 0L, TimeUnit.DAYS);
                    LOG.info("LLDB server has exited: " + output);
                }
                catch (Exception e) {
                    LOG.warn("LLDB server has failed: ", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    @NotNull
    protected String executeCommand(@NotNull String command, long maxTimeToOutputResponse, TimeUnit maxTimeUnits) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, AndroidNativeDeviceException {
        ErrorMatchingReceiver receiver = new ErrorMatchingReceiver((LaunchStatus)this.myLaunchStatus);
        this.myClient.getDevice().executeShellCommand(command, (IShellOutputReceiver)receiver, maxTimeToOutputResponse, maxTimeUnits);
        return receiver.getOutput().toString();
    }

    @NotNull
    protected String getClientCommand(@NotNull String command) {
        return command;
    }

    private void copyFileToTargetBinDirectory(@NotNull String tmpDeviceFile) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException, ShellCommandUnresponsiveException {
        String fileName = new File(tmpDeviceFile).getName();
        String destFile = RootSessionStarterImpl.joinPaths(this.getTargetBinDirectory(), fileName);
        String copyChmodCommand = "cat " + tmpDeviceFile + " | " + this.getClientCommand(String.format("sh -c 'cat > %s && chmod 700 %s'", destFile, destFile));
        LOG.info("Copying to app folder: " + tmpDeviceFile + " => " + destFile);
        LOG.info("Command: " + copyChmodCommand);
        if (!ShellCommandLauncher.execute((String)copyChmodCommand, (IDevice)this.myClient.getDevice(), (LaunchStatus)this.myLaunchStatus, (ConsolePrinter)this.myPrinter, (long)60L, (TimeUnit)TimeUnit.SECONDS)) {
            throw new IOException("Command failed: " + copyChmodCommand);
        }
    }

    @Override
    public void resumeVm() throws ExecutionException {
        this.connectJdwp();
    }

    @Override
    @NotNull
    protected String getTargetDataDir() {
        return "/data/local/tmp";
    }
}

