/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.run.AndroidProcessText;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.tasks.ConnectDebuggerTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.run.AndroidNativeDebugProcess;
import com.android.tools.ndk.run.AttachProgressReporter;
import com.android.tools.ndk.run.ClientShellHelper;
import com.android.tools.ndk.run.editor.NativeAndroidDebugger;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.android.tools.ndk.run.lldb.InjectorSessionStarterImpl;
import com.android.tools.ndk.run.lldb.LLDBUsageTracker;
import com.android.tools.ndk.run.lldb.RootSessionStarterImpl;
import com.android.tools.ndk.run.lldb.RunAsSessionStarterImpl;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrRunner;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.TrivialInstaller;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.testing.CidrLauncher;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectLLDBTask
extends ConnectDebuggerTask {
    private static final Logger LOG = Logger.getInstance(ConnectLLDBTask.class);
    private static final Map<Abi, Abi> ABI_MAPPINGS = Collections.singletonMap(Abi.ARMEABI_V7A, Abi.ARMEABI);
    @NotNull
    private final ExecutionEnvironment myEnv;
    @NotNull
    protected final AndroidFacet myFacet;
    @NotNull
    protected final NativeAndroidDebuggerState myDebuggerState;
    @NotNull
    private final String myRunConfigTypeId;
    @NotNull
    private final NativeAndroidDebugger myNativeDebugger;
    protected AttachProgressReporter myAttachProgressReporter;

    public ConnectLLDBTask(@NotNull ExecutionEnvironment env, @NotNull Set<String> applicationIds, @NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState state, @NotNull NativeAndroidDebugger debugger, @NotNull String runConfigTypeId) {
        super(applicationIds, (AndroidDebugger)debugger, facet.getModule().getProject());
        this.myEnv = env;
        this.myFacet = facet;
        this.myDebuggerState = state;
        this.myRunConfigTypeId = runConfigTypeId;
        this.myNativeDebugger = debugger;
    }

    public boolean isReadyForDebugging(@NotNull Client client, @NotNull ConsolePrinter printer) {
        return super.isReadyForDebugging(client, printer) && client.isDdmAware();
    }

    protected boolean isDetachOnStop() {
        return false;
    }

    @Nullable
    public ProcessHandler launchDebugger(@NotNull LaunchInfo currentLaunchInfo, @NotNull Client client, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ProcessHandlerConsolePrinter printer) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myAttachProgressReporter = new AttachProgressReporter(this.myEnv.getProject());
        String prettyConfigName = this.getPrettyConfigurationName(client);
        LLDBUsageTracker.trackSessionStarted(prettyConfigName);
        IDevice device = client.getDevice();
        String deviceModel = device.getProperty("ro.product.model");
        String deviceAPILevel = device.getProperty("ro.build.version.sdk");
        String deviceCodename = device.getProperty("ro.build.version.codename");
        String deviceManufacturer = device.getProperty("ro.product.manufacturer");
        LLDBUsageTracker.trackDeviceAPILevel(deviceAPILevel);
        LLDBUsageTracker.trackDeviceModel(deviceModel);
        LOG.info(String.format("Launching %s native debug session on device: manufacturer=%s, model=%s, API=%s, codename=%s, ABIs=%s", prettyConfigName, deviceManufacturer, deviceModel, deviceAPILevel, deviceCodename, device.getAbis().toString()));
        try {
            return this.launchCidrDebugger(currentLaunchInfo, client, launchStatus, printer);
        }
        catch (Throwable e) {
            this.onLaunchFailure((LaunchStatus)launchStatus, client, "Error while starting native debug session: " + e.toString(), e);
            return null;
        }
    }

    @NotNull
    private static File createTempFile(String prefix) throws IOException {
        File file = File.createTempFile(prefix, Long.toString(System.currentTimeMillis()));
        file.deleteOnExit();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getPtraceScope(@NotNull IDevice device) {
        SyncService syncService = null;
        File localPtraceScopeFile = null;
        try {
            syncService = device.getSyncService();
            if (syncService == null) {
                throw new ExecutionException("Failed to get SyncService");
            }
            SyncService.FileStat ptraceScopeStat = syncService.statFile("/proc/sys/kernel/yama/ptrace_scope");
            if (ptraceScopeStat == null || ptraceScopeStat.getMode() == 0) {
                int n = 0;
                return n;
            }
            localPtraceScopeFile = ConnectLLDBTask.createTempFile("ptrace_scope");
            device.pullFile("/proc/sys/kernel/yama/ptrace_scope", localPtraceScopeFile.getPath());
            int n = Integer.parseInt(Files.toString((File)localPtraceScopeFile, (Charset)Charsets.UTF_8).trim());
            return n;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        finally {
            if (localPtraceScopeFile != null) {
                localPtraceScopeFile.delete();
            }
            if (syncService != null) {
                syncService.close();
            }
        }
        return -1;
    }

    @NotNull
    private SessionStarter newSessionStarter(@NotNull JdwpConnector jdwpConnector, @NotNull Client client, @NotNull List<Abi> clientABIs, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException, ShellCommandUnresponsiveException, ExecutionException {
        boolean restrictedPtraceScope;
        AndroidNativeDebugProcess.verifyNativeModel(this.myFacet, clientABIs, printer);
        File lldbServer = ConnectLLDBTask.findLLDBServer(this.myFacet, this.myDebuggerState, clientABIs);
        if (lldbServer == null) {
            LOG.error("LLDB server not found");
            throw new IllegalStateException("LLDB server not found");
        }
        LOG.info(String.format("Found LLDB server: \"%s\"", lldbServer.getAbsolutePath()));
        File startServerScript = ModulePathManager.getSdkLLDBAndroidFile("start_lldb_server.sh");
        if (Boolean.getBoolean("lldb.session-starter.runas")) {
            return this.newRunAsSessionStarter(jdwpConnector, client, lldbServer, startServerScript, launchStatus, printer);
        }
        int ptraceScope = ConnectLLDBTask.getPtraceScope(client.getDevice());
        boolean bl = restrictedPtraceScope = ptraceScope > 0;
        if (restrictedPtraceScope) {
            String yamaMsg = String.format("YAMA is on - ptrace_scope set to %d", ptraceScope);
            printer.stderr(yamaMsg);
            LOG.warn(yamaMsg);
        }
        if (Boolean.getBoolean("lldb.session-starter.jdwp") || restrictedPtraceScope) {
            return this.newInjectorSessionStarter(jdwpConnector, client, restrictedPtraceScope, lldbServer, startServerScript, launchStatus, printer);
        }
        if (ConnectLLDBTask.isRootedDevice(client.getDevice())) {
            return new RootSessionStarterImpl(jdwpConnector, client, lldbServer, startServerScript, this.myDebuggerState, this.myAttachProgressReporter, launchStatus, printer);
        }
        if (ConnectLLDBTask.isRunAsOK(client)) {
            return this.newRunAsSessionStarter(jdwpConnector, client, lldbServer, startServerScript, launchStatus, printer);
        }
        return this.newInjectorSessionStarter(jdwpConnector, client, restrictedPtraceScope, lldbServer, startServerScript, launchStatus, printer);
    }

    @NotNull
    private SessionStarter newRunAsSessionStarter(@NotNull JdwpConnector jdwpConnector, @NotNull Client client, @NotNull File serverPath, @NotNull File startScriptPath, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        return new RunAsSessionStarterImpl(jdwpConnector, client, serverPath, startScriptPath, this.myDebuggerState, this.myAttachProgressReporter, launchStatus, printer);
    }

    @NotNull
    private SessionStarter newInjectorSessionStarter(@NotNull JdwpConnector jdwpConnector, @NotNull Client client, boolean restrictedPtraceScope, @NotNull File serverPath, @NotNull File startScriptPath, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        return new InjectorSessionStarterImpl(jdwpConnector, client, restrictedPtraceScope, serverPath, startScriptPath, this.myDebuggerState, this.myAttachProgressReporter, launchStatus, printer);
    }

    private static boolean isRunAsOK(@NotNull Client client) throws ExecutionException {
        try {
            ClientShellHelper shellHelper = new ClientShellHelper(client);
            IDevice device = client.getDevice();
            String deviceModel = device.getProperty("ro.product.model");
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            client.getDevice().executeShellCommand(shellHelper.getRunAsCommand(String.format("getprop %s", "ro.product.model")), (IShellOutputReceiver)receiver);
            return receiver.getOutput().trim().contains(deviceModel);
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    protected static boolean isRootedDevice(@NotNull IDevice device) throws ExecutionException {
        try {
            return device.isRoot();
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    private static int getClientAddressByteSize(@NotNull Client client) {
        String abi = client.getClientData().getAbi();
        if (abi != null && abi.startsWith("64-bit")) {
            return 8;
        }
        return 4;
    }

    @Nullable
    private static File findLLDBServer(@NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull List<Abi> abis) {
        File foundServerFile = null;
        for (Abi abi : abis) {
            File serverFile = ConnectLLDBTask.getServerFileByAbi(abi);
            if (serverFile != null) {
                foundServerFile = serverFile;
            }
            if (AndroidNativeDebugProcess.getSymbolsDir(facet, debuggerState, Collections.singletonList(abi)).isEmpty()) continue;
            return serverFile;
        }
        return foundServerFile;
    }

    @Nullable
    private static File getServerFileByAbi(@NotNull Abi abi) {
        File lldbServerFile = ConnectLLDBTask.getAndroidLLDBBinFile(abi);
        if (lldbServerFile.exists()) {
            return lldbServerFile;
        }
        Abi mappedAbi = ABI_MAPPINGS.get(abi);
        if (mappedAbi != null && (lldbServerFile = ConnectLLDBTask.getAndroidLLDBBinFile(mappedAbi)).exists()) {
            return lldbServerFile;
        }
        return null;
    }

    @NotNull
    private static File getAndroidLLDBBinFile(Abi abi) {
        return ModulePathManager.getSdkLLDBAndroidFile(new File(abi.toString(), "lldb-server").getPath());
    }

    @NotNull
    private static List<Abi> getClientABIs(@NotNull Client client) {
        int clientAddrByteSize = ConnectLLDBTask.getClientAddressByteSize(client);
        if (clientAddrByteSize <= 0) {
            LOG.warn("Failed to get client address byte size from ABI: " + client.getClientData().getAbi());
        }
        LinkedList abis = Lists.newLinkedList();
        IDevice device = client.getDevice();
        for (String abiStr : device.getAbis()) {
            Abi abi = Abi.getEnum((String)abiStr);
            if (abi == null) {
                LOG.warn("Failed to get abi by name: " + abiStr);
                continue;
            }
            if (clientAddrByteSize > 0) {
                if (abi.getAddressSizeInBytes() != clientAddrByteSize) continue;
                abis.add(abi);
                continue;
            }
            abis.add(abi);
        }
        LOG.info("ABIs supported by app: " + ((Object)abis).toString());
        return abis;
    }

    @NotNull
    private RunParameters newRunParameters(final @NotNull Client client, final @NotNull List<Abi> clientABIs, final @NotNull SessionStarter sessionStarter, final @NotNull ProcessHandlerConsolePrinter printer) {
        final IDevice device = client.getDevice();
        return new RunParameters(){

            @NotNull
            public Installer getInstaller() {
                return new TrivialInstaller(new GeneralCommandLine());
            }

            @NotNull
            public DebuggerDriverConfiguration getDebuggerDriverConfiguration() {
                return new AndroidLLDBDriverConfiguration(ConnectLLDBTask.this.myEnv.getProject(), ConnectLLDBTask.this.myFacet, ConnectLLDBTask.this.myDebuggerState, (ConsolePrinter)printer, device, clientABIs, sessionStarter, ConnectLLDBTask.this.getStartupCommands(client), ConnectLLDBTask.this.getPostAttachCommands(client, printer));
            }

            public boolean isWaitFor() {
                return false;
            }

            @NotNull
            public String getArchitectureId() {
                return NdkHelper.getArchitectureId(NdkHelper.getAbi(device));
            }
        };
    }

    @NotNull
    protected JdwpConnector newJdwpConnector(@NotNull LaunchInfo currentLaunchInfo, @NotNull Client client, @NotNull XDebugSession session) {
        return new JdwpConnector(currentLaunchInfo, this.myFacet, client, session, true);
    }

    private ProcessHandler launchCidrDebugger(final @NotNull LaunchInfo currentLaunchInfo, final @NotNull Client client, final @NotNull ProcessHandlerLaunchStatus launchStatus, final @NotNull ProcessHandlerConsolePrinter printer) throws ExecutionException {
        CidrRunner cidrRunner = new CidrRunner(){

            @NotNull
            public String getRunnerId() {
                return "AndroidNativeDebugRunner2";
            }
        };
        ExecutionEnvironment env = new ExecutionEnvironmentBuilder(this.myEnv).executor(this.myEnv.getExecutor()).runner((ProgramRunner)cidrRunner).contentToReuse(this.myEnv.getContentToReuse()).build();
        CidrCommandLineState cidrState = new CidrCommandLineState(env, new CidrLauncher(){

            public ProcessHandler startProcess(@NotNull CommandLineState state) throws ExecutionException {
                throw new RuntimeException("start process not implemented");
            }

            public XDebugProcess startDebugProcess(@NotNull CommandLineState state, @NotNull XDebugSession session) throws ExecutionException {
                SessionStarter sessionStarter;
                List clientABIs = ConnectLLDBTask.getClientABIs(client);
                try {
                    sessionStarter = ConnectLLDBTask.this.newSessionStarter(ConnectLLDBTask.this.newJdwpConnector(currentLaunchInfo, client, session), client, clientABIs, launchStatus, (ConsolePrinter)printer);
                }
                catch (Exception e) {
                    throw new ExecutionException((Throwable)e);
                }
                RunParameters runParameters = ConnectLLDBTask.this.newRunParameters(client, clientABIs, sessionStarter, printer);
                AndroidNativeDebugProcess result = ConnectLLDBTask.this.myNativeDebugger.getAndroidNativeDebugProcess(ConnectLLDBTask.this.myEnv.getProject(), runParameters, session, state.getConsoleBuilder(), (ConsolePrinter)printer, sessionStarter, client, ConnectLLDBTask.this.myAttachProgressReporter, ConnectLLDBTask.this.isDetachOnStop());
                ProcessTerminatedListener.attach((ProcessHandler)result.getProcessHandler(), (Project)ConnectLLDBTask.this.myEnv.getProject());
                result.start();
                return result;
            }

            public ExecutionResult execute(@NotNull CommandLineState state, @NotNull Executor executor, @NotNull ProgramRunner runner, DefaultExecutionResult result) throws ExecutionException {
                throw new RuntimeException("execute not implemented");
            }
        });
        printer.stdout("Now Launching Native Debug Session");
        this.myAttachProgressReporter.step("Launching debug session");
        XDebugSessionImpl xDebugSession = (XDebugSessionImpl)cidrRunner.startDebugSession(cidrState, env, false, new XDebugSessionListener[0]);
        ProcessHandler processHandler = launchStatus.getProcessHandler();
        assert (processHandler != null);
        ProcessHandler newProcessHandler = xDebugSession.getRunContentDescriptor().getProcessHandler();
        if (newProcessHandler == null) {
            throw new ExecutionException("Cannot start debugging - null process handler.");
        }
        launchStatus.setProcessHandler(newProcessHandler);
        printer.setProcessHandler(newProcessHandler);
        processHandler.detachProcess();
        AndroidProcessText oldText = AndroidProcessText.get((ProcessHandler)processHandler);
        if (oldText != null) {
            oldText.printTo(newProcessHandler);
        }
        xDebugSession.showSessionTab();
        return newProcessHandler;
    }

    @NotNull
    private String getPrettyConfigurationName(@NotNull Client client) {
        LinkedList items = Lists.newLinkedList();
        items.add(this.myRunConfigTypeId);
        items.add(this.myDebugger.getId());
        if (client.getClientData().isNativeDebuggable()) {
            items.add("java_aware_cpp");
        }
        return StringUtil.join((Collection)items, (String)":");
    }

    private void onLaunchFailure(@NotNull LaunchStatus launchStatus, @NotNull Client client, @NotNull String message, @NotNull Throwable e) {
        LOG.warn(message, e);
        launchStatus.terminateLaunch(message);
        LLDBUsageTracker.trackSessionFailed(e);
        this.myAttachProgressReporter.finish();
        ConnectLLDBTask.forceStopActivity(client);
    }

    private static void forceStopActivity(@NotNull Client client) {
        String packageName = client.getClientData().getClientDescription();
        try {
            IDevice device = client.getDevice();
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            device.executeShellCommand("am force-stop " + packageName, (IShellOutputReceiver)receiver);
        }
        catch (Exception e) {
            LOG.info("Failed to force-stop activity " + packageName, (Throwable)e);
        }
    }

    @NotNull
    private List<String> getStartupCommands(@NotNull Client client) {
        return Stream.concat(this.myNativeDebugger.getStartupCommands(client, this.myFacet).stream(), this.myDebuggerState.getUserStartupCommands().stream()).collect(Collectors.toList());
    }

    @NotNull
    private List<String> getPostAttachCommands(@NotNull Client client, @NotNull ProcessHandlerConsolePrinter printer) {
        return Stream.concat(this.myNativeDebugger.getPostAttachCommands(client, this.myFacet, printer).stream(), this.myDebuggerState.getUserPostAttachCommands().stream()).collect(Collectors.toList());
    }
}

