/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.jdwp;

import com.android.ddmlib.Client;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.tools.idea.run.AndroidDebugState;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.ndk.run.jdwp.CodeInjection;
import com.android.tools.ndk.run.jdwp.CodeInjectionImpl;
import com.android.tools.ndk.run.jdwp.InstrumentationStopRequestor;
import com.android.tools.ndk.run.jdwp.NativeAwareDebugProcessHandler;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebugUIEnvironment;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugUIEnvironment;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Service;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class JdwpConnector {
    private static final String INSTRUMENTATION_CLASS = "android.app.Instrumentation";
    private final LaunchInfo myLaunchInfo;
    private final AndroidFacet myFacet;
    private final Client myClient;
    private final XDebugSession myNativeDebugSession;
    private final boolean myLaunchMode;
    private final List<CodeInjectionImpl> myCodeInjections = Lists.newLinkedList();
    List<SessionListener> mySessionListeners = Lists.newLinkedList();
    List<FilteredRequestor> myRequestors = Lists.newLinkedList();
    private static final Logger LOG = Logger.getInstance(JdwpConnector.class);

    public JdwpConnector(@NotNull LaunchInfo launchInfo, @NotNull AndroidFacet facet, @NotNull Client client, @NotNull XDebugSession nativeDebugSession, boolean launchMode) {
        this.myLaunchInfo = launchInfo;
        this.myFacet = facet;
        this.myClient = client;
        this.myNativeDebugSession = nativeDebugSession;
        this.myLaunchMode = launchMode;
    }

    public void Connect() throws ExecutionException {
        String debugPort = Integer.toString(this.myClient.getDebuggerListenPort());
        Project project = this.myLaunchInfo.env.getProject();
        RemoteConnection connection = new RemoteConnection(true, "localhost", debugPort, false);
        NativeAwareDebugProcessHandler debugProcessHandler = new NativeAwareDebugProcessHandler(project, this.myNativeDebugSession);
        AndroidDebugState st = new AndroidDebugState(project, (ProcessHandler)debugProcessHandler, connection, this.myLaunchInfo.consoleProvider);
        ExecutionEnvironment env = new ExecutionEnvironmentBuilder(this.myLaunchInfo.env).executor(this.myLaunchInfo.env.getExecutor()).build();
        DefaultDebugUIEnvironment debugUIEnv = new DefaultDebugUIEnvironment(env, (RunProfileState)st, st.getRemoteConnection(), false);
        DebugEnvironment modelEnvironment = debugUIEnv.getEnvironment();
        DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx((Project)project);
        DebuggerSession debuggerSession = debuggerManager.attachVirtualMachine(modelEnvironment);
        DebugProcessImpl debugProcess = debuggerSession.getProcess();
        if (debugProcess.isDetached() || debugProcess.isDetaching()) {
            debuggerSession.dispose();
            throw new ExecutionException("Debug process has been detached");
        }
        if (!this.myCodeInjections.isEmpty()) {
            debugProcess.addDebugProcessListener((DebugProcessListener)new DebugProcessAdapterImplEx());
        }
        for (SessionListener sessionListener : this.getSessionListenersCopy()) {
            sessionListener.sessionCreated(debuggerSession, (DebugUIEnvironment)debugUIEnv);
        }
        if (!debugProcessHandler.isStartNotified()) {
            debugProcessHandler.startNotify();
        }
    }

    public CodeInjection injectCodeFragment(@NotNull String codeFragment) {
        CodeInjectionImpl codeInjection = new CodeInjectionImpl(codeFragment);
        this.myCodeInjections.add(codeInjection);
        return codeInjection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCodeInjections(SuspendContextImpl suspendContext) {
        DebugProcessImpl dbgProcess = suspendContext.getDebugProcess();
        ThreadReferenceProxyImpl threadRefProxy = suspendContext.getThread();
        for (CodeInjectionImpl codeInjection : this.myCodeInjections) {
            FutureResult<Void> resultFuture = codeInjection.getResultFuture();
            LOG.info("Evaluating expression: " + codeInjection.getCodeFragment());
            Date startTime = new Date();
            XExpressionImpl expr = XExpressionImpl.fromText((String)codeInjection.getCodeFragment(), (EvaluationMode)EvaluationMode.CODE_FRAGMENT);
            TextWithImports text = TextWithImportsImpl.fromXExpression((XExpression)expr);
            WatchItemDescriptor descriptor = new WatchItemDescriptor(dbgProcess.getProject(), text);
            try {
                StackFrameProxyImpl stackFrameProxy = threadRefProxy.frame(0);
                EvaluationContextImpl evaluationContext = new EvaluationContextImpl(suspendContext, stackFrameProxy, null);
                descriptor.setContext(evaluationContext);
                LOG.info("Evaluation took " + (new Date().getTime() - startTime.getTime()) + " ms");
                EvaluateException exception = descriptor.getEvaluateException();
                if (exception != null && descriptor.getValue() == null) {
                    LOG.error("Failed to evaluate expression: " + exception.getMessage());
                    resultFuture.setException((Throwable)exception);
                    continue;
                }
                resultFuture.set(null);
            }
            catch (EvaluateException e) {
                LOG.error((Throwable)e);
                resultFuture.setException((Throwable)e);
            }
            finally {
                codeInjection.waitForResume();
            }
        }
    }

    @NotNull
    private synchronized List<SessionListener> getSessionListenersCopy() {
        return Lists.newArrayList(this.mySessionListeners);
    }

    public synchronized void addSessionListener(@NotNull SessionListener sessionListener) {
        this.mySessionListeners.add(sessionListener);
    }

    public synchronized void removeSessionListener(@NotNull SessionListener sessionListener) {
        this.mySessionListeners.remove(sessionListener);
    }

    private class DebugProcessAdapterImplEx
    extends DebugProcessAdapterImpl {
        private DebugProcessAdapterImplEx() {
        }

        public void paused(SuspendContextImpl suspendContext) {
            LOG.info("Process is paused");
            DebugProcessImpl dbgProcess = suspendContext.getDebugProcess();
            dbgProcess.removeDebugProcessListener((DebugProcessListener)this);
            JdwpConnector.this.runCodeInjections(suspendContext);
            RequestManagerImpl requestManager = dbgProcess.getRequestsManager();
            for (FilteredRequestor requestor : JdwpConnector.this.myRequestors) {
                requestManager.deleteRequest((Requestor)requestor);
            }
            dbgProcess.getManagerThread().schedule((DebuggerCommandImpl)dbgProcess.createResumeCommand(suspendContext));
        }

        public void processAttached(DebugProcessImpl process) {
            LOG.info("Attached to process");
            try {
                if (JdwpConnector.this.myLaunchMode) {
                    this.setLaunchHooks(process);
                } else {
                    this.setAttachHooks(process);
                }
            }
            catch (ExecutionException e) {
                this.fail(e.getMessage());
                LOG.warn((Throwable)e);
            }
        }

        private void setLaunchHooks(@NotNull DebugProcessImpl process) throws ExecutionException {
            List refs = process.getVirtualMachineProxy().classesByName(JdwpConnector.INSTRUMENTATION_CLASS);
            if (refs.isEmpty()) {
                throw new ExecutionException("Failed to find Instrumentation class in VM");
            }
            ClassType classClassType = (ClassType)refs.get(0);
            Method ctor = DebuggerUtils.findMethod((ReferenceType)classClassType, (String)"<init>", (String)"()V");
            if (ctor == null) {
                throw new ExecutionException("Failed to find Instrumentation default constructor");
            }
            this.setMethodBreakpoint(process.getRequestsManager(), ctor);
        }

        private void setAttachHooks(@NotNull DebugProcessImpl process) throws ExecutionException {
            final LinkedList activities = Lists.newLinkedList();
            final LinkedList services = Lists.newLinkedList();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    Application app = JdwpConnector.this.myFacet.getManifest().getApplication();
                    for (Activity activity : app.getActivities()) {
                        PsiClass activityClass = (PsiClass)activity.getActivityClass().getValue();
                        if (activityClass == null) continue;
                        activities.add(activityClass.getQualifiedName());
                    }
                    for (Service service : app.getServices()) {
                        PsiClass serviceClass = (PsiClass)service.getServiceClass().getValue();
                        if (serviceClass == null) continue;
                        services.add(serviceClass.getQualifiedName());
                    }
                }
            });
            RequestManagerImpl requestManager = process.getRequestsManager();
            boolean activitiesSet = this.setDumpBreakpoints(process, requestManager, activities);
            boolean servicesSet = false;
            if (!activitiesSet && !(servicesSet = this.setDumpBreakpoints(process, requestManager, services))) {
                throw new ExecutionException("Failed to set dump breakpoints");
            }
            try {
                String cmd = activitiesSet ? "dumpsys activity" : "dumpsys activity service";
                JdwpConnector.this.myClient.getDevice().executeShellCommand(String.format("%s %s", cmd, JdwpConnector.this.myClient.getClientData().getPackageName()), (IShellOutputReceiver)new NullOutputReceiver());
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                throw new ExecutionException("dumpsys failed", (Throwable)e);
            }
        }

        private void setMethodBreakpoint(@NotNull RequestManagerImpl requestManager, @NotNull Method method) {
            String className = method.location().declaringType().name();
            InstrumentationStopRequestor requestor = new InstrumentationStopRequestor(className);
            BreakpointRequest br = requestManager.createBreakpointRequest((FilteredRequestor)requestor, method.location());
            requestManager.enableRequest((EventRequest)br);
            JdwpConnector.this.myRequestors.add(requestor);
        }

        private boolean setDumpBreakpoints(@NotNull DebugProcessImpl process, @NotNull RequestManagerImpl requestManager, @NotNull List<String> classNames) {
            boolean result = false;
            HashSet methods = Sets.newHashSet();
            for (String className : classNames) {
                ClassType activityClassType;
                Method dump;
                List activityRefs = process.getVirtualMachineProxy().classesByName(className);
                if (activityRefs.isEmpty() || (dump = DebuggerUtils.findMethod((ReferenceType)(activityClassType = (ClassType)activityRefs.get(0)), (String)"dump", null)) == null || methods.contains(dump)) continue;
                this.setMethodBreakpoint(requestManager, dump);
                methods.add(dump);
                result = true;
            }
            return result;
        }

        private void fail(@NotNull String errorMessage) {
            ExecutionException e = new ExecutionException(errorMessage);
            for (CodeInjectionImpl codeInjection : JdwpConnector.this.myCodeInjections) {
                FutureResult<Void> resultFuture = codeInjection.getResultFuture();
                resultFuture.setException((Throwable)e);
            }
        }
    }

    public static interface SessionListener {
        public void sessionCreated(@NotNull DebuggerSession var1, @NotNull DebugUIEnvironment var2);
    }
}

