/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.crash;

import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.run.crash.CrashLoggingEvent;
import com.google.common.io.Files;
import com.intellij.diagnostic.LogEventException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.StreamUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;

public class NativeClientCrashException
extends Exception {
    public static LogEventException create(String message, File minidump) throws IOException {
        return new CrashLoggingEvent(message, new NativeClientCrashException(), NativeClientCrashException.createMinidumpAttachment(minidump)).makeException();
    }

    private static String getHumanReadableMinidump(File minidump) throws IOException {
        String stackwalkFile = SystemInfo.isWindows ? "minidump_stackwalk.exe" : "minidump_stackwalk";
        File stackwalkPathRel = new File(new File("bin"), stackwalkFile);
        File stackwalkPathAbs = ModulePathManager.getSdkLLDBFile(stackwalkPathRel.getPath());
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine();
            commandLine.setExePath(stackwalkPathAbs.getPath());
            commandLine.addParameters(new String[]{"-s", minidump.getAbsolutePath()});
            commandLine.setRedirectErrorStream(true);
            Process process = commandLine.createProcess();
            String humanReadable = StreamUtil.readText((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset());
            int errorCode = process.waitFor();
            if (errorCode != 0) {
                throw new IOException("Unable to extract data from the crash dump file. Process returned " + errorCode);
            }
            return humanReadable;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    private static Attachment createMinidumpAttachment(File minidump) throws IOException {
        byte[] contents = Files.toByteArray((File)minidump);
        String humanReadable = NativeClientCrashException.getHumanReadableMinidump(minidump);
        return new Attachment(minidump.getPath(), contents, humanReadable);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        s.append("\nThe technical details of the error report found on the \u2018Attachments\u2019\ntab will be sent to Google\u2019s Android team to help identify and fix\nthe problem.  https://www.google.com/policies/privacy/");
    }
}

