/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeFolder;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.SourceProvider;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.AndroidApkFacet;
import com.android.tools.idea.apk.AndroidApkFacetConfiguration;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.NativeAndroidGradleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.ndk.MemoryRegionMap;
import com.android.tools.ndk.run.AndroidNativeExecutionStack;
import com.android.tools.ndk.run.AttachProgressReporter;
import com.android.tools.ndk.run.crash.AndroidLLDBBreakpadIntegration;
import com.android.tools.ndk.run.crash.CrashLoggingEvent;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriver;
import com.android.tools.ndk.run.lldb.LLDBUsageTracker;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.android.utils.FileUtils;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointType;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidNativeDebugProcess
extends CidrDebugProcess {
    private static final Logger LOG = Logger.getInstance(AndroidNativeDebugProcess.class);
    private static final String LIBART_SO = "libart.so";
    private static final String ART_SIGSEGV_FAULT = "art_sigsegv_fault";
    private static final List<String> SKIPPABLE_UNITY_SIGNALS = ImmutableList.of((Object)"SIGPWR", (Object)"SIGXCPU");
    private static final List<String> UNITY_IDENTIFYING_LIBRARIES = ImmutableList.of((Object)"libil2cpp.so", (Object)"libmono.so");
    private static final CidrSymbolicBreakpointType SYMBOLIC_BREAKPOINT_TYPE = (CidrSymbolicBreakpointType)XBreakpointType.EXTENSION_POINT_NAME.findExtension(CidrSymbolicBreakpointType.class);
    private static final boolean ENABLE_ATTACH_ERROR_REPORTING = true;
    private final Project myProject;
    private final ConsolePrinter myPrinter;
    private final SessionStarter mySessionStarter;
    private final Client myClient;
    private final AttachProgressReporter myAttachProgressReporter;
    private XBreakpoint<CidrSymbolicBreakpointType.Properties> myArtSigSegvFaultBp;
    private boolean myArt = false;
    private final MemoryRegionMap myArtMemRegionMap = new MemoryRegionMap(Arrays.asList(".*\\.dex", ".*\\.odex", ".*\\.oat"));
    private final boolean myDetachOnStop;
    private final Set<String> myLoadedModules = Sets.newHashSet();
    private static final Map<String, String> DANGEROUS_COMPILER_FLAGS = ImmutableMap.of((Object)"-flto", (Object)"Combining -flto with -g is currently experimental and expected to produce unexpected results");

    public AndroidNativeDebugProcess(@NotNull Project project, @NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsolePrinter printer, @NotNull SessionStarter sessionStarter, @NotNull Client client, @NotNull AttachProgressReporter attachProgressReporter, boolean detachOnStop) throws ExecutionException {
        super(parameters, session, consoleBuilder);
        this.myProject = project;
        this.myPrinter = printer;
        this.mySessionStarter = sessionStarter;
        this.myClient = client;
        this.myAttachProgressReporter = attachProgressReporter;
        this.myDetachOnStop = detachOnStop;
    }

    @NotNull
    public Client getClient() {
        return this.myClient;
    }

    protected boolean isRemote() {
        return true;
    }

    public boolean isDetachDefault() {
        return this.myDetachOnStop;
    }

    public boolean checkCanInitBreakpoints() {
        return false;
    }

    protected void doStart(@NotNull DebuggerDriver driver) throws ExecutionException {
    }

    public void sessionInitialized() {
        this.getProcessHandler().startNotify();
        this.postCommand(new CidrDebugProcess.DebuggerCommand(){

            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                try {
                    LOG.info("Pushing files to device");
                    AndroidNativeDebugProcess.this.myAttachProgressReporter.step("Pushing files to device");
                    AndroidNativeDebugProcess.this.mySessionStarter.pushFilesToDevice();
                    LOG.info("Loading driver");
                    AndroidNativeDebugProcess.this.myAttachProgressReporter.step("Loading debugger driver");
                    driver.loadForRemote(null);
                    ClientData clientData = AndroidNativeDebugProcess.this.myClient.getClientData();
                    LOG.info(String.format("Attaching to inferior: pid=%d, ABI=%s, native debuggable=%b", clientData.getPid(), clientData.getAbi(), clientData.isNativeDebuggable()));
                    AndroidNativeDebugProcess.this.myAttachProgressReporter.step("Attaching to the app");
                    driver.attachTo(clientData.getPid());
                    AndroidNativeDebugProcess.this.myArt = AndroidNativeDebugProcess.this.isArtVM();
                    if (AndroidNativeDebugProcess.this.myArt) {
                        LOG.info("Running in ART VM");
                        AndroidNativeDebugProcess.this.initArtSigSegvFaultBreakpoint();
                    } else {
                        LOG.info("Running in Dalvik VM");
                    }
                }
                catch (ExecutionException launchException) {
                    AndroidNativeDebugProcess.this.myAttachProgressReporter.finish();
                    AndroidNativeDebugProcess.this.handleLaunchException(launchException);
                }
            }
        });
        ApplicationManager.getApplication().runReadAction(() -> this.getSession().initBreakpoints());
        super.sessionInitialized();
    }

    protected void doLaunchTarget(@NotNull DebuggerDriver driver) throws ExecutionException {
        try {
            LOG.info("Resuming paused inferior");
            this.myAttachProgressReporter.step("Resuming the app process");
            driver.resume();
            this.myAttachProgressReporter.step("Resuming the app VM");
            this.mySessionStarter.resumeVm();
            LOG.info("Launch has been completed");
        }
        catch (ExecutionException launchException) {
            this.handleLaunchException(launchException);
        }
        finally {
            this.myAttachProgressReporter.finish();
        }
    }

    private void handleLaunchException(@NotNull ExecutionException launchException) throws ExecutionException {
        Attachment logs;
        this.getSession().stop();
        LOG.warn((Throwable)launchException);
        this.myPrinter.stderr(launchException.getMessage());
        AndroidNativeDebugProcess.reportError(launchException);
        try {
            logs = this.mySessionStarter.getLogFilesFromDevice();
        }
        catch (ExecutionException nestedException) {
            LOG.warn("Failed to get log files from the device.", (Throwable)nestedException);
            throw launchException;
        }
        throw new CrashLoggingEvent(launchException.getMessage(), launchException, logs).makeException();
    }

    @NotNull
    protected XBreakpointManager getBreakpointManager() {
        return XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager();
    }

    @NotNull
    protected static Application getApp() {
        return ApplicationManager.getApplication();
    }

    private void initArtSigSegvFaultBreakpoint() throws ExecutionException {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (XBreakpoint bp : AndroidNativeDebugProcess.this.getBreakpointManager().getBreakpoints((XBreakpointType)SYMBOLIC_BREAKPOINT_TYPE)) {
                    CidrSymbolicBreakpointType.Properties bpProps = (CidrSymbolicBreakpointType.Properties)bp.getProperties();
                    if (!bpProps.getModuleName().equals(AndroidNativeDebugProcess.LIBART_SO) || !bpProps.getSymbolPattern().equals(AndroidNativeDebugProcess.ART_SIGSEGV_FAULT)) continue;
                    AndroidNativeDebugProcess.this.myArtSigSegvFaultBp = bp;
                    break;
                }
            }
        });
        if (this.myArtSigSegvFaultBp != null) {
            return;
        }
        AndroidNativeDebugProcess.getApp().invokeLater(new Runnable(){

            @Override
            public void run() {
                AndroidNativeDebugProcess.getApp().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        CidrSymbolicBreakpointType.Properties props = new CidrSymbolicBreakpointType.Properties(AndroidNativeDebugProcess.ART_SIGSEGV_FAULT, AndroidNativeDebugProcess.LIBART_SO);
                        AndroidNativeDebugProcess.this.myArtSigSegvFaultBp = AndroidNativeDebugProcess.this.getBreakpointManager().addBreakpoint((XBreakpointType)SYMBOLIC_BREAKPOINT_TYPE, (XBreakpointProperties)props);
                    }
                });
            }
        });
    }

    private boolean isArtVM() {
        return this.myLoadedModules.contains(LIBART_SO);
    }

    public void stop() {
        super.stop();
        AndroidNativeDebugProcess.getApp().invokeLater(new Runnable(){

            @Override
            public void run() {
                AndroidNativeDebugProcess.getApp().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        if (AndroidNativeDebugProcess.this.myArtSigSegvFaultBp != null && !AndroidNativeDebugProcess.this.myProject.isDisposed()) {
                            XDebuggerManager.getInstance((Project)AndroidNativeDebugProcess.this.myProject).getBreakpointManager().removeBreakpoint(AndroidNativeDebugProcess.this.myArtSigSegvFaultBp);
                            AndroidNativeDebugProcess.this.myArtSigSegvFaultBp = null;
                        }
                    }
                });
            }
        });
    }

    private boolean isUnityApp() {
        for (String unityLibrary : UNITY_IDENTIFYING_LIBRARIES) {
            if (!this.myLoadedModules.contains(unityLibrary)) continue;
            return true;
        }
        return false;
    }

    public void handleSignal(final @NotNull List<LLThread> threads, final int currentThreadIndex, final @NotNull String signal, final @NotNull String meaning) {
        if (SKIPPABLE_UNITY_SIGNALS.contains(signal)) {
            this.postCommand(new CidrDebugProcess.DebuggerCommand(){

                public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                    if (AndroidNativeDebugProcess.this.isUnityApp()) {
                        for (String skippableUnixSignal : SKIPPABLE_UNITY_SIGNALS) {
                            driver.handleSignal(skippableUnixSignal, false, true, false);
                        }
                        driver.resume();
                    } else {
                        AndroidNativeDebugProcess.super.handleSignal(threads, currentThreadIndex, signal, meaning);
                    }
                }
            });
            return;
        }
        if (this.myArt && signal.equals("SIGSEGV")) {
            this.postCommand(new CidrDebugProcess.DebuggerCommand(){

                public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                    if (!AndroidNativeDebugProcess.this.handleArtSigSegv(driver, threads, currentThreadIndex)) {
                        AndroidNativeDebugProcess.super.handleSignal(threads, currentThreadIndex, signal, meaning);
                    }
                }
            });
            return;
        }
        super.handleSignal(threads, currentThreadIndex, signal, meaning);
    }

    private boolean handleArtSigSegv(@NotNull DebuggerDriver driver, @NotNull List<LLThread> threads, int currentThreadIndex) {
        LLThread thread = threads.get(currentThreadIndex);
        try {
            List frames = driver.getFrames(thread.getId());
            if (frames.isEmpty()) {
                return false;
            }
            LLFrame firstFrame = (LLFrame)frames.get(0);
            LOG.info(String.format("Got SIGSEGV signal, PC address: 0x%X", firstFrame.getProgramCounter()));
            MemoryRegionMap.Region region = this.myArtMemRegionMap.getRegionByAddress(firstFrame.getProgramCounter());
            if (region == null || !region.isExecutable()) {
                this.myArtMemRegionMap.clear();
                String procMapsContent = this.readProcMapsFile(driver);
                this.myArtMemRegionMap.addMapEntries(StringUtil.splitByLines((String)procMapsContent));
            }
            if ((region = this.myArtMemRegionMap.getRegionByAddress(firstFrame.getProgramCounter())) != null && region.isExecutable()) {
                LOG.info(String.format("SIGSEGV came from ART module '%s' - resuming the inferior", region.getFileName()));
                driver.resume();
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    @NotNull
    private String readProcMapsFile(@NotNull DebuggerDriver driver) throws ExecutionException {
        return driver.executeShellCommand("cat", (List)Lists.newArrayList((Object[])new String[]{String.format("/proc/%d/maps", this.myClient.getClientData().getPid())}), null, 0).getOutput();
    }

    @NotNull
    private static Set<String> getAbiNameSet(@NotNull List<Abi> abis) {
        HashSet abiNames = Sets.newHashSetWithExpectedSize((int)abis.size());
        for (Abi abi : abis) {
            abiNames.add(abi.toString());
        }
        return abiNames;
    }

    private static void visitNativeLibraries(@NotNull Module module, @NotNull Set<String> abiNames, @NotNull NativeLibraryVisitor visitor) {
        Collection nativeLibraries;
        AndroidGradleModel androidModel;
        NativeAndroidGradleModel nativeAndroidGradleModel = NativeAndroidGradleModel.get((Module)module);
        if (nativeAndroidGradleModel != null) {
            NativeAndroidGradleModel.NativeVariant nativeVariant = nativeAndroidGradleModel.getSelectedVariant();
            Collection nativeArtifacts = nativeVariant.getArtifacts();
            for (NativeArtifact nativeArtifact : nativeArtifacts) {
                String abi;
                File artifactOutputFile = nativeArtifact.getOutputFile();
                if (!artifactOutputFile.exists() || !abiNames.contains(abi = artifactOutputFile.getParentFile().getName())) continue;
                visitor.visit(nativeAndroidGradleModel, nativeArtifact);
            }
        }
        if ((androidModel = AndroidGradleModel.get((Module)module)) == null) {
            return;
        }
        AndroidArtifact androidArtifact = androidModel.getSelectedVariant().getMainArtifact();
        if (GradleUtil.isUsingExperimentalPlugin((Module)module) && (nativeLibraries = androidArtifact.getNativeLibraries()) != null) {
            for (NativeLibrary library : nativeLibraries) {
                if (!abiNames.contains(library.getAbi())) continue;
                visitor.visit(library);
            }
        }
        Dependencies dependencies = GradleUtil.getDependencies((BaseArtifact)androidArtifact, (GradleVersion)androidModel.getModelVersion());
        for (AndroidLibrary lib : dependencies.getLibraries()) {
            AndroidGradleModel moduleModel;
            AndroidFacet moduleFacet;
            Module depModule;
            String projectName = lib.getProject();
            if (projectName == null || (depModule = GradleUtil.findModuleByGradlePath((Project)module.getProject(), (String)projectName)) == null || (moduleFacet = AndroidFacet.getInstance((Module)depModule)) == null || (moduleModel = AndroidGradleModel.get((AndroidFacet)moduleFacet)) == null) continue;
            AndroidNativeDebugProcess.visitNativeLibraries(depModule, abiNames, visitor);
        }
    }

    @NotNull
    public static Map<String, String> getSourceMap(@NotNull AndroidFacet facet) {
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        AndroidApkFacet apkFacet = AndroidApkFacet.getInstance((Module)facet.getModule());
        if (apkFacet != null) {
            for (Map.Entry entry : ((AndroidApkFacetConfiguration)apkFacet.getConfiguration()).SOURCE_MAP.entrySet()) {
                if (((String)entry.getValue()).isEmpty() || ((String)entry.getKey()).equals(entry.getValue())) continue;
                sourceMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return sourceMap;
    }

    @NotNull
    public static Collection<File> getSymbolsDir(@NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull List<Abi> abis) {
        AndroidGradleModel androidModel;
        final LinkedHashSet symDirs = Sets.newLinkedHashSet();
        AndroidNativeDebugProcess.addSymbolDirectories(symDirs, debuggerState.getSymbolDirs());
        AndroidApkFacet apkFacet = AndroidApkFacet.getInstance((Module)facet.getModule());
        if (apkFacet != null) {
            AndroidNativeDebugProcess.addSymbolDirectories(symDirs, ((AndroidApkFacetConfiguration)apkFacet.getConfiguration()).SYMBOL_PATHS);
        }
        if ((androidModel = AndroidGradleModel.get((AndroidFacet)facet)) != null) {
            for (SourceProvider sourceProvider : androidModel.getActiveSourceProviders()) {
                for (File jniLib : sourceProvider.getJniLibsDirectories()) {
                    if (!jniLib.exists()) continue;
                    for (Abi abi : abis) {
                        File abiJniLib = new File(jniLib, abi.toString());
                        if (!abiJniLib.exists()) continue;
                        symDirs.add(abiJniLib);
                    }
                }
            }
        }
        AndroidNativeDebugProcess.visitNativeLibraries(facet.getModule(), AndroidNativeDebugProcess.getAbiNameSet(abis), new NativeLibraryVisitor(){

            @Override
            public void visit(@NotNull NativeLibrary nativeLibrary) {
                symDirs.addAll(nativeLibrary.getDebuggableLibraryFolders());
            }

            @Override
            public void visit(@NotNull NativeAndroidGradleModel nativeModel, @NotNull NativeArtifact nativeArtifact) {
                symDirs.add(nativeArtifact.getOutputFile().getParentFile());
            }
        });
        return symDirs;
    }

    private static void addSymbolDirectories(@NotNull Set<File> symDirs, @NotNull Iterable<String> paths) {
        for (String path : paths) {
            File dir = new File(FileUtils.toSystemDependentPath((String)path));
            symDirs.add(dir);
            FluentIterable dirIt = Files.fileTreeTraverser().preOrderTraversal((Object)dir).filter(Files.isDirectory());
            dirIt.copyInto(symDirs);
        }
    }

    public static void verifyNativeModel(@NotNull AndroidFacet facet, @NotNull List<Abi> abis, final @NotNull ConsolePrinter printer) {
        AndroidNativeDebugProcess.visitNativeLibraries(facet.getModule(), AndroidNativeDebugProcess.getAbiNameSet(abis), new NativeLibraryVisitor(){

            @Override
            public void visit(@NotNull NativeLibrary nativeLibrary) {
                HashSet compilerFlags = Sets.newHashSet();
                compilerFlags.addAll(nativeLibrary.getCCompilerFlags());
                compilerFlags.addAll(nativeLibrary.getCppCompilerFlags());
                this.verifyCompilerFlags(nativeLibrary.getName(), compilerFlags);
            }

            @Override
            public void visit(@NotNull NativeAndroidGradleModel nativeModel, @NotNull NativeArtifact nativeArtifact) {
                HashSet compilerFlags = Sets.newHashSet();
                for (NativeFile nativeFile : nativeArtifact.getSourceFiles()) {
                    NativeSettings settings = nativeModel.findSettings(nativeFile.getSettingsName());
                    if (settings == null) {
                        LOG.warn(String.format("Cannot find settings \"%s\" for native file \"%s\"", nativeFile.getSettingsName(), nativeFile.getFilePath()));
                        continue;
                    }
                    compilerFlags.addAll(settings.getCompilerFlags());
                }
                for (NativeFolder nativeFolder : nativeArtifact.getSourceFolders()) {
                    for (Map.Entry setting : nativeFolder.getPerLanguageSettings().entrySet()) {
                        NativeSettings settings = nativeModel.findSettings((String)setting.getValue());
                        if (settings == null) {
                            LOG.warn(String.format("Cannot find settings \"%s\" for native folder \"%s\"", setting.getValue(), nativeFolder.getFolderPath()));
                            continue;
                        }
                        compilerFlags.addAll(settings.getCompilerFlags());
                    }
                }
                this.verifyCompilerFlags(nativeArtifact.getName(), compilerFlags);
            }

            private void verifyCompilerFlags(@NotNull String libraryName, @NotNull Collection<String> compilerFlags) {
                HashMap foundDangerousFlags = Maps.newHashMap();
                for (Map.Entry flag : DANGEROUS_COMPILER_FLAGS.entrySet()) {
                    if (!compilerFlags.contains(flag.getKey())) continue;
                    foundDangerousFlags.put(flag.getKey(), flag.getValue());
                }
                if (!foundDangerousFlags.isEmpty()) {
                    printer.stderr(String.format("Native library %s is using compiler flags which may be debug incompatible:", libraryName));
                    for (Map.Entry flag : foundDangerousFlags.entrySet()) {
                        printer.stderr(String.format("%s: %s", flag.getKey(), flag.getValue()));
                    }
                }
            }
        });
    }

    @NotNull
    protected XExecutionStack newExecutionStack(@NotNull DebuggerDriver driver, @NotNull LLThread thread, boolean current, @Nullable CidrSuspensionCause suspensionCause) throws ExecutionException {
        if (System.getProperty("com.google.android-studio.lazy-backtraces", "yes").equals("yes")) {
            return new AndroidNativeExecutionStack(this, driver, thread, current, suspensionCause);
        }
        return super.newExecutionStack(driver, thread, current, suspensionCause);
    }

    protected void handleCommandException(@NotNull DebuggerDriver driver, @NotNull CidrDebugProcess.DebuggerCommand command, @NotNull ExecutionException exception) {
        AndroidNativeDebugProcess.reportError(exception);
        if (!AndroidLLDBBreakpadIntegration.checkForCrashes((AndroidLLDBDriver)driver)) {
            super.handleCommandException(driver, command, exception);
        }
    }

    public void handleModulesLoaded(@NotNull List<String> modules) {
        this.myLoadedModules.addAll(modules);
        for (String module : modules) {
            this.myAttachProgressReporter.step("Loaded module: " + module);
        }
    }

    private static void reportError(@NotNull Throwable e) {
        LLDBUsageTracker.trackSessionFailed(e);
    }

    static {
        AndroidLLDBBreakpadIntegration.checkForStaleMinidumps();
    }

    private static interface NativeLibraryVisitor {
        public void visit(@NotNull NativeLibrary var1);

        public void visit(@NotNull NativeAndroidGradleModel var1, @NotNull NativeArtifact var2);
    }
}

