/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.ddmlib.IDevice;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class NdkHelper {
    @NotNull
    public static String getArchitectureId(@NotNull Abi abi) {
        switch (abi) {
            case ARMEABI_V7A: 
            case ARMEABI: 
            case ARM64_V8A: {
                return ArchitectureType.ARM.name().toLowerCase();
            }
            case X86_64: {
                return ArchitectureType.X86_64.name().toLowerCase();
            }
            case X86: {
                return ArchitectureType.I386.name().toLowerCase();
            }
        }
        return ArchitectureType.UNKNOWN.name().toLowerCase();
    }

    @NotNull
    public static Abi getAbi(@NotNull IDevice targetDevice) {
        List abis = targetDevice.getAbis();
        for (String a : abis) {
            Abi abi = Abi.getEnum((String)a);
            if (abi == null) continue;
            return abi;
        }
        return Abi.ARMEABI_V7A;
    }

    @NotNull
    private static String getHostPlatformString() {
        String platformString;
        if (SystemInfo.isLinux) {
            platformString = "linux";
        } else if (SystemInfo.isWindows) {
            platformString = "windows";
        } else if (SystemInfo.isMac) {
            platformString = "darwin";
        } else {
            return "UNKNOWN";
        }
        platformString = platformString + "-";
        if (SystemInfo.is64Bit) {
            platformString = platformString + "x86_64";
        } else if (SystemInfo.is32Bit) {
            platformString = platformString + "x86";
        } else {
            return "UNKNOWN";
        }
        return platformString;
    }

    @NotNull
    public static File getLibStdCxxPrintersPath(@NotNull File ndkRoot, @NotNull String gccVersion) {
        File prebuilt = new File(ndkRoot, "prebuilt");
        File hostPlatform = new File(prebuilt, NdkHelper.getHostPlatformString());
        File share = new File(hostPlatform, "share");
        File prettyPrinters = new File(share, "pretty-printers");
        File libStdCxx = new File(prettyPrinters, "libstdcxx");
        File fullPath = new File(libStdCxx, "gcc-" + gccVersion);
        return fullPath;
    }

    public static boolean isNdkProject(@NotNull Project project) {
        return AndroidProjectInfo.get((Project)project).hasNativeModules();
    }

    public static void disableCppLanguageSupport(@NotNull Project project, boolean disable) {
        OCLanguage.LANGUAGE_SUPPORT_DISABLED.set((UserDataHolder)project, (Object)disable);
        UIUtil.invokeAndWaitIfNeeded(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            if (project.isDisposed()) {
                return;
            }
            OCLanguage langToReset = disable ? OCLanguage.getInstance() : PlainTextLanguage.INSTANCE;
            FileManager fileManager = ((PsiManagerEx)PsiManager.getInstance((Project)project)).getFileManager();
            for (PsiFile file : fileManager.getAllCachedFiles()) {
                VirtualFile vf;
                if (file.getLanguage() != langToReset || (vf = OCInclusionContextUtil.getVirtualFile((PsiFile)file)) == null) continue;
                fileManager.setViewProvider(vf, null);
            }
        }));
    }

    @NotNull
    public static String getNdkVersion(@NotNull File ndkRoot) throws ExecutionException {
        File sourcePropertiesFile = new File(ndkRoot, "source.properties");
        if (sourcePropertiesFile.exists()) {
            FileInputStream fileInput = null;
            try {
                fileInput = new FileInputStream(sourcePropertiesFile);
                Properties props = new Properties();
                props.load(fileInput);
                String string = props.getProperty("Pkg.Revision");
                return string;
            }
            catch (Exception e) {
                throw new ExecutionException((Throwable)e);
            }
            finally {
                if (fileInput != null) {
                    try {
                        ((InputStream)fileInput).close();
                    }
                    catch (IOException e) {
                        throw new ExecutionException((Throwable)e);
                    }
                }
            }
        }
        File releaseTxtFile = new File(ndkRoot, "RELEASE.TXT");
        if (releaseTxtFile.exists()) {
            try {
                byte[] content = Files.readAllBytes(releaseTxtFile.toPath());
                return new String(content).trim();
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
        return "UNKNOWN";
    }
}

