/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeFolder;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.NativeAndroidGradleModel;
import com.android.tools.idea.gradle.facet.NativeAndroidGradleFacet;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.service.notification.errors.NdkLocationNotFoundErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.stats.UsageTracker;
import com.android.tools.ndk.AndroidSysroot;
import com.android.tools.ndk.ModuleResolveConfiguration;
import com.android.tools.ndk.NdkCompilerInfoCache;
import com.android.tools.ndk.NdkHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeaderRoots;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleWorkspace
extends AbstractProjectComponent
implements OCWorkspace {
    private static final String GRADLE_LANGUAGE_TYPE_C = "c";
    private static final String GRADLE_LANGUAGE_TYPE_CPP = "c++";
    private static final Logger LOG = Logger.getInstance(GradleWorkspace.class);
    @NotNull
    private final OCWorkspaceModificationTrackers myTrackers;
    @NotNull
    private final Map<String, OCLanguageKind> myProjectFileExtensions = Maps.newHashMap();
    @NotNull
    private Map<String, ModuleResolveConfiguration> myResolveConfigurations = ImmutableMap.of();
    @NotNull
    private NdkCompilerInfoCache myCompilerInfoCache = new NdkCompilerInfoCache();

    @NotNull
    public static GradleWorkspace getInstance(@NotNull Project project) {
        GradleWorkspace instance = (GradleWorkspace)((Object)project.getComponent(GradleWorkspace.class));
        assert (instance != null);
        return instance;
    }

    public GradleWorkspace(@NotNull Project project) {
        super(project);
        if (Projects.isBuildWithGradle((Project)project)) {
            OCLanguage.LANGUAGE_SUPPORT_DISABLED.set((UserDataHolder)project, (Object)true);
        }
        this.myTrackers = new OCWorkspaceModificationTrackers(project);
        GradleSyncState.subscribe((Project)this.myProject, (GradleSyncListener)new GradleSyncListener.Adapter(){

            public void syncSucceeded(@NotNull Project project) {
                GradleWorkspace.this.scheduleGradleWorkspaceUpdate();
            }

            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                GradleWorkspace.this.scheduleGradleWorkspaceUpdate();
            }

            public void syncSkipped(@NotNull Project project) {
                GradleWorkspace.this.scheduleGradleWorkspaceUpdate();
            }
        });
    }

    private void scheduleGradleWorkspaceUpdate() {
        this.myProjectFileExtensions.clear();
        this.myResolveConfigurations = ImmutableMap.of();
        this.myCompilerInfoCache = new NdkCompilerInfoCache();
        new Task.Backgroundable(this.myProject, "Resolving C/C++ Configurations", false){

            public void run(@NotNull ProgressIndicator indicator) {
                GradleWorkspace.this.updateGradleWorkspace(indicator);
            }
        }.queue();
    }

    private void logProjectInfo() {
        String gradleModelVersion = "UNKNOWN";
        GradleVersion gradleVersion = GradleUtil.getGradleVersion((Project)this.myProject);
        if (gradleVersion != null) {
            gradleModelVersion = gradleVersion.toString();
        }
        String ndkVersion = "UNKNOWN";
        try {
            File ndkPath = this.getNdkPath();
            if (ndkPath != null) {
                ndkVersion = NdkHelper.getNdkVersion(ndkPath);
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        LOG.info(String.format("Project settings: Gradle model version=%s, NDK version=%s", gradleModelVersion, ndkVersion));
    }

    /*
     * WARNING - void declaration
     */
    private void updateGradleWorkspace(@NotNull ProgressIndicator indicator) {
        boolean newDisableLanguageSupport;
        boolean isValidNdkProject;
        indicator.setIndeterminate(true);
        String incompatibleModelVersion = GradleWorkspace.getModelVersionIfIncompatible(this.myProject);
        boolean isNdkSpecified = this.isNdkDefined() && SdkPaths.validateAndroidNdk((File)this.getNdkPath(), (boolean)false).success;
        HashMap projectResolveConfigurations = Maps.newHashMap();
        ArrayList nativeAppModules = Lists.newArrayList();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            void var12_14;
            void var11_13;
            ImmutableMap moduleFileExtensions;
            Map<String, ModuleResolveConfiguration> moduleResolveConfigurations;
            AndroidGradleModel androidModel = AndroidGradleModel.get((Module)module);
            NativeAndroidGradleModel nativeAndroidModel = NativeAndroidGradleModel.get((Module)module);
            if (nativeAndroidModel != null) {
                moduleResolveConfigurations = GradleWorkspace.getResolveConfigurations(this.myProject, this.myCompilerInfoCache, nativeAndroidModel);
                moduleFileExtensions = GradleWorkspace.getFileExtensions(nativeAndroidModel);
            } else {
                if (androidModel == null) continue;
                moduleResolveConfigurations = GradleWorkspace.getResolveConfigurations(this.myProject, this.myCompilerInfoCache, androidModel);
                moduleFileExtensions = ImmutableMap.of();
            }
            if (androidModel != null && !var11_13.isEmpty()) {
                nativeAppModules.add(module);
            }
            if (!var11_13.isEmpty()) {
                if (incompatibleModelVersion != null) {
                    GradleWorkspace.addModelVersionIncompatibilityNotification(incompatibleModelVersion, this.myProject);
                    return;
                }
                if (!isNdkSpecified) {
                    this.addNdkNotSpecifiedNotification(this.myProject, this.isNdkDefined());
                    return;
                }
            }
            projectResolveConfigurations.putAll(var11_13);
            this.myProjectFileExtensions.putAll((Map<String, OCLanguageKind>)var12_14);
        }
        this.myResolveConfigurations = GradleWorkspace.getValidConfigurations(projectResolveConfigurations);
        boolean bl = isValidNdkProject = !this.myResolveConfigurations.isEmpty();
        if (isValidNdkProject) {
            UsageTracker.getInstance().trackEvent("gradle", "cppSyncCompleted", null, null);
            this.logProjectInfo();
        }
        boolean bl2 = newDisableLanguageSupport = !isValidNdkProject;
        if ((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)this.myProject, (Object)false) != newDisableLanguageSupport) {
            NdkHelper.disableCppLanguageSupport(this.myProject, newDisableLanguageSupport);
            if (newDisableLanguageSupport) {
                LOG.warn("NDK support for project '" + this.myProject.getName() + "' is disabled " + "because the project doesn't contain any valid native configurations.");
            }
        }
        new ReadAction(){

            protected void run(@NotNull Result result) throws Throwable {
                if (GradleWorkspace.this.myProject.isDisposed()) {
                    return;
                }
                GradleWorkspace.this.myTrackers.getProjectFilesListTracker().incModificationCount();
                GradleWorkspace.this.myTrackers.getSourceFilesListTracker().incModificationCount();
                GradleWorkspace.this.myTrackers.getBuildConfigurationChangesTracker().incModificationCount();
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    GradleWorkspace.this.myTrackers.getBuildSettingsChangesTracker().incModificationCount();
                }
            }
        }.execute();
        AndroidProjectInfo projectInfo = AndroidProjectInfo.get((Project)this.myProject);
        projectInfo.setHasNativeModules(!nativeAppModules.isEmpty());
    }

    @Nullable
    private static String getModelVersionIfIncompatible(@NotNull Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidProject androidProject;
            String version;
            AndroidGradleModel androidModel;
            AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
            if (androidFacet == null || (androidModel = AndroidGradleModel.get((AndroidFacet)androidFacet)) == null || (version = GradleWorkspace.getModelVersionIfIncompatible(androidProject = androidModel.getAndroidProject())) == null) continue;
            return version;
        }
        return null;
    }

    private static void addModelVersionIncompatibilityNotification(@NotNull String modelVersion, @NotNull Project project) {
        String text = String.format("Android plugin version %1$s is not compatible with the NDK support. ", modelVersion) + "Please use the experimental plugin.";
        ProjectSyncMessages.getInstance((Project)project).add(new Message("Gradle Sync Issue", Message.Type.WARNING, new String[]{text}), new NotificationHyperlink[0]);
        String title = "Incompatible Android Plugin Version";
        AndroidGradleNotification.getInstance((Project)project).showBalloon(title, text, NotificationType.WARNING);
    }

    private void addNdkNotSpecifiedNotification(@NotNull Project project, boolean isNdkDefined) {
        boolean ndkInSdk = this.isNdkInSdk();
        NotificationHyperlink downloadLink = NdkLocationNotFoundErrorHandler.getSelectNdkNotificationHyperlink((!ndkInSdk ? 1 : 0) != 0);
        AndroidGradleNotification.getInstance((Project)project).showBalloon("Project Sync Error", String.format("Android NDK location is not %1$s.", isNdkDefined ? "valid" : "specified"), NotificationType.ERROR, new NotificationHyperlink[]{downloadLink});
    }

    @NotNull
    private static Map<String, ModuleResolveConfiguration> getResolveConfigurations(@NotNull Project project, @NotNull NdkCompilerInfoCache compilerInfoCache, @NotNull AndroidGradleModel androidModel) {
        HashMap configurations = Maps.newHashMap();
        AndroidProject androidProject = androidModel.getAndroidProject();
        Map<String, NativeToolchain> toolchains = GradleWorkspace.getToolchainsByName(androidProject);
        for (Variant variant : androidProject.getVariants()) {
            Collection<NativeLibrary> nativeLibraries = GradleWorkspace.getNativeLibraries(variant, androidProject);
            for (NativeLibrary library : nativeLibraries) {
                NativeToolchain toolchain = toolchains.get(library.getToolchainName());
                String key = GradleWorkspace.getResolvedConfigurationKey(androidModel, variant, library);
                if (toolchain == null || configurations.containsKey(key)) continue;
                ModuleResolveConfiguration configuration = new ModuleResolveConfiguration(project, androidModel.getRootDirPath(), compilerInfoCache, library, toolchain);
                configurations.put(key, configuration);
            }
        }
        return configurations;
    }

    @NotNull
    private static Map<String, NativeToolchain> getToolchainsByName(@NotNull AndroidProject androidProject) {
        if (GradleWorkspace.isModelVersionIncompatible(androidProject)) {
            return Collections.emptyMap();
        }
        HashMap toolchains = Maps.newHashMap();
        for (NativeToolchain toolchain : androidProject.getNativeToolchains()) {
            toolchains.put(toolchain.getName(), toolchain);
        }
        return toolchains;
    }

    private static String getResolvedConfigurationKey(AndroidGradleModel androidModel, Variant variant, NativeLibrary library) {
        return androidModel.getModuleName() + variant.getName() + library.getAbi();
    }

    @NotNull
    private static Map<String, ModuleResolveConfiguration> getResolveConfigurations(@NotNull Project project, @NotNull NdkCompilerInfoCache compilerInfoCache, @NotNull NativeAndroidGradleModel nativeAndroidModel) {
        HashMap configurations = Maps.newHashMap();
        for (NativeAndroidGradleModel.NativeVariant variant : nativeAndroidModel.getVariants()) {
            for (NativeArtifact artifact : variant.getArtifacts()) {
                NativeToolchain toolchain = nativeAndroidModel.findToolchain(artifact.getToolChain());
                if (toolchain == null) continue;
                for (NativeFolder folder : artifact.getSourceFolders()) {
                    for (String settingsName : folder.getPerLanguageSettings().values()) {
                        File workingDirectory;
                        String key;
                        NativeSettings settings = nativeAndroidModel.findSettings(settingsName);
                        if (settings == null || configurations.containsKey(key = GradleWorkspace.getResolvedConfigurationKey(artifact, toolchain, settings, workingDirectory = GradleWorkspace.getWorkingDirectory(nativeAndroidModel, folder)))) continue;
                        ModuleResolveConfiguration configuration = new ModuleResolveConfiguration(project, workingDirectory, compilerInfoCache, toolchain, artifact, settings);
                        configurations.put(key, configuration);
                    }
                }
                for (NativeFile file : artifact.getSourceFiles()) {
                    File workingDirectory;
                    String key;
                    NativeSettings settings = nativeAndroidModel.findSettings(file.getSettingsName());
                    if (settings == null || configurations.containsKey(key = GradleWorkspace.getResolvedConfigurationKey(artifact, toolchain, settings, workingDirectory = GradleWorkspace.getWorkingDirectory(nativeAndroidModel, file)))) continue;
                    ModuleResolveConfiguration configuration = new ModuleResolveConfiguration(project, workingDirectory, compilerInfoCache, toolchain, artifact, settings);
                    configurations.put(key, configuration);
                }
            }
        }
        return configurations;
    }

    @NotNull
    private static String getResolvedConfigurationKey(@NotNull NativeArtifact artifact, @NotNull NativeToolchain toolchain, @NotNull NativeSettings settings, @NotNull File workingDirectory) {
        return artifact.getName() + toolchain.getName() + settings.getName() + FileUtilRt.toSystemIndependentName((String)workingDirectory.getPath());
    }

    @NotNull
    private static File getWorkingDirectory(@NotNull NativeAndroidGradleModel nativeAndroidModel, @NotNull NativeFile nativeFile) {
        File workingDirectory = null;
        if (nativeAndroidModel.modelVersionIsAtLeast("2.0.0")) {
            workingDirectory = nativeFile.getWorkingDirectory();
        }
        if (workingDirectory != null) {
            return workingDirectory;
        }
        return nativeAndroidModel.getRootDirPath();
    }

    @NotNull
    private static File getWorkingDirectory(@NotNull NativeAndroidGradleModel nativeAndroidModel, @NotNull NativeFolder nativeFolder) {
        File workingDirectory = null;
        if (nativeAndroidModel.modelVersionIsAtLeast("2.0.0")) {
            workingDirectory = nativeFolder.getWorkingDirectory();
        }
        if (workingDirectory != null) {
            return workingDirectory;
        }
        return nativeAndroidModel.getRootDirPath();
    }

    @NotNull
    private static Map<String, OCLanguageKind> getFileExtensions(@NotNull NativeAndroidGradleModel nativeAndroidModel) {
        HashMap fileExtensions = Maps.newHashMap();
        for (Map.Entry entry : nativeAndroidModel.getNativeAndroidProject().getFileExtensions().entrySet()) {
            String fileExtension = (String)entry.getKey();
            String languageType = (String)entry.getValue();
            OCLanguageKind languageKind = null;
            if (GRADLE_LANGUAGE_TYPE_C.equals(languageType)) {
                languageKind = OCLanguageKind.C;
            } else if (GRADLE_LANGUAGE_TYPE_CPP.equals(languageType)) {
                languageKind = OCLanguageKind.CPP;
            }
            if (languageKind == null) {
                LOG.warn(String.format("Unknown language type '%1$s' found in '%2$s'", languageType, nativeAndroidModel.getModuleName()));
                continue;
            }
            fileExtensions.put(fileExtension, languageKind);
        }
        return fileExtensions;
    }

    public boolean isNdkDefined() {
        return this.getNdkPath() != null;
    }

    @Nullable
    public File getNdkPath() {
        try {
            return new LocalProperties(this.myProject).getAndroidNdkPath();
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file of Project '%1$s'", this.myProject.getName());
            LOG.info(msg, (Throwable)e);
            return null;
        }
    }

    @Nullable
    public File getSdkPath() {
        try {
            return new LocalProperties(this.myProject).getAndroidSdkPath();
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file of Project '%1$s'", this.myProject.getName());
            LOG.info(msg, (Throwable)e);
            return null;
        }
    }

    private boolean isNdkInSdk() {
        return this.getNdkPath() != null && FileUtil.filesEqual((File)this.getNdkPath().getParentFile(), (File)this.getSdkPath());
    }

    public boolean isInSDK(@Nullable VirtualFile file) {
        return false;
    }

    public boolean areFromSameProject(@Nullable VirtualFile a, @Nullable VirtualFile b) {
        return false;
    }

    public boolean areFromSamePackage(@Nullable VirtualFile a, @Nullable VirtualFile b) {
        return false;
    }

    public boolean isFromWrongSDK(@NotNull OCSymbol symbol, @Nullable VirtualFile contextFile) {
        return false;
    }

    @NotNull
    public Collection<VirtualFile> getLibraryFilesToBuildSymbols() {
        return Collections.emptyList();
    }

    @NotNull
    public List<? extends OCResolveConfiguration> getConfigurations() {
        return Lists.newArrayList(this.myResolveConfigurations.values());
    }

    @NotNull
    public List<? extends OCResolveConfiguration> getConfigurationsForFile(@Nullable VirtualFile file) {
        if (file == null || !file.isValid() || this.myResolveConfigurations.isEmpty()) {
            return ImmutableList.of();
        }
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject);
        if (module == null) {
            return ImmutableList.of();
        }
        NativeAndroidGradleFacet nativeAndroidFacet = NativeAndroidGradleFacet.getInstance((Module)module);
        if (nativeAndroidFacet != null) {
            return this.getResolvedConfigurations(ioFile, nativeAndroidFacet);
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
        if (androidFacet != null) {
            return this.getResolvedConfigurations(androidFacet);
        }
        ArrayList configurations = Lists.newArrayList();
        block0: for (ModuleResolveConfiguration configuration : this.myResolveConfigurations.values()) {
            HeaderRoots headerRoots = configuration.getLibraryHeadersRoots(new OCResolveRootAndConfiguration(null, file));
            for (PsiFileSystemItem root : headerRoots.getRoots()) {
                VirtualFile rootFile = root.getVirtualFile();
                if (rootFile == null || !FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)rootFile), (File)ioFile, (boolean)true)) continue;
                configurations.add(configuration);
                continue block0;
            }
        }
        return ImmutableList.copyOf((Collection)configurations);
    }

    @NotNull
    private List<? extends OCResolveConfiguration> getResolvedConfigurations(@NotNull AndroidFacet androidFacet) {
        AndroidGradleModel androidModel = AndroidGradleModel.get((AndroidFacet)androidFacet);
        if (androidModel == null) {
            return ImmutableList.of();
        }
        ArrayList configurations = Lists.newArrayList();
        Variant variant = androidModel.getSelectedVariant();
        Collection<NativeLibrary> nativeLibraries = GradleWorkspace.getNativeLibraries(variant, androidModel.getAndroidProject());
        for (NativeLibrary nativeLibrary : nativeLibraries) {
            String key = GradleWorkspace.getResolvedConfigurationKey(androidModel, variant, nativeLibrary);
            ModuleResolveConfiguration configuration = this.myResolveConfigurations.get(key);
            if (configuration == null) continue;
            configurations.add(configuration);
        }
        return configurations;
    }

    private List<? extends OCResolveConfiguration> getResolvedConfigurations(@NotNull File file, @NotNull NativeAndroidGradleFacet nativeAndroidFacet) {
        NativeAndroidGradleModel nativeAndroidModel = nativeAndroidFacet.getNativeAndroidGradleModel();
        if (nativeAndroidModel == null) {
            return ImmutableList.of();
        }
        HashMap configurations = Maps.newHashMap();
        for (NativeArtifact artifact : nativeAndroidModel.getSelectedVariant().getArtifacts()) {
            ModuleResolveConfiguration configuration;
            NativeToolchain toolchain = nativeAndroidModel.findToolchain(artifact.getToolChain());
            if (toolchain == null) continue;
            String configurationKey = null;
            for (NativeFile sourceFile : artifact.getSourceFiles()) {
                NativeSettings settings;
                if (!FileUtil.filesEqual((File)sourceFile.getFilePath(), (File)file) || (settings = nativeAndroidModel.findSettings(sourceFile.getSettingsName())) == null) continue;
                File workingDirectory = GradleWorkspace.getWorkingDirectory(nativeAndroidModel, sourceFile);
                configurationKey = GradleWorkspace.getResolvedConfigurationKey(artifact, toolchain, settings, workingDirectory);
                break;
            }
            if (configurationKey == null) {
                File previouslyFoundFolderPath = null;
                for (NativeFolder sourceFolder : artifact.getSourceFolders()) {
                    NativeSettings settings;
                    String settingsName;
                    String languageType;
                    File folderPath = sourceFolder.getFolderPath();
                    if (!FileUtil.isAncestor((File)folderPath, (File)file, (boolean)true) || previouslyFoundFolderPath != null && FileUtil.isAncestor((File)folderPath, previouslyFoundFolderPath, (boolean)false) || (languageType = (String)nativeAndroidModel.getNativeAndroidProject().getFileExtensions().get(FileUtilRt.getExtension((String)file.getName()))) == null || (settingsName = (String)sourceFolder.getPerLanguageSettings().get(languageType)) == null || (settings = nativeAndroidModel.findSettings(settingsName)) == null) continue;
                    File workingDirectory = GradleWorkspace.getWorkingDirectory(nativeAndroidModel, sourceFolder);
                    configurationKey = GradleWorkspace.getResolvedConfigurationKey(artifact, toolchain, settings, workingDirectory);
                    previouslyFoundFolderPath = folderPath;
                }
            }
            if (configurationKey == null || configurations.containsKey(configurationKey) || (configuration = this.myResolveConfigurations.get(configurationKey)) == null) continue;
            configurations.put(configurationKey, configuration);
        }
        return ImmutableList.copyOf(configurations.values());
    }

    @NotNull
    private static Collection<NativeLibrary> getNativeLibraries(@NotNull Variant variant, @NotNull AndroidProject androidProject) {
        if (GradleWorkspace.isModelVersionIncompatible(androidProject)) {
            return Collections.emptyList();
        }
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        Collection nativeLibraries = mainArtifact.getNativeLibraries();
        if (nativeLibraries != null) {
            return nativeLibraries;
        }
        return Collections.emptyList();
    }

    private static boolean isModelVersionIncompatible(@NotNull AndroidProject androidProject) {
        return GradleWorkspace.getModelVersionIfIncompatible(androidProject) != null;
    }

    @Nullable
    private static String getModelVersionIfIncompatible(@NotNull AndroidProject androidProject) {
        String modelVersion = androidProject.getModelVersion();
        if (!modelVersion.startsWith("1.0") && !modelVersion.startsWith("1.1") && androidProject.getApiVersion() >= 3) {
            return null;
        }
        return modelVersion;
    }

    @NotNull
    private static Map<String, ModuleResolveConfiguration> getValidConfigurations(@NotNull Map<String, ModuleResolveConfiguration> configs) {
        ImmutableMap.Builder configurationsBuilder = ImmutableMap.builder();
        for (Map.Entry<String, ModuleResolveConfiguration> entry : configs.entrySet()) {
            if (!GradleWorkspace.isValidConfiguration(entry.getValue())) continue;
            configurationsBuilder.put(entry);
        }
        return configurationsBuilder.build();
    }

    private static boolean isValidConfiguration(@NotNull ModuleResolveConfiguration configuration) {
        if (!GradleWorkspace.isValidConfiguration(configuration, OCLanguageKind.C)) {
            return false;
        }
        return GradleWorkspace.isValidConfiguration(configuration, OCLanguageKind.CPP);
    }

    private static boolean isValidConfiguration(@NotNull ModuleResolveConfiguration configuration, @NotNull OCLanguageKind kind) {
        OCCompilerSettings compilerSettings = configuration.getCompilerSettings();
        CidrCompilerSwitches compilerSwitches = compilerSettings.getCompilerSwitches(kind, null);
        boolean isValidConfiguration = false;
        boolean isystemFound = false;
        for (String argument : compilerSwitches.getCommandLineArgs()) {
            String sysrootPath = StringUtil.trimStart((String)(argument = StringUtil.unquoteString((String)argument.trim())), (String)"--sysroot=");
            if (sysrootPath.length() < argument.length()) {
                File sysroot = new File(FileUtilRt.toSystemIndependentName((String)sysrootPath));
                if (!sysroot.isAbsolute()) {
                    sysroot = new File(compilerSettings.getCompilerWorkingDir(), sysroot.getPath());
                }
                if (isValidConfiguration = AndroidSysroot.isValidAndroidSysroot(sysroot)) continue;
                return false;
            }
            if (argument.equals("-isystem")) {
                isystemFound = true;
                continue;
            }
            if (!isystemFound) continue;
            isystemFound = false;
            File systemIncludePath = new File(FileUtilRt.toSystemIndependentName((String)argument));
            if (!systemIncludePath.isAbsolute()) {
                systemIncludePath = new File(compilerSettings.getCompilerWorkingDir(), systemIncludePath.getPath());
            }
            if (AndroidSysroot.isValidAndroidSysrootUsrInclude(systemIncludePath)) {
                isValidConfiguration = true;
                continue;
            }
            if (!AndroidSysroot.isPotentialNonAndroidSysrootUsrInclude(systemIncludePath)) continue;
            return false;
        }
        return isValidConfiguration;
    }

    @Nullable
    public OCResolveConfiguration getSelectedResolveConfiguration() {
        return null;
    }

    @NotNull
    public OCWorkspaceModificationTrackers getModificationTrackers() {
        return this.myTrackers;
    }

    @Nullable
    public OCLanguageKind getLanguageKind(@NotNull String fileName) {
        if (!OCFileTypeHelpers.isSourceFile((String)fileName)) {
            return null;
        }
        String fileExtension = FileUtilRt.getExtension((String)fileName);
        OCLanguageKind languageKind = this.myProjectFileExtensions.get(fileExtension);
        if (languageKind == null && !this.myResolveConfigurations.isEmpty()) {
            languageKind = fileExtension.equalsIgnoreCase(GRADLE_LANGUAGE_TYPE_C) ? OCLanguageKind.C : OCLanguageKind.CPP;
            LOG.warn(String.format("Unable to find language kind for files with extension '%1$s', assuming it as '%2$s'", fileExtension, languageKind));
            this.myProjectFileExtensions.put(fileExtension, languageKind);
        }
        return languageKind;
    }
}

