/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.pico.ConstructorInjectionComponentAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public abstract class AbstractExtensionPointBean
implements PluginAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.extensions.AbstractExtensionPointBean");
    protected PluginDescriptor myPluginDescriptor;

    @Override
    public final void setPluginDescriptor(PluginDescriptor pluginDescriptor) {
        this.myPluginDescriptor = pluginDescriptor;
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.myPluginDescriptor;
    }

    @NotNull
    public final <T> Class<T> findClass(String className) throws ClassNotFoundException {
        return Class.forName(className, true, this.getLoaderForClass());
    }

    @Nullable
    public final <T> Class<T> findClassNoExceptions(String className) {
        try {
            return this.findClass(className);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Problem loading class " + className + " from plugin " + this.myPluginDescriptor.getPluginId().getIdString(), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public ClassLoader getLoaderForClass() {
        return this.myPluginDescriptor == null ? this.getClass().getClassLoader() : this.myPluginDescriptor.getPluginClassLoader();
    }

    @NotNull
    public final <T> T instantiate(String className, @NotNull PicoContainer container) throws ClassNotFoundException {
        return AbstractExtensionPointBean.instantiate(this.findClass(className), container);
    }

    @NotNull
    public static <T> T instantiate(@NotNull Class<T> aClass, @NotNull PicoContainer container) {
        return AbstractExtensionPointBean.instantiate(aClass, container, false);
    }

    @NotNull
    public static <T> T instantiate(@NotNull Class<T> aClass, @NotNull PicoContainer container, boolean allowNonPublicClasses) {
        return (T)new ConstructorInjectionComponentAdapter((Object)aClass.getName(), aClass, null, allowNonPublicClasses).getComponentInstance(container);
    }
}

