/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login;

import com.google.common.collect.Lists;
import com.google.gct.login.CredentialedUser;
import com.google.gct.login.GoogleLoginListener;
import com.google.gct.login.GoogleLoginPrefs;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CredentialedUserRoster {
    private final LinkedHashMap<String, CredentialedUser> myAllUsers = new LinkedHashMap();
    private final Collection<GoogleLoginListener> myListeners = Lists.newLinkedList();
    private CredentialedUser myActiveUser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public LinkedHashMap<String, CredentialedUser> getAllUsers() {
        CredentialedUserRoster credentialedUserRoster = this;
        synchronized (credentialedUserRoster) {
            LinkedHashMap<String, CredentialedUser> clone = new LinkedHashMap<String, CredentialedUser>();
            clone.putAll(this.myAllUsers);
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllUsers(Map<String, CredentialedUser> users) {
        CredentialedUserRoster credentialedUserRoster = this;
        synchronized (credentialedUserRoster) {
            this.myAllUsers.clear();
            this.myAllUsers.putAll(users);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CredentialedUser getActiveUser() {
        CredentialedUserRoster credentialedUserRoster = this;
        synchronized (credentialedUserRoster) {
            return this.myActiveUser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveUser(@NotNull String userEmail) throws IllegalArgumentException {
        CredentialedUserRoster credentialedUserRoster = this;
        synchronized (credentialedUserRoster) {
            if (!this.myAllUsers.containsKey(userEmail)) {
                throw new IllegalArgumentException(userEmail + " is not a logged in user.");
            }
            if (this.myActiveUser != null) {
                this.myActiveUser.setActive(false);
            }
            this.myActiveUser = this.myAllUsers.get(userEmail);
            this.myActiveUser.setActive(true);
            GoogleLoginPrefs.saveActiveUser(userEmail);
            this.notifyLoginStatusChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveUser() {
        CredentialedUserRoster credentialedUserRoster = this;
        synchronized (credentialedUserRoster) {
            if (this.myActiveUser != null) {
                this.myActiveUser.setActive(false);
                this.myActiveUser = null;
                GoogleLoginPrefs.removeActiveUser();
                this.notifyLoginStatusChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfUsers() {
        CredentialedUserRoster credentialedUserRoster = this;
        synchronized (credentialedUserRoster) {
            return this.myAllUsers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActiveUserAvailable() {
        CredentialedUserRoster credentialedUserRoster = this;
        synchronized (credentialedUserRoster) {
            return this.myActiveUser != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUser(CredentialedUser user) {
        CredentialedUserRoster credentialedUserRoster = this;
        synchronized (credentialedUserRoster) {
            this.myAllUsers.put(user.getEmail(), user);
            this.setActiveUser(user.getEmail());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUser(String userEmail) {
        CredentialedUserRoster credentialedUserRoster = this;
        synchronized (credentialedUserRoster) {
            if (!this.myAllUsers.containsKey(userEmail)) {
                return false;
            }
            if (this.myActiveUser.getEmail().equals(userEmail)) {
                this.myActiveUser = null;
                GoogleLoginPrefs.removeActiveUser();
            }
            this.myAllUsers.remove(userEmail);
            this.notifyLoginStatusChange();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllUsers() {
        CredentialedUserRoster credentialedUserRoster = this;
        synchronized (credentialedUserRoster) {
            this.myAllUsers.clear();
            this.myActiveUser = null;
            GoogleLoginPrefs.removeAllUsers();
            this.notifyLoginStatusChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLoginListener(GoogleLoginListener listener) {
        Collection<GoogleLoginListener> collection = this.myListeners;
        synchronized (collection) {
            this.myListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLoginStatusChange() {
        Collection<GoogleLoginListener> collection = this.myListeners;
        synchronized (collection) {
            for (GoogleLoginListener listener : this.myListeners) {
                listener.statusChanged();
            }
        }
    }
}

