/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.instructions;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.artifacts.ArtifactOutputToSourceMapping;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.SourceFileFilter;

public abstract class ArtifactRootDescriptor
extends BuildRootDescriptor {
    protected final File myRoot;
    private final SourceFileFilter myFilter;
    private final int myRootIndex;
    private final ArtifactBuildTarget myTarget;
    private final DestinationInfo myDestinationInfo;

    protected ArtifactRootDescriptor(File root, @NotNull SourceFileFilter filter, int index, ArtifactBuildTarget target, @NotNull DestinationInfo destinationInfo) {
        this.myRoot = root;
        this.myFilter = filter;
        this.myRootIndex = index;
        this.myTarget = target;
        this.myDestinationInfo = destinationInfo;
    }

    public String toString() {
        return this.getFullPath();
    }

    protected abstract String getFullPath();

    public void writeConfiguration(PrintWriter out) {
        out.println(this.getFullPath());
        out.println("->" + this.myDestinationInfo.getOutputPath());
    }

    public ArtifactBuildTarget getTarget() {
        return this.myTarget;
    }

    @Override
    @NotNull
    public FileFilter createFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return ArtifactRootDescriptor.this.myFilter.accept(file.getAbsolutePath());
            }
        };
    }

    @Override
    @NotNull
    public final File getRootFile() {
        return this.myRoot;
    }

    @Override
    public String getRootId() {
        return String.valueOf(this.myRootIndex);
    }

    public abstract void copyFromRoot(String var1, int var2, String var3, CompileContext var4, BuildOutputConsumer var5, ArtifactOutputToSourceMapping var6) throws IOException, ProjectBuildException;

    public SourceFileFilter getFilter() {
        return this.myFilter;
    }

    public DestinationInfo getDestinationInfo() {
        return this.myDestinationInfo;
    }

    public int getRootIndex() {
        return this.myRootIndex;
    }
}

