/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.artifacts.JpsBuilderArtifactService;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.JpsArtifact;

public class ArtifactBuildTargetType
extends BuildTargetType<ArtifactBuildTarget> {
    public static final ArtifactBuildTargetType INSTANCE = new ArtifactBuildTargetType();

    public ArtifactBuildTargetType() {
        super("artifact");
    }

    @Override
    @NotNull
    public List<ArtifactBuildTarget> computeAllTargets(@NotNull JpsModel model) {
        Collection<JpsArtifact> artifacts = JpsBuilderArtifactService.getInstance().getArtifacts(model, true);
        ArrayList<ArtifactBuildTarget> targets = new ArrayList<ArtifactBuildTarget>(artifacts.size());
        for (JpsArtifact artifact : artifacts) {
            if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
            targets.add(new ArtifactBuildTarget(artifact));
        }
        return targets;
    }

    @NotNull
    public Loader createLoader(@NotNull JpsModel model) {
        return new Loader(model);
    }

    private static class Loader
    extends BuildTargetLoader<ArtifactBuildTarget> {
        private final Map<String, JpsArtifact> myArtifacts = new HashMap<String, JpsArtifact>();

        public Loader(JpsModel model) {
            for (JpsArtifact artifact : JpsBuilderArtifactService.getInstance().getArtifacts(model, true)) {
                this.myArtifacts.put(artifact.getName(), artifact);
            }
        }

        @Override
        @Nullable
        public ArtifactBuildTarget createTarget(@NotNull String targetId) {
            JpsArtifact artifact = this.myArtifacts.get(targetId);
            return artifact != null ? new ArtifactBuildTarget(artifact) : null;
        }
    }
}

