/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class BinaryContent {
    private final byte[] myBuffer;
    private final int myOffset;
    private final int myLength;

    public BinaryContent(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public BinaryContent(byte[] buf, int off, int len) {
        this.myBuffer = buf;
        this.myOffset = off;
        this.myLength = len;
    }

    public byte[] getBuffer() {
        return this.myBuffer;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getLength() {
        return this.myLength;
    }

    public byte[] toByteArray() {
        return Arrays.copyOfRange(this.myBuffer, this.myOffset, this.myOffset + this.myLength);
    }

    public void saveToFile(File file) throws IOException {
        try {
            BinaryContent._writeToFile(file, this);
        }
        catch (IOException e) {
            File parentFile = file.getParentFile();
            if (parentFile == null) {
                throw e;
            }
            if (!parentFile.mkdirs()) {
                throw e;
            }
            BinaryContent._writeToFile(file, this);
        }
    }

    private static void _writeToFile(File file, BinaryContent content) throws IOException {
        FileOutputStream stream = new FileOutputStream(file);
        try {
            ((OutputStream)stream).write(content.getBuffer(), content.getOffset(), content.getLength());
        }
        finally {
            ((OutputStream)stream).close();
        }
    }
}

