/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.incremental.ResourcesTarget;

public class ResourceRootDescriptor
extends BuildRootDescriptor {
    @NotNull
    private final File myRoot;
    @NotNull
    private final ResourcesTarget myTarget;
    @NotNull
    private final String myPackagePrefix;
    @NotNull
    private final Set<File> myExcludes;

    public ResourceRootDescriptor(@NotNull File root, @NotNull ResourcesTarget target, @NotNull String packagePrefix, @NotNull Set<File> excludes) {
        this.myPackagePrefix = packagePrefix;
        this.myRoot = root;
        this.myTarget = target;
        this.myExcludes = excludes;
    }

    @Override
    public File getRootFile() {
        return this.myRoot;
    }

    @Override
    @NotNull
    public Set<File> getExcludedRoots() {
        return this.myExcludes;
    }

    @NotNull
    public ResourcesTarget getTarget() {
        return this.myTarget;
    }

    @NotNull
    public String getPackagePrefix() {
        return this.myPackagePrefix;
    }

    @Override
    public boolean isGenerated() {
        return false;
    }

    public String toString() {
        return "ResourceRootDescriptor{target='" + this.myTarget + '\'' + ", root=" + this.myRoot + '}';
    }

    @Override
    public boolean canUseFileCache() {
        return true;
    }

    @Override
    public String getRootId() {
        return FileUtil.toSystemIndependentName((String)this.myRoot.getPath());
    }
}

