/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl.storage;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.storage.CompositeStorageOwner;
import org.jetbrains.jps.incremental.storage.StorageOwner;

public class BuildTargetStorages
extends CompositeStorageOwner {
    private final BuildTarget<?> myTarget;
    private final BuildDataPaths myPaths;
    private final ConcurrentMap<StorageProvider<?>, AtomicNotNullLazyValue<? extends StorageOwner>> myStorages = new ConcurrentHashMap(16, 0.75f, 1);

    public BuildTargetStorages(BuildTarget<?> target, BuildDataPaths paths) {
        this.myTarget = target;
        this.myPaths = paths;
    }

    @NotNull
    public <S extends StorageOwner> S getOrCreateStorage(final @NotNull StorageProvider<S> provider) throws IOException {
        AtomicNotNullLazyValue newValue;
        Object lazyValue = (NotNullLazyValue)this.myStorages.get(provider);
        if (lazyValue == null && (lazyValue = (NotNullLazyValue)this.myStorages.putIfAbsent(provider, (AtomicNotNullLazyValue<? extends StorageOwner>)(newValue = new AtomicNotNullLazyValue<S>(){

            @NotNull
            protected S compute() {
                try {
                    return provider.createStorage(BuildTargetStorages.this.myPaths.getTargetDataRoot(BuildTargetStorages.this.myTarget));
                }
                catch (IOException e) {
                    throw new BuildDataCorruptedException(e);
                }
            }
        }))) == null) {
            lazyValue = newValue;
        }
        try {
            return (S)((StorageOwner)lazyValue.getValue());
        }
        catch (BuildDataCorruptedException e) {
            throw e.getCause();
        }
    }

    @Override
    protected Iterable<? extends StorageOwner> getChildStorages() {
        return new Iterable<StorageOwner>(){

            @Override
            public Iterator<StorageOwner> iterator() {
                final Iterator iterator = BuildTargetStorages.this.myStorages.values().iterator();
                return new Iterator<StorageOwner>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public StorageOwner next() {
                        return (StorageOwner)((AtomicNotNullLazyValue)iterator.next()).getValue();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
    }
}

