/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.EcjParser;
import com.android.tools.lint.EcjSourceFile;
import com.android.tools.lint.psi.EcjPsiAnnotation;
import com.android.tools.lint.psi.EcjPsiAnnotationMethod;
import com.android.tools.lint.psi.EcjPsiAnnotationParameterList;
import com.android.tools.lint.psi.EcjPsiAnonymousClass;
import com.android.tools.lint.psi.EcjPsiArrayAccessExpression;
import com.android.tools.lint.psi.EcjPsiArrayInitializerExpression;
import com.android.tools.lint.psi.EcjPsiArrayInitializerMemberValue;
import com.android.tools.lint.psi.EcjPsiAssertStatement;
import com.android.tools.lint.psi.EcjPsiAssignmentExpression;
import com.android.tools.lint.psi.EcjPsiBinaryExpression;
import com.android.tools.lint.psi.EcjPsiBlockStatement;
import com.android.tools.lint.psi.EcjPsiBreakStatement;
import com.android.tools.lint.psi.EcjPsiCatchSection;
import com.android.tools.lint.psi.EcjPsiClass;
import com.android.tools.lint.psi.EcjPsiClassInitializer;
import com.android.tools.lint.psi.EcjPsiClassLevelDeclarationStatement;
import com.android.tools.lint.psi.EcjPsiClassObjectAccessExpression;
import com.android.tools.lint.psi.EcjPsiCodeBlock;
import com.android.tools.lint.psi.EcjPsiConditionalExpression;
import com.android.tools.lint.psi.EcjPsiConstructorReferenceExpression;
import com.android.tools.lint.psi.EcjPsiContinueStatement;
import com.android.tools.lint.psi.EcjPsiDeclarationStatement;
import com.android.tools.lint.psi.EcjPsiDoWhileStatement;
import com.android.tools.lint.psi.EcjPsiEmptyStatement;
import com.android.tools.lint.psi.EcjPsiEnumConstant;
import com.android.tools.lint.psi.EcjPsiEnumConstantInitializer;
import com.android.tools.lint.psi.EcjPsiExplicitConstructorCall;
import com.android.tools.lint.psi.EcjPsiExpression;
import com.android.tools.lint.psi.EcjPsiExpressionList;
import com.android.tools.lint.psi.EcjPsiExpressionListStatement;
import com.android.tools.lint.psi.EcjPsiExpressionStatement;
import com.android.tools.lint.psi.EcjPsiField;
import com.android.tools.lint.psi.EcjPsiForStatement;
import com.android.tools.lint.psi.EcjPsiForeachStatement;
import com.android.tools.lint.psi.EcjPsiIdentifier;
import com.android.tools.lint.psi.EcjPsiIfStatement;
import com.android.tools.lint.psi.EcjPsiImport;
import com.android.tools.lint.psi.EcjPsiImportList;
import com.android.tools.lint.psi.EcjPsiInstanceOfExpression;
import com.android.tools.lint.psi.EcjPsiJavaCodeReferenceElement;
import com.android.tools.lint.psi.EcjPsiJavaFile;
import com.android.tools.lint.psi.EcjPsiLabeledStatement;
import com.android.tools.lint.psi.EcjPsiLambdaExpression;
import com.android.tools.lint.psi.EcjPsiLiteralExpression;
import com.android.tools.lint.psi.EcjPsiLocalVariable;
import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.EcjPsiMethod;
import com.android.tools.lint.psi.EcjPsiMethodCallExpression;
import com.android.tools.lint.psi.EcjPsiMethodReferenceExpression;
import com.android.tools.lint.psi.EcjPsiModifierList;
import com.android.tools.lint.psi.EcjPsiNameValuePair;
import com.android.tools.lint.psi.EcjPsiNewExpression;
import com.android.tools.lint.psi.EcjPsiPackageStatement;
import com.android.tools.lint.psi.EcjPsiParameter;
import com.android.tools.lint.psi.EcjPsiParameterList;
import com.android.tools.lint.psi.EcjPsiPostfixExpression;
import com.android.tools.lint.psi.EcjPsiPrefixExpression;
import com.android.tools.lint.psi.EcjPsiReferenceExpression;
import com.android.tools.lint.psi.EcjPsiReferenceList;
import com.android.tools.lint.psi.EcjPsiReferenceParameterList;
import com.android.tools.lint.psi.EcjPsiResourceList;
import com.android.tools.lint.psi.EcjPsiResourceVariable;
import com.android.tools.lint.psi.EcjPsiReturnStatement;
import com.android.tools.lint.psi.EcjPsiSourceElement;
import com.android.tools.lint.psi.EcjPsiStatement;
import com.android.tools.lint.psi.EcjPsiStaticImport;
import com.android.tools.lint.psi.EcjPsiSuperExpression;
import com.android.tools.lint.psi.EcjPsiSwitchLabelStatement;
import com.android.tools.lint.psi.EcjPsiSwitchStatement;
import com.android.tools.lint.psi.EcjPsiSynchronizedStatement;
import com.android.tools.lint.psi.EcjPsiThisExpression;
import com.android.tools.lint.psi.EcjPsiThrowStatement;
import com.android.tools.lint.psi.EcjPsiTryStatement;
import com.android.tools.lint.psi.EcjPsiTypeCastExpression;
import com.android.tools.lint.psi.EcjPsiTypeElement;
import com.android.tools.lint.psi.EcjPsiTypeParameter;
import com.android.tools.lint.psi.EcjPsiTypeParameterList;
import com.android.tools.lint.psi.EcjPsiWhileStatement;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.AssertStatement;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.BreakStatement;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ContinueStatement;
import org.eclipse.jdt.internal.compiler.ast.DoStatement;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.ForStatement;
import org.eclipse.jdt.internal.compiler.ast.ForeachStatement;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression;
import org.eclipse.jdt.internal.compiler.ast.LabeledStatement;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.PostfixExpression;
import org.eclipse.jdt.internal.compiler.ast.PrefixExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.ast.UnionTypeReference;
import org.eclipse.jdt.internal.compiler.ast.WhileStatement;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public class EcjPsiBuilder {
    static final boolean DEBUG = false;
    private static boolean sAddWhitespaceNodes = false;
    private static boolean sAddParentheses = false;
    private static final char[] PACKAGE_INFO = "package-info".toCharArray();
    private final EcjPsiManager mManager;
    static List<EcjPsiSourceElement> sElements;

    EcjPsiBuilder(EcjPsiManager manager) {
        this.mManager = manager;
    }

    public static void setDebugOptions(boolean addWhitespace, boolean addParens) {
        sAddWhitespaceNodes = addWhitespace;
        sAddParentheses = addParens;
    }

    private static void checkElements(EcjPsiSourceElement root) {
    }

    private static void checkChildOrder(EcjPsiSourceElement element) {
    }

    static void registerElement(EcjPsiSourceElement element) {
    }

    private void insertWhitespace(EcjPsiSourceElement root) {
        EcjPsiSourceElement current = root.mFirstChild;
        while (current != null) {
            this.insertWhitespace(current);
            current = current.mNextSibling;
        }
        current = root.mFirstChild;
        if (root.mFirstChild == null) {
            return;
        }
        while (current != null) {
            EcjPsiSourceElement next = current.mNextSibling;
            TestWhitespace inserted = new TestWhitespace();
            int offset = current.getTextRange().getStartOffset();
            inserted.setRange(offset, offset);
            inserted.mParent = root;
            if (root.mFirstChild == current) {
                root.mFirstChild = inserted;
            }
            if (current.mPrevSibling != null) {
                inserted.mPrevSibling = current.mPrevSibling;
                current.mPrevSibling.mNextSibling = inserted;
                current.mPrevSibling = null;
            }
            inserted.mNextSibling = current;
            current.mPrevSibling = inserted;
            current = next;
        }
        TestWhitespace inserted = new TestWhitespace();
        inserted.mParent = root;
        root.mLastChild.mNextSibling = inserted;
        inserted.mPrevSibling = root.mLastChild;
        root.mLastChild = inserted;
    }

    private void insertParentheses(EcjPsiSourceElement root) {
        EcjPsiSourceElement current = root.mFirstChild;
        while (current != null) {
            this.insertParentheses(current);
            current = current.mNextSibling;
        }
        current = root.mFirstChild;
        while (current != null) {
            EcjPsiSourceElement next = current.mNextSibling;
            if (current instanceof PsiExpression) {
                TestParentheses inserted = new TestParentheses((PsiExpression)current);
                inserted.mRange = current.mRange;
                inserted.mFirstChild = inserted.mLastChild = current;
                current.mParent = inserted;
                inserted.mParent = root;
                if (root.mFirstChild == current) {
                    root.mFirstChild = inserted;
                }
                if (root.mLastChild == current) {
                    root.mLastChild = inserted;
                }
                if (current.mPrevSibling != null) {
                    inserted.mPrevSibling = current.mPrevSibling;
                    current.mPrevSibling.mNextSibling = inserted;
                    current.mPrevSibling = null;
                }
                if (current.mNextSibling != null) {
                    inserted.mNextSibling = current.mNextSibling;
                    current.mNextSibling.mPrevSibling = inserted;
                    current.mNextSibling = null;
                }
            }
            current = next;
        }
    }

    public static EcjPsiJavaFile create(EcjPsiManager manager, CompilationUnitDeclaration unit, EcjSourceFile source) {
        EcjPsiBuilder builder = new EcjPsiBuilder(manager);
        EcjPsiJavaFile file = builder.toFile(unit, source);
        if (sAddParentheses) {
            builder.insertParentheses(file);
        }
        if (sAddWhitespaceNodes) {
            builder.insertWhitespace(file);
        }
        return file;
    }

    static TextRange toRange(long ecjPos) {
        int start = (int)(ecjPos >> 32);
        int end = (int)(ecjPos & 0xFFFFFFFFL) + 1;
        return new TextRange(start, end);
    }

    static TextRange toRange(int start, int end) {
        return new TextRange(start, end);
    }

    static TextRange toRange(ASTNode node) {
        int sourceStart = node.sourceStart;
        int endOffset = node.sourceEnd + 1;
        int parens = (node.bits & 0x1FE00000) >> 21;
        if (parens > 0 && (endOffset -= parens) < (sourceStart += parens)) {
            sourceStart = node.sourceStart;
            endOffset = node.sourceEnd + 1;
        }
        return new TextRange(sourceStart, endOffset);
    }

    EcjPsiPackageStatement toPackageStatement(EcjPsiSourceElement parent, ImportReference node) {
        EcjPsiPackageStatement statement = new EcjPsiPackageStatement(this.mManager, node);
        statement.setRange(EcjPsiBuilder.toRange(node.declarationSourceStart, node.declarationSourceEnd + 1));
        parent.adoptChild(statement);
        statement.setPackageName(EcjPsiManager.getTypeName(node.tokens));
        if (node.annotations != null) {
            EcjPsiModifierList modifierList = this.toModifierList((EcjPsiSourceElement)statement, node);
            statement.setModifierList(modifierList);
        }
        return statement;
    }

    private EcjPsiModifierList toModifierList(EcjPsiSourceElement parent, ImportReference node) {
        EcjPsiModifierList modifierList = this.toModifierList(parent, node.modifiers, node.annotations);
        modifierList.setRange(node.declarationSourceStart, node.declarationSourceStart);
        return modifierList;
    }

    private EcjPsiModifierList toModifierList(EcjPsiSourceElement parent, AbstractMethodDeclaration node) {
        int start;
        EcjPsiModifierList modifierList = this.toModifierList(parent, node.modifiers, node.annotations);
        int end = start = node.modifiersSourceStart > 0 ? node.modifiersSourceStart : node.declarationSourceStart;
        if (node.javadoc != null) {
            start = Math.max(start, node.javadoc.sourceEnd + 1);
            end = Math.max(end, start);
        }
        if (node.annotations != null && node.annotations.length > 0) {
            Annotation last = node.annotations[node.annotations.length - 1];
            end = Math.max(end, last.declarationSourceEnd + 1);
        }
        modifierList.setRange(start, end);
        return modifierList;
    }

    private EcjPsiModifierList toModifierList(EcjPsiSourceElement parent, TypeDeclaration node) {
        int start;
        EcjPsiModifierList modifierList = this.toModifierList(parent, node.modifiers, node.annotations);
        int end = start = node.modifiersSourceStart > 0 ? node.modifiersSourceStart : node.declarationSourceStart;
        if (node.javadoc != null) {
            start = Math.max(start, node.javadoc.sourceEnd + 1);
            end = Math.max(end, start);
        }
        if (node.annotations != null && node.annotations.length > 0) {
            Annotation last = node.annotations[node.annotations.length - 1];
            end = Math.max(end, last.declarationSourceEnd + 1);
        }
        modifierList.setRange(start, end);
        return modifierList;
    }

    private EcjPsiModifierList toModifierList(EcjPsiSourceElement parent, AbstractVariableDeclaration node) {
        int start;
        EcjPsiModifierList modifierList = this.toModifierList(parent, node.modifiers, node.annotations);
        int end = start = node.modifiersSourceStart > 0 ? node.modifiersSourceStart : node.declarationSourceStart;
        if (node.annotations != null && node.annotations.length > 0) {
            Annotation last = node.annotations[node.annotations.length - 1];
            end = Math.max(end, last.declarationSourceEnd + 1);
        }
        modifierList.setRange(start, end);
        return modifierList;
    }

    private EcjPsiModifierList toModifierList(EcjPsiSourceElement parent, int modifiers, Annotation[] annotations) {
        int flags = 0;
        if ((modifiers & 8) != 0) {
            flags |= 8;
        }
        if ((modifiers & 0x10) != 0) {
            flags |= 0x10;
        }
        if ((modifiers & 0x400) != 0) {
            flags |= 0x400;
        }
        if ((modifiers & 2) != 0) {
            flags |= 2;
        }
        if ((modifiers & 4) != 0) {
            flags |= 4;
        }
        if ((modifiers & 1) != 0) {
            flags |= 1;
        }
        if ((modifiers & 0x20) != 0) {
            flags |= 0x20;
        }
        if ((modifiers & 0x40) != 0) {
            flags |= 0x40;
        }
        if ((modifiers & 0x10000) != 0) {
            flags |= 0x4000;
        }
        EcjPsiModifierList modifierList = new EcjPsiModifierList(this.mManager, flags);
        parent.adoptChild(modifierList);
        EcjPsiAnnotation[] psiAnnotations = this.toAnnotations(modifierList, annotations);
        modifierList.setAnnotations(psiAnnotations);
        return modifierList;
    }

    private EcjPsiAnnotation[] toAnnotations(EcjPsiSourceElement parent, Annotation[] annotations) {
        ArrayList list = Lists.newArrayList();
        if (annotations != null) {
            for (Annotation ecjAnnotation : annotations) {
                EcjPsiAnnotation psiAnnotation = this.toAnnotation(parent, ecjAnnotation);
                if (psiAnnotation == null) continue;
                list.add(psiAnnotation);
            }
        }
        return list.toArray(new EcjPsiAnnotation[list.size()]);
    }

    private EcjPsiAnnotation toAnnotation(EcjPsiSourceElement parent, Annotation ecjAnnotation) {
        EcjPsiAnnotation psiAnnotation = new EcjPsiAnnotation(this.mManager, ecjAnnotation);
        parent.adoptChild(psiAnnotation);
        EcjPsiJavaCodeReferenceElement nameElement = this.toTypeReference(psiAnnotation, ecjAnnotation.type);
        psiAnnotation.setNameElement(nameElement);
        if (!(ecjAnnotation instanceof MarkerAnnotation)) {
            if (ecjAnnotation instanceof NormalAnnotation) {
                NormalAnnotation na = (NormalAnnotation)ecjAnnotation;
                psiAnnotation.setParameterList(this.toAnnotationParameterList(psiAnnotation, na.memberValuePairs));
            } else if (ecjAnnotation instanceof SingleMemberAnnotation) {
                SingleMemberAnnotation na = (SingleMemberAnnotation)ecjAnnotation;
                psiAnnotation.setParameterList(this.toAnnotationParameterList(psiAnnotation, na.memberValuePairs()));
            }
        }
        return psiAnnotation;
    }

    private EcjPsiNameValuePair toMemberValuePair(EcjPsiSourceElement parent, MemberValuePair memberValuePair) {
        Expression value;
        EcjPsiNameValuePair pair = new EcjPsiNameValuePair(this.mManager, memberValuePair);
        parent.adoptChild(pair);
        if (memberValuePair.name != null && memberValuePair.sourceStart < memberValuePair.value.sourceStart) {
            pair.setNameIdentifier(this.toIdentifier((EcjPsiSourceElement)pair, memberValuePair.name, EcjPsiBuilder.toRange(memberValuePair.sourceStart, memberValuePair.sourceStart + memberValuePair.name.length)));
        }
        if ((value = memberValuePair.value) != null) {
            if (value instanceof Annotation) {
                EcjPsiAnnotation psiAnnotation = this.toAnnotation(pair, (Annotation)value);
                if (psiAnnotation != null) {
                    pair.setMemberValue((PsiAnnotationMemberValue)psiAnnotation);
                    pair.setRange(memberValuePair.sourceStart, psiAnnotation.getTextRange().getEndOffset());
                } else {
                    pair.setRange(memberValuePair.sourceStart, value.sourceEnd + 1);
                }
            } else {
                pair.setMemberValue(this.toMemberValue(pair, (ASTNode)value));
                pair.setRange(memberValuePair.sourceStart, value.sourceEnd + 1);
            }
        } else {
            pair.setRange(memberValuePair.sourceStart, memberValuePair.sourceEnd + 1);
        }
        return pair;
    }

    private EcjPsiImportList toImportList(EcjPsiSourceElement parent, ImportReference[] references) {
        EcjPsiImportList importList = new EcjPsiImportList(this.mManager);
        parent.adoptChild(importList);
        if (references != null) {
            ArrayList list = Lists.newArrayListWithCapacity((int)references.length);
            for (ImportReference node : references) {
                list.add(this.toImport(importList, node));
            }
            importList.setImports(list);
            PsiElement firstChild = importList.getFirstChild();
            if (firstChild != null) {
                PsiElement lastChild = importList.getLastChild();
                importList.setRange(firstChild.getTextOffset(), lastChild.getTextOffset() + lastChild.getTextLength());
            }
        }
        return importList;
    }

    private EcjPsiImport toImport(EcjPsiImportList parent, ImportReference importReference) {
        String typeName = EcjPsiManager.getTypeName(importReference.getImportName());
        boolean onDemand = (importReference.bits & 0x20000) != 0;
        EcjPsiImport ref = (importReference.modifiers & 8) != 0 ? new EcjPsiStaticImport(this.mManager, importReference, typeName, onDemand) : new EcjPsiImport(this.mManager, importReference, typeName, onDemand);
        ref.setReference(this.toImportReference(ref, importReference));
        parent.adoptChild(ref);
        return ref;
    }

    private EcjPsiClass toClass(EcjPsiSourceElement parent, TypeDeclaration declaration) {
        EcjPsiClass cls = new EcjPsiClass(this.mManager, declaration, new String(declaration.name));
        parent.adoptChild(cls);
        cls.setRange(declaration.declarationSourceStart, declaration.declarationSourceEnd + 1);
        EcjPsiModifierList modifierList = this.toModifierList((EcjPsiSourceElement)cls, declaration);
        cls.setNameIdentifier(this.toIdentifier((EcjPsiSourceElement)cls, declaration.name, EcjPsiBuilder.toRange((ASTNode)declaration)));
        cls.setModifierList(modifierList);
        int kind = TypeDeclaration.kind((int)declaration.modifiers);
        switch (kind) {
            case 1: {
                cls.setSuperClass(declaration.superclass);
                cls.setSuperInterfaces(declaration.superInterfaces);
                cls.setTypeParameterList(this.toTypeParameterList((EcjPsiSourceElement)cls, declaration.typeParameters));
                cls.setExtendsList(this.toTypeReferenceList((EcjPsiSourceElement)cls, declaration.superclass, PsiReferenceList.Role.EXTENDS_LIST));
                cls.setImplementsList(this.toTypeReferenceList((EcjPsiSourceElement)cls, declaration.superInterfaces, PsiReferenceList.Role.IMPLEMENTS_LIST));
                this.initializeClassBody(cls, declaration);
                break;
            }
            case 2: {
                modifierList.setModifiers(modifierList.getModifiers() | 8 | 0x400);
                cls.setSuperInterfaces(declaration.superInterfaces);
                cls.setTypeParameterList(this.toTypeParameterList((EcjPsiSourceElement)cls, declaration.typeParameters));
                cls.setImplementsList(this.toTypeReferenceList((EcjPsiSourceElement)cls, declaration.superInterfaces, PsiReferenceList.Role.EXTENDS_LIST));
                this.initializeClassBody(cls, declaration);
                break;
            }
            case 3: {
                cls.setSuperInterfaces(declaration.superInterfaces);
                cls.setImplementsList(this.toTypeReferenceList((EcjPsiSourceElement)cls, declaration.superInterfaces, PsiReferenceList.Role.IMPLEMENTS_LIST));
                modifierList.setModifiers(modifierList.getModifiers() | 8 | 0x10);
                this.initializeClassBody(cls, declaration);
                break;
            }
            case 4: {
                modifierList.setModifiers(modifierList.getModifiers() | 8 | 0x400);
                this.initializeClassBody(cls, declaration);
            }
        }
        return cls;
    }

    private EcjPsiEnumConstantInitializer toEnumInitializer(EcjPsiEnumConstant parent, Expression expression) {
        EcjPsiModifierList modifierList;
        if (!(expression instanceof QualifiedAllocationExpression)) {
            return null;
        }
        QualifiedAllocationExpression node = (QualifiedAllocationExpression)expression;
        TypeDeclaration declaration = node.anonymousType;
        if (declaration == null) {
            return null;
        }
        EcjPsiEnumConstantInitializer cls = new EcjPsiEnumConstantInitializer(this.mManager, declaration);
        parent.adoptChild(cls);
        cls.setRange(declaration.declarationSourceStart, declaration.declarationSourceEnd + 1);
        cls.setSuperClass(declaration.superclass);
        this.initializeClassBody(cls, declaration);
        PsiClass containingClass = parent.getContainingClass();
        if (containingClass != null && (modifierList = (EcjPsiModifierList)containingClass.getModifierList()) != null) {
            modifierList.setModifiers(modifierList.getModifiers() & 0xFFFFFFEF);
        }
        return cls;
    }

    private void initializeClassBody(EcjPsiClass cls, TypeDeclaration declaration) {
        ArrayList methods;
        ArrayList initializers = null;
        if (declaration.fields != null) {
            ArrayList fields = Lists.newArrayList();
            for (FieldDeclaration fieldDeclaration : declaration.fields) {
                if (fieldDeclaration instanceof Initializer) {
                    if (initializers == null) {
                        initializers = Lists.newArrayListWithExpectedSize((int)4);
                    }
                    initializers.add(this.toClassInitializer(cls, (Initializer)fieldDeclaration));
                    continue;
                }
                if (fieldDeclaration.type == null) {
                    fields.add(this.toEnumConstant(cls, fieldDeclaration));
                    continue;
                }
                fields.add(this.toField(cls, fieldDeclaration));
            }
            cls.setFields(fields);
        }
        if (declaration.methods != null) {
            methods = Lists.newArrayList();
            for (FieldDeclaration fieldDeclaration : declaration.methods) {
                if (fieldDeclaration.isClinit()) {
                    Clinit clinit = (Clinit)fieldDeclaration;
                    if (clinit.statements == null) continue;
                    if (initializers == null) {
                        initializers = Lists.newArrayListWithExpectedSize((int)4);
                    }
                    initializers.add(this.toClassInitializer(cls, clinit));
                    continue;
                }
                EcjPsiMethod psiMethod = this.toMethod(cls, (AbstractMethodDeclaration)fieldDeclaration);
                if (psiMethod == null) continue;
                methods.add(psiMethod);
            }
            cls.setMethods(methods);
        }
        if (initializers != null) {
            cls.setInitializers(initializers);
        }
        if (declaration.memberTypes != null && declaration.memberTypes.length > 0) {
            methods = Lists.newArrayList();
            for (FieldDeclaration fieldDeclaration : declaration.memberTypes) {
                methods.add(this.toClass(cls, (TypeDeclaration)fieldDeclaration));
            }
            cls.setInnerClasses(methods.toArray(new EcjPsiClass[0]));
        }
        cls.sortChildren();
    }

    private PsiClassInitializer toClassInitializer(EcjPsiClass parent, Clinit clinit) {
        EcjPsiClassInitializer initializer = new EcjPsiClassInitializer(this.mManager, parent, (ASTNode)clinit);
        parent.adoptChild(initializer);
        if ((clinit.modifiers & 8) != 0) {
            initializer.setRange(clinit.declarationSourceStart, clinit.sourceEnd + 1);
        }
        initializer.setModifierList(this.toModifierList(initializer, clinit.modifiers, clinit.annotations));
        EcjPsiCodeBlock body = this.toBlock(initializer, clinit.statements, null, clinit.declarationSourceStart, clinit.declarationSourceEnd + 1);
        initializer.setBody(body);
        return initializer;
    }

    private PsiClassInitializer toClassInitializer(EcjPsiClass parent, Initializer init) {
        EcjPsiClassInitializer initializer = new EcjPsiClassInitializer(this.mManager, parent, (ASTNode)init);
        parent.adoptChild(initializer);
        initializer.setModifierList(this.toModifierList(initializer, init.modifiers, init.annotations));
        EcjPsiCodeBlock body = this.toBlock((EcjPsiSourceElement)initializer, init.block);
        initializer.setBody(body);
        return initializer;
    }

    private EcjPsiMethod toMethod(EcjPsiClass cls, AbstractMethodDeclaration method) {
        EcjPsiCodeBlock body;
        TypeReference returnType;
        int modifiers;
        if (method instanceof ConstructorDeclaration && (method.bits & 0x80) != 0) {
            return null;
        }
        boolean isAnnotation = method instanceof AnnotationMethodDeclaration;
        EcjPsiMethod psiMethod = !isAnnotation ? new EcjPsiMethod(this.mManager, cls, method) : new EcjPsiAnnotationMethod(this.mManager, cls, method);
        cls.adoptChild(psiMethod);
        EcjPsiModifierList modifierList = this.toModifierList((EcjPsiSourceElement)psiMethod, method);
        psiMethod.setModifierList(modifierList);
        if (cls.isInterface()) {
            boolean hasDefaultMethod = method.statements != null && method.statements.length > 0;
            int modifiers2 = modifierList.getModifiers();
            modifiers2 |= (hasDefaultMethod ? 0 : 1024) | 1;
            modifierList.setModifiers(modifiers2 &= 0xFFFFFFF9);
        } else if (cls.isAnnotationType()) {
            modifiers = modifierList.getModifiers();
            modifiers |= 0x401;
            modifierList.setModifiers(modifiers &= 0xFFFFFFF9);
        } else if (cls.isEnum() && method.isConstructor()) {
            modifiers = modifierList.getModifiers();
            modifiers |= 2;
            modifierList.setModifiers(modifiers &= 0xFFFFFFFA);
        }
        TypeParameter[] typeParameters = method.typeParameters();
        if (typeParameters != null) {
            psiMethod.setTypeParameters(this.toTypeParameterList((EcjPsiSourceElement)psiMethod, typeParameters));
        }
        if (method instanceof MethodDeclaration && !method.isConstructor() && (returnType = ((MethodDeclaration)method).returnType) != null) {
            psiMethod.setReturnTypeElement(this.toTypeElement(psiMethod, returnType));
        }
        psiMethod.setNameIdentifier(this.toIdentifier((EcjPsiSourceElement)cls, method.selector, EcjPsiBuilder.toRange(method.sourceStart, method.sourceStart + method.selector.length)));
        psiMethod.setArguments(this.toParameterList(psiMethod, method.arguments));
        EcjPsiReferenceList psiReferenceList = this.toTypeReferenceList((EcjPsiSourceElement)psiMethod, method.thrownExceptions, PsiReferenceList.Role.THROWS_LIST);
        psiMethod.setThrownExceptions(psiReferenceList);
        if (method instanceof ConstructorDeclaration) {
            ExplicitConstructorCall constructorCall = ((ConstructorDeclaration)method).constructorCall;
            body = this.toBlock(psiMethod, method.statements, constructorCall, method.bodyStart - 1, method.bodyEnd + 1);
        } else if (method instanceof MethodDeclaration) {
            boolean semiColonBody = (method.modifiers & 0x1000000) != 0;
            body = !method.isAbstract() && !method.isNative() && !semiColonBody ? this.toBlock(psiMethod, method.statements, null, method.bodyStart - 1, method.bodyEnd + 1) : null;
            if (isAnnotation) {
                AnnotationMethodDeclaration amd = (AnnotationMethodDeclaration)method;
                if (amd.defaultValue != null) {
                    EcjPsiExpression defaultValue = this.toExpression(psiMethod, amd.defaultValue);
                    ((EcjPsiAnnotationMethod)psiMethod).setValue(defaultValue);
                }
            }
        } else {
            body = this.toBlock(psiMethod, method.statements, null, method.bodyStart - 1, method.bodyEnd + 1);
        }
        psiMethod.setBody(body);
        return psiMethod;
    }

    private PsiAnnotationMemberValue toMemberValue(EcjPsiSourceElement parent, ASTNode node) {
        if (node instanceof Annotation) {
            return this.toAnnotation(parent, (Annotation)node);
        }
        if (node instanceof ArrayInitializer) {
            return this.toArrayInitializerMemberValue(parent, (ArrayInitializer)node);
        }
        if (node instanceof Expression) {
            return this.toExpression(parent, (Expression)node);
        }
        throw new IllegalArgumentException(node.getClass().getName());
    }

    private EcjPsiExpression toExpression(EcjPsiSourceElement parent, Expression expression) {
        if (expression instanceof Literal) {
            return this.toLiteral(parent, (Literal)expression);
        }
        if (expression instanceof Reference) {
            return this.toReferenceExpression(parent, expression);
        }
        if (expression instanceof MessageSend) {
            return this.toCallExpression(parent, (MessageSend)expression);
        }
        if (expression instanceof OperatorExpression) {
            return this.toOperatorExpression(parent, (OperatorExpression)expression);
        }
        if (expression instanceof Assignment) {
            return this.toAssignmentExpression(parent, (Assignment)expression);
        }
        if (expression instanceof AllocationExpression) {
            return this.toNewExpression(parent, (AllocationExpression)expression);
        }
        if (expression instanceof CastExpression) {
            return this.toCastExpression(parent, (CastExpression)expression);
        }
        if (expression instanceof FunctionalExpression) {
            return this.toFunctionalExpression(parent, (FunctionalExpression)expression);
        }
        if (expression instanceof ClassLiteralAccess) {
            return this.toClassObjectAccessExpression(parent, (ClassLiteralAccess)expression);
        }
        if (expression instanceof ArrayInitializer) {
            return this.toArrayInitializerExpression(parent, (ArrayInitializer)expression);
        }
        if (expression instanceof ArrayAllocationExpression) {
            return this.toArrayAllocationExpression(parent, (ArrayAllocationExpression)expression);
        }
        throw new IllegalArgumentException(expression.getClass().getName());
    }

    private EcjPsiArrayInitializerExpression toArrayInitializerExpression(EcjPsiSourceElement parent, ArrayInitializer expression) {
        EcjPsiArrayInitializerExpression e = new EcjPsiArrayInitializerExpression(this.mManager, (Expression)expression);
        if (expression.expressions != null) {
            PsiExpression[] initializers = new PsiExpression[expression.expressions.length];
            for (int i = 0; i < expression.expressions.length; ++i) {
                initializers[i] = this.toExpression(e, expression.expressions[i]);
            }
            e.setInitializers(initializers);
        } else {
            e.setInitializers(PsiExpression.EMPTY_ARRAY);
        }
        parent.adoptChild(e);
        return e;
    }

    private EcjPsiArrayInitializerMemberValue toArrayInitializerMemberValue(EcjPsiSourceElement parent, ArrayInitializer expression) {
        EcjPsiArrayInitializerMemberValue e = new EcjPsiArrayInitializerMemberValue(this.mManager, (Expression)expression);
        if (expression.expressions != null) {
            PsiAnnotationMemberValue[] initializers = new PsiAnnotationMemberValue[expression.expressions.length];
            for (int i = 0; i < expression.expressions.length; ++i) {
                initializers[i] = this.toMemberValue(e, (ASTNode)expression.expressions[i]);
            }
            e.setInitializers(initializers);
        } else {
            e.setInitializers((PsiAnnotationMemberValue[])PsiExpression.EMPTY_ARRAY);
        }
        parent.adoptChild(e);
        return e;
    }

    private EcjPsiExpression toFunctionalExpression(EcjPsiSourceElement parent, FunctionalExpression expression) {
        if (expression instanceof LambdaExpression) {
            LambdaExpression lambda = (LambdaExpression)expression;
            EcjPsiLambdaExpression e = new EcjPsiLambdaExpression(this.mManager, lambda);
            e.setParameterList(this.toParameterList(e, lambda.arguments));
            if (lambda.body instanceof Expression) {
                e.setBody(this.toExpression(e, (Expression)lambda.body));
            } else {
                e.setBody(this.toStatement(e, lambda.body));
            }
            parent.adoptChild(e);
            return e;
        }
        if (expression instanceof ReferenceExpression) {
            ReferenceExpression ref = (ReferenceExpression)expression;
            EcjPsiMethodReferenceExpression e = new EcjPsiMethodReferenceExpression(this.mManager, ref);
            e.setQualifier(this.toExpression(e, ref.lhs));
            e.setParameterList(this.toTypeParameterList((EcjPsiSourceElement)e, ref.typeArguments));
            if (EcjParser.sameChars("<init>", ref.selector)) {
                e.setReferenceNameElement(this.toIdentifier((EcjPsiSourceElement)e, "new", EcjPsiBuilder.toRange(ref.nameSourceStart, ref.nameSourceStart + 3)));
            } else {
                e.setReferenceNameElement(this.toIdentifier((EcjPsiSourceElement)e, ref.selector, EcjPsiBuilder.toRange(ref.nameSourceStart, ref.nameSourceStart + ref.selector.length)));
            }
            parent.adoptChild(e);
            return e;
        }
        throw new IllegalArgumentException(expression.getClass().getName());
    }

    private EcjPsiClassObjectAccessExpression toClassObjectAccessExpression(EcjPsiSourceElement parent, ClassLiteralAccess expression) {
        EcjPsiClassObjectAccessExpression accessExpression = new EcjPsiClassObjectAccessExpression(this.mManager, (Expression)expression);
        accessExpression.setOperand(this.toTypeElement(accessExpression, expression.type));
        parent.adoptChild(accessExpression);
        return accessExpression;
    }

    private EcjPsiExpression toCastExpression(EcjPsiSourceElement parent, CastExpression expression) {
        EcjPsiTypeCastExpression cast = new EcjPsiTypeCastExpression(this.mManager, expression);
        cast.setCastType(this.toTypeElement(cast, expression.type));
        cast.setOperand(this.toExpression(cast, expression.expression));
        parent.adoptChild(cast);
        return cast;
    }

    private EcjPsiMethodCallExpression toCallExpression(EcjPsiSourceElement parent, MessageSend send) {
        EcjPsiMethodCallExpression call = new EcjPsiMethodCallExpression(this.mManager, (Expression)send);
        parent.adoptChild(call);
        EcjPsiReferenceExpression methodCall = new EcjPsiReferenceExpression(this.mManager, (Expression)send);
        call.adoptChild(methodCall);
        if (send.receiver != null && !send.receiverIsImplicitThis()) {
            EcjPsiExpression qualifier = this.toExpression(methodCall, send.receiver);
            methodCall.setQualifier(qualifier);
        }
        EcjPsiIdentifier nameElement = this.toIdentifier((EcjPsiSourceElement)methodCall, send.selector, EcjPsiBuilder.toRange(send.nameSourcePosition));
        methodCall.setNameElement(nameElement);
        methodCall.setRange(send.sourceStart, nameElement.getTextRange().getEndOffset());
        call.setMethodExpression(methodCall);
        call.setArgumentList(this.toArguments(call, send.arguments));
        if (send.typeArguments != null) {
            call.setTypeArgumentList(this.toTypeParameterList((EcjPsiSourceElement)call, send.typeArguments));
        }
        return call;
    }

    private EcjPsiNewExpression toNewExpression(EcjPsiSourceElement parent, AllocationExpression send) {
        EcjPsiNewExpression call = new EcjPsiNewExpression(this.mManager, (Expression)send);
        QualifiedAllocationExpression node = null;
        if (send instanceof QualifiedAllocationExpression) {
            node = (QualifiedAllocationExpression)send;
            if (node.enclosingInstance != null) {
                call.setQualifier(this.toExpression(call, node.enclosingInstance));
            }
        }
        if (node != null && node.anonymousType != null) {
            EcjPsiAnonymousClass cls = new EcjPsiAnonymousClass(this.mManager, node.anonymousType);
            call.adoptChild(cls);
            cls.setSuperClass(node.anonymousType.superclass);
            cls.setSuperInterfaces(node.anonymousType.superInterfaces);
            cls.setRange(node.anonymousType.declarationSourceStart, node.anonymousType.declarationSourceEnd + 1);
            EcjPsiJavaCodeReferenceElement typeReference = this.toTypeReference(cls, send.type);
            cls.setBaseClassReference(typeReference);
            EcjPsiExpressionList argumentList = this.toArguments(cls, send.arguments);
            cls.setArgumentList(argumentList);
            call.setArgumentList(argumentList);
            call.setAnonymousClass(cls);
            this.initializeClassBody(cls, node.anonymousType);
            cls.setInQualifiedNew(node.enclosingInstance != null);
        } else {
            EcjPsiJavaCodeReferenceElement typeReference = this.toTypeReference(call, send.type);
            call.setClassReference(typeReference);
            if (send.typeArguments != null) {
                call.setTypeArgumentList(this.toTypeParameterList((EcjPsiSourceElement)call, send.typeArguments));
            }
            EcjPsiExpressionList argumentList = this.toArguments(call, send.arguments);
            call.setArgumentList(argumentList);
        }
        call.setArrayDimensions(PsiExpression.EMPTY_ARRAY);
        parent.adoptChild(call);
        return call;
    }

    private EcjPsiExpression toArrayAllocationExpression(EcjPsiSourceElement parent, ArrayAllocationExpression allocation) {
        EcjPsiNewExpression newExpression = new EcjPsiNewExpression(this.mManager, (Expression)allocation);
        if (allocation.initializer != null) {
            newExpression.setArrayInitializer(this.toArrayInitializerExpression(newExpression, allocation.initializer));
        }
        if (allocation.dimensions.length > 0 && (allocation.dimensions.length != 1 || allocation.dimensions[0] != null)) {
            ArrayList dimensions = Lists.newArrayListWithCapacity((int)allocation.dimensions.length);
            for (int i = 0; i < allocation.dimensions.length; ++i) {
                if (allocation.dimensions[i] == null) continue;
                dimensions.add(this.toExpression(newExpression, allocation.dimensions[i]));
            }
            newExpression.setArrayDimensions(dimensions.toArray(PsiExpression.EMPTY_ARRAY));
        } else {
            newExpression.setArrayDimensions(PsiExpression.EMPTY_ARRAY);
        }
        parent.adoptChild(newExpression);
        return newExpression;
    }

    private EcjPsiExpression toReferenceExpression(EcjPsiSourceElement parent, Expression expression) {
        if (expression instanceof NameReference) {
            if (expression instanceof SingleNameReference) {
                SingleNameReference snr = (SingleNameReference)expression;
                EcjPsiReferenceExpression exp = new EcjPsiReferenceExpression(this.mManager, expression);
                parent.adoptChild(exp);
                exp.setNameElement(this.toIdentifier((EcjPsiSourceElement)exp, snr.token, EcjPsiBuilder.toRange((ASTNode)snr)));
                return exp;
            }
            if (expression instanceof QualifiedNameReference) {
                QualifiedNameReference qnr = (QualifiedNameReference)expression;
                char[][] tokens = qnr.tokens;
                assert (tokens.length > 1);
                int startOffset = qnr.sourceStart;
                int endOffset = startOffset + tokens[0].length;
                EcjPsiReferenceExpression prev = new EcjPsiReferenceExpression(this.mManager, null);
                prev.setTypeExpression(expression);
                prev.setNameElement(this.toIdentifier((EcjPsiSourceElement)prev, tokens[0], EcjPsiBuilder.toRange(startOffset, endOffset)));
                prev.setRange(startOffset, endOffset);
                EcjPsiReferenceExpression curr = null;
                for (int i = 1; i < tokens.length; ++i) {
                    curr = new EcjPsiReferenceExpression(this.mManager, null);
                    curr.setTypeExpression(expression);
                    curr.setQualifier(prev);
                    char[] name = tokens[i];
                    curr.adoptChild(prev);
                    curr.setNameElement(this.toIdentifier((EcjPsiSourceElement)curr, name, EcjPsiBuilder.toRange((endOffset += name.length + 1) - name.length, endOffset)));
                    curr.setRange(startOffset, endOffset);
                    prev = curr;
                }
                assert (curr != null);
                curr.mNativeNode = expression;
                parent.adoptChild(curr);
                return curr;
            }
        } else {
            if (expression instanceof ThisReference) {
                if (expression instanceof SuperReference) {
                    EcjPsiSuperExpression e = new EcjPsiSuperExpression(this.mManager, expression);
                    assert (!expression.isImplicitThis());
                    parent.adoptChild(e);
                    return e;
                }
                if (expression instanceof QualifiedSuperReference) {
                    QualifiedSuperReference ref = (QualifiedSuperReference)expression;
                    EcjPsiSuperExpression e = new EcjPsiSuperExpression(this.mManager, expression);
                    EcjPsiJavaCodeReferenceElement qualifier = this.toTypeReference(e, ref.qualification);
                    e.setQualifier(qualifier);
                    parent.adoptChild(e);
                    return e;
                }
                if (expression instanceof QualifiedThisReference) {
                    QualifiedThisReference ref = (QualifiedThisReference)expression;
                    EcjPsiThisExpression e = new EcjPsiThisExpression(this.mManager, expression);
                    EcjPsiJavaCodeReferenceElement qualifier = this.toTypeReference(e, ref.qualification);
                    e.setQualifier(qualifier);
                    parent.adoptChild(e);
                    return e;
                }
                assert (!expression.isImplicitThis());
                EcjPsiThisExpression e = new EcjPsiThisExpression(this.mManager, expression);
                parent.adoptChild(e);
                return e;
            }
            if (expression instanceof FieldReference) {
                FieldReference ref = (FieldReference)expression;
                EcjPsiReferenceExpression exp = new EcjPsiReferenceExpression(this.mManager, expression);
                parent.adoptChild(exp);
                if (ref.receiver != null && !ref.receiverIsImplicitThis()) {
                    exp.setQualifier(this.toExpression(exp, ref.receiver));
                    int start = ref.receiver.sourceEnd + 2;
                    int end = ref.sourceEnd + 1;
                    int length = Math.min(end - start, ref.token.length);
                    String name = new String(ref.token, ref.token.length - length, length);
                    exp.setNameElement(this.toIdentifier((EcjPsiSourceElement)exp, name, new TextRange(start, end)));
                } else {
                    exp.setNameElement(this.toIdentifier((EcjPsiSourceElement)exp, ref.token, EcjPsiBuilder.toRange((ASTNode)ref)));
                }
                return exp;
            }
            if (expression instanceof ArrayReference) {
                EcjPsiArrayAccessExpression accessExpression = new EcjPsiArrayAccessExpression(this.mManager, expression);
                parent.adoptChild(accessExpression);
                ArrayReference ref = (ArrayReference)expression;
                accessExpression.setArrayExpression(this.toExpression(accessExpression, ref.receiver));
                accessExpression.setIndexExpression(this.toExpression(accessExpression, ref.position));
                return accessExpression;
            }
        }
        throw new IllegalArgumentException(expression.getClass().getName());
    }

    private EcjPsiExpression toAssignmentExpression(EcjPsiSourceElement parent, Assignment expression) {
        if (expression instanceof CompoundAssignment) {
            if (expression instanceof PrefixExpression) {
                EcjPsiPrefixExpression unaryExpression = new EcjPsiPrefixExpression(this.mManager, (Expression)expression);
                parent.adoptChild(unaryExpression);
                int operatorId = (expression.bits & 0xFC0) >> 6;
                IElementType tokenType = this.ecjToPsiToken(operatorId);
                unaryExpression.setOperationType(tokenType);
                unaryExpression.setOperand(this.toExpression(unaryExpression, expression.lhs));
                return unaryExpression;
            }
            if (expression instanceof PostfixExpression) {
                EcjPsiPostfixExpression unaryExpression = new EcjPsiPostfixExpression(this.mManager, (Expression)expression);
                parent.adoptChild(unaryExpression);
                int operatorId = (expression.bits & 0xFC0) >> 6;
                IElementType tokenType = this.ecjToPsiToken(operatorId);
                unaryExpression.setOperationType(tokenType);
                unaryExpression.setOperand(this.toExpression(unaryExpression, expression.lhs));
                return unaryExpression;
            }
        }
        EcjPsiAssignmentExpression assignmentExpression = new EcjPsiAssignmentExpression(this.mManager, (Expression)expression);
        parent.adoptChild(assignmentExpression);
        assignmentExpression.setLhs(this.toExpression(assignmentExpression, expression.lhs));
        assignmentExpression.setRhs(this.toExpression(assignmentExpression, expression.expression));
        if (expression instanceof CompoundAssignment) {
            int operatorId = ((CompoundAssignment)expression).operator;
            assignmentExpression.setOperation(this.ecjAssignmentToPsiToken(operatorId));
        } else {
            assignmentExpression.setOperation(JavaTokenType.EQ);
        }
        return assignmentExpression;
    }

    private EcjPsiExpression toOperatorExpression(EcjPsiSourceElement parent, OperatorExpression expression) {
        if (expression instanceof BinaryExpression) {
            return this.toBinaryExpression(parent, (BinaryExpression)expression);
        }
        if (expression instanceof UnaryExpression) {
            return this.toUnaryExpression(parent, (UnaryExpression)expression);
        }
        if (expression instanceof ConditionalExpression) {
            return this.toConditionalExpression(parent, (ConditionalExpression)expression);
        }
        if (expression instanceof InstanceOfExpression) {
            return this.toInstanceOfExpression(parent, (InstanceOfExpression)expression);
        }
        throw new IllegalArgumentException(expression.getClass().getName());
    }

    private EcjPsiExpression toConditionalExpression(EcjPsiSourceElement parent, ConditionalExpression expression) {
        EcjPsiConditionalExpression e = new EcjPsiConditionalExpression(this.mManager, (Expression)expression);
        e.setCondition(this.toExpression(e, expression.condition));
        e.setThenExpression(this.toExpression(e, expression.valueIfTrue));
        e.setElseExpression(this.toExpression(e, expression.valueIfFalse));
        parent.adoptChild(e);
        return e;
    }

    private EcjPsiExpression toInstanceOfExpression(EcjPsiSourceElement parent, InstanceOfExpression expression) {
        EcjPsiInstanceOfExpression e = new EcjPsiInstanceOfExpression(this.mManager, (Expression)expression);
        e.setOperand(this.toExpression(e, expression.expression));
        e.setCheckType(this.toTypeElement(e, expression.type));
        parent.adoptChild(e);
        return e;
    }

    private IElementType ecjToPsiToken(int operator) {
        switch (operator) {
            case 32: {
                return JavaTokenType.PLUSPLUS;
            }
            case 33: {
                return JavaTokenType.MINUSMINUS;
            }
            case 12: {
                return JavaTokenType.TILDE;
            }
            case 11: {
                return JavaTokenType.EXCL;
            }
            case 14: {
                return JavaTokenType.PLUS;
            }
            case 13: {
                return JavaTokenType.MINUS;
            }
            case 1: {
                return JavaTokenType.OROR;
            }
            case 0: {
                return JavaTokenType.ANDAND;
            }
            case 3: {
                return JavaTokenType.OR;
            }
            case 8: {
                return JavaTokenType.XOR;
            }
            case 2: {
                return JavaTokenType.AND;
            }
            case 18: {
                return JavaTokenType.EQEQ;
            }
            case 29: {
                return JavaTokenType.NE;
            }
            case 6: {
                return JavaTokenType.GT;
            }
            case 7: {
                return JavaTokenType.GE;
            }
            case 4: {
                return JavaTokenType.LT;
            }
            case 5: {
                return JavaTokenType.LE;
            }
            case 10: {
                return JavaTokenType.LTLT;
            }
            case 17: {
                return JavaTokenType.GTGT;
            }
            case 19: {
                return JavaTokenType.GTGTGT;
            }
            case 15: {
                return JavaTokenType.ASTERISK;
            }
            case 9: {
                return JavaTokenType.DIV;
            }
            case 16: {
                return JavaTokenType.PERC;
            }
            case 30: {
                return JavaTokenType.EQ;
            }
        }
        return JavaTokenType.IDENTIFIER;
    }

    private IElementType ecjAssignmentToPsiToken(int operator) {
        switch (operator) {
            case 14: {
                return JavaTokenType.PLUSEQ;
            }
            case 13: {
                return JavaTokenType.MINUSEQ;
            }
            case 15: {
                return JavaTokenType.ASTERISKEQ;
            }
            case 9: {
                return JavaTokenType.DIVEQ;
            }
            case 16: {
                return JavaTokenType.PERCEQ;
            }
            case 2: {
                return JavaTokenType.ANDEQ;
            }
            case 8: {
                return JavaTokenType.XOREQ;
            }
            case 3: {
                return JavaTokenType.OREQ;
            }
            case 10: {
                return JavaTokenType.LTLTEQ;
            }
            case 17: {
                return JavaTokenType.GTGTEQ;
            }
            case 19: {
                return JavaTokenType.GTGTGTEQ;
            }
        }
        return JavaTokenType.EQ;
    }

    private EcjPsiExpression toUnaryExpression(EcjPsiSourceElement parent, UnaryExpression expression) {
        EcjPsiPrefixExpression unaryExpression = new EcjPsiPrefixExpression(this.mManager, (Expression)expression);
        parent.adoptChild(unaryExpression);
        int operatorId = (expression.bits & 0xFC0) >> 6;
        IElementType tokenType = this.ecjToPsiToken(operatorId);
        assert (tokenType != JavaTokenType.MINUSMINUS && tokenType != JavaTokenType.PLUSPLUS);
        unaryExpression.setOperationType(tokenType);
        unaryExpression.setOperand(this.toExpression(unaryExpression, expression.expression));
        return unaryExpression;
    }

    private EcjPsiBinaryExpression toBinaryExpression(EcjPsiSourceElement parent, BinaryExpression expression) {
        EcjPsiBinaryExpression binaryExpression = new EcjPsiBinaryExpression(this.mManager, (Expression)expression);
        parent.adoptChild(binaryExpression);
        int operatorId = (expression.bits & 0xFC0) >> 6;
        IElementType tokenType = this.ecjToPsiToken(operatorId);
        binaryExpression.setOperationType(tokenType);
        binaryExpression.setLeftOperand(this.toExpression(binaryExpression, expression.left));
        if (expression.right != null) {
            binaryExpression.setRightOperand(this.toExpression(binaryExpression, expression.right));
        }
        return binaryExpression;
    }

    private EcjPsiExpression toLiteral(EcjPsiSourceElement parent, Literal expression) {
        EcjPsiLiteralExpression literal = new EcjPsiLiteralExpression(this.mManager, expression);
        parent.adoptChild(literal);
        return literal;
    }

    private EcjPsiReferenceList toTypeReferenceList(EcjPsiSourceElement parent, TypeReference reference, PsiReferenceList.Role role) {
        TypeReference[] typeReferenceArray;
        if (reference == null) {
            typeReferenceArray = TypeReference.NO_TYPE_ARGUMENTS;
        } else {
            TypeReference[] typeReferenceArray2 = new TypeReference[1];
            typeReferenceArray = typeReferenceArray2;
            typeReferenceArray2[0] = reference;
        }
        TypeReference[] references = typeReferenceArray;
        return this.toTypeReferenceList(parent, references, role);
    }

    private EcjPsiReferenceList toTypeReferenceList(EcjPsiSourceElement parent, TypeReference[] references, PsiReferenceList.Role role) {
        EcjPsiReferenceList list = new EcjPsiReferenceList(this.mManager, references, role);
        parent.adoptChild(list);
        if (references != null) {
            ArrayList elements = Lists.newArrayListWithCapacity((int)references.length);
            for (TypeReference reference : references) {
                elements.add(this.toTypeReference(list, reference));
            }
            list.setReferenceElements(elements.toArray(PsiJavaCodeReferenceElement.EMPTY_ARRAY));
            list.mRange = null;
        } else {
            list.setReferenceElements(PsiJavaCodeReferenceElement.EMPTY_ARRAY);
        }
        return list;
    }

    private EcjPsiJavaCodeReferenceElement toTypeReference(EcjPsiSourceElement parent, TypeReference reference) {
        char[][] tokens = reference.getTypeName();
        EcjPsiJavaCodeReferenceElement element = null;
        if (tokens.length == 1) {
            element = new EcjPsiJavaCodeReferenceElement(this.mManager, reference);
            parent.adoptChild(element);
            String referenceName = new String(tokens[tokens.length - 1]);
            int start = reference.sourceStart;
            int end = (start += (reference.bits & 0x1FE00000) >> 21) + referenceName.length();
            element.setNameElement(this.toIdentifier((EcjPsiSourceElement)element, referenceName, new TextRange(start, end)));
        } else {
            int startOffset = reference.sourceStart;
            int endOffset = startOffset + tokens[0].length;
            EcjPsiJavaCodeReferenceElement prev = new EcjPsiJavaCodeReferenceElement(this.mManager, reference);
            prev.setNameElement(this.toIdentifier((EcjPsiSourceElement)prev, tokens[0], EcjPsiBuilder.toRange(startOffset, endOffset)));
            prev.setRange(startOffset, endOffset);
            for (int i = 1; i < tokens.length; ++i) {
                element = new EcjPsiJavaCodeReferenceElement(this.mManager, reference);
                element.setQualifier(prev);
                char[] name = tokens[i];
                element.adoptChild(prev);
                element.setNameElement(this.toIdentifier((EcjPsiSourceElement)element, name, EcjPsiBuilder.toRange((endOffset += name.length + 1) - name.length, endOffset)));
                element.setRange(startOffset, endOffset);
                prev = element;
            }
            assert (element != null);
            if (reference instanceof ParameterizedSingleTypeReference) {
                ParameterizedSingleTypeReference typeReference = (ParameterizedSingleTypeReference)reference;
                element.setParameterList(this.toTypeParameterList((EcjPsiSourceElement)element, typeReference.typeArguments));
            }
            parent.adoptChild(element);
        }
        if (reference instanceof ParameterizedSingleTypeReference) {
            ParameterizedSingleTypeReference typeReference = (ParameterizedSingleTypeReference)reference;
            if (typeReference.typeArguments.length > 0) {
                EcjPsiReferenceParameterList parameterList = this.toTypeParameterList((EcjPsiSourceElement)element, typeReference.typeArguments);
                element.setParameterList(parameterList);
                int endOffset = parameterList.getTextRange().getEndOffset();
                element.setRange(element.getTextRange().getStartOffset(), endOffset);
                while (parent != null && parent.getTextRange().getEndOffset() < endOffset) {
                    parent.setRange(parent.getTextRange().getStartOffset(), endOffset);
                    parent = parent.getParent();
                }
            }
        }
        return element;
    }

    private EcjPsiJavaCodeReferenceElement toImportReference(EcjPsiSourceElement parent, ImportReference reference) {
        char[][] tokens = reference.tokens;
        if (tokens.length == 1) {
            EcjPsiJavaCodeReferenceElement element = new EcjPsiJavaCodeReferenceElement(this.mManager, reference);
            parent.adoptChild(element);
            String referenceName = new String(tokens[tokens.length - 1]);
            element.setNameElement(this.toIdentifier((EcjPsiSourceElement)element, referenceName, EcjPsiBuilder.toRange((ASTNode)reference)));
            return element;
        }
        int startOffset = reference.sourceStart;
        int endOffset = startOffset + tokens[0].length;
        EcjPsiSourceElement prev = new EcjPsiJavaCodeReferenceElement(this.mManager, (ImportReference)null);
        prev.setNameElement(this.toIdentifier(prev, tokens[0], EcjPsiBuilder.toRange(startOffset, endOffset)));
        prev.setRange(startOffset, endOffset);
        EcjPsiSourceElement curr = null;
        for (int i = 1; i < tokens.length; ++i) {
            curr = new EcjPsiJavaCodeReferenceElement(this.mManager, (ImportReference)null);
            ((EcjPsiJavaCodeReferenceElement)curr).setQualifier((EcjPsiJavaCodeReferenceElement)prev);
            char[] name = tokens[i];
            curr.adoptChild(prev);
            ((EcjPsiJavaCodeReferenceElement)curr).setNameElement(this.toIdentifier(curr, name, EcjPsiBuilder.toRange((endOffset += name.length + 1) - name.length, endOffset)));
            curr.setRange(startOffset, endOffset);
            prev = curr;
        }
        assert (curr != null);
        curr.setNativeNode((ASTNode)reference);
        parent.adoptChild(curr);
        return curr;
    }

    private EcjPsiTypeElement toTypeElement(EcjPsiSourceElement parent, TypeReference reference) {
        EcjPsiTypeElement element = new EcjPsiTypeElement(this.mManager, reference);
        parent.adoptChild(element);
        if (reference.resolvedType instanceof ReferenceBinding) {
            EcjPsiJavaCodeReferenceElement nameElement = this.toTypeReference(element, reference);
            element.setReferenceElement(nameElement);
        }
        return element;
    }

    private PsiParameterList toParameterList(EcjPsiSourceElement parent, Argument[] arguments) {
        EcjPsiParameterList list = new EcjPsiParameterList(this.mManager);
        if (arguments == null || arguments.length == 0) {
            list.setParameters(PsiParameter.EMPTY_ARRAY);
        } else {
            ArrayList parameters = Lists.newArrayListWithCapacity((int)arguments.length);
            for (Argument argument : arguments) {
                EcjPsiParameter parameter = this.toParameter(list, (LocalDeclaration)argument);
                parameters.add(parameter);
            }
            list.setParameters(parameters.toArray(PsiParameter.EMPTY_ARRAY));
            list.mRange = null;
        }
        parent.adoptChild(list);
        return list;
    }

    private EcjPsiAnnotationParameterList toAnnotationParameterList(EcjPsiSourceElement parent, MemberValuePair[] memberValuePairs) {
        EcjPsiAnnotationParameterList list = new EcjPsiAnnotationParameterList(this.mManager);
        if (memberValuePairs != null && memberValuePairs.length > 0) {
            PsiNameValuePair[] pairs = new PsiNameValuePair[memberValuePairs.length];
            for (int i = 0; i < memberValuePairs.length; ++i) {
                pairs[i] = this.toMemberValuePair(list, memberValuePairs[i]);
            }
            list.setAttributes(pairs);
            list.mRange = null;
        } else {
            list.setAttributes(PsiNameValuePair.EMPTY_ARRAY);
        }
        parent.adoptChild(list);
        return list;
    }

    private EcjPsiLocalVariable toVariable(EcjPsiSourceElement parent, LocalDeclaration localDeclaration, boolean includeModifiersAndType) {
        EcjPsiLocalVariable variable = new EcjPsiLocalVariable(this.mManager, localDeclaration);
        if (includeModifiersAndType) {
            EcjPsiModifierList modifierList = this.toModifierList((EcjPsiSourceElement)variable, (AbstractVariableDeclaration)localDeclaration);
            variable.setModifierList(modifierList);
            variable.setTypeElement(this.toTypeElement(variable, localDeclaration.type));
        }
        variable.setNameIdentifier(this.toIdentifier((EcjPsiSourceElement)variable, localDeclaration.name, EcjPsiBuilder.toRange((ASTNode)localDeclaration)));
        if (localDeclaration.initialization != null) {
            variable.setInitializer(this.toExpression(variable, localDeclaration.initialization));
            variable.setRange(EcjPsiBuilder.toRange(localDeclaration.declarationSourceStart, Math.max(localDeclaration.declarationSourceEnd + 1, localDeclaration.initialization.sourceEnd + 1)));
        } else {
            variable.setRange(EcjPsiBuilder.toRange(localDeclaration.declarationSourceStart, localDeclaration.declarationSourceEnd + 1));
        }
        parent.adoptChild(variable);
        return variable;
    }

    private EcjPsiResourceVariable toResourceVariable(EcjPsiSourceElement parent, LocalDeclaration localDeclaration, boolean includeModifiersAndType) {
        EcjPsiResourceVariable variable = new EcjPsiResourceVariable(this.mManager, localDeclaration);
        if (includeModifiersAndType) {
            EcjPsiModifierList modifierList = this.toModifierList((EcjPsiSourceElement)variable, (AbstractVariableDeclaration)localDeclaration);
            modifierList.setModifiers(modifierList.getModifiers() | 0x10);
            variable.setModifierList(modifierList);
            variable.setTypeElement(this.toTypeElement(variable, localDeclaration.type));
        }
        variable.setNameIdentifier(this.toIdentifier((EcjPsiSourceElement)variable, localDeclaration.name, EcjPsiBuilder.toRange((ASTNode)localDeclaration)));
        if (localDeclaration.initialization != null) {
            variable.setInitializer(this.toExpression(variable, localDeclaration.initialization));
            variable.setRange(EcjPsiBuilder.toRange(localDeclaration.declarationSourceStart, Math.max(localDeclaration.declarationSourceEnd + 1, localDeclaration.initialization.sourceEnd + 1)));
        } else {
            variable.setRange(EcjPsiBuilder.toRange(localDeclaration.declarationSourceStart, localDeclaration.declarationSourceEnd + 1));
        }
        parent.adoptChild(variable);
        return variable;
    }

    private EcjPsiParameter toParameter(EcjPsiSourceElement parent, LocalDeclaration argument) {
        EcjPsiParameter parameter = new EcjPsiParameter(this.mManager, argument);
        EcjPsiModifierList modifierList = this.toModifierList((EcjPsiSourceElement)parameter, (AbstractVariableDeclaration)argument);
        parameter.setModifierList(modifierList);
        if (argument.type != null) {
            parameter.setTypeElement(this.toTypeElement(parameter, argument.type));
        }
        parameter.setNameIdentifier(this.toIdentifier((EcjPsiSourceElement)parameter, argument.name, EcjPsiBuilder.toRange((ASTNode)argument)));
        parameter.setRange(EcjPsiBuilder.toRange(argument.declarationSourceStart, argument.sourceEnd + 1));
        parent.adoptChild(parameter);
        return parameter;
    }

    private EcjPsiBlockStatement toBlockStatement(EcjPsiSourceElement parent, Block block) {
        EcjPsiBlockStatement statement = new EcjPsiBlockStatement(this.mManager, (Statement)block);
        parent.adoptChild(statement);
        EcjPsiCodeBlock nestedBlock = this.toBlock(statement, block.statements, null, block.sourceStart, block.sourceEnd + 1);
        statement.setBlock(nestedBlock);
        nestedBlock.setNativeNode((ASTNode)block);
        return statement;
    }

    private EcjPsiCodeBlock toBlock(EcjPsiSourceElement parent, Statement[] statements, ExplicitConstructorCall constructorCall, int startOffset, int endOffset) {
        EcjPsiCodeBlock block = new EcjPsiCodeBlock(this.mManager);
        if (statements != null) {
            ArrayList psiStatements = Lists.newArrayListWithExpectedSize((int)(statements.length + 1));
            if (constructorCall != null && !constructorCall.isImplicitSuper()) {
                psiStatements.add(this.toExplicitConstructorCall(block, constructorCall));
            }
            for (Statement statement : statements) {
                EcjPsiStatement psiStatement = this.toStatement(block, statement);
                psiStatements.add(psiStatement);
            }
            block.setStatements(psiStatements.toArray(PsiStatement.EMPTY_ARRAY));
        } else if (constructorCall != null && !constructorCall.isImplicitSuper()) {
            block.setStatements(new PsiStatement[]{this.toExplicitConstructorCall(block, constructorCall)});
        } else {
            block.setStatements(PsiStatement.EMPTY_ARRAY);
        }
        parent.adoptChild(block);
        if (startOffset != -1) {
            block.setRange(startOffset, endOffset);
        }
        return block;
    }

    private EcjPsiCodeBlock toBlock(EcjPsiSourceElement parent, Statement[] statements) {
        return this.toBlock(parent, statements, null, -1, -1);
    }

    private EcjPsiCodeBlock toBlock(EcjPsiSourceElement parent, Block block) {
        return this.toBlock(parent, block.statements, null, -1, -1);
    }

    private EcjPsiStatement toStatement(EcjPsiSourceElement parent, Statement statement) {
        if (statement instanceof Expression) {
            return this.toExpressionStatement(parent, statement);
        }
        if (statement instanceof AbstractVariableDeclaration) {
            return this.toDeclarationStatement(parent, (AbstractVariableDeclaration)statement);
        }
        if (statement instanceof Block) {
            Block blockStatement = (Block)statement;
            return this.toBlockStatement(parent, blockStatement);
        }
        if (statement instanceof LabeledStatement) {
            return this.toLabeledStatement(parent, (LabeledStatement)statement);
        }
        if (statement instanceof IfStatement) {
            return this.toIfStatement(parent, (IfStatement)statement);
        }
        if (statement instanceof ReturnStatement) {
            return this.toReturnStatement(parent, (ReturnStatement)statement);
        }
        if (statement instanceof ForStatement) {
            return this.toForStatement(parent, (ForStatement)statement);
        }
        if (statement instanceof ForeachStatement) {
            return this.toForEachStatement(parent, (ForeachStatement)statement);
        }
        if (statement instanceof DoStatement) {
            return this.toDoWhileStatement(parent, (DoStatement)statement);
        }
        if (statement instanceof WhileStatement) {
            return this.toWhileStatement(parent, (WhileStatement)statement);
        }
        if (statement instanceof SwitchStatement) {
            return this.toSwitchStatement(parent, (SwitchStatement)statement);
        }
        if (statement instanceof BreakStatement) {
            return this.toBreakStatement(parent, (BreakStatement)statement);
        }
        if (statement instanceof ContinueStatement) {
            return this.toContinueStatement(parent, (ContinueStatement)statement);
        }
        if (statement instanceof CaseStatement) {
            return this.toCaseStatement(parent, (CaseStatement)statement);
        }
        if (statement instanceof SynchronizedStatement) {
            return this.toSynchronizedStatement(parent, (SynchronizedStatement)statement);
        }
        if (statement instanceof TryStatement) {
            return this.toTryStatement(parent, (TryStatement)statement);
        }
        if (statement instanceof EmptyStatement) {
            return this.toEmptyStatement(parent);
        }
        if (statement instanceof AssertStatement) {
            return this.toAssertStatement(parent, (AssertStatement)statement);
        }
        if (statement instanceof ThrowStatement) {
            return this.toThrowStatement(parent, (ThrowStatement)statement);
        }
        if (statement instanceof ExplicitConstructorCall) {
            return this.toExplicitConstructorCall(parent, (ExplicitConstructorCall)statement);
        }
        if (statement instanceof TypeDeclaration) {
            EcjPsiClassLevelDeclarationStatement st = new EcjPsiClassLevelDeclarationStatement(this.mManager);
            this.toClass(st, (TypeDeclaration)statement);
            parent.adoptChild(st);
            return st;
        }
        assert (false) : "Missing implementation for " + statement.getClass();
        throw new IllegalArgumentException(statement.getClass().getName());
    }

    private EcjPsiStatement toExpressionStatement(EcjPsiSourceElement parent, Statement statement) {
        EcjPsiExpressionStatement expressionStatement = new EcjPsiExpressionStatement(this.mManager, statement);
        EcjPsiExpression expression = this.toExpression(expressionStatement, (Expression)statement);
        expressionStatement.setExpression(expression);
        parent.adoptChild(expressionStatement);
        return expressionStatement;
    }

    private EcjPsiStatement toExplicitConstructorCall(EcjPsiSourceElement parent, ExplicitConstructorCall constructorCall) {
        EcjPsiExpressionStatement expressionStatement = new EcjPsiExpressionStatement(this.mManager, (Statement)constructorCall);
        EcjPsiExplicitConstructorCall call = new EcjPsiExplicitConstructorCall(this.mManager, constructorCall);
        expressionStatement.adoptChild(call);
        EcjPsiConstructorReferenceExpression refExp = new EcjPsiConstructorReferenceExpression(this.mManager, constructorCall);
        EcjPsiExpression qualifier = constructorCall.qualification == null ? null : this.toExpression(refExp, constructorCall.qualification);
        refExp.setQualifier(qualifier);
        String keyword = constructorCall.isSuperAccess() ? "super" : "this";
        int identifierStart = constructorCall.qualification != null ? constructorCall.qualification.sourceEnd + 2 : constructorCall.sourceStart;
        int identifierEnd = identifierStart + keyword.length();
        EcjPsiIdentifier identifier = this.toIdentifier((EcjPsiSourceElement)refExp, keyword, EcjPsiBuilder.toRange(identifierStart, identifierEnd));
        refExp.setNameElement(identifier);
        refExp.setRange(constructorCall.sourceStart, identifierEnd);
        call.setMethodExpression(refExp);
        call.adoptChild(refExp);
        call.setArgumentList(this.toArguments(call, constructorCall.arguments));
        if (constructorCall.typeArguments != null) {
            EcjPsiReferenceParameterList typeArgumentList = this.toTypeParameterList((EcjPsiSourceElement)call, constructorCall.typeArguments);
            typeArgumentList.setRange(constructorCall.typeArgumentsSourceStart, constructorCall.sourceEnd + 1);
            call.setTypeArgumentList(typeArgumentList);
        }
        expressionStatement.setExpression((PsiExpression)call);
        parent.adoptChild(expressionStatement);
        return expressionStatement;
    }

    private EcjPsiThrowStatement toThrowStatement(EcjPsiSourceElement parent, ThrowStatement statement) {
        EcjPsiThrowStatement throwStatement = new EcjPsiThrowStatement(this.mManager, (Statement)statement);
        parent.adoptChild(throwStatement);
        throwStatement.setException(this.toExpression(throwStatement, statement.exception));
        return throwStatement;
    }

    private EcjPsiAssertStatement toAssertStatement(EcjPsiSourceElement parent, AssertStatement statement) {
        EcjPsiAssertStatement assertStatement = new EcjPsiAssertStatement(this.mManager, (Statement)statement);
        parent.adoptChild(assertStatement);
        assertStatement.setCondition(this.toExpression(assertStatement, statement.assertExpression));
        if (statement.exceptionArgument != null) {
            assertStatement.setDescription(this.toExpression(assertStatement, statement.exceptionArgument));
        }
        return assertStatement;
    }

    private EcjPsiStatement toEmptyStatement(EcjPsiSourceElement parent) {
        EcjPsiEmptyStatement empty = new EcjPsiEmptyStatement(this.mManager);
        parent.adoptChild(empty);
        return empty;
    }

    private EcjPsiIfStatement toIfStatement(EcjPsiSourceElement parent, IfStatement statement) {
        EcjPsiStatement thenStatement;
        EcjPsiIfStatement ifStatement = new EcjPsiIfStatement(this.mManager, (Statement)statement);
        parent.adoptChild(ifStatement);
        EcjPsiExpression condition = this.toExpression(ifStatement, statement.condition);
        ifStatement.setCondition(condition);
        if (statement.thenStatement != null) {
            thenStatement = this.toStatement(ifStatement, statement.thenStatement);
            ifStatement.setThen(thenStatement);
        }
        if (statement.elseStatement != null) {
            thenStatement = this.toStatement(ifStatement, statement.elseStatement);
            ifStatement.setElse(thenStatement);
        }
        return ifStatement;
    }

    private EcjPsiReturnStatement toReturnStatement(EcjPsiSourceElement parent, ReturnStatement statement) {
        EcjPsiReturnStatement returnStatement = new EcjPsiReturnStatement(this.mManager, (Statement)statement);
        parent.adoptChild(returnStatement);
        if (statement.expression != null) {
            EcjPsiExpression expression = this.toExpression(returnStatement, statement.expression);
            returnStatement.setReturnValue(expression);
        }
        return returnStatement;
    }

    private EcjPsiForStatement toForStatement(EcjPsiSourceElement parent, ForStatement statement) {
        EcjPsiForStatement forStatement = new EcjPsiForStatement(this.mManager, statement);
        parent.adoptChild(forStatement);
        EcjPsiStatement initialization = this.toForDeclarationStatement(forStatement, statement.initializations);
        forStatement.setInitialization(initialization);
        if (statement.condition != null) {
            EcjPsiExpression condition = this.toExpression(forStatement, statement.condition);
            forStatement.setCondition(condition);
        }
        if (statement.increments != null && statement.increments.length > 0) {
            EcjPsiStatement updates = this.toForUpdateStatement(forStatement, statement.increments);
            forStatement.setUpdate(updates);
        }
        EcjPsiStatement body = this.toStatement(forStatement, statement.action);
        forStatement.setBody(body);
        return forStatement;
    }

    private EcjPsiSwitchLabelStatement toCaseStatement(EcjPsiSourceElement parent, CaseStatement statement) {
        EcjPsiSwitchLabelStatement st = new EcjPsiSwitchLabelStatement(this.mManager, (Statement)statement);
        if (statement.constantExpression != null) {
            st.setCaseValue(this.toExpression(st, statement.constantExpression));
        }
        parent.adoptChild(st);
        return st;
    }

    private EcjPsiSwitchStatement toSwitchStatement(EcjPsiSourceElement parent, SwitchStatement statement) {
        EcjPsiSwitchStatement switchStatement = new EcjPsiSwitchStatement(this.mManager, (Statement)statement);
        parent.adoptChild(switchStatement);
        switchStatement.setExpression(this.toExpression(switchStatement, statement.expression));
        switchStatement.setBody(this.toBlock((EcjPsiSourceElement)switchStatement, statement.statements));
        return switchStatement;
    }

    private EcjPsiBreakStatement toBreakStatement(EcjPsiSourceElement parent, BreakStatement statement) {
        EcjPsiBreakStatement breakStatement = new EcjPsiBreakStatement(this.mManager, (Statement)statement);
        parent.adoptChild(breakStatement);
        if (statement.label != null) {
            breakStatement.setIdentifier(this.toIdentifier((EcjPsiSourceElement)breakStatement, statement.label, EcjPsiBuilder.toRange(statement.sourceEnd - statement.label.length, statement.sourceEnd)));
        }
        return breakStatement;
    }

    private EcjPsiContinueStatement toContinueStatement(EcjPsiSourceElement parent, ContinueStatement statement) {
        EcjPsiContinueStatement continueStatement = new EcjPsiContinueStatement(this.mManager, (Statement)statement);
        parent.adoptChild(continueStatement);
        if (statement.label != null) {
            continueStatement.setIdentifier(this.toIdentifier((EcjPsiSourceElement)continueStatement, statement.label, EcjPsiBuilder.toRange(statement.sourceEnd - statement.label.length, statement.sourceEnd)));
        }
        return continueStatement;
    }

    private EcjPsiSynchronizedStatement toSynchronizedStatement(EcjPsiSourceElement parent, SynchronizedStatement statement) {
        EcjPsiSynchronizedStatement s = new EcjPsiSynchronizedStatement(this.mManager, (Statement)statement);
        parent.adoptChild(s);
        if (statement.expression != null) {
            s.setLockExpression(this.toExpression(s, statement.expression));
        }
        if (statement.block != null) {
            s.setBody(this.toBlock((EcjPsiSourceElement)s, statement.block));
        }
        return s;
    }

    private EcjPsiWhileStatement toWhileStatement(EcjPsiSourceElement parent, WhileStatement statement) {
        EcjPsiWhileStatement whileStatement = new EcjPsiWhileStatement(this.mManager, (Statement)statement);
        parent.adoptChild(whileStatement);
        whileStatement.setCondition(this.toExpression(whileStatement, statement.condition));
        whileStatement.setBody(this.toStatement(whileStatement, statement.action));
        return whileStatement;
    }

    private EcjPsiDoWhileStatement toDoWhileStatement(EcjPsiSourceElement parent, DoStatement statement) {
        EcjPsiDoWhileStatement doWhile = new EcjPsiDoWhileStatement(this.mManager, (Statement)statement);
        parent.adoptChild(doWhile);
        doWhile.setBody(this.toStatement(doWhile, statement.action));
        doWhile.setCondition(this.toExpression(doWhile, statement.condition));
        return doWhile;
    }

    private EcjPsiTryStatement toTryStatement(EcjPsiSourceElement parent, TryStatement statement) {
        EcjPsiTryStatement tryStatement = new EcjPsiTryStatement(this.mManager, (Statement)statement);
        parent.adoptChild(tryStatement);
        if (statement.resources != null && statement.resources.length > 0) {
            EcjPsiResourceList list = new EcjPsiResourceList(this.mManager);
            ArrayList variables = Lists.newArrayListWithCapacity((int)statement.resources.length);
            boolean first = true;
            for (LocalDeclaration resource : statement.resources) {
                variables.add(this.toResourceVariable(list, resource, first));
                first = false;
            }
            list.setResourceVariables(variables);
            list.mRange = null;
            tryStatement.setResourceList(list);
            tryStatement.adoptChild(list);
        }
        if (statement.tryBlock != null) {
            tryStatement.setTryBlock(this.toBlock((EcjPsiSourceElement)tryStatement, statement.tryBlock));
        }
        if (statement.catchBlocks != null) {
            assert (statement.catchArguments != null && statement.catchArguments.length == statement.catchBlocks.length);
            ArrayList sections = Lists.newArrayListWithCapacity((int)statement.catchBlocks.length);
            for (int i = 0; i < statement.catchBlocks.length; ++i) {
                Block catchBlock = statement.catchBlocks[i];
                Argument catchArgument = statement.catchArguments[i];
                sections.add(this.toCatchSection(tryStatement, catchArgument, catchBlock));
            }
            tryStatement.setCatchSections(sections.toArray(PsiCatchSection.EMPTY_ARRAY));
        } else {
            tryStatement.setCatchSections(PsiCatchSection.EMPTY_ARRAY);
        }
        if (statement.finallyBlock != null) {
            tryStatement.setFinallyBlock(this.toBlock((EcjPsiSourceElement)tryStatement, statement.finallyBlock));
        }
        return tryStatement;
    }

    private PsiCatchSection toCatchSection(EcjPsiTryStatement parent, Argument catchArgument, Block catchBlock) {
        EcjPsiCatchSection section = new EcjPsiCatchSection(this.mManager, catchArgument, catchBlock);
        parent.adoptChild(section);
        EcjPsiParameter parameter = this.toParameter(section, (LocalDeclaration)catchArgument);
        section.setParameter(parameter);
        section.setCodeBlock(this.toBlock((EcjPsiSourceElement)section, catchBlock));
        if (catchArgument.type instanceof UnionTypeReference) {
            EcjPsiModifierList modifierList = (EcjPsiModifierList)parameter.getModifierList();
            modifierList.setModifiers(modifierList.getModifiers() | 0x10);
        }
        return section;
    }

    private EcjPsiForeachStatement toForEachStatement(EcjPsiSourceElement parent, ForeachStatement statement) {
        EcjPsiForeachStatement forStatement = new EcjPsiForeachStatement(this.mManager, (Statement)statement);
        parent.adoptChild(forStatement);
        forStatement.setIterationParameter(this.toParameter(forStatement, statement.elementVariable));
        forStatement.setIteratedValue(this.toExpression(forStatement, statement.collection));
        forStatement.setBody(this.toStatement(forStatement, statement.action));
        return forStatement;
    }

    private EcjPsiLabeledStatement toLabeledStatement(EcjPsiSourceElement parent, LabeledStatement statement) {
        EcjPsiLabeledStatement labeledStatement = new EcjPsiLabeledStatement(this.mManager, statement);
        parent.adoptChild(labeledStatement);
        EcjPsiIdentifier nameIdentifier = new EcjPsiIdentifier(this.mManager, new String(statement.label), EcjPsiBuilder.toRange(statement.sourceStart, statement.labelEnd + 1));
        labeledStatement.adoptChild(nameIdentifier);
        labeledStatement.setIdentifier(nameIdentifier);
        if (statement.statement != null) {
            labeledStatement.setStatement(this.toStatement(labeledStatement, statement.statement));
        }
        return labeledStatement;
    }

    private EcjPsiStatement toForDeclarationStatement(EcjPsiSourceElement parent, Statement[] statements) {
        if (statements == null || statements.length == 0) {
            return this.toEmptyStatement(parent);
        }
        if (!(statements[0] instanceof LocalDeclaration)) {
            return this.toForUpdateStatement(parent, statements);
        }
        EcjPsiDeclarationStatement declaration = new EcjPsiDeclarationStatement(this.mManager, null);
        parent.adoptChild(declaration);
        ArrayList variables = Lists.newArrayListWithCapacity((int)statements.length);
        EcjPsiSourceElement prevVariable = null;
        for (Statement statement : statements) {
            if (statement instanceof LocalDeclaration) {
                LocalDeclaration localDeclaration = (LocalDeclaration)statement;
                EcjPsiLocalVariable variable = this.toVariable(declaration, localDeclaration, prevVariable == null);
                variables.add(variable);
                if (prevVariable != null) {
                    TextRange prevRange = prevVariable.getTextRange();
                    prevVariable.setRange(prevRange.getStartOffset(), Math.min(prevRange.getEndOffset(), localDeclaration.sourceStart));
                    variable.setRange(localDeclaration.sourceStart, localDeclaration.initialization != null ? localDeclaration.initialization.sourceEnd + 1 : localDeclaration.sourceEnd + 1);
                }
                prevVariable = variable;
                continue;
            }
            assert (false) : statement;
        }
        declaration.setDeclaredElements(variables.toArray(PsiElement.EMPTY_ARRAY));
        return declaration;
    }

    private EcjPsiExpressionList toArguments(EcjPsiSourceElement parent, Expression[] expressionArray) {
        EcjPsiExpressionList list = new EcjPsiExpressionList(this.mManager);
        if (expressionArray != null && expressionArray.length > 0) {
            ArrayList expressions = Lists.newArrayListWithCapacity((int)expressionArray.length);
            for (Expression e : expressionArray) {
                EcjPsiExpression expression = this.toExpression(list, e);
                expressions.add(expression);
            }
            list.setExpressions(expressions.toArray(PsiExpression.EMPTY_ARRAY));
            list.mRange = null;
        } else {
            list.setExpressions(PsiExpression.EMPTY_ARRAY);
        }
        parent.adoptChild(list);
        return list;
    }

    private EcjPsiStatement toForUpdateStatement(EcjPsiSourceElement parent, Statement[] statements) {
        if (statements.length == 1) {
            return this.toStatement(parent, statements[0]);
        }
        EcjPsiExpressionListStatement listStatement = new EcjPsiExpressionListStatement(this.mManager);
        EcjPsiExpressionList expressionList = new EcjPsiExpressionList(this.mManager);
        ArrayList expressions = Lists.newArrayListWithCapacity((int)statements.length);
        for (Statement s : statements) {
            if (s instanceof Expression) {
                EcjPsiExpression expression = this.toExpression(expressionList, (Expression)s);
                expressions.add(expression);
                continue;
            }
            assert (false) : s;
        }
        expressionList.setExpressions(expressions.toArray(PsiExpression.EMPTY_ARRAY));
        if (statements.length > 0) {
            expressionList.setRange(new TextRange(expressionList.getFirstChild().getTextRange().getStartOffset(), expressionList.getLastChild().getTextRange().getEndOffset()));
        }
        listStatement.setExpressionList(expressionList);
        listStatement.adoptChild(expressionList);
        parent.adoptChild(listStatement);
        return listStatement;
    }

    private EcjPsiDeclarationStatement toDeclarationStatement(EcjPsiSourceElement parent, AbstractVariableDeclaration statement) {
        if (parent.mLastChild instanceof EcjPsiDeclarationStatement && parent.mLastChild.mNativeNode instanceof AbstractVariableDeclaration && statement.declarationSourceStart == ((AbstractVariableDeclaration)parent.mLastChild.mNativeNode).declarationSourceStart) {
            EcjPsiDeclarationStatement declaration = (EcjPsiDeclarationStatement)parent.mLastChild;
            PsiElement prevVariable = declaration.getLastChild();
            assert (statement instanceof LocalDeclaration);
            assert (prevVariable instanceof EcjPsiLocalVariable);
            LocalDeclaration localDeclaration = (LocalDeclaration)statement;
            EcjPsiLocalVariable variable = this.toVariable(declaration, localDeclaration, false);
            TextRange prevRange = prevVariable.getTextRange();
            ((EcjPsiLocalVariable)prevVariable).setRange(prevRange.getStartOffset(), Math.min(prevRange.getEndOffset(), localDeclaration.sourceStart));
            variable.setRange(localDeclaration.sourceStart, localDeclaration.initialization != null ? localDeclaration.initialization.sourceEnd + 1 : localDeclaration.sourceEnd + 1);
            Object[] declaredElements = declaration.getDeclaredElements();
            declaration.setDeclaredElements((PsiElement[])ObjectArrays.concat((Object[])declaredElements, (Object)variable));
            return declaration;
        }
        EcjPsiDeclarationStatement declaration = new EcjPsiDeclarationStatement(this.mManager, statement);
        parent.adoptChild(declaration);
        assert (statement instanceof LocalDeclaration);
        EcjPsiLocalVariable variable = this.toVariable(declaration, (LocalDeclaration)statement, true);
        declaration.setDeclaredElements(new PsiElement[]{variable});
        return declaration;
    }

    private EcjPsiField toField(EcjPsiClass cls, FieldDeclaration field) {
        EcjPsiField psiField = new EcjPsiField(this.mManager, cls, field);
        cls.adoptChild(psiField);
        EcjPsiModifierList modifierList = this.toModifierList((EcjPsiSourceElement)psiField, (AbstractVariableDeclaration)field);
        psiField.setModifierList(modifierList);
        psiField.setTypeElement(this.toTypeElement(psiField, field.type));
        psiField.setIdentifier(this.toIdentifier((EcjPsiSourceElement)psiField, field.name, EcjPsiBuilder.toRange(field.sourceStart, field.sourceStart + field.name.length)));
        if (field.initialization != null) {
            psiField.setFieldInitializer(this.toExpression(psiField, field.initialization));
        }
        return psiField;
    }

    private EcjPsiEnumConstant toEnumConstant(EcjPsiClass cls, FieldDeclaration field) {
        EcjPsiEnumConstant psiField = new EcjPsiEnumConstant(this.mManager, cls, field);
        cls.adoptChild(psiField);
        EcjPsiModifierList modifierList = this.toModifierList((EcjPsiSourceElement)psiField, (AbstractVariableDeclaration)field);
        psiField.setModifierList(modifierList);
        int modifiers = modifierList.getModifiers();
        modifiers |= 0x19;
        modifierList.setModifiers(modifiers &= 0xFFFFFFF9);
        psiField.setIdentifier(this.toIdentifier((EcjPsiSourceElement)psiField, field.name, EcjPsiBuilder.toRange(field.sourceStart, field.sourceStart + field.name.length)));
        Expression init = field.initialization;
        if (init != null && init instanceof AllocationExpression) {
            EcjPsiEnumConstantInitializer initializer;
            EcjPsiExpressionList arguments = this.toArguments(psiField, ((AllocationExpression)init).arguments);
            psiField.setArgumentList(arguments);
            if (init instanceof QualifiedAllocationExpression && (initializer = this.toEnumInitializer(psiField, init)) != null) {
                psiField.setInitializer(initializer);
                initializer.setConstant(psiField);
            }
        }
        return psiField;
    }

    private EcjPsiReferenceParameterList toTypeParameterList(EcjPsiSourceElement parent, TypeReference[] references) {
        EcjPsiReferenceParameterList list = new EcjPsiReferenceParameterList(this.mManager);
        if (references != null && references.length > 0) {
            ArrayList parameters = Lists.newArrayListWithCapacity((int)references.length);
            for (TypeReference typeReference : references) {
                EcjPsiTypeElement typeElement = this.toTypeElement(list, typeReference);
                parameters.add(typeElement);
            }
            list.setTypeParameters(parameters.toArray(PsiTypeElement.EMPTY_ARRAY));
            list.mRange = null;
        } else {
            list.setTypeParameters(PsiTypeElement.EMPTY_ARRAY);
        }
        parent.adoptChild(list);
        return list;
    }

    private PsiTypeParameterList toTypeParameterList(EcjPsiSourceElement parent, TypeParameter[] typeParameters) {
        EcjPsiTypeParameterList list = new EcjPsiTypeParameterList(this.mManager);
        if (typeParameters != null && typeParameters.length > 0) {
            ArrayList parameters = Lists.newArrayListWithCapacity((int)typeParameters.length);
            for (TypeParameter typeParameter : typeParameters) {
                EcjPsiTypeParameter p = new EcjPsiTypeParameter(this.mManager, typeParameter);
                list.adoptChild(p);
                EcjPsiReferenceList extendsList = this.toTypeReferenceList((EcjPsiSourceElement)p, typeParameter.bounds, PsiReferenceList.Role.EXTENDS_BOUNDS_LIST);
                p.setExtendsList(extendsList);
                parameters.add(p);
            }
            list.setTypeParameters(parameters.toArray(PsiTypeParameter.EMPTY_ARRAY));
            list.mRange = null;
        } else {
            list.setTypeParameters(PsiTypeParameter.EMPTY_ARRAY);
        }
        parent.adoptChild(list);
        return list;
    }

    private EcjPsiIdentifier toIdentifier(EcjPsiSourceElement parent, String name, TextRange range) {
        EcjPsiIdentifier identifier = new EcjPsiIdentifier(this.mManager, name, range);
        parent.adoptChild(identifier);
        return identifier;
    }

    private EcjPsiIdentifier toIdentifier(EcjPsiSourceElement parent, char[] name, TextRange range) {
        EcjPsiIdentifier identifier = new EcjPsiIdentifier(this.mManager, new String(name), range);
        parent.adoptChild(identifier);
        return identifier;
    }

    EcjPsiJavaFile toFile(CompilationUnitDeclaration node, EcjSourceFile source) {
        TypeDeclaration[] newTypes;
        EcjPsiJavaFile unit = new EcjPsiJavaFile(this.mManager, source, node);
        if (node.currentPackage != null) {
            EcjPsiPackageStatement packageStatement = this.toPackageStatement(unit, node.currentPackage);
            unit.setPackageStatement(packageStatement);
        }
        EcjPsiImportList importList = this.toImportList(unit, node.imports);
        unit.setImportList(importList);
        if (node.types != null && node.types.length > 0 && CharOperation.equals((char[])PACKAGE_INFO, (char[])node.types[0].name)) {
            newTypes = new TypeDeclaration[node.types.length - 1];
            System.arraycopy(node.types, 1, newTypes, 0, node.types.length - 1);
        } else {
            newTypes = node.types;
        }
        ArrayList classes = Lists.newArrayList();
        if (newTypes != null) {
            for (TypeDeclaration declaration : newTypes) {
                EcjPsiClass toClass = this.toClass(unit, declaration);
                classes.add(toClass);
            }
        }
        unit.setClasses(classes.toArray(new PsiClass[classes.size()]));
        return unit;
    }

    private class TestParentheses
    extends EcjPsiExpression
    implements PsiParenthesizedExpression {
        private final PsiExpression mExpression;

        public TestParentheses(PsiExpression expression) {
            super(EcjPsiBuilder.this.mManager, (Expression)null);
            this.mExpression = expression;
        }

        @Override
        public void accept(PsiElementVisitor visitor) {
            if (visitor instanceof JavaElementVisitor) {
                ((JavaElementVisitor)visitor).visitParenthesizedExpression((PsiParenthesizedExpression)this);
            } else {
                visitor.visitElement((PsiElement)this);
            }
        }

        public PsiExpression getExpression() {
            return this.mExpression;
        }

        @Override
        public PsiType getType() {
            return this.mExpression.getType();
        }
    }

    private class TestWhitespace
    extends EcjPsiSourceElement
    implements PsiWhiteSpace {
        public TestWhitespace() {
            super(EcjPsiBuilder.this.mManager, null);
        }

        @Override
        public void accept(PsiElementVisitor visitor) {
            visitor.visitWhiteSpace((PsiWhiteSpace)this);
        }
    }
}

