/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.psi.EcjPsiAnnotation;
import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.EcjPsiSourceElement;
import com.android.tools.lint.psi.UnimplementedLintPsiApiException;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;

class EcjPsiModifierList
extends EcjPsiSourceElement
implements PsiModifierList {
    static final int DEFAULT_MASK = 16384;
    private int mModifiers;
    private PsiAnnotation[] mAnnotations;

    EcjPsiModifierList(EcjPsiManager manager, int modifiers) {
        super(manager, null);
        this.mModifiers = modifiers;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.mAnnotations != null && this.mAnnotations.length > 0) {
            sb.append(this.mAnnotations.length).append(" annotations");
        } else if (this.mModifiers == 0) {
            sb.append(":<empty>");
            return sb.toString();
        }
        sb.append(':').append(Integer.toString(this.mModifiers));
        if ((this.mModifiers & 1) != 0) {
            sb.append(':').append("public");
        }
        if ((this.mModifiers & 4) != 0) {
            sb.append(':').append("protected");
        }
        if ((this.mModifiers & 2) != 0) {
            sb.append(':').append("private");
        }
        if ((this.mModifiers & 8) != 0) {
            sb.append(':').append("static");
        }
        if ((this.mModifiers & 0x400) != 0) {
            sb.append(':').append("abstract");
        }
        if ((this.mModifiers & 0x10) != 0) {
            sb.append(':').append("final");
        }
        if ((this.mModifiers & 0x100) != 0) {
            sb.append(':').append("native");
        }
        if ((this.mModifiers & 0x20) != 0) {
            sb.append(':').append("synchronized");
        }
        if ((this.mModifiers & 0x800) != 0) {
            sb.append(':').append("strictfp");
        }
        return sb.toString();
    }

    int getModifiers() {
        return this.mModifiers;
    }

    void setModifiers(int modifiers) {
        this.mModifiers = modifiers;
    }

    public PsiAnnotation[] getAnnotations() {
        return this.mAnnotations;
    }

    void setAnnotations(EcjPsiAnnotation[] annotations) {
        this.mAnnotations = annotations;
    }

    public boolean hasModifierProperty(@PsiModifier.ModifierConstant String s) {
        return this.hasExplicitModifier(s);
    }

    public boolean hasExplicitModifier(@PsiModifier.ModifierConstant String s) {
        return EcjPsiModifierList.hasModifier(this.mModifiers, s);
    }

    static boolean hasModifier(int modifiers, @PsiModifier.ModifierConstant String s) {
        if ("public".equals(s)) {
            return (modifiers & 1) != 0;
        }
        if ("protected".equals(s)) {
            return (modifiers & 4) != 0;
        }
        if ("private".equals(s)) {
            return (modifiers & 2) != 0;
        }
        if ("static".equals(s)) {
            return (modifiers & 8) != 0;
        }
        if ("abstract".equals(s)) {
            return (modifiers & 0x400) != 0;
        }
        if ("final".equals(s)) {
            return (modifiers & 0x10) != 0;
        }
        if ("transient".equals(s)) {
            return (modifiers & 0x80) != 0;
        }
        if ("volatile".equals(s)) {
            return (modifiers & 0x40) != 0;
        }
        if ("native".equals(s)) {
            return (modifiers & 0x100) != 0;
        }
        if ("synchronized".equals(s)) {
            return (modifiers & 0x20) != 0;
        }
        if ("strictfp".equals(s)) {
            return (modifiers & 0x800) != 0;
        }
        if ("default".equals(s)) {
            return (modifiers & 0x4000) != 0;
        }
        return false;
    }

    @Override
    public void accept(PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitModifierList((PsiModifierList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiAnnotation[] getApplicableAnnotations() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiAnnotation findAnnotation(String s) {
        if (this.mAnnotations != null) {
            for (PsiAnnotation annotation : this.mAnnotations) {
                if (!s.equals(annotation.getQualifiedName())) continue;
                return annotation;
            }
        }
        return null;
    }
}

