/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.util;

import android.databinding.tool.processing.ScopedException;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class L {
    private static boolean sEnableDebug = false;
    private static final Client sSystemClient;
    private static Client sClient;

    public static void setClient(Client systemClient) {
        sClient = systemClient;
    }

    public static void setDebugLog(boolean enabled) {
        sEnableDebug = enabled;
    }

    public static void d(String msg, Object ... args) {
        if (sEnableDebug) {
            L.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
        }
    }

    public static void d(Throwable t, String msg, Object ... args) {
        if (sEnableDebug) {
            L.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args) + " " + ExceptionUtils.getStackTrace((Throwable)t));
        }
    }

    public static void w(String msg, Object ... args) {
        L.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args));
    }

    public static void w(Throwable t, String msg, Object ... args) {
        L.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args) + " " + ExceptionUtils.getStackTrace((Throwable)t));
    }

    private static void tryToThrowScoped(Throwable t, String fullMessage) {
        ScopedException ex;
        if (t instanceof ScopedException && (ex = (ScopedException)t).isValid()) {
            throw ex;
        }
        ex = new ScopedException(fullMessage, new Object[0]);
        if (ex.isValid()) {
            throw ex;
        }
    }

    public static void e(String msg, Object ... args) {
        String fullMsg = String.format(msg, args);
        L.tryToThrowScoped(null, fullMsg);
        L.printMessage(Diagnostic.Kind.ERROR, fullMsg);
    }

    public static void e(Throwable t, String msg, Object ... args) {
        String fullMsg = String.format(msg, args);
        L.tryToThrowScoped(t, fullMsg);
        L.printMessage(Diagnostic.Kind.ERROR, fullMsg + " " + ExceptionUtils.getStackTrace((Throwable)t));
    }

    private static void printMessage(Diagnostic.Kind kind, String message) {
        sClient.printMessage(kind, message);
        if (kind == Diagnostic.Kind.ERROR) {
            throw new RuntimeException("failure, see logs for details.\n" + message);
        }
    }

    public static boolean isDebugEnabled() {
        return sEnableDebug;
    }

    static {
        sClient = sSystemClient = new Client(){

            @Override
            public void printMessage(Diagnostic.Kind kind, String message) {
                if (kind == Diagnostic.Kind.ERROR) {
                    System.err.println(message);
                } else {
                    System.out.println(message);
                }
            }
        };
    }

    public static interface Client {
        public void printMessage(Diagnostic.Kind var1, String var2);
    }
}

