/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zfile;

import com.android.builder.internal.packaging.sign.FullApkSignExtension;
import com.android.builder.internal.packaging.sign.ManifestGenerationExtension;
import com.android.builder.internal.packaging.sign.SignatureExtension;
import com.android.builder.internal.packaging.zip.AlignmentRule;
import com.android.builder.internal.packaging.zip.AlignmentRules;
import com.android.builder.internal.packaging.zip.StoredEntry;
import com.android.builder.internal.packaging.zip.ZFile;
import com.android.builder.internal.packaging.zip.ZFileOptions;
import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class ZFiles {
    private static final AlignmentRule APK_DEFAULT_RULE = AlignmentRules.constant(4);
    private static final String DEFAULT_BUILD_BY = "Generated-by-ADT";
    private static final String DEFAULT_CREATED_BY = "Generated-by-ADT";

    public static ZFile apk(File f, ZFileOptions options) throws IOException {
        options.setAlignmentRule(AlignmentRules.compose(options.getAlignmentRule(), APK_DEFAULT_RULE));
        return new ZFile(f, options);
    }

    public static ZFile apk(File f, ZFileOptions options, PrivateKey key, X509Certificate certificate, boolean v1SigningEnabled, boolean v2SigningEnabled, String builtBy, String createdBy, int minSdkVersion) throws IOException {
        ZFile zfile = ZFiles.apk(f, options);
        if (builtBy == null) {
            builtBy = "Generated-by-ADT";
        }
        if (createdBy == null) {
            createdBy = "Generated-by-ADT";
        }
        ManifestGenerationExtension manifestExt = new ManifestGenerationExtension(builtBy, createdBy);
        manifestExt.register(zfile);
        if (key != null && certificate != null) {
            try {
                if (v1SigningEnabled) {
                    String apkSignedHeaderValue = v2SigningEnabled ? "2" : null;
                    SignatureExtension jarSignatureSchemeExt = new SignatureExtension(manifestExt, minSdkVersion, certificate, key, apkSignedHeaderValue);
                    jarSignatureSchemeExt.register();
                }
                if (v2SigningEnabled) {
                    FullApkSignExtension apkSignatureSchemeV2Ext = new FullApkSignExtension(zfile, minSdkVersion, certificate, key);
                    apkSignatureSchemeV2Ext.register();
                }
                if (!v1SigningEnabled) {
                    for (StoredEntry entry : zfile.entries()) {
                        if (!SignatureExtension.isIgnoredFile(entry.getCentralDirectoryHeader().getName())) continue;
                        entry.delete();
                    }
                }
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new IOException("Failed to create signature extensions", e);
            }
        }
        return zfile;
    }
}

