/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.settings;

import com.intellij.application.options.GeneralCodeStyleOptionsProvider;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigConfigurable
extends CodeStyleSettingsProvider
implements GeneralCodeStyleOptionsProvider {
    private JBCheckBox myEnabled;

    @Nullable
    public JComponent createComponent() {
        this.myEnabled = new JBCheckBox("Enable EditorConfig support");
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"EditorConfig", (boolean)false));
        panel.add((Component)this.myEnabled);
        JLabel warning = new JLabel("EditorConfig may override the IDE code style settings");
        warning.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        warning.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)20, (int)0, (int)0));
        panel.add(warning);
        return panel;
    }

    public boolean isModified(CodeStyleSettings settings) {
        return this.myEnabled.isSelected() != ((EditorConfigSettings)settings.getCustomSettings(EditorConfigSettings.class)).ENABLED;
    }

    public void apply(CodeStyleSettings settings) {
        ((EditorConfigSettings)settings.getCustomSettings(EditorConfigSettings.class)).ENABLED = this.myEnabled.isSelected();
    }

    public void reset(CodeStyleSettings settings) {
        this.myEnabled.setSelected(((EditorConfigSettings)settings.getCustomSettings(EditorConfigSettings.class)).ENABLED);
    }

    public void disposeUIResources() {
        this.myEnabled = null;
    }

    @NotNull
    public Configurable createSettingsPage(CodeStyleSettings settings, CodeStyleSettings originalSettings) {
        return null;
    }

    public boolean isModified() {
        return false;
    }

    public void apply() throws ConfigurationException {
    }

    public void reset() {
    }

    public boolean hasSettingsPage() {
        return false;
    }

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(CodeStyleSettings settings) {
        return new EditorConfigSettings(settings);
    }
}

