/*
 * Decompiled with CFR 0.152.
 */
package com.android.ninepatch;

import com.android.ninepatch.GraphicsUtilities;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NinePatchChunk
implements Serializable {
    private static final long serialVersionUID = -7353439224505296217L;
    private static final int[] sPaddingRect = new int[4];
    private boolean mVerticalStartWithPatch;
    private boolean mHorizontalStartWithPatch;
    private List<Rectangle> mFixed;
    private List<Rectangle> mPatches;
    private List<Rectangle> mHorizontalPatches;
    private List<Rectangle> mVerticalPatches;
    private Pair<Integer> mHorizontalPadding;
    private Pair<Integer> mVerticalPadding;

    public static NinePatchChunk create(BufferedImage bufferedImage) {
        NinePatchChunk ninePatchChunk = new NinePatchChunk();
        ninePatchChunk.findPatches(bufferedImage);
        return ninePatchChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(BufferedImage bufferedImage, Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl;
        boolean bl2 = bl = n5 != n6 && n5 != 0 && n6 != 0;
        if (bl) {
            try {
                graphics2D = (Graphics2D)graphics2D.create();
                float f = (float)n5 / (float)n6;
                graphics2D.translate(n, n2);
                graphics2D.scale(f, f);
                n3 = (int)((float)n3 / f);
                n4 = (int)((float)n4 / f);
                n2 = 0;
                n = 0;
                this.draw(bufferedImage, graphics2D, n, n2, n3, n4);
            }
            finally {
                graphics2D.dispose();
            }
        } else {
            this.draw(bufferedImage, graphics2D, n, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void draw(BufferedImage bufferedImage, Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        if (n3 <= 1 || n4 <= 1) {
            return;
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        try {
            if (this.mPatches.size() == 0) {
                graphics2D2.drawImage(bufferedImage, n, n2, n3, n4, null);
                return;
            }
            graphics2D2.translate(n, n2);
            n2 = 0;
            n = 0;
            DrawingData drawingData = this.computePatches(n3, n4);
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            float f = 1.0f;
            float f2 = drawingData.mRemainderVertical;
            boolean bl = this.mVerticalStartWithPatch;
            while (n2 < n4 - 1) {
                boolean bl2 = this.mHorizontalStartWithPatch;
                int n9 = 0;
                float f3 = 0.0f;
                float f4 = 1.0f;
                float f5 = drawingData.mRemainderHorizontal;
                while (n < n3 - 1) {
                    int n10;
                    float f6;
                    Rectangle rectangle;
                    if (!bl) {
                        if (bl2) {
                            rectangle = this.mHorizontalPatches.get(n6++);
                            f6 = (float)rectangle.width / drawingData.mHorizontalPatchesSum;
                            n10 = (int)(f6 * f5 / f4);
                            f4 -= f6;
                            f5 -= (float)n10;
                            graphics2D2.drawImage(bufferedImage, n, n2, n + n10, n2 + rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, null);
                            n += n10;
                        } else {
                            rectangle = this.mFixed.get(n5++);
                            graphics2D2.drawImage(bufferedImage, n, n2, n + rectangle.width, n2 + rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, null);
                            n += rectangle.width;
                        }
                        n9 = rectangle.height;
                    } else if (bl2) {
                        rectangle = this.mPatches.get(n8++);
                        f3 = (float)rectangle.height / drawingData.mVerticalPatchesSum;
                        n9 = (int)(f3 * f2 / f);
                        f6 = (float)rectangle.width / drawingData.mHorizontalPatchesSum;
                        n10 = (int)(f6 * f5 / f4);
                        f4 -= f6;
                        f5 -= (float)n10;
                        graphics2D2.drawImage(bufferedImage, n, n2, n + n10, n2 + n9, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, null);
                        n += n10;
                    } else {
                        rectangle = this.mVerticalPatches.get(n7++);
                        f3 = (float)rectangle.height / drawingData.mVerticalPatchesSum;
                        n9 = (int)(f3 * f2 / f);
                        graphics2D2.drawImage(bufferedImage, n, n2, n + rectangle.width, n2 + n9, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, null);
                        n += rectangle.width;
                    }
                    bl2 = !bl2;
                }
                n = 0;
                n2 += n9;
                if (bl) {
                    f -= f3;
                    f2 -= (float)n9;
                }
                bl = !bl;
            }
        }
        finally {
            graphics2D2.dispose();
        }
    }

    public void getPadding(int[] nArray) {
        nArray[0] = (Integer)this.mHorizontalPadding.mFirst;
        nArray[2] = (Integer)this.mHorizontalPadding.mSecond;
        nArray[1] = (Integer)this.mVerticalPadding.mFirst;
        nArray[3] = (Integer)this.mVerticalPadding.mSecond;
    }

    public int[] getPadding() {
        this.getPadding(sPaddingRect);
        return sPaddingRect;
    }

    private DrawingData computePatches(int n, int n2) {
        int n3;
        DrawingData drawingData = new DrawingData();
        boolean bl = false;
        boolean bl2 = true;
        int n4 = 0;
        int n5 = 0;
        if (this.mFixed.size() > 0) {
            n3 = this.mFixed.get((int)0).y;
            for (Rectangle rectangle : this.mFixed) {
                if (rectangle.y > n3) {
                    bl2 = true;
                    bl = true;
                }
                if (!bl) {
                    n4 += rectangle.width;
                }
                if (!bl2) continue;
                n5 += rectangle.height;
                bl2 = false;
                n3 = rectangle.y;
            }
        }
        drawingData.mRemainderHorizontal = n - n4;
        drawingData.mRemainderVertical = n2 - n5;
        drawingData.mHorizontalPatchesSum = 0.0f;
        if (this.mHorizontalPatches.size() > 0) {
            n3 = -1;
            for (Rectangle rectangle : this.mHorizontalPatches) {
                if (rectangle.x <= n3) continue;
                drawingData.mHorizontalPatchesSum += rectangle.width;
                n3 = rectangle.x;
            }
        } else {
            n3 = -1;
            for (Rectangle rectangle : this.mPatches) {
                if (rectangle.x <= n3) continue;
                drawingData.mHorizontalPatchesSum += rectangle.width;
                n3 = rectangle.x;
            }
        }
        drawingData.mVerticalPatchesSum = 0.0f;
        if (this.mVerticalPatches.size() > 0) {
            n3 = -1;
            for (Rectangle rectangle : this.mVerticalPatches) {
                if (rectangle.y <= n3) continue;
                drawingData.mVerticalPatchesSum += rectangle.height;
                n3 = rectangle.y;
            }
        } else {
            n3 = -1;
            for (Rectangle rectangle : this.mPatches) {
                if (rectangle.y <= n3) continue;
                drawingData.mVerticalPatchesSum += rectangle.height;
                n3 = rectangle.y;
            }
        }
        return drawingData;
    }

    private void findPatches(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth() - 2;
        int n2 = bufferedImage.getHeight() - 2;
        int[] nArray = null;
        int[] nArray2 = null;
        nArray = GraphicsUtilities.getPixels(bufferedImage, 1, 0, n, 1, nArray);
        nArray2 = GraphicsUtilities.getPixels(bufferedImage, 0, 1, 1, n2, nArray2);
        boolean[] blArray = new boolean[1];
        Pair<List<Pair<Integer>>> pair = this.getPatches(nArray2, blArray);
        this.mVerticalStartWithPatch = blArray[0];
        blArray = new boolean[1];
        Pair<List<Pair<Integer>>> pair2 = this.getPatches(nArray, blArray);
        this.mHorizontalStartWithPatch = blArray[0];
        this.mFixed = this.getRectangles((List)pair.mFirst, (List)pair2.mFirst);
        this.mPatches = this.getRectangles((List)pair.mSecond, (List)pair2.mSecond);
        if (this.mFixed.size() > 0) {
            this.mHorizontalPatches = this.getRectangles((List)pair.mFirst, (List)pair2.mSecond);
            this.mVerticalPatches = this.getRectangles((List)pair.mSecond, (List)pair2.mFirst);
        } else if (((List)pair2.mFirst).size() > 0) {
            this.mHorizontalPatches = new ArrayList<Rectangle>(0);
            this.mVerticalPatches = this.getVerticalRectangles(n2, (List)pair2.mFirst);
        } else if (((List)pair.mFirst).size() > 0) {
            this.mHorizontalPatches = this.getHorizontalRectangles(n, (List)pair.mFirst);
            this.mVerticalPatches = new ArrayList<Rectangle>(0);
        } else {
            this.mVerticalPatches = new ArrayList<Rectangle>(0);
            this.mHorizontalPatches = this.mVerticalPatches;
        }
        nArray = GraphicsUtilities.getPixels(bufferedImage, 1, n2 + 1, n, 1, nArray);
        nArray2 = GraphicsUtilities.getPixels(bufferedImage, n + 1, 1, 1, n2, nArray2);
        pair2 = this.getPatches(nArray, blArray);
        this.mHorizontalPadding = this.getPadding((List)pair2.mFirst);
        pair = this.getPatches(nArray2, blArray);
        this.mVerticalPadding = this.getPadding((List)pair.mFirst);
    }

    private List<Rectangle> getVerticalRectangles(int n, List<Pair<Integer>> list) {
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        for (Pair<Integer> pair : list) {
            int n2 = (Integer)pair.mFirst;
            int n3 = (Integer)pair.mSecond - (Integer)pair.mFirst;
            arrayList.add(new Rectangle(n2, 0, n3, n));
        }
        return arrayList;
    }

    private List<Rectangle> getHorizontalRectangles(int n, List<Pair<Integer>> list) {
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        for (Pair<Integer> pair : list) {
            int n2 = (Integer)pair.mFirst;
            int n3 = (Integer)pair.mSecond - (Integer)pair.mFirst;
            arrayList.add(new Rectangle(0, n2, n, n3));
        }
        return arrayList;
    }

    private Pair<Integer> getPadding(List<Pair<Integer>> list) {
        if (list.size() == 0) {
            return new Pair<Integer>(0, 0);
        }
        if (list.size() == 1) {
            if ((Integer)list.get((int)0).mFirst == 0) {
                return new Pair<Integer>((Integer)list.get((int)0).mSecond - (Integer)list.get((int)0).mFirst, 0);
            }
            return new Pair<Integer>(0, (Integer)list.get((int)0).mSecond - (Integer)list.get((int)0).mFirst);
        }
        int n = list.size() - 1;
        return new Pair<Integer>((Integer)list.get((int)0).mSecond - (Integer)list.get((int)0).mFirst, (Integer)list.get((int)n).mSecond - (Integer)list.get((int)n).mFirst);
    }

    private List<Rectangle> getRectangles(List<Pair<Integer>> list, List<Pair<Integer>> list2) {
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        for (Pair<Integer> pair : list) {
            int n = (Integer)pair.mFirst;
            int n2 = (Integer)pair.mSecond - (Integer)pair.mFirst;
            for (Pair<Integer> pair2 : list2) {
                int n3 = (Integer)pair2.mFirst;
                int n4 = (Integer)pair2.mSecond - (Integer)pair2.mFirst;
                arrayList.add(new Rectangle(n3, n, n4, n2));
            }
        }
        return arrayList;
    }

    private Pair<List<Pair<Integer>>> getPatches(int[] nArray, boolean[] blArray) {
        int n = 0;
        int n2 = nArray[0];
        boolean bl = true;
        ArrayList<Pair<Integer>> arrayList = new ArrayList<Pair<Integer>>();
        ArrayList<Pair<Integer>> arrayList2 = new ArrayList<Pair<Integer>>();
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            if (n3 == n2) continue;
            if (n2 == -16777216) {
                if (bl) {
                    blArray[0] = true;
                }
                arrayList2.add(new Pair<Integer>(n, i));
            } else {
                arrayList.add(new Pair<Integer>(n, i));
            }
            bl = false;
            n = i;
            n2 = n3;
        }
        if (n2 == -16777216) {
            if (bl) {
                blArray[0] = true;
            }
            arrayList2.add(new Pair<Integer>(n, nArray.length));
        } else {
            arrayList.add(new Pair<Integer>(n, nArray.length));
        }
        if (arrayList2.size() == 0) {
            arrayList2.add(new Pair<Integer>(1, nArray.length));
            blArray[0] = true;
            arrayList.clear();
        }
        return new Pair<List<Pair<Integer>>>(arrayList, arrayList2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Pair<E>
    implements Serializable {
        private static final long serialVersionUID = -2204108979541762418L;
        E mFirst;
        E mSecond;

        Pair(E e, E e2) {
            this.mFirst = e;
            this.mSecond = e2;
        }

        public String toString() {
            return "Pair[" + this.mFirst + ", " + this.mSecond + "]";
        }
    }

    static final class DrawingData {
        private int mRemainderHorizontal;
        private int mRemainderVertical;
        private float mHorizontalPatchesSum;
        private float mVerticalPatchesSum;

        DrawingData() {
        }
    }
}

