/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import com.android.layoutlib.bridge.impl.LayoutParserWrapper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ParserFactory {
    public static final boolean LOG_PARSER = false;
    private static com.android.ide.common.rendering.api.ParserFactory sParserFactory;

    public static void setParserFactory(com.android.ide.common.rendering.api.ParserFactory parserFactory) {
        sParserFactory = parserFactory;
    }

    public static XmlPullParser create(File f) throws XmlPullParserException, FileNotFoundException {
        return ParserFactory.create(f, false);
    }

    public static XmlPullParser create(File f, boolean isLayout) throws XmlPullParserException, FileNotFoundException {
        FileInputStream stream = new FileInputStream(f);
        return ParserFactory.create(stream, f.getName(), f.length(), isLayout);
    }

    public static XmlPullParser create(InputStream stream, String name) throws XmlPullParserException {
        return ParserFactory.create(stream, name, -1L, false);
    }

    private static XmlPullParser create(InputStream stream, String name, long size, boolean isLayout) throws XmlPullParserException {
        XmlPullParser parser = ParserFactory.instantiateParser(name);
        stream = ParserFactory.readAndClose(stream, name, size);
        parser.setInput(stream, null);
        if (isLayout) {
            try {
                return new LayoutParserWrapper(parser).peekTillLayoutStart();
            }
            catch (IOException e) {
                throw new XmlPullParserException(null, parser, e);
            }
        }
        return parser;
    }

    public static XmlPullParser instantiateParser(String name) throws XmlPullParserException {
        if (sParserFactory == null) {
            throw new XmlPullParserException("ParserFactory not initialized.");
        }
        XmlPullParser parser = sParserFactory.createParser(name);
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        return parser;
    }

    private static InputStream readAndClose(InputStream stream, String name, long size) throws XmlPullParserException {
        ByteArrayInputStream byteArrayInputStream;
        if (size > Integer.MAX_VALUE) {
            throw new XmlPullParserException("File " + name + " is too big to be parsed");
        }
        int intSize = (int)size;
        BufferedInputStream bufferedStream = new BufferedInputStream(stream);
        try {
            int avail = intSize != -1 ? intSize : bufferedStream.available();
            byte[] buffer = new byte[avail];
            int read = stream.read(buffer);
            if (read == intSize) {
                ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(buffer);
                return byteArrayInputStream2;
            }
            while ((avail = bufferedStream.available()) > 0) {
                if (read + avail > buffer.length) {
                    byte[] moreBuffer = new byte[read + avail];
                    System.arraycopy(buffer, 0, moreBuffer, 0, read);
                    buffer = moreBuffer;
                }
                read += stream.read(buffer, read, avail);
            }
            byteArrayInputStream = new ByteArrayInputStream(buffer);
        }
        catch (IOException e) {
            throw new XmlPullParserException("Failed to read " + name, null, e);
        }
        finally {
            try {
                bufferedStream.close();
            }
            catch (IOException iOException) {}
        }
        return byteArrayInputStream;
    }
}

