/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;
import java.util.ArrayList;

public class OverflowMenuAdapter
extends BaseAdapter {
    private final MenuBuilder mMenu;
    private int mExpandedIndex = -1;
    private final Context context;

    public OverflowMenuAdapter(MenuBuilder menu2, Context context) {
        this.mMenu = menu2;
        this.findExpandedIndex();
        this.context = context;
    }

    @Override
    public int getCount() {
        ArrayList<MenuItemImpl> items = this.mMenu.getNonActionItems();
        if (this.mExpandedIndex < 0) {
            return items.size();
        }
        return items.size() - 1;
    }

    @Override
    public MenuItemImpl getItem(int position) {
        ArrayList<MenuItemImpl> items = this.mMenu.getNonActionItems();
        if (this.mExpandedIndex >= 0 && position >= this.mExpandedIndex) {
            ++position;
        }
        return items.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            LayoutInflater mInflater = LayoutInflater.from(this.context);
            convertView = mInflater.inflate(17367201, parent, false);
        }
        MenuView.ItemView itemView = (MenuView.ItemView)((Object)convertView);
        itemView.initialize(this.getItem(position), 0);
        return convertView;
    }

    private void findExpandedIndex() {
        MenuItemImpl expandedItem = this.mMenu.getExpandedItem();
        if (expandedItem != null) {
            ArrayList<MenuItemImpl> items = this.mMenu.getNonActionItems();
            int count = items.size();
            for (int i = 0; i < count; ++i) {
                MenuItemImpl item = items.get(i);
                if (item != expandedItem) continue;
                this.mExpandedIndex = i;
                return;
            }
        }
    }
}

