/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.android.ide.common.rendering.api.ActionBarCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.layoutlib.bridge.android.BridgeContext;

public abstract class BridgeActionBar {
    protected final BridgeContext mBridgeContext;
    protected final SessionParams mParams;
    protected final ViewGroup mEnclosingLayout;
    private final View mDecorContent;
    private final ActionBarCallback mCallback;
    private FrameLayout mContentRoot;

    public BridgeActionBar(BridgeContext context, SessionParams params) {
        this.mBridgeContext = context;
        this.mParams = params;
        this.mCallback = params.getLayoutlibCallback().getActionBarCallback();
        ResourceValue layoutName = this.getLayoutResource(context);
        if (layoutName == null) {
            throw new RuntimeException("Unable to find the layout for Action Bar.");
        }
        int layoutId = layoutName.isFramework() ? context.getFrameworkResourceValue(layoutName.getResourceType(), layoutName.getName(), 0) : context.getProjectResourceValue(layoutName.getResourceType(), layoutName.getName(), 0);
        if (layoutId == 0) {
            throw new RuntimeException(String.format("Unable to resolve attribute \"%1$s\" of type \"%2$s\"", layoutName.getName(), layoutName.getResourceType()));
        }
        if (this.mCallback.isOverflowPopupNeeded()) {
            this.mEnclosingLayout = new RelativeLayout(this.mBridgeContext);
            BridgeActionBar.setMatchParent(this.mEnclosingLayout);
        } else {
            this.mEnclosingLayout = null;
        }
        this.mDecorContent = this.getInflater(context).inflate(layoutId, this.mEnclosingLayout, this.mEnclosingLayout != null);
    }

    protected abstract ResourceValue getLayoutResource(BridgeContext var1);

    protected LayoutInflater getInflater(BridgeContext context) {
        return LayoutInflater.from(context);
    }

    protected void setContentRoot(FrameLayout contentRoot) {
        this.mContentRoot = contentRoot;
    }

    public FrameLayout getContentRoot() {
        return this.mContentRoot;
    }

    protected View getDecorContent() {
        return this.mDecorContent;
    }

    protected void setupActionBar() {
        this.setTitle();
        this.setSutTitle();
        this.setIcon();
        this.setHomeAsUp(this.mCallback.getHomeButtonStyle() == ActionBarCallback.HomeButtonStyle.SHOW_HOME_AS_UP);
    }

    protected abstract void setTitle(CharSequence var1);

    protected abstract void setSubtitle(CharSequence var1);

    protected abstract void setIcon(String var1);

    protected abstract void setHomeAsUp(boolean var1);

    private void setTitle() {
        String title;
        RenderResources res = this.mBridgeContext.getRenderResources();
        ResourceValue titleValue = res.findResValue(title = this.mParams.getAppLabel(), false);
        if (titleValue != null && titleValue.getValue() != null) {
            this.setTitle(titleValue.getValue());
        } else {
            this.setTitle(title);
        }
    }

    private void setSutTitle() {
        String subTitle = this.mCallback.getSubTitle();
        if (subTitle != null) {
            this.setSubtitle(subTitle);
        }
    }

    private void setIcon() {
        String appIcon = this.mParams.getAppIcon();
        if (appIcon != null) {
            this.setIcon(appIcon);
        }
    }

    public abstract void createMenuPopup();

    public View getRootView() {
        return this.mEnclosingLayout == null ? this.mDecorContent : this.mEnclosingLayout;
    }

    public ActionBarCallback getCallBack() {
        return this.mCallback;
    }

    protected static void setMatchParent(View view) {
        view.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
    }
}

