/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.bars.BridgeActionBar;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.ResourceType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AppCompatActionBar
extends BridgeActionBar {
    private Object mWindowDecorActionBar;
    private static final String WINDOW_ACTION_BAR_CLASS = "android.support.v7.internal.app.WindowDecorActionBar";
    private static final String WINDOW_ACTION_BAR_CLASS_NEW = "android.support.v7.app.WindowDecorActionBar";
    private Class<?> mWindowActionBarClass;

    public AppCompatActionBar(BridgeContext context, SessionParams params) {
        super(context, params);
        int contentRootId = context.getProjectResourceValue(ResourceType.ID, "action_bar_activity_content", 0);
        View contentView = this.getDecorContent().findViewById(contentRootId);
        if (contentView != null) {
            assert (contentView instanceof FrameLayout);
            this.setContentRoot((FrameLayout)contentView);
        } else {
            FrameLayout contentRoot = new FrameLayout(context);
            AppCompatActionBar.setMatchParent(contentRoot);
            if (this.mEnclosingLayout != null) {
                this.mEnclosingLayout.addView(contentRoot);
            }
            this.setContentRoot(contentRoot);
        }
        try {
            Class[] constructorParams = new Class[]{View.class};
            Object[] constructorArgs = new Object[]{this.getDecorContent()};
            LayoutlibCallback callback = params.getLayoutlibCallback();
            String actionBarClass = WINDOW_ACTION_BAR_CLASS;
            try {
                callback.findClass(actionBarClass);
            }
            catch (ClassNotFoundException expected) {
                actionBarClass = WINDOW_ACTION_BAR_CLASS_NEW;
            }
            this.mWindowDecorActionBar = callback.loadView(actionBarClass, constructorParams, constructorArgs);
            this.mWindowActionBarClass = this.mWindowDecorActionBar == null ? null : this.mWindowDecorActionBar.getClass();
            this.setupActionBar();
        }
        catch (Exception e) {
            Bridge.getLog().warning("broken", "Failed to load AppCompat ActionBar with unknown error.", (Object)e);
        }
    }

    @Override
    protected ResourceValue getLayoutResource(BridgeContext context) {
        return context.getRenderResources().getProjectResource(ResourceType.LAYOUT, "abc_screen_toolbar");
    }

    @Override
    protected LayoutInflater getInflater(BridgeContext context) {
        int styleId;
        Context themedContext = context;
        RenderResources resources = context.getRenderResources();
        ResourceValue actionBarTheme = resources.findItemInTheme("actionBarTheme", false);
        if (actionBarTheme != null) {
            actionBarTheme = resources.resolveResValue(actionBarTheme);
        }
        if (actionBarTheme instanceof StyleResourceValue && (styleId = context.getDynamicIdByStyle((StyleResourceValue)actionBarTheme)) != 0) {
            themedContext = new ContextThemeWrapper((Context)context, styleId);
        }
        return LayoutInflater.from(themedContext);
    }

    @Override
    protected void setTitle(CharSequence title) {
        if (title != null && this.mWindowDecorActionBar != null) {
            Method setTitle = AppCompatActionBar.getMethod(this.mWindowActionBarClass, "setTitle", CharSequence.class);
            AppCompatActionBar.invoke(setTitle, this.mWindowDecorActionBar, title);
        }
    }

    @Override
    protected void setSubtitle(CharSequence subtitle) {
        if (subtitle != null && this.mWindowDecorActionBar != null) {
            Method setSubtitle = AppCompatActionBar.getMethod(this.mWindowActionBarClass, "setSubtitle", CharSequence.class);
            AppCompatActionBar.invoke(setSubtitle, this.mWindowDecorActionBar, subtitle);
        }
    }

    @Override
    protected void setIcon(String icon) {
        Drawable iconDrawable;
        if (icon != null && !icon.isEmpty() && this.mWindowDecorActionBar != null && AppCompatActionBar.invoke(AppCompatActionBar.getMethod(this.mWindowActionBarClass, "hasIcon", new Class[0]), this.mWindowDecorActionBar, new Object[0]) == Boolean.TRUE && (iconDrawable = this.getDrawable(icon, false)) != null) {
            Method setIcon = AppCompatActionBar.getMethod(this.mWindowActionBarClass, "setIcon", Drawable.class);
            AppCompatActionBar.invoke(setIcon, this.mWindowDecorActionBar, iconDrawable);
        }
    }

    @Override
    protected void setHomeAsUp(boolean homeAsUp) {
        if (this.mWindowDecorActionBar != null) {
            Method setHomeAsUp = AppCompatActionBar.getMethod(this.mWindowActionBarClass, "setDefaultDisplayHomeAsUpEnabled", Boolean.TYPE);
            AppCompatActionBar.invoke(setHomeAsUp, this.mWindowDecorActionBar, homeAsUp);
        }
    }

    @Override
    public void createMenuPopup() {
    }

    private static Method getMethod(Class<?> owner, String name, Class<?> ... parameterTypes) {
        try {
            return owner == null ? null : owner.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object invoke(Method method, Object owner, Object ... args) {
        try {
            return method == null ? null : method.invoke(owner, args);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Drawable getDrawable(String name, boolean isFramework) {
        RenderResources res = this.mBridgeContext.getRenderResources();
        ResourceValue value = res.findResValue(name, isFramework);
        if ((value = res.resolveResValue(value)) != null) {
            return ResourceHelper.getDrawable(value, this.mBridgeContext);
        }
        return null;
    }
}

