/*
 * Decompiled with CFR 0.152.
 */
package com.android.framework.protobuf.nano;

import com.android.framework.protobuf.nano.FieldData;

public class FieldArray
implements Cloneable {
    private static final FieldData DELETED = new FieldData();
    private boolean mGarbage = false;
    private int[] mFieldNumbers;
    private FieldData[] mData;
    private int mSize;

    FieldArray() {
        this(10);
    }

    FieldArray(int initialCapacity) {
        initialCapacity = this.idealIntArraySize(initialCapacity);
        this.mFieldNumbers = new int[initialCapacity];
        this.mData = new FieldData[initialCapacity];
        this.mSize = 0;
    }

    FieldData get(int fieldNumber) {
        int i = this.binarySearch(fieldNumber);
        if (i < 0 || this.mData[i] == DELETED) {
            return null;
        }
        return this.mData[i];
    }

    void remove(int fieldNumber) {
        int i = this.binarySearch(fieldNumber);
        if (i >= 0 && this.mData[i] != DELETED) {
            this.mData[i] = DELETED;
            this.mGarbage = true;
        }
    }

    private void gc() {
        int n = this.mSize;
        int o = 0;
        int[] keys = this.mFieldNumbers;
        FieldData[] values = this.mData;
        for (int i = 0; i < n; ++i) {
            FieldData val = values[i];
            if (val == DELETED) continue;
            if (i != o) {
                keys[o] = keys[i];
                values[o] = val;
                values[i] = null;
            }
            ++o;
        }
        this.mGarbage = false;
        this.mSize = o;
    }

    void put(int fieldNumber, FieldData data) {
        int i = this.binarySearch(fieldNumber);
        if (i >= 0) {
            this.mData[i] = data;
        } else {
            if ((i ^= 0xFFFFFFFF) < this.mSize && this.mData[i] == DELETED) {
                this.mFieldNumbers[i] = fieldNumber;
                this.mData[i] = data;
                return;
            }
            if (this.mGarbage && this.mSize >= this.mFieldNumbers.length) {
                this.gc();
                i = ~this.binarySearch(fieldNumber);
            }
            if (this.mSize >= this.mFieldNumbers.length) {
                int n = this.idealIntArraySize(this.mSize + 1);
                int[] nkeys = new int[n];
                FieldData[] nvalues = new FieldData[n];
                System.arraycopy(this.mFieldNumbers, 0, nkeys, 0, this.mFieldNumbers.length);
                System.arraycopy(this.mData, 0, nvalues, 0, this.mData.length);
                this.mFieldNumbers = nkeys;
                this.mData = nvalues;
            }
            if (this.mSize - i != 0) {
                System.arraycopy(this.mFieldNumbers, i, this.mFieldNumbers, i + 1, this.mSize - i);
                System.arraycopy(this.mData, i, this.mData, i + 1, this.mSize - i);
            }
            this.mFieldNumbers[i] = fieldNumber;
            this.mData[i] = data;
            ++this.mSize;
        }
    }

    int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    FieldData dataAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mData[index];
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldArray)) {
            return false;
        }
        FieldArray other = (FieldArray)o;
        if (this.size() != other.size()) {
            return false;
        }
        return this.arrayEquals(this.mFieldNumbers, other.mFieldNumbers, this.mSize) && this.arrayEquals(this.mData, other.mData, this.mSize);
    }

    public int hashCode() {
        if (this.mGarbage) {
            this.gc();
        }
        int result = 17;
        for (int i = 0; i < this.mSize; ++i) {
            result = 31 * result + this.mFieldNumbers[i];
            result = 31 * result + this.mData[i].hashCode();
        }
        return result;
    }

    private int idealIntArraySize(int need) {
        return this.idealByteArraySize(need * 4) / 4;
    }

    private int idealByteArraySize(int need) {
        for (int i = 4; i < 32; ++i) {
            if (need > (1 << i) - 12) continue;
            return (1 << i) - 12;
        }
        return need;
    }

    private int binarySearch(int value) {
        int lo = 0;
        int hi = this.mSize - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int midVal = this.mFieldNumbers[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    private boolean arrayEquals(int[] a, int[] b, int size) {
        for (int i = 0; i < size; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private boolean arrayEquals(FieldData[] a, FieldData[] b, int size) {
        for (int i = 0; i < size; ++i) {
            if (a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    public FieldArray clone() {
        int size = this.size();
        FieldArray clone = new FieldArray(size);
        System.arraycopy(this.mFieldNumbers, 0, clone.mFieldNumbers, 0, size);
        for (int i = 0; i < size; ++i) {
            if (this.mData[i] == null) continue;
            clone.mData[i] = this.mData[i].clone();
        }
        clone.mSize = size;
        return clone;
    }
}

