/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.ActivityManagerInternal;
import android.app.ActivityManagerNative;
import android.app.AppGlobals;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemProperties;
import android.os.Trace;
import android.text.TextUtils;
import android.util.AndroidRuntimeException;
import android.util.ArraySet;
import android.util.Log;
import android.webkit.IWebViewUpdateService;
import android.webkit.WebViewDelegate;
import android.webkit.WebViewFactoryProvider;
import android.webkit.WebViewProviderResponse;
import com.android.server.LocalServices;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class WebViewFactory {
    private static final String CHROMIUM_WEBVIEW_FACTORY = "com.android.webview.chromium.WebViewChromiumFactoryProvider";
    private static final String NULL_WEBVIEW_FACTORY = "com.android.webview.nullwebview.NullWebViewFactoryProvider";
    private static final String CHROMIUM_WEBVIEW_NATIVE_RELRO_32 = "/data/misc/shared_relro/libwebviewchromium32.relro";
    private static final String CHROMIUM_WEBVIEW_NATIVE_RELRO_64 = "/data/misc/shared_relro/libwebviewchromium64.relro";
    public static final String CHROMIUM_WEBVIEW_VMSIZE_SIZE_PROPERTY = "persist.sys.webview.vmsize";
    private static final long CHROMIUM_WEBVIEW_DEFAULT_VMSIZE_BYTES = 0x6400000L;
    private static final String LOGTAG = "WebViewFactory";
    private static final boolean DEBUG = false;
    private static WebViewFactoryProvider sProviderInstance;
    private static final Object sProviderLock;
    private static boolean sAddressSpaceReserved;
    private static PackageInfo sPackageInfo;
    public static final int LIBLOAD_SUCCESS = 0;
    public static final int LIBLOAD_WRONG_PACKAGE_NAME = 1;
    public static final int LIBLOAD_ADDRESS_SPACE_NOT_RESERVED = 2;
    public static final int LIBLOAD_FAILED_WAITING_FOR_RELRO = 3;
    public static final int LIBLOAD_FAILED_LISTING_WEBVIEW_PACKAGES = 4;
    public static final int LIBLOAD_FAILED_TO_OPEN_RELRO_FILE = 5;
    public static final int LIBLOAD_FAILED_TO_LOAD_LIBRARY = 6;
    public static final int LIBLOAD_FAILED_JNI_CALL = 7;
    public static final int LIBLOAD_FAILED_WAITING_FOR_WEBVIEW_REASON_UNKNOWN = 8;
    public static final int LIBLOAD_FAILED_TO_FIND_NAMESPACE = 10;
    private static String WEBVIEW_UPDATE_SERVICE_NAME;

    private static String getWebViewPreparationErrorReason(int error) {
        switch (error) {
            case 3: {
                return "Time out waiting for Relro files being created";
            }
            case 4: {
                return "No WebView installed";
            }
            case 8: {
                return "Crashed for unknown reason";
            }
        }
        return "Unknown";
    }

    public static String getWebViewLibrary(ApplicationInfo ai) {
        if (ai.metaData != null) {
            return ai.metaData.getString("com.android.webview.WebViewLibrary");
        }
        return null;
    }

    public static PackageInfo getLoadedPackageInfo() {
        return sPackageInfo;
    }

    public static int loadWebViewNativeLibraryFromPackage(String packageName, ClassLoader clazzLoader) {
        PackageInfo packageInfo;
        WebViewProviderResponse response = null;
        try {
            response = WebViewFactory.getUpdateService().waitForAndGetProvider();
        }
        catch (RemoteException e) {
            Log.e(LOGTAG, "error waiting for relro creation", e);
            return 8;
        }
        if (response.status != 0 && response.status != 3) {
            return response.status;
        }
        if (!response.packageInfo.packageName.equals(packageName)) {
            return 1;
        }
        PackageManager packageManager = AppGlobals.getInitialApplication().getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 0x10000080);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(LOGTAG, "Couldn't find package " + packageName);
            return 1;
        }
        sPackageInfo = packageInfo;
        int loadNativeRet = WebViewFactory.loadNativeLibrary(clazzLoader);
        if (loadNativeRet == 0) {
            return response.status;
        }
        return loadNativeRet;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    static WebViewFactoryProvider getProvider() {
        Object object = sProviderLock;
        synchronized (object) {
            if (sProviderInstance != null) {
                return sProviderInstance;
            }
            int uid = Process.myUid();
            if (uid == 0 || uid == 1000) {
                throw new UnsupportedOperationException("For security reasons, WebView is not allowed in privileged processes");
            }
            StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
            Trace.traceBegin(16L, "WebViewFactory.getProvider()");
            try {
                WebViewFactoryProvider webViewFactoryProvider;
                Class<WebViewFactoryProvider> providerClass = WebViewFactory.getProviderClass();
                Trace.traceBegin(16L, "providerClass.newInstance()");
                try {
                    webViewFactoryProvider = sProviderInstance = providerClass.getConstructor(WebViewDelegate.class).newInstance(new WebViewDelegate());
                }
                catch (Exception e) {
                    Log.e(LOGTAG, "error instantiating provider", e);
                    throw new AndroidRuntimeException(e);
                }
                finally {
                    Trace.traceEnd(16L);
                }
                return webViewFactoryProvider;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Trace.traceEnd(16L);
                StrictMode.setThreadPolicy(oldPolicy);
            }
        }
    }

    private static boolean signaturesEquals(Signature[] s1, Signature[] s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        ArraySet<Signature> set1 = new ArraySet<Signature>();
        for (Signature signature : s1) {
            set1.add(signature);
        }
        ArraySet<Signature> set2 = new ArraySet<Signature>();
        for (Signature signature : s2) {
            set2.add(signature);
        }
        return set1.equals(set2);
    }

    private static void verifyPackageInfo(PackageInfo chosen, PackageInfo toUse) {
        if (!chosen.packageName.equals(toUse.packageName)) {
            throw new MissingWebViewPackageException("Failed to verify WebView provider, packageName mismatch, expected: " + chosen.packageName + " actual: " + toUse.packageName);
        }
        if (chosen.versionCode > toUse.versionCode) {
            throw new MissingWebViewPackageException("Failed to verify WebView provider, version code is lower than expected: " + chosen.versionCode + " actual: " + toUse.versionCode);
        }
        if (WebViewFactory.getWebViewLibrary(toUse.applicationInfo) == null) {
            throw new MissingWebViewPackageException("Tried to load an invalid WebView provider: " + toUse.packageName);
        }
        if (!WebViewFactory.signaturesEquals(chosen.signatures, toUse.signatures)) {
            throw new MissingWebViewPackageException("Failed to verify WebView provider, signature mismatch");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Context getWebViewContextAndSetProvider() {
        Context context;
        Application initialApplication = AppGlobals.getInitialApplication();
        WebViewProviderResponse response = null;
        Trace.traceBegin(16L, "WebViewUpdateService.waitForAndGetProvider()");
        try {
            response = WebViewFactory.getUpdateService().waitForAndGetProvider();
        }
        finally {
            Trace.traceEnd(16L);
        }
        if (response.status != 0 && response.status != 3) {
            throw new MissingWebViewPackageException("Failed to load WebView provider: " + WebViewFactory.getWebViewPreparationErrorReason(response.status));
        }
        Trace.traceBegin(16L, "ActivityManager.addPackageDependency()");
        try {
            ActivityManagerNative.getDefault().addPackageDependency(response.packageInfo.packageName);
        }
        finally {
            Trace.traceEnd(16L);
        }
        PackageInfo newPackageInfo = null;
        Trace.traceBegin(16L, "PackageManager.getPackageInfo()");
        try {
            newPackageInfo = initialApplication.getPackageManager().getPackageInfo(response.packageInfo.packageName, 268444864);
        }
        finally {
            Trace.traceEnd(16L);
        }
        WebViewFactory.verifyPackageInfo(response.packageInfo, newPackageInfo);
        Trace.traceBegin(16L, "initialApplication.createApplicationContext");
        try {
            Context webViewContext = initialApplication.createApplicationContext(newPackageInfo.applicationInfo, 3);
            sPackageInfo = newPackageInfo;
            context = webViewContext;
        }
        catch (Throwable throwable) {
            try {
                Trace.traceEnd(16L);
                throw throwable;
            }
            catch (PackageManager.NameNotFoundException | RemoteException e) {
                throw new MissingWebViewPackageException("Failed to load WebView provider: " + e);
            }
        }
        Trace.traceEnd(16L);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static Class<WebViewFactoryProvider> getProviderClass() {
        Context webViewContext = null;
        Application initialApplication = AppGlobals.getInitialApplication();
        try {
            Trace.traceBegin(16L, "WebViewFactory.getWebViewContextAndSetProvider()");
            try {
                webViewContext = WebViewFactory.getWebViewContextAndSetProvider();
            }
            finally {
                Trace.traceEnd(16L);
            }
            Log.i(LOGTAG, "Loading " + WebViewFactory.sPackageInfo.packageName + " version " + WebViewFactory.sPackageInfo.versionName + " (code " + WebViewFactory.sPackageInfo.versionCode + ")");
            Trace.traceBegin(16L, "WebViewFactory.getChromiumProviderClass()");
            try {
                Class<WebViewFactoryProvider> clazz;
                initialApplication.getAssets().addAssetPathAsSharedLibrary(webViewContext.getApplicationInfo().sourceDir);
                ClassLoader clazzLoader = webViewContext.getClassLoader();
                Trace.traceBegin(16L, "WebViewFactory.loadNativeLibrary()");
                WebViewFactory.loadNativeLibrary(clazzLoader);
                Trace.traceEnd(16L);
                Trace.traceBegin(16L, "Class.forName()");
                try {
                    clazz = Class.forName(CHROMIUM_WEBVIEW_FACTORY, true, clazzLoader);
                }
                catch (Throwable throwable) {
                    try {
                        Trace.traceEnd(16L);
                        throw throwable;
                    }
                    catch (ClassNotFoundException e) {
                        Log.e(LOGTAG, "error loading provider", e);
                        throw new AndroidRuntimeException(e);
                    }
                }
                Trace.traceEnd(16L);
                return clazz;
            }
            finally {
                Trace.traceEnd(16L);
            }
        }
        catch (MissingWebViewPackageException e) {
            try {
                return Class.forName(NULL_WEBVIEW_FACTORY);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Log.e(LOGTAG, "Chromium WebView package does not exist", e);
                throw new AndroidRuntimeException(e);
            }
        }
    }

    public static void prepareWebViewInZygote() {
        try {
            System.loadLibrary("webviewchromium_loader");
            long addressSpaceToReserve = SystemProperties.getLong(CHROMIUM_WEBVIEW_VMSIZE_SIZE_PROPERTY, 0x6400000L);
            sAddressSpaceReserved = WebViewFactory.nativeReserveAddressSpace(addressSpaceToReserve);
            if (!sAddressSpaceReserved) {
                Log.e(LOGTAG, "reserving " + addressSpaceToReserve + " bytes of address space failed");
            }
        }
        catch (Throwable t) {
            Log.e(LOGTAG, "error preparing native loader", t);
        }
    }

    private static int prepareWebViewInSystemServer(String[] nativeLibraryPaths) {
        int numRelros = 0;
        if (Build.SUPPORTED_32_BIT_ABIS.length > 0) {
            WebViewFactory.createRelroFile(false, nativeLibraryPaths);
            ++numRelros;
        }
        if (Build.SUPPORTED_64_BIT_ABIS.length > 0) {
            WebViewFactory.createRelroFile(true, nativeLibraryPaths);
            ++numRelros;
        }
        return numRelros;
    }

    public static int onWebViewProviderChanged(PackageInfo packageInfo) {
        String[] nativeLibs;
        block22: {
            nativeLibs = null;
            try {
                nativeLibs = WebViewFactory.getWebViewNativeLibraryPaths(packageInfo);
                if (nativeLibs == null) break block22;
                long newVmSize = 0L;
                for (String path : nativeLibs) {
                    String[] split;
                    if (path == null || TextUtils.isEmpty(path)) continue;
                    File f = new File(path);
                    if (f.exists()) {
                        newVmSize = Math.max(newVmSize, f.length());
                        continue;
                    }
                    if (path.contains("!/") && (split = TextUtils.split(path, "!/")).length == 2) {
                        try (ZipFile z = new ZipFile(split[0]);){
                            ZipEntry e = z.getEntry(split[1]);
                            if (e != null && e.getMethod() == 0) {
                                newVmSize = Math.max(newVmSize, e.getSize());
                                continue;
                            }
                        }
                        catch (IOException e) {
                            Log.e(LOGTAG, "error reading APK file " + split[0] + ", ", e);
                        }
                    }
                    Log.e(LOGTAG, "error sizing load for " + path);
                }
                newVmSize = Math.max(2L * newVmSize, 0x6400000L);
                Log.d(LOGTAG, "Setting new address space to " + newVmSize);
                SystemProperties.set(CHROMIUM_WEBVIEW_VMSIZE_SIZE_PROPERTY, Long.toString(newVmSize));
            }
            catch (Throwable t) {
                Log.e(LOGTAG, "error preparing webview native library", t);
            }
        }
        return WebViewFactory.prepareWebViewInSystemServer(nativeLibs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getLoadFromApkPath(String apkPath, String[] abiList, String nativeLibFileName) {
        try (ZipFile z = new ZipFile(apkPath);){
            String[] stringArray = abiList;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String abi = stringArray[n2];
                String entry = "lib/" + abi + "/" + nativeLibFileName;
                ZipEntry e = z.getEntry(entry);
                if (e != null && e.getMethod() == 0) {
                    String string2 = apkPath + "!/" + entry;
                    return string2;
                }
                ++n2;
            }
            return "";
        }
        catch (IOException e) {
            throw new MissingWebViewPackageException(e);
        }
    }

    private static String[] getWebViewNativeLibraryPaths(PackageInfo packageInfo) {
        File f;
        String path32;
        String path64;
        ApplicationInfo ai = packageInfo.applicationInfo;
        String NATIVE_LIB_FILE_NAME = WebViewFactory.getWebViewLibrary(ai);
        boolean primaryArchIs64bit = VMRuntime.is64BitAbi(ai.primaryCpuAbi);
        if (!TextUtils.isEmpty(ai.secondaryCpuAbi)) {
            if (primaryArchIs64bit) {
                path64 = ai.nativeLibraryDir;
                path32 = ai.secondaryNativeLibraryDir;
            } else {
                path64 = ai.secondaryNativeLibraryDir;
                path32 = ai.nativeLibraryDir;
            }
        } else if (primaryArchIs64bit) {
            path64 = ai.nativeLibraryDir;
            path32 = "";
        } else {
            path32 = ai.nativeLibraryDir;
            path64 = "";
        }
        if (!TextUtils.isEmpty(path32) && !(f = new File(path32 = path32 + "/" + NATIVE_LIB_FILE_NAME)).exists()) {
            path32 = WebViewFactory.getLoadFromApkPath(ai.sourceDir, Build.SUPPORTED_32_BIT_ABIS, NATIVE_LIB_FILE_NAME);
        }
        if (!TextUtils.isEmpty(path64) && !(f = new File(path64 = path64 + "/" + NATIVE_LIB_FILE_NAME)).exists()) {
            path64 = WebViewFactory.getLoadFromApkPath(ai.sourceDir, Build.SUPPORTED_64_BIT_ABIS, NATIVE_LIB_FILE_NAME);
        }
        return new String[]{path32, path64};
    }

    private static void createRelroFile(boolean is64Bit, String[] nativeLibraryPaths) {
        final String abi = is64Bit ? Build.SUPPORTED_64_BIT_ABIS[0] : Build.SUPPORTED_32_BIT_ABIS[0];
        Runnable crashHandler = new Runnable(){

            @Override
            public void run() {
                try {
                    Log.e(WebViewFactory.LOGTAG, "relro file creator for " + abi + " crashed. Proceeding without");
                    WebViewFactory.getUpdateService().notifyRelroCreationCompleted();
                }
                catch (RemoteException e) {
                    Log.e(WebViewFactory.LOGTAG, "Cannot reach WebViewUpdateService. " + e.getMessage());
                }
            }
        };
        try {
            if (nativeLibraryPaths == null || nativeLibraryPaths[0] == null || nativeLibraryPaths[1] == null) {
                throw new IllegalArgumentException("Native library paths to the WebView RelRo process must not be null!");
            }
            int pid = LocalServices.getService(ActivityManagerInternal.class).startIsolatedProcess(RelroFileCreator.class.getName(), nativeLibraryPaths, "WebViewLoader-" + abi, abi, 1037, crashHandler);
            if (pid <= 0) {
                throw new Exception("Failed to start the relro file creator process");
            }
        }
        catch (Throwable t) {
            Log.e(LOGTAG, "error starting relro file creator for abi " + abi, t);
            crashHandler.run();
        }
    }

    private static int loadNativeLibrary(ClassLoader clazzLoader) {
        if (!sAddressSpaceReserved) {
            Log.e(LOGTAG, "can't load with relro file; address space not reserved");
            return 2;
        }
        String[] args = WebViewFactory.getWebViewNativeLibraryPaths(sPackageInfo);
        int result = WebViewFactory.nativeLoadWithRelroFile(args[0], args[1], CHROMIUM_WEBVIEW_NATIVE_RELRO_32, CHROMIUM_WEBVIEW_NATIVE_RELRO_64, clazzLoader);
        if (result != 0) {
            Log.w(LOGTAG, "failed to load with relro file, proceeding without");
        }
        return result;
    }

    public static IWebViewUpdateService getUpdateService() {
        return IWebViewUpdateService.Stub.asInterface(ServiceManager.getService(WEBVIEW_UPDATE_SERVICE_NAME));
    }

    private static boolean nativeReserveAddressSpace(long l) {
        return OverrideMethod.invokeI("android.webkit.WebViewFactory#nativeReserveAddressSpace(J)Z", true, null) != 0;
    }

    private static boolean nativeCreateRelroFile(String string2, String string3, String string4, String string5) {
        return OverrideMethod.invokeI("android.webkit.WebViewFactory#nativeCreateRelroFile(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z", true, null) != 0;
    }

    private static int nativeLoadWithRelroFile(String string2, String string3, String string4, String string5, ClassLoader classLoader) {
        return OverrideMethod.invokeI("android.webkit.WebViewFactory#nativeLoadWithRelroFile(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/ClassLoader;)I", true, null);
    }

    static {
        sProviderLock = new Object();
        sAddressSpaceReserved = false;
        WEBVIEW_UPDATE_SERVICE_NAME = "webviewupdate";
    }

    private static class RelroFileCreator {
        private RelroFileCreator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            boolean result = false;
            boolean is64Bit = VMRuntime.getRuntime().is64Bit();
            try {
                if (args.length != 2 || args[0] == null || args[1] == null) {
                    Log.e(WebViewFactory.LOGTAG, "Invalid RelroFileCreator args: " + Arrays.toString(args));
                    return;
                }
                Log.v(WebViewFactory.LOGTAG, "RelroFileCreator (64bit = " + is64Bit + "), " + " 32-bit lib: " + args[0] + ", 64-bit lib: " + args[1]);
                if (!sAddressSpaceReserved) {
                    Log.e(WebViewFactory.LOGTAG, "can't create relro file; address space not reserved");
                    return;
                }
                result = WebViewFactory.nativeCreateRelroFile(args[0], args[1], WebViewFactory.CHROMIUM_WEBVIEW_NATIVE_RELRO_32, WebViewFactory.CHROMIUM_WEBVIEW_NATIVE_RELRO_64);
                if (result) {
                    // empty if block
                }
            }
            finally {
                try {
                    WebViewFactory.getUpdateService().notifyRelroCreationCompleted();
                }
                catch (RemoteException e) {
                    Log.e(WebViewFactory.LOGTAG, "error notifying update service", e);
                }
                if (!result) {
                    Log.e(WebViewFactory.LOGTAG, "failed to create relro file");
                }
                System.exit(0);
            }
        }
    }

    public static class MissingWebViewPackageException
    extends AndroidRuntimeException {
        public MissingWebViewPackageException(String message) {
            super(message);
        }

        public MissingWebViewPackageException(Exception e) {
            super(e);
        }
    }
}

