/*
 * Decompiled with CFR 0.152.
 */
package android.view.textservice;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.SpellCheckSpan;

public class TextInfo
implements Parcelable {
    private final CharSequence mCharSequence;
    private final int mCookie;
    private final int mSequenceNumber;
    private static final int DEFAULT_COOKIE = 0;
    private static final int DEFAULT_SEQUENCE_NUMBER = 0;
    public static final Parcelable.Creator<TextInfo> CREATOR = new Parcelable.Creator<TextInfo>(){

        @Override
        public TextInfo createFromParcel(Parcel source) {
            return new TextInfo(source);
        }

        public TextInfo[] newArray(int size) {
            return new TextInfo[size];
        }
    };

    public TextInfo(String text) {
        this(text, 0, TextInfo.getStringLengthOrZero(text), 0, 0);
    }

    public TextInfo(String text, int cookie, int sequenceNumber) {
        this(text, 0, TextInfo.getStringLengthOrZero(text), cookie, sequenceNumber);
    }

    private static int getStringLengthOrZero(String text) {
        return TextUtils.isEmpty(text) ? 0 : text.length();
    }

    public TextInfo(CharSequence charSequence, int start, int end, int cookie, int sequenceNumber) {
        if (TextUtils.isEmpty(charSequence)) {
            throw new IllegalArgumentException("charSequence is empty");
        }
        SpannableStringBuilder spannableString = new SpannableStringBuilder(charSequence, start, end);
        SpellCheckSpan[] spans = spannableString.getSpans(0, spannableString.length(), SpellCheckSpan.class);
        for (int i = 0; i < spans.length; ++i) {
            spannableString.removeSpan(spans[i]);
        }
        this.mCharSequence = spannableString;
        this.mCookie = cookie;
        this.mSequenceNumber = sequenceNumber;
    }

    public TextInfo(Parcel source) {
        this.mCharSequence = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
        this.mCookie = source.readInt();
        this.mSequenceNumber = source.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        TextUtils.writeToParcel(this.mCharSequence, dest, flags);
        dest.writeInt(this.mCookie);
        dest.writeInt(this.mSequenceNumber);
    }

    public String getText() {
        if (this.mCharSequence == null) {
            return null;
        }
        return this.mCharSequence.toString();
    }

    public CharSequence getCharSequence() {
        return this.mCharSequence;
    }

    public int getCookie() {
        return this.mCookie;
    }

    public int getSequence() {
        return this.mSequenceNumber;
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

