/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.LineBreaker;
import android.text.LineWidth;
import android.text.Primitive;
import android.text.StaticLayout;
import android.text.TabStops;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class OptimizingLineBreaker
extends LineBreaker {
    public OptimizingLineBreaker(List<Primitive> primitives, LineWidth lineWidth, TabStops tabStops) {
        super(primitives, lineWidth, tabStops);
    }

    @Override
    public void computeBreaks(StaticLayout.LineBreaks breakInfo) {
        int numBreaks = this.mPrimitives.size();
        assert (numBreaks > 0);
        if (numBreaks == 1) {
            Primitive p = (Primitive)this.mPrimitives.get(0);
            assert (p.type == Primitive.PrimitiveType.PENALTY);
            breakInfo.breaks = new int[]{0};
            breakInfo.widths = new float[]{p.width};
            breakInfo.flags = new int[]{0};
            return;
        }
        Node[] opt = new Node[numBreaks];
        opt[0] = new Node(-1, 0, 0.0f, 0.0f, false);
        opt[numBreaks - 1] = new Node(-1, 0, 0.0f, 0.0f, false);
        ArrayList<Integer> active = new ArrayList<Integer>();
        active.add(0);
        int lastBreak = 0;
        for (int i = 0; i < numBreaks; ++i) {
            Primitive p = (Primitive)this.mPrimitives.get(i);
            if (p.type != Primitive.PrimitiveType.PENALTY) continue;
            boolean finalBreak = i + 1 == numBreaks;
            Node bestBreak = null;
            ListIterator it = active.listIterator();
            while (it.hasNext()) {
                int pos = (Integer)it.next();
                int lines = opt[pos].mPrevCount;
                float maxWidth = this.mLineWidth.getLineWidth(lines);
                LineMetrics lineMetrics = this.computeMetrics(pos, i);
                if (lineMetrics.mPrintedWidth <= maxWidth) {
                    float demerits = OptimizingLineBreaker.computeDemerits(maxWidth, lineMetrics.mPrintedWidth, finalBreak, p.penalty) + opt[pos].mDemerits;
                    if (bestBreak != null && !(demerits < bestBreak.mDemerits)) continue;
                    if (bestBreak == null) {
                        bestBreak = new Node(pos, opt[pos].mPrevCount + 1, demerits, lineMetrics.mPrintedWidth, lineMetrics.mHasTabs);
                        continue;
                    }
                    bestBreak.mPrev = pos;
                    bestBreak.mPrevCount = opt[pos].mPrevCount + 1;
                    bestBreak.mDemerits = demerits;
                    bestBreak.mWidth = lineMetrics.mPrintedWidth;
                    bestBreak.mHasTabs = lineMetrics.mHasTabs;
                    continue;
                }
                it.remove();
            }
            if (p.penalty == -1.0E7f) {
                active.clear();
            }
            if (bestBreak != null) {
                opt[i] = bestBreak;
                active.add(i);
                lastBreak = i;
            }
            if (!active.isEmpty()) continue;
            LineMetrics lineMetrics = new LineMetrics();
            int lines = opt[lastBreak].mPrevCount;
            float maxWidth = this.mLineWidth.getLineWidth(lines);
            int breakIndex = this.desperateBreak(lastBreak, numBreaks, maxWidth, lineMetrics);
            opt[breakIndex] = new Node(lastBreak, lines + 1, 0.0f, lineMetrics.mWidth, lineMetrics.mHasTabs);
            active.add(breakIndex);
            lastBreak = breakIndex;
            i = breakIndex;
        }
        int idx = numBreaks - 1;
        int count = opt[idx].mPrevCount;
        OptimizingLineBreaker.resize(breakInfo, count);
        while (opt[idx].mPrev != -1) {
            assert (--count >= 0);
            breakInfo.breaks[count] = ((Primitive)this.mPrimitives.get((int)idx)).location;
            breakInfo.widths[count] = opt[idx].mWidth;
            breakInfo.flags[count] = opt[idx].mHasTabs ? 0x20000000 : 0;
            idx = opt[idx].mPrev;
        }
    }

    private static void resize(StaticLayout.LineBreaks lineBreaks, int size) {
        if (lineBreaks.breaks.length == size) {
            return;
        }
        int[] breaks = new int[size];
        float[] widths = new float[size];
        int[] flags = new int[size];
        int toCopy = Math.min(size, lineBreaks.breaks.length);
        System.arraycopy(lineBreaks.breaks, 0, breaks, 0, toCopy);
        System.arraycopy(lineBreaks.widths, 0, widths, 0, toCopy);
        System.arraycopy(lineBreaks.flags, 0, flags, 0, toCopy);
        lineBreaks.breaks = breaks;
        lineBreaks.widths = widths;
        lineBreaks.flags = flags;
    }

    private LineMetrics computeMetrics(int start, int end) {
        boolean f = false;
        float w = 0.0f;
        float pw = 0.0f;
        for (int i = start; i < end; ++i) {
            Primitive p = (Primitive)this.mPrimitives.get(i);
            if (p.type == Primitive.PrimitiveType.BOX || p.type == Primitive.PrimitiveType.GLUE) {
                w += p.width;
                if (p.type != Primitive.PrimitiveType.BOX) continue;
                pw = w;
                continue;
            }
            if (p.type != Primitive.PrimitiveType.VARIABLE) continue;
            w = this.mTabStops.width(w);
            f = true;
        }
        return new LineMetrics(w, pw, f);
    }

    private static float computeDemerits(float maxWidth, float width, boolean finalBreak, float penalty) {
        float deviation = finalBreak ? 0.0f : maxWidth - width;
        return deviation * deviation + penalty;
    }

    private int desperateBreak(int start, int limit, float maxWidth, LineMetrics lineMetrics) {
        float w = 0.0f;
        float pw = 0.0f;
        boolean breakFound = false;
        int breakIndex = 0;
        int firstTabIndex = Integer.MAX_VALUE;
        for (int i = start; i < limit; ++i) {
            Primitive p = (Primitive)this.mPrimitives.get(i);
            if (p.type == Primitive.PrimitiveType.BOX || p.type == Primitive.PrimitiveType.GLUE) {
                w += p.width;
                if (p.type == Primitive.PrimitiveType.BOX) {
                    pw = w;
                }
            } else if (p.type == Primitive.PrimitiveType.VARIABLE) {
                w = this.mTabStops.width(w);
                firstTabIndex = Math.min(firstTabIndex, i);
            }
            if (pw > maxWidth && breakFound) break;
            if (i <= start || p.type != Primitive.PrimitiveType.PENALTY && p.type != Primitive.PrimitiveType.WORD_BREAK) continue;
            breakFound = true;
            breakIndex = i;
        }
        if (breakFound) {
            lineMetrics.mWidth = w;
            lineMetrics.mPrintedWidth = pw;
            lineMetrics.mHasTabs = start <= firstTabIndex && firstTabIndex < breakIndex;
            return breakIndex;
        }
        return -1;
    }

    private static class Node {
        int mPrev;
        int mPrevCount;
        float mDemerits;
        float mWidth;
        boolean mHasTabs;

        public Node(int prev, int prevCount, float demerits, float width, boolean hasTabs) {
            this.mPrev = prev;
            this.mPrevCount = prevCount;
            this.mDemerits = demerits;
            this.mWidth = width;
            this.mHasTabs = hasTabs;
        }
    }

    private static class LineMetrics {
        float mWidth;
        float mPrintedWidth;
        boolean mHasTabs;

        public LineMetrics() {
        }

        public LineMetrics(float width, float printedWidth, boolean hasTabs) {
            this.mWidth = width;
            this.mPrintedWidth = printedWidth;
            this.mHasTabs = hasTabs;
        }
    }
}

