/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.app.ActivityThread;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telecom.PhoneAccount;
import android.telecom.PhoneAccountHandle;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.IccOpenLogicalChannelResponse;
import android.telephony.NeighboringCellInfo;
import android.telephony.PhoneStateListener;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.util.Log;
import com.android.internal.telecom.ITelecomService;
import com.android.internal.telephony.CellNetworkScanResult;
import com.android.internal.telephony.IPhoneSubInfo;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.OperatorInfo;
import com.android.internal.telephony.PhoneConstants;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TelephonyManager {
    private static final String TAG = "TelephonyManager";
    public static final String MODEM_ACTIVITY_RESULT_KEY = "controller_activity";
    private static ITelephonyRegistry sRegistry;
    private final Context mContext;
    private final int mSubId;
    private SubscriptionManager mSubscriptionManager;
    private static String multiSimConfig;
    private static TelephonyManager sInstance;
    public static final String ACTION_PHONE_STATE_CHANGED = "android.intent.action.PHONE_STATE";
    public static final String ACTION_RESPOND_VIA_MESSAGE = "android.intent.action.RESPOND_VIA_MESSAGE";
    public static final String ACTION_EMERGENCY_ASSISTANCE = "android.telephony.action.EMERGENCY_ASSISTANCE";
    public static final String ACTION_CONFIGURE_VOICEMAIL = "android.telephony.action.CONFIGURE_VOICEMAIL";
    public static final boolean EMERGENCY_ASSISTANCE_ENABLED = true;
    public static final String EXTRA_STATE = "state";
    public static final String EXTRA_STATE_IDLE;
    public static final String EXTRA_STATE_RINGING;
    public static final String EXTRA_STATE_OFFHOOK;
    public static final String EXTRA_INCOMING_NUMBER = "incoming_number";
    public static final String ACTION_PRECISE_CALL_STATE_CHANGED = "android.intent.action.PRECISE_CALL_STATE";
    public static final String EXTRA_RINGING_CALL_STATE = "ringing_state";
    public static final String EXTRA_FOREGROUND_CALL_STATE = "foreground_state";
    public static final String EXTRA_BACKGROUND_CALL_STATE = "background_state";
    public static final String EXTRA_DISCONNECT_CAUSE = "disconnect_cause";
    public static final String EXTRA_PRECISE_DISCONNECT_CAUSE = "precise_disconnect_cause";
    public static final String ACTION_PRECISE_DATA_CONNECTION_STATE_CHANGED = "android.intent.action.PRECISE_DATA_CONNECTION_STATE_CHANGED";
    public static final String EXTRA_DATA_STATE = "state";
    public static final String EXTRA_DATA_NETWORK_TYPE = "networkType";
    public static final String EXTRA_DATA_APN_TYPE = "apnType";
    public static final String EXTRA_DATA_APN = "apn";
    public static final String EXTRA_DATA_CHANGE_REASON = "reason";
    public static final String EXTRA_DATA_LINK_PROPERTIES_KEY = "linkProperties";
    public static final String EXTRA_DATA_FAILURE_CAUSE = "failCause";
    public static final String ACTION_SHOW_VOICEMAIL_NOTIFICATION = "android.telephony.action.SHOW_VOICEMAIL_NOTIFICATION";
    public static final String EXTRA_NOTIFICATION_COUNT = "android.telephony.extra.NOTIFICATION_COUNT";
    public static final String EXTRA_VOICEMAIL_NUMBER = "android.telephony.extra.VOICEMAIL_NUMBER";
    public static final String EXTRA_CALL_VOICEMAIL_INTENT = "android.telephony.extra.CALL_VOICEMAIL_INTENT";
    public static final String EXTRA_LAUNCH_VOICEMAIL_SETTINGS_INTENT = "android.telephony.extra.LAUNCH_VOICEMAIL_SETTINGS_INTENT";
    public static final int SIM_ACTIVATION_RESULT_COMPLETE = 0;
    public static final int SIM_ACTIVATION_RESULT_NOT_SUPPORTED = 1;
    public static final int SIM_ACTIVATION_RESULT_IN_PROGRESS = 2;
    public static final int SIM_ACTIVATION_RESULT_FAILED = 3;
    public static final int SIM_ACTIVATION_RESULT_CANCELED = 4;
    public static final String VVM_TYPE_OMTP = "vvm_type_omtp";
    public static final String VVM_TYPE_CVVM = "vvm_type_cvvm";
    public static final int PHONE_TYPE_NONE = 0;
    public static final int PHONE_TYPE_GSM = 1;
    public static final int PHONE_TYPE_CDMA = 2;
    public static final int PHONE_TYPE_SIP = 3;
    private static final String sKernelCmdLine;
    private static final Pattern sProductTypePattern;
    private static final String sLteOnCdmaProductType;
    public static final int NETWORK_TYPE_UNKNOWN = 0;
    public static final int NETWORK_TYPE_GPRS = 1;
    public static final int NETWORK_TYPE_EDGE = 2;
    public static final int NETWORK_TYPE_UMTS = 3;
    public static final int NETWORK_TYPE_CDMA = 4;
    public static final int NETWORK_TYPE_EVDO_0 = 5;
    public static final int NETWORK_TYPE_EVDO_A = 6;
    public static final int NETWORK_TYPE_1xRTT = 7;
    public static final int NETWORK_TYPE_HSDPA = 8;
    public static final int NETWORK_TYPE_HSUPA = 9;
    public static final int NETWORK_TYPE_HSPA = 10;
    public static final int NETWORK_TYPE_IDEN = 11;
    public static final int NETWORK_TYPE_EVDO_B = 12;
    public static final int NETWORK_TYPE_LTE = 13;
    public static final int NETWORK_TYPE_EHRPD = 14;
    public static final int NETWORK_TYPE_HSPAP = 15;
    public static final int NETWORK_TYPE_GSM = 16;
    public static final int NETWORK_TYPE_TD_SCDMA = 17;
    public static final int NETWORK_TYPE_IWLAN = 18;
    public static final int NETWORK_CLASS_UNKNOWN = 0;
    public static final int NETWORK_CLASS_2_G = 1;
    public static final int NETWORK_CLASS_3_G = 2;
    public static final int NETWORK_CLASS_4_G = 3;
    public static final int SIM_STATE_UNKNOWN = 0;
    public static final int SIM_STATE_ABSENT = 1;
    public static final int SIM_STATE_PIN_REQUIRED = 2;
    public static final int SIM_STATE_PUK_REQUIRED = 3;
    public static final int SIM_STATE_NETWORK_LOCKED = 4;
    public static final int SIM_STATE_READY = 5;
    public static final int SIM_STATE_NOT_READY = 6;
    public static final int SIM_STATE_PERM_DISABLED = 7;
    public static final int SIM_STATE_CARD_IO_ERROR = 8;
    public static final int CALL_STATE_IDLE = 0;
    public static final int CALL_STATE_RINGING = 1;
    public static final int CALL_STATE_OFFHOOK = 2;
    public static final int DATA_ACTIVITY_NONE = 0;
    public static final int DATA_ACTIVITY_IN = 1;
    public static final int DATA_ACTIVITY_OUT = 2;
    public static final int DATA_ACTIVITY_INOUT = 3;
    public static final int DATA_ACTIVITY_DORMANT = 4;
    public static final int DATA_UNKNOWN = -1;
    public static final int DATA_DISCONNECTED = 0;
    public static final int DATA_CONNECTING = 1;
    public static final int DATA_CONNECTED = 2;
    public static final int DATA_SUSPENDED = 3;
    public static final int APPTYPE_SIM = 1;
    public static final int APPTYPE_USIM = 2;
    public static final int APPTYPE_RUIM = 3;
    public static final int APPTYPE_CSIM = 4;
    public static final int APPTYPE_ISIM = 5;
    public static final int AUTHTYPE_EAP_SIM = 128;
    public static final int AUTHTYPE_EAP_AKA = 129;
    public static final int CARRIER_PRIVILEGE_STATUS_HAS_ACCESS = 1;
    public static final int CARRIER_PRIVILEGE_STATUS_NO_ACCESS = 0;
    public static final int CARRIER_PRIVILEGE_STATUS_RULES_NOT_LOADED = -1;
    public static final int CARRIER_PRIVILEGE_STATUS_ERROR_LOADING_RULES = -2;

    public TelephonyManager(Context context) {
        this(context, Integer.MAX_VALUE);
    }

    public TelephonyManager(Context context, int subId) {
        this.mSubId = subId;
        Context appContext = context.getApplicationContext();
        this.mContext = appContext != null ? appContext : context;
        this.mSubscriptionManager = SubscriptionManager.from(this.mContext);
        if (sRegistry == null) {
            sRegistry = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
        }
    }

    private TelephonyManager() {
        this.mContext = null;
        this.mSubId = -1;
    }

    public static TelephonyManager getDefault() {
        return sInstance;
    }

    private String getOpPackageName() {
        if (this.mContext != null) {
            return this.mContext.getOpPackageName();
        }
        return ActivityThread.currentOpPackageName();
    }

    public MultiSimVariants getMultiSimConfiguration() {
        String mSimConfig = SystemProperties.get("persist.radio.multisim.config");
        if (mSimConfig.equals("dsds")) {
            return MultiSimVariants.DSDS;
        }
        if (mSimConfig.equals("dsda")) {
            return MultiSimVariants.DSDA;
        }
        if (mSimConfig.equals("tsts")) {
            return MultiSimVariants.TSTS;
        }
        return MultiSimVariants.UNKNOWN;
    }

    public int getPhoneCount() {
        int phoneCount = 1;
        switch (this.getMultiSimConfiguration()) {
            case UNKNOWN: {
                if (this.isVoiceCapable() || this.isSmsCapable()) {
                    phoneCount = 1;
                    break;
                }
                if (this.mContext == null) {
                    phoneCount = 1;
                    break;
                }
                ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
                if (cm == null) {
                    phoneCount = 1;
                    break;
                }
                if (cm.isNetworkSupported(0)) {
                    phoneCount = 1;
                    break;
                }
                phoneCount = 0;
                break;
            }
            case DSDS: 
            case DSDA: {
                phoneCount = 2;
                break;
            }
            case TSTS: {
                phoneCount = 3;
            }
        }
        return phoneCount;
    }

    public static TelephonyManager from(Context context) {
        return (TelephonyManager)context.getSystemService("phone");
    }

    public TelephonyManager createForSubscriptionId(int subId) {
        return new TelephonyManager(this.mContext, subId);
    }

    public boolean isMultiSimEnabled() {
        return multiSimConfig.equals("dsds") || multiSimConfig.equals("dsda") || multiSimConfig.equals("tsts");
    }

    public String getDeviceSoftwareVersion() {
        return this.getDeviceSoftwareVersion(this.getDefaultSim());
    }

    public String getDeviceSoftwareVersion(int slotId) {
        ITelephony telephony = this.getITelephony();
        if (telephony == null) {
            return null;
        }
        try {
            return telephony.getDeviceSoftwareVersionForSlot(slotId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getDeviceId() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getDeviceId(this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getDeviceId(int slotId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getDeviceIdForPhone(slotId, this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getImei() {
        return this.getImei(this.getDefaultSim());
    }

    public String getImei(int slotId) {
        ITelephony telephony = this.getITelephony();
        if (telephony == null) {
            return null;
        }
        try {
            return telephony.getImeiForSlot(slotId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getNai() {
        return this.getNai(this.getDefaultSim());
    }

    public String getNai(int slotId) {
        int[] subId = SubscriptionManager.getSubId(slotId);
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            String nai = info.getNaiForSubscriber(subId[0], this.mContext.getOpPackageName());
            if (Log.isLoggable(TAG, 2)) {
                Rlog.v(TAG, "Nai = " + nai);
            }
            return nai;
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public CellLocation getCellLocation() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                Rlog.d(TAG, "getCellLocation returning null because telephony is null");
                return null;
            }
            Bundle bundle = telephony.getCellLocation(this.mContext.getOpPackageName());
            if (bundle.isEmpty()) {
                Rlog.d(TAG, "getCellLocation returning null because bundle is empty");
                return null;
            }
            CellLocation cl = CellLocation.newFromBundle(bundle);
            if (cl.isEmpty()) {
                Rlog.d(TAG, "getCellLocation returning null because CellLocation is empty");
                return null;
            }
            return cl;
        }
        catch (RemoteException ex) {
            Rlog.d(TAG, "getCellLocation returning null due to RemoteException " + ex);
            return null;
        }
        catch (NullPointerException ex) {
            Rlog.d(TAG, "getCellLocation returning null due to NullPointerException " + ex);
            return null;
        }
    }

    public void enableLocationUpdates() {
        this.enableLocationUpdates(this.getSubId());
    }

    public void enableLocationUpdates(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.enableLocationUpdatesForSubscriber(subId);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void disableLocationUpdates() {
        this.disableLocationUpdates(this.getSubId());
    }

    public void disableLocationUpdates(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.disableLocationUpdatesForSubscriber(subId);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Deprecated
    public List<NeighboringCellInfo> getNeighboringCellInfo() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getNeighboringCellInfo(this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public int getCurrentPhoneType() {
        return this.getCurrentPhoneType(this.getSubId());
    }

    public int getCurrentPhoneType(int subId) {
        int phoneId = subId == -1 ? 0 : SubscriptionManager.getPhoneId(subId);
        return this.getCurrentPhoneTypeForSlot(phoneId);
    }

    public int getCurrentPhoneTypeForSlot(int slotId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getActivePhoneTypeForSlot(slotId);
            }
            return this.getPhoneTypeFromProperty(slotId);
        }
        catch (RemoteException ex) {
            return this.getPhoneTypeFromProperty(slotId);
        }
        catch (NullPointerException ex) {
            return this.getPhoneTypeFromProperty(slotId);
        }
    }

    public int getPhoneType() {
        if (!this.isVoiceCapable()) {
            return 0;
        }
        return this.getCurrentPhoneType();
    }

    private int getPhoneTypeFromProperty() {
        return this.getPhoneTypeFromProperty(TelephonyManager.getDefaultPhone());
    }

    private int getPhoneTypeFromProperty(int phoneId) {
        String type = TelephonyManager.getTelephonyProperty(phoneId, "gsm.current.phone-type", null);
        if (type == null || type.equals("")) {
            return this.getPhoneTypeFromNetworkType(phoneId);
        }
        return Integer.parseInt(type);
    }

    private int getPhoneTypeFromNetworkType() {
        return this.getPhoneTypeFromNetworkType(TelephonyManager.getDefaultPhone());
    }

    private int getPhoneTypeFromNetworkType(int phoneId) {
        String mode = TelephonyManager.getTelephonyProperty(phoneId, "ro.telephony.default_network", null);
        if (mode != null) {
            return TelephonyManager.getPhoneType(Integer.parseInt(mode));
        }
        return 0;
    }

    public static int getPhoneType(int networkMode) {
        switch (networkMode) {
            case 4: 
            case 5: 
            case 6: {
                return 2;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                return 1;
            }
            case 7: 
            case 8: 
            case 21: {
                return 2;
            }
            case 11: {
                if (TelephonyManager.getLteOnCdmaModeStatic() == 1) {
                    return 2;
                }
                return 1;
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProcCmdLine() {
        String cmdline = "";
        FileInputStream is = null;
        try {
            is = new FileInputStream("/proc/cmdline");
            byte[] buffer = new byte[2048];
            int count = is.read(buffer);
            if (count > 0) {
                cmdline = new String(buffer, 0, count);
            }
        }
        catch (IOException e) {
            Rlog.d(TAG, "No /proc/cmdline exception=" + e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        Rlog.d(TAG, "/proc/cmdline=" + cmdline);
        return cmdline;
    }

    public static int getLteOnCdmaModeStatic() {
        String productType = "";
        int curVal = SystemProperties.getInt("telephony.lteOnCdmaDevice", -1);
        int retVal = curVal;
        if (retVal == -1) {
            Matcher matcher = sProductTypePattern.matcher(sKernelCmdLine);
            retVal = matcher.find() ? (sLteOnCdmaProductType.equals(productType = matcher.group(1)) ? 1 : 0) : 0;
        }
        Rlog.d(TAG, "getLteOnCdmaMode=" + retVal + " curVal=" + curVal + " product_type='" + productType + "' lteOnCdmaProductType='" + sLteOnCdmaProductType + "'");
        return retVal;
    }

    public String getNetworkOperatorName() {
        return this.getNetworkOperatorName(this.getSubId());
    }

    public String getNetworkOperatorName(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return TelephonyManager.getTelephonyProperty(phoneId, "gsm.operator.alpha", "");
    }

    public String getNetworkOperator() {
        return this.getNetworkOperatorForPhone(TelephonyManager.getDefaultPhone());
    }

    public String getNetworkOperator(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return this.getNetworkOperatorForPhone(phoneId);
    }

    public String getNetworkOperatorForPhone(int phoneId) {
        return TelephonyManager.getTelephonyProperty(phoneId, "gsm.operator.numeric", "");
    }

    public boolean isNetworkRoaming() {
        return this.isNetworkRoaming(this.getSubId());
    }

    public boolean isNetworkRoaming(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return Boolean.parseBoolean(TelephonyManager.getTelephonyProperty(phoneId, "gsm.operator.isroaming", null));
    }

    public String getNetworkCountryIso() {
        return this.getNetworkCountryIsoForPhone(TelephonyManager.getDefaultPhone());
    }

    public String getNetworkCountryIso(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return this.getNetworkCountryIsoForPhone(phoneId);
    }

    public String getNetworkCountryIsoForPhone(int phoneId) {
        return TelephonyManager.getTelephonyProperty(phoneId, "gsm.operator.iso-country", "");
    }

    public int getNetworkType() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getNetworkType();
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int getNetworkType(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getNetworkTypeForSubscriber(subId, this.getOpPackageName());
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int getDataNetworkType() {
        return this.getDataNetworkType(this.getSubId());
    }

    public int getDataNetworkType(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getDataNetworkTypeForSubscriber(subId, this.getOpPackageName());
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int getVoiceNetworkType() {
        return this.getVoiceNetworkType(this.getSubId());
    }

    public int getVoiceNetworkType(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getVoiceNetworkTypeForSubscriber(subId, this.getOpPackageName());
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public static int getNetworkClass(int networkType) {
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: {
                return 1;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                return 2;
            }
            case 13: 
            case 18: {
                return 3;
            }
        }
        return 0;
    }

    public String getNetworkTypeName() {
        return TelephonyManager.getNetworkTypeName(this.getNetworkType());
    }

    public static String getNetworkTypeName(int type) {
        switch (type) {
            case 1: {
                return "GPRS";
            }
            case 2: {
                return "EDGE";
            }
            case 3: {
                return "UMTS";
            }
            case 8: {
                return "HSDPA";
            }
            case 9: {
                return "HSUPA";
            }
            case 10: {
                return "HSPA";
            }
            case 4: {
                return "CDMA";
            }
            case 5: {
                return "CDMA - EvDo rev. 0";
            }
            case 6: {
                return "CDMA - EvDo rev. A";
            }
            case 12: {
                return "CDMA - EvDo rev. B";
            }
            case 7: {
                return "CDMA - 1xRTT";
            }
            case 13: {
                return "LTE";
            }
            case 14: {
                return "CDMA - eHRPD";
            }
            case 11: {
                return "iDEN";
            }
            case 15: {
                return "HSPA+";
            }
            case 16: {
                return "GSM";
            }
            case 17: {
                return "TD_SCDMA";
            }
            case 18: {
                return "IWLAN";
            }
        }
        return "UNKNOWN";
    }

    public boolean hasIccCard() {
        return this.hasIccCard(this.getDefaultSim());
    }

    public boolean hasIccCard(int slotId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return false;
            }
            return telephony.hasIccCardUsingSlotId(slotId);
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    public int getSimState() {
        int slotIdx = this.getDefaultSim();
        if (slotIdx < 0) {
            for (int i = 0; i < this.getPhoneCount(); ++i) {
                int simState = this.getSimState(i);
                if (simState == 1) continue;
                Rlog.d(TAG, "getSimState: default sim:" + slotIdx + ", sim state for " + "slotIdx=" + i + " is " + simState + ", return state as unknown");
                return 0;
            }
            Rlog.d(TAG, "getSimState: default sim:" + slotIdx + ", all SIMs absent, return " + "state as absent");
            return 1;
        }
        return this.getSimState(slotIdx);
    }

    public int getSimState(int slotIdx) {
        int simState = SubscriptionManager.getSimStateForSlotIdx(slotIdx);
        return simState;
    }

    public String getSimOperator() {
        return this.getSimOperatorNumeric();
    }

    public String getSimOperator(int subId) {
        return this.getSimOperatorNumeric(subId);
    }

    public String getSimOperatorNumeric() {
        int subId = SubscriptionManager.getDefaultDataSubscriptionId();
        if (!(SubscriptionManager.isUsableSubIdValue(subId) || SubscriptionManager.isUsableSubIdValue(subId = SubscriptionManager.getDefaultSmsSubscriptionId()) || SubscriptionManager.isUsableSubIdValue(subId = SubscriptionManager.getDefaultVoiceSubscriptionId()))) {
            subId = SubscriptionManager.getDefaultSubscriptionId();
        }
        return this.getSimOperatorNumeric(subId);
    }

    public String getSimOperatorNumeric(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return this.getSimOperatorNumericForPhone(phoneId);
    }

    public String getSimOperatorNumericForPhone(int phoneId) {
        return TelephonyManager.getTelephonyProperty(phoneId, "gsm.sim.operator.numeric", "");
    }

    public String getSimOperatorName() {
        return this.getSimOperatorNameForPhone(TelephonyManager.getDefaultPhone());
    }

    public String getSimOperatorName(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return this.getSimOperatorNameForPhone(phoneId);
    }

    public String getSimOperatorNameForPhone(int phoneId) {
        return TelephonyManager.getTelephonyProperty(phoneId, "gsm.sim.operator.alpha", "");
    }

    public String getSimCountryIso() {
        return this.getSimCountryIsoForPhone(TelephonyManager.getDefaultPhone());
    }

    public String getSimCountryIso(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return this.getSimCountryIsoForPhone(phoneId);
    }

    public String getSimCountryIsoForPhone(int phoneId) {
        return TelephonyManager.getTelephonyProperty(phoneId, "gsm.sim.operator.iso-country", "");
    }

    public String getSimSerialNumber() {
        return this.getSimSerialNumber(this.getSubId());
    }

    public String getSimSerialNumber(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIccSerialNumberForSubscriber(subId, this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public int getLteOnCdmaMode() {
        return this.getLteOnCdmaMode(this.getSubId());
    }

    public int getLteOnCdmaMode(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return -1;
            }
            return telephony.getLteOnCdmaModeForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    public String getSubscriberId() {
        return this.getSubscriberId(this.getSubId());
    }

    public String getSubscriberId(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getSubscriberIdForSubscriber(subId, this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getGroupIdLevel1() {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getGroupIdLevel1(this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getGroupIdLevel1(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getGroupIdLevel1ForSubscriber(subId, this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getLine1Number() {
        return this.getLine1Number(this.getSubId());
    }

    public String getLine1Number(int subId) {
        String number = null;
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                number = telephony.getLine1NumberForDisplay(subId, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException telephony) {
        }
        catch (NullPointerException telephony) {
            // empty catch block
        }
        if (number != null) {
            return number;
        }
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getLine1NumberForSubscriber(subId, this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public boolean setLine1NumberForDisplay(String alphaTag, String number) {
        return this.setLine1NumberForDisplay(this.getSubId(), alphaTag, number);
    }

    public boolean setLine1NumberForDisplay(int subId, String alphaTag, String number) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setLine1NumberForDisplayForSubscriber(subId, alphaTag, number);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public String getLine1AlphaTag() {
        return this.getLine1AlphaTag(this.getSubId());
    }

    public String getLine1AlphaTag(int subId) {
        String alphaTag = null;
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                alphaTag = telephony.getLine1AlphaTagForDisplay(subId, this.getOpPackageName());
            }
        }
        catch (RemoteException telephony) {
        }
        catch (NullPointerException telephony) {
            // empty catch block
        }
        if (alphaTag != null) {
            return alphaTag;
        }
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getLine1AlphaTagForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String[] getMergedSubscriberIds() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getMergedSubscriberIds(this.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public String getMsisdn() {
        return this.getMsisdn(this.getSubId());
    }

    public String getMsisdn(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getMsisdnForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getVoiceMailNumber() {
        return this.getVoiceMailNumber(this.getSubId());
    }

    public String getVoiceMailNumber(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getVoiceMailNumberForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getCompleteVoiceMailNumber() {
        return this.getCompleteVoiceMailNumber(this.getSubId());
    }

    public String getCompleteVoiceMailNumber(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getCompleteVoiceMailNumberForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public boolean setVoiceMailNumber(String alphaTag, String number) {
        return this.setVoiceMailNumber(this.getSubId(), alphaTag, number);
    }

    public boolean setVoiceMailNumber(int subId, String alphaTag, String number) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setVoiceMailNumber(subId, alphaTag, number);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public int getVoiceMessageCount() {
        return this.getVoiceMessageCount(this.getSubId());
    }

    public int getVoiceMessageCount(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return 0;
            }
            return telephony.getVoiceMessageCountForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public String getVoiceMailAlphaTag() {
        return this.getVoiceMailAlphaTag(this.getSubId());
    }

    public String getVoiceMailAlphaTag(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getVoiceMailAlphaTagForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getIsimImpi() {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIsimImpi();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getIsimDomain() {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIsimDomain();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String[] getIsimImpu() {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIsimImpu();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private IPhoneSubInfo getSubscriberInfo() {
        return IPhoneSubInfo.Stub.asInterface(ServiceManager.getService("iphonesubinfo"));
    }

    public int getCallState() {
        try {
            ITelecomService telecom = this.getTelecomService();
            if (telecom != null) {
                return telecom.getCallState();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#getCallState", e);
        }
        return 0;
    }

    public int getCallState(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return this.getCallStateForSlot(phoneId);
    }

    public int getCallStateForSlot(int slotId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return 0;
            }
            return telephony.getCallStateForSlot(slotId);
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int getDataActivity() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return 0;
            }
            return telephony.getDataActivity();
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int getDataState() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return 0;
            }
            return telephony.getDataState();
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    private ITelephony getITelephony() {
        return ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
    }

    private ITelecomService getTelecomService() {
        return ITelecomService.Stub.asInterface(ServiceManager.getService("telecom"));
    }

    public void listen(PhoneStateListener listener, int events) {
        if (this.mContext == null) {
            return;
        }
        try {
            Boolean notifyNow = this.getITelephony() != null;
            sRegistry.listenForSubscriber(listener.mSubId, this.getOpPackageName(), listener.callback, events, notifyNow);
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public int getCdmaEriIconIndex() {
        return this.getCdmaEriIconIndex(this.getSubId());
    }

    public int getCdmaEriIconIndex(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return -1;
            }
            return telephony.getCdmaEriIconIndexForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    public int getCdmaEriIconMode() {
        return this.getCdmaEriIconMode(this.getSubId());
    }

    public int getCdmaEriIconMode(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return -1;
            }
            return telephony.getCdmaEriIconModeForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    public String getCdmaEriText() {
        return this.getCdmaEriText(this.getSubId());
    }

    public String getCdmaEriText(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getCdmaEriTextForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public boolean isVoiceCapable() {
        if (this.mContext == null) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17956953);
    }

    public boolean isSmsCapable() {
        if (this.mContext == null) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17956956);
    }

    public List<CellInfo> getAllCellInfo() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getAllCellInfo(this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public void setCellInfoListRate(int rateInMillis) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setCellInfoListRate(rateInMillis);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public String getMmsUserAgent() {
        if (this.mContext == null) {
            return null;
        }
        return this.mContext.getResources().getString(17039440);
    }

    public String getMmsUAProfUrl() {
        if (this.mContext == null) {
            return null;
        }
        return this.mContext.getResources().getString(17039441);
    }

    public IccOpenLogicalChannelResponse iccOpenLogicalChannel(String AID) {
        return this.iccOpenLogicalChannel(this.getSubId(), AID);
    }

    public IccOpenLogicalChannelResponse iccOpenLogicalChannel(int subId, String AID) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.iccOpenLogicalChannel(subId, AID);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public boolean iccCloseLogicalChannel(int channel) {
        return this.iccCloseLogicalChannel(this.getSubId(), channel);
    }

    public boolean iccCloseLogicalChannel(int subId, int channel) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.iccCloseLogicalChannel(subId, channel);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public String iccTransmitApduLogicalChannel(int channel, int cla, int instruction, int p1, int p2, int p3, String data) {
        return this.iccTransmitApduLogicalChannel(this.getSubId(), channel, cla, instruction, p1, p2, p3, data);
    }

    public String iccTransmitApduLogicalChannel(int subId, int channel, int cla, int instruction, int p1, int p2, int p3, String data) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.iccTransmitApduLogicalChannel(subId, channel, cla, instruction, p1, p2, p3, data);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "";
    }

    public String iccTransmitApduBasicChannel(int cla, int instruction, int p1, int p2, int p3, String data) {
        return this.iccTransmitApduBasicChannel(this.getSubId(), cla, instruction, p1, p2, p3, data);
    }

    public String iccTransmitApduBasicChannel(int subId, int cla, int instruction, int p1, int p2, int p3, String data) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.iccTransmitApduBasicChannel(subId, cla, instruction, p1, p2, p3, data);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "";
    }

    public byte[] iccExchangeSimIO(int fileID, int command, int p1, int p2, int p3, String filePath) {
        return this.iccExchangeSimIO(this.getSubId(), fileID, command, p1, p2, p3, filePath);
    }

    public byte[] iccExchangeSimIO(int subId, int fileID, int command, int p1, int p2, int p3, String filePath) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.iccExchangeSimIO(subId, fileID, command, p1, p2, p3, filePath);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public String sendEnvelopeWithStatus(String content) {
        return this.sendEnvelopeWithStatus(this.getSubId(), content);
    }

    public String sendEnvelopeWithStatus(int subId, String content) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.sendEnvelopeWithStatus(subId, content);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "";
    }

    public String nvReadItem(int itemID) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.nvReadItem(itemID);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "nvReadItem RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "nvReadItem NPE", ex);
        }
        return "";
    }

    public boolean nvWriteItem(int itemID, String itemValue) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.nvWriteItem(itemID, itemValue);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "nvWriteItem RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "nvWriteItem NPE", ex);
        }
        return false;
    }

    public boolean nvWriteCdmaPrl(byte[] preferredRoamingList) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.nvWriteCdmaPrl(preferredRoamingList);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "nvWriteCdmaPrl RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "nvWriteCdmaPrl NPE", ex);
        }
        return false;
    }

    public boolean nvResetConfig(int resetType) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.nvResetConfig(resetType);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "nvResetConfig RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "nvResetConfig NPE", ex);
        }
        return false;
    }

    private int getSubId() {
        if (this.mSubId == Integer.MAX_VALUE) {
            return TelephonyManager.getDefaultSubscription();
        }
        return this.mSubId;
    }

    private static int getDefaultSubscription() {
        return SubscriptionManager.getDefaultSubscriptionId();
    }

    private static int getDefaultPhone() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultSubscriptionId());
    }

    public int getDefaultSim() {
        return SubscriptionManager.getSlotId(SubscriptionManager.getDefaultSubscriptionId());
    }

    public static void setTelephonyProperty(int phoneId, String property, String value) {
        int i;
        String propVal = "";
        String[] p = null;
        String prop = SystemProperties.get(property);
        if (value == null) {
            value = "";
        }
        if (prop != null) {
            p = prop.split(",");
        }
        if (!SubscriptionManager.isValidPhoneId(phoneId)) {
            Rlog.d(TAG, "setTelephonyProperty: invalid phoneId=" + phoneId + " property=" + property + " value: " + value + " prop=" + prop);
            return;
        }
        for (i = 0; i < phoneId; ++i) {
            String str = "";
            if (p != null && i < p.length) {
                str = p[i];
            }
            propVal = propVal + str + ",";
        }
        propVal = propVal + value;
        if (p != null) {
            for (i = phoneId + 1; i < p.length; ++i) {
                propVal = propVal + "," + p[i];
            }
        }
        if (property.length() > 31 || propVal.length() > 91) {
            Rlog.d(TAG, "setTelephonyProperty: property to long phoneId=" + phoneId + " property=" + property + " value: " + value + " propVal=" + propVal);
            return;
        }
        Rlog.d(TAG, "setTelephonyProperty: success phoneId=" + phoneId + " property=" + property + " value: " + value + " propVal=" + propVal);
        SystemProperties.set(property, propVal);
    }

    public static int getIntAtIndex(ContentResolver cr, String name, int index) throws Settings.SettingNotFoundException {
        String v = Settings.Global.getString(cr, name);
        if (v != null) {
            String[] valArray = v.split(",");
            if (index >= 0 && index < valArray.length && valArray[index] != null) {
                try {
                    return Integer.parseInt(valArray[index]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        throw new Settings.SettingNotFoundException(name);
    }

    public static boolean putIntAtIndex(ContentResolver cr, String name, int index, int value) {
        int i;
        String data = "";
        String[] valArray = null;
        String v = Settings.Global.getString(cr, name);
        if (index == Integer.MAX_VALUE) {
            throw new RuntimeException("putIntAtIndex index == MAX_VALUE index=" + index);
        }
        if (index < 0) {
            throw new RuntimeException("putIntAtIndex index < 0 index=" + index);
        }
        if (v != null) {
            valArray = v.split(",");
        }
        for (i = 0; i < index; ++i) {
            String str = "";
            if (valArray != null && i < valArray.length) {
                str = valArray[i];
            }
            data = data + str + ",";
        }
        data = data + value;
        if (valArray != null) {
            for (i = index + 1; i < valArray.length; ++i) {
                data = data + "," + valArray[i];
            }
        }
        return Settings.Global.putString(cr, name, data);
    }

    public static String getTelephonyProperty(int phoneId, String property, String defaultVal) {
        String propVal = null;
        String prop = SystemProperties.get(property);
        if (prop != null && prop.length() > 0) {
            String[] values = prop.split(",");
            if (phoneId >= 0 && phoneId < values.length && values[phoneId] != null) {
                propVal = values[phoneId];
            }
        }
        return propVal == null ? defaultVal : propVal;
    }

    public int getSimCount() {
        if (this.isMultiSimEnabled()) {
            return 2;
        }
        return 1;
    }

    public String getIsimIst() {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIsimIst();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String[] getIsimPcscf() {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIsimPcscf();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getIsimChallengeResponse(String nonce) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIsimChallengeResponse(nonce);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getIccAuthentication(int appType, int authType, String data) {
        return this.getIccAuthentication(this.getSubId(), appType, authType, data);
    }

    public String getIccAuthentication(int subId, int appType, int authType, String data) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIccSimChallengeResponse(subId, appType, authType, data);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String[] getPcscfAddress(String apnType) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return new String[0];
            }
            return telephony.getPcscfAddress(apnType, this.getOpPackageName());
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    public void setImsRegistrationState(boolean registered) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setImsRegistrationState(registered);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int getPreferredNetworkType(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getPreferredNetworkType(subId);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getPreferredNetworkType RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "getPreferredNetworkType NPE", ex);
        }
        return -1;
    }

    public void setNetworkSelectionModeAutomatic(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setNetworkSelectionModeAutomatic(subId);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setNetworkSelectionModeAutomatic RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "setNetworkSelectionModeAutomatic NPE", ex);
        }
    }

    public CellNetworkScanResult getCellNetworkScanResults(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getCellNetworkScanResults(subId);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getCellNetworkScanResults RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "getCellNetworkScanResults NPE", ex);
        }
        return null;
    }

    public boolean setNetworkSelectionModeManual(int subId, OperatorInfo operator, boolean persistSelection) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setNetworkSelectionModeManual(subId, operator, persistSelection);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setNetworkSelectionModeManual RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "setNetworkSelectionModeManual NPE", ex);
        }
        return false;
    }

    public boolean setPreferredNetworkType(int subId, int networkType) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setPreferredNetworkType(subId, networkType);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setPreferredNetworkType RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "setPreferredNetworkType NPE", ex);
        }
        return false;
    }

    public boolean setPreferredNetworkTypeToGlobal() {
        return this.setPreferredNetworkTypeToGlobal(this.getSubId());
    }

    public boolean setPreferredNetworkTypeToGlobal(int subId) {
        return this.setPreferredNetworkType(subId, 10);
    }

    public int getTetherApnRequired() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getTetherApnRequired();
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "hasMatchedTetherApnSetting RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "hasMatchedTetherApnSetting NPE", ex);
        }
        return 2;
    }

    public boolean hasCarrierPrivileges() {
        return this.hasCarrierPrivileges(this.getSubId());
    }

    public boolean hasCarrierPrivileges(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getCarrierPrivilegeStatus(this.mSubId) == 1;
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "hasCarrierPrivileges RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "hasCarrierPrivileges NPE", ex);
        }
        return false;
    }

    public boolean setOperatorBrandOverride(String brand) {
        return this.setOperatorBrandOverride(this.getSubId(), brand);
    }

    public boolean setOperatorBrandOverride(int subId, String brand) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setOperatorBrandOverride(subId, brand);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setOperatorBrandOverride RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "setOperatorBrandOverride NPE", ex);
        }
        return false;
    }

    public boolean setRoamingOverride(List<String> gsmRoamingList, List<String> gsmNonRoamingList, List<String> cdmaRoamingList, List<String> cdmaNonRoamingList) {
        return this.setRoamingOverride(this.getSubId(), gsmRoamingList, gsmNonRoamingList, cdmaRoamingList, cdmaNonRoamingList);
    }

    public boolean setRoamingOverride(int subId, List<String> gsmRoamingList, List<String> gsmNonRoamingList, List<String> cdmaRoamingList, List<String> cdmaNonRoamingList) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setRoamingOverride(subId, gsmRoamingList, gsmNonRoamingList, cdmaRoamingList, cdmaNonRoamingList);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setRoamingOverride RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "setRoamingOverride NPE", ex);
        }
        return false;
    }

    public String getCdmaMdn() {
        return this.getCdmaMdn(this.getSubId());
    }

    public String getCdmaMdn(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getCdmaMdn(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getCdmaMin() {
        return this.getCdmaMin(this.getSubId());
    }

    public String getCdmaMin(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getCdmaMin(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public int checkCarrierPrivilegesForPackage(String pkgName) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.checkCarrierPrivilegesForPackage(pkgName);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "checkCarrierPrivilegesForPackage RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "checkCarrierPrivilegesForPackage NPE", ex);
        }
        return 0;
    }

    public int checkCarrierPrivilegesForPackageAnyPhone(String pkgName) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.checkCarrierPrivilegesForPackageAnyPhone(pkgName);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "checkCarrierPrivilegesForPackageAnyPhone RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "checkCarrierPrivilegesForPackageAnyPhone NPE", ex);
        }
        return 0;
    }

    public List<String> getCarrierPackageNamesForIntent(Intent intent) {
        return this.getCarrierPackageNamesForIntentAndPhone(intent, TelephonyManager.getDefaultPhone());
    }

    public List<String> getCarrierPackageNamesForIntentAndPhone(Intent intent, int phoneId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getCarrierPackageNamesForIntentAndPhone(intent, phoneId);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getCarrierPackageNamesForIntentAndPhone RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "getCarrierPackageNamesForIntentAndPhone NPE", ex);
        }
        return null;
    }

    public List<String> getPackagesWithCarrierPrivileges() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getPackagesWithCarrierPrivileges();
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getPackagesWithCarrierPrivileges RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "getPackagesWithCarrierPrivileges NPE", ex);
        }
        return Collections.EMPTY_LIST;
    }

    public void dial(String number) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.dial(number);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#dial", e);
        }
    }

    public void call(String callingPackage, String number) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.call(callingPackage, number);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#call", e);
        }
    }

    public boolean endCall() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.endCall();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#endCall", e);
        }
        return false;
    }

    public void answerRingingCall() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.answerRingingCall();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#answerRingingCall", e);
        }
    }

    public void silenceRinger() {
        try {
            this.getTelecomService().silenceRinger(this.getOpPackageName());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#silenceRinger", e);
        }
    }

    public boolean isOffhook() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isOffhook(this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isOffhook", e);
        }
        return false;
    }

    public boolean isRinging() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isRinging(this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isRinging", e);
        }
        return false;
    }

    public boolean isIdle() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isIdle(this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isIdle", e);
        }
        return true;
    }

    public boolean isRadioOn() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isRadioOn(this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isRadioOn", e);
        }
        return false;
    }

    public boolean supplyPin(String pin) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.supplyPin(pin);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#supplyPin", e);
        }
        return false;
    }

    public boolean supplyPuk(String puk, String pin) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.supplyPuk(puk, pin);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#supplyPuk", e);
        }
        return false;
    }

    public int[] supplyPinReportResult(String pin) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.supplyPinReportResult(pin);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#supplyPinReportResult", e);
        }
        return new int[0];
    }

    public int[] supplyPukReportResult(String puk, String pin) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.supplyPukReportResult(puk, pin);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#]", e);
        }
        return new int[0];
    }

    public boolean handlePinMmi(String dialString) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.handlePinMmi(dialString);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#handlePinMmi", e);
        }
        return false;
    }

    public boolean handlePinMmiForSubscriber(int subId, String dialString) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.handlePinMmiForSubscriber(subId, dialString);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#handlePinMmi", e);
        }
        return false;
    }

    public void toggleRadioOnOff() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.toggleRadioOnOff();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#toggleRadioOnOff", e);
        }
    }

    public boolean setRadio(boolean turnOn) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setRadio(turnOn);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setRadio", e);
        }
        return false;
    }

    public boolean setRadioPower(boolean turnOn) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setRadioPower(turnOn);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setRadioPower", e);
        }
        return false;
    }

    public void updateServiceLocation() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.updateServiceLocation();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#updateServiceLocation", e);
        }
    }

    public boolean enableDataConnectivity() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.enableDataConnectivity();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#enableDataConnectivity", e);
        }
        return false;
    }

    public boolean disableDataConnectivity() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.disableDataConnectivity();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#disableDataConnectivity", e);
        }
        return false;
    }

    public boolean isDataConnectivityPossible() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isDataConnectivityPossible();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isDataConnectivityPossible", e);
        }
        return false;
    }

    public boolean needsOtaServiceProvisioning() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.needsOtaServiceProvisioning();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#needsOtaServiceProvisioning", e);
        }
        return false;
    }

    public void setDataEnabled(boolean enable) {
        this.setDataEnabled(SubscriptionManager.getDefaultDataSubscriptionId(), enable);
    }

    public void setDataEnabled(int subId, boolean enable) {
        try {
            Log.d(TAG, "setDataEnabled: enabled=" + enable);
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setDataEnabled(subId, enable);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setDataEnabled", e);
        }
    }

    public boolean getDataEnabled() {
        return this.getDataEnabled(SubscriptionManager.getDefaultDataSubscriptionId());
    }

    public boolean getDataEnabled(int subId) {
        boolean retVal = false;
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                retVal = telephony.getDataEnabled(subId);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getDataEnabled", e);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return retVal;
    }

    public int invokeOemRilRequestRaw(byte[] oemReq, byte[] oemResp) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.invokeOemRilRequestRaw(oemReq, oemResp);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return -1;
    }

    public void enableVideoCalling(boolean enable) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.enableVideoCalling(enable);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#enableVideoCalling", e);
        }
    }

    public boolean isVideoCallingEnabled() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isVideoCallingEnabled(this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isVideoCallingEnabled", e);
        }
        return false;
    }

    public boolean canChangeDtmfToneLength() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.canChangeDtmfToneLength();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#canChangeDtmfToneLength", e);
        }
        catch (SecurityException e) {
            Log.e(TAG, "Permission error calling ITelephony#canChangeDtmfToneLength", e);
        }
        return false;
    }

    public boolean isWorldPhone() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isWorldPhone();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isWorldPhone", e);
        }
        catch (SecurityException e) {
            Log.e(TAG, "Permission error calling ITelephony#isWorldPhone", e);
        }
        return false;
    }

    public boolean isTtyModeSupported() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isTtyModeSupported();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isTtyModeSupported", e);
        }
        catch (SecurityException e) {
            Log.e(TAG, "Permission error calling ITelephony#isTtyModeSupported", e);
        }
        return false;
    }

    public boolean isHearingAidCompatibilitySupported() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isHearingAidCompatibilitySupported();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isHearingAidCompatibilitySupported", e);
        }
        catch (SecurityException e) {
            Log.e(TAG, "Permission error calling ITelephony#isHearingAidCompatibilitySupported", e);
        }
        return false;
    }

    public static int getIntWithSubId(ContentResolver cr, String name, int subId) throws Settings.SettingNotFoundException {
        try {
            return Settings.Global.getInt(cr, name + subId);
        }
        catch (Settings.SettingNotFoundException e) {
            try {
                int val = Settings.Global.getInt(cr, name);
                Settings.Global.putInt(cr, name + subId, val);
                int default_val = val;
                if (name.equals("mobile_data")) {
                    default_val = "true".equalsIgnoreCase(SystemProperties.get("ro.com.android.mobiledata", "true")) ? 1 : 0;
                } else if (name.equals("data_roaming")) {
                    int n = default_val = "true".equalsIgnoreCase(SystemProperties.get("ro.com.android.dataroaming", "false")) ? 1 : 0;
                }
                if (default_val != val) {
                    Settings.Global.putInt(cr, name, default_val);
                }
                return val;
            }
            catch (Settings.SettingNotFoundException exc) {
                throw new Settings.SettingNotFoundException(name);
            }
        }
    }

    public boolean isImsRegistered() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return false;
            }
            return telephony.isImsRegistered();
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    public boolean isVolteAvailable() {
        try {
            return this.getITelephony().isVolteAvailable();
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    public boolean isVideoTelephonyAvailable() {
        try {
            return this.getITelephony().isVideoTelephonyAvailable();
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    public boolean isWifiCallingAvailable() {
        try {
            return this.getITelephony().isWifiCallingAvailable();
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    public void setSimOperatorNumeric(String numeric) {
        int phoneId = TelephonyManager.getDefaultPhone();
        this.setSimOperatorNumericForPhone(phoneId, numeric);
    }

    public void setSimOperatorNumericForPhone(int phoneId, String numeric) {
        TelephonyManager.setTelephonyProperty(phoneId, "gsm.sim.operator.numeric", numeric);
    }

    public void setSimOperatorName(String name) {
        int phoneId = TelephonyManager.getDefaultPhone();
        this.setSimOperatorNameForPhone(phoneId, name);
    }

    public void setSimOperatorNameForPhone(int phoneId, String name) {
        TelephonyManager.setTelephonyProperty(phoneId, "gsm.sim.operator.alpha", name);
    }

    public void setSimCountryIso(String iso) {
        int phoneId = TelephonyManager.getDefaultPhone();
        this.setSimCountryIsoForPhone(phoneId, iso);
    }

    public void setSimCountryIsoForPhone(int phoneId, String iso) {
        TelephonyManager.setTelephonyProperty(phoneId, "gsm.sim.operator.iso-country", iso);
    }

    public void setSimState(String state) {
        int phoneId = TelephonyManager.getDefaultPhone();
        this.setSimStateForPhone(phoneId, state);
    }

    public void setSimStateForPhone(int phoneId, String state) {
        TelephonyManager.setTelephonyProperty(phoneId, "gsm.sim.state", state);
    }

    public void setBasebandVersion(String version) {
        int phoneId = TelephonyManager.getDefaultPhone();
        this.setBasebandVersionForPhone(phoneId, version);
    }

    public void setBasebandVersionForPhone(int phoneId, String version) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            String prop = "gsm.version.baseband" + (phoneId == 0 ? "" : Integer.toString(phoneId));
            SystemProperties.set(prop, version);
        }
    }

    public void setPhoneType(int type) {
        int phoneId = TelephonyManager.getDefaultPhone();
        this.setPhoneType(phoneId, type);
    }

    public void setPhoneType(int phoneId, int type) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            TelephonyManager.setTelephonyProperty(phoneId, "gsm.current.phone-type", String.valueOf(type));
        }
    }

    public String getOtaSpNumberSchema(String defaultValue) {
        int phoneId = TelephonyManager.getDefaultPhone();
        return this.getOtaSpNumberSchemaForPhone(phoneId, defaultValue);
    }

    public String getOtaSpNumberSchemaForPhone(int phoneId, String defaultValue) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            return TelephonyManager.getTelephonyProperty(phoneId, "ro.cdma.otaspnumschema", defaultValue);
        }
        return defaultValue;
    }

    public boolean getSmsReceiveCapable(boolean defaultValue) {
        int phoneId = TelephonyManager.getDefaultPhone();
        return this.getSmsReceiveCapableForPhone(phoneId, defaultValue);
    }

    public boolean getSmsReceiveCapableForPhone(int phoneId, boolean defaultValue) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            return Boolean.valueOf(TelephonyManager.getTelephonyProperty(phoneId, "telephony.sms.receive", String.valueOf(defaultValue)));
        }
        return defaultValue;
    }

    public boolean getSmsSendCapable(boolean defaultValue) {
        int phoneId = TelephonyManager.getDefaultPhone();
        return this.getSmsSendCapableForPhone(phoneId, defaultValue);
    }

    public boolean getSmsSendCapableForPhone(int phoneId, boolean defaultValue) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            return Boolean.valueOf(TelephonyManager.getTelephonyProperty(phoneId, "telephony.sms.send", String.valueOf(defaultValue)));
        }
        return defaultValue;
    }

    public void setNetworkOperatorName(String name) {
        int phoneId = TelephonyManager.getDefaultPhone();
        this.setNetworkOperatorNameForPhone(phoneId, name);
    }

    public void setNetworkOperatorNameForPhone(int phoneId, String name) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            TelephonyManager.setTelephonyProperty(phoneId, "gsm.operator.alpha", name);
        }
    }

    public void setNetworkOperatorNumeric(String numeric) {
        int phoneId = TelephonyManager.getDefaultPhone();
        this.setNetworkOperatorNumericForPhone(phoneId, numeric);
    }

    public void setNetworkOperatorNumericForPhone(int phoneId, String numeric) {
        TelephonyManager.setTelephonyProperty(phoneId, "gsm.operator.numeric", numeric);
    }

    public void setNetworkRoaming(boolean isRoaming) {
        int phoneId = TelephonyManager.getDefaultPhone();
        this.setNetworkRoamingForPhone(phoneId, isRoaming);
    }

    public void setNetworkRoamingForPhone(int phoneId, boolean isRoaming) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            TelephonyManager.setTelephonyProperty(phoneId, "gsm.operator.isroaming", isRoaming ? "true" : "false");
        }
    }

    public void setNetworkCountryIso(String iso) {
        int phoneId = TelephonyManager.getDefaultPhone();
        this.setNetworkCountryIsoForPhone(phoneId, iso);
    }

    public void setNetworkCountryIsoForPhone(int phoneId, String iso) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            TelephonyManager.setTelephonyProperty(phoneId, "gsm.operator.iso-country", iso);
        }
    }

    public void setDataNetworkType(int type) {
        int phoneId = TelephonyManager.getDefaultPhone();
        this.setDataNetworkTypeForPhone(phoneId, type);
    }

    public void setDataNetworkTypeForPhone(int phoneId, int type) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            TelephonyManager.setTelephonyProperty(phoneId, "gsm.network.type", ServiceState.rilRadioTechnologyToString(type));
        }
    }

    public int getSubIdForPhoneAccount(PhoneAccount phoneAccount) {
        int retval = -1;
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                retval = service.getSubIdForPhoneAccount(phoneAccount);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return retval;
    }

    public void factoryReset(int subId) {
        try {
            Log.d(TAG, "factoryReset: subId=" + subId);
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.factoryReset(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public String getLocaleFromDefaultSim() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getLocaleFromDefaultSim();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    public void requestModemActivityInfo(ResultReceiver result) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.requestModemActivityInfo(result);
                return;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getModemActivityInfo", e);
        }
        result.send(0, null);
    }

    public ServiceState getServiceStateForSubscriber(int subId) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getServiceStateForSubscriber(subId, this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getServiceStateForSubscriber", e);
        }
        return null;
    }

    public Uri getVoicemailRingtoneUri(PhoneAccountHandle accountHandle) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getVoicemailRingtoneUri(accountHandle);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getVoicemailRingtoneUri", e);
        }
        return null;
    }

    public boolean isVoicemailVibrationEnabled(PhoneAccountHandle accountHandle) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.isVoicemailVibrationEnabled(accountHandle);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isVoicemailVibrationEnabled", e);
        }
        return false;
    }

    static {
        multiSimConfig = SystemProperties.get("persist.radio.multisim.config");
        sInstance = new TelephonyManager();
        EXTRA_STATE_IDLE = PhoneConstants.State.IDLE.toString();
        EXTRA_STATE_RINGING = PhoneConstants.State.RINGING.toString();
        EXTRA_STATE_OFFHOOK = PhoneConstants.State.OFFHOOK.toString();
        sKernelCmdLine = TelephonyManager.getProcCmdLine();
        sProductTypePattern = Pattern.compile("\\sproduct_type\\s*=\\s*(\\w+)");
        sLteOnCdmaProductType = SystemProperties.get("telephony.lteOnCdmaProductType", "");
    }

    public static enum MultiSimVariants {
        DSDS,
        DSDA,
        TSTS,
        UNKNOWN;

    }

    public static interface WifiCallingChoices {
        public static final int ALWAYS_USE = 0;
        public static final int ASK_EVERY_TIME = 1;
        public static final int NEVER_USE = 2;
    }
}

