/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.AsyncTask;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.IllegalFormatException;
import java.util.Locale;

public class Log {
    private static final String TAG = "TelecomFramework";
    public static final boolean FORCE_LOGGING = false;
    public static final boolean DEBUG = Log.isLoggable(3);
    public static final boolean INFO = Log.isLoggable(4);
    public static final boolean VERBOSE = Log.isLoggable(2);
    public static final boolean WARN = Log.isLoggable(5);
    public static final boolean ERROR = Log.isLoggable(6);
    private static MessageDigest sMessageDigest;
    private static final Object sMessageDigestLock;

    private Log() {
    }

    public static void initMd5Sum() {
        new AsyncTask<Void, Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void doInBackground(Void ... args) {
                MessageDigest md;
                try {
                    md = MessageDigest.getInstance("SHA-1");
                }
                catch (NoSuchAlgorithmException e) {
                    md = null;
                }
                Object object = sMessageDigestLock;
                synchronized (object) {
                    sMessageDigest = md;
                }
                return null;
            }
        }.execute(new Void[0]);
    }

    public static boolean isLoggable(int level) {
        return android.util.Log.isLoggable(TAG, level);
    }

    public static void d(String prefix, String format, Object ... args) {
        if (DEBUG) {
            android.util.Log.d(TAG, Log.buildMessage(prefix, format, args));
        }
    }

    public static void d(Object objectPrefix, String format, Object ... args) {
        if (DEBUG) {
            android.util.Log.d(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args));
        }
    }

    public static void i(String prefix, String format, Object ... args) {
        if (INFO) {
            android.util.Log.i(TAG, Log.buildMessage(prefix, format, args));
        }
    }

    public static void i(Object objectPrefix, String format, Object ... args) {
        if (INFO) {
            android.util.Log.i(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args));
        }
    }

    public static void v(String prefix, String format, Object ... args) {
        if (VERBOSE) {
            android.util.Log.v(TAG, Log.buildMessage(prefix, format, args));
        }
    }

    public static void v(Object objectPrefix, String format, Object ... args) {
        if (VERBOSE) {
            android.util.Log.v(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args));
        }
    }

    public static void w(String prefix, String format, Object ... args) {
        if (WARN) {
            android.util.Log.w(TAG, Log.buildMessage(prefix, format, args));
        }
    }

    public static void w(Object objectPrefix, String format, Object ... args) {
        if (WARN) {
            android.util.Log.w(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args));
        }
    }

    public static void e(String prefix, Throwable tr, String format, Object ... args) {
        if (ERROR) {
            android.util.Log.e(TAG, Log.buildMessage(prefix, format, args), tr);
        }
    }

    public static void e(Object objectPrefix, Throwable tr, String format, Object ... args) {
        if (ERROR) {
            android.util.Log.e(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args), tr);
        }
    }

    public static void wtf(String prefix, Throwable tr, String format, Object ... args) {
        android.util.Log.wtf(TAG, Log.buildMessage(prefix, format, args), tr);
    }

    public static void wtf(Object objectPrefix, Throwable tr, String format, Object ... args) {
        android.util.Log.wtf(TAG, Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args), tr);
    }

    public static void wtf(String prefix, String format, Object ... args) {
        String msg = Log.buildMessage(prefix, format, args);
        android.util.Log.wtf(TAG, msg, new IllegalStateException(msg));
    }

    public static void wtf(Object objectPrefix, String format, Object ... args) {
        String msg = Log.buildMessage(Log.getPrefixFromObject(objectPrefix), format, args);
        android.util.Log.wtf(TAG, msg, new IllegalStateException(msg));
    }

    public static String pii(Object pii) {
        if (pii == null || VERBOSE) {
            return String.valueOf(pii);
        }
        if (pii instanceof Uri) {
            return Log.piiUri((Uri)pii);
        }
        return "[" + Log.secureHash(String.valueOf(pii).getBytes()) + "]";
    }

    private static String piiUri(Uri handle) {
        String value;
        StringBuilder sb = new StringBuilder();
        String scheme = handle.getScheme();
        if (!TextUtils.isEmpty(scheme)) {
            sb.append(scheme).append(":");
        }
        if (!TextUtils.isEmpty(value = handle.getSchemeSpecificPart())) {
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (PhoneNumberUtils.isStartsPostDial(c)) {
                    sb.append(c);
                    continue;
                }
                if (PhoneNumberUtils.isDialable(c)) {
                    sb.append("*");
                    continue;
                }
                if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z') {
                    sb.append("*");
                    continue;
                }
                sb.append(c);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String secureHash(byte[] input) {
        Object object = sMessageDigestLock;
        synchronized (object) {
            if (sMessageDigest != null) {
                sMessageDigest.reset();
                sMessageDigest.update(input);
                byte[] result = sMessageDigest.digest();
                return Log.encodeHex(result);
            }
            return "Uninitialized SHA1";
        }
    }

    private static String encodeHex(byte[] bytes) {
        StringBuffer hex = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            int byteIntValue = bytes[i] & 0xFF;
            if (byteIntValue < 16) {
                hex.append("0");
            }
            hex.append(Integer.toString(byteIntValue, 16));
        }
        return hex.toString();
    }

    private static String getPrefixFromObject(Object obj) {
        return obj == null ? "<null>" : obj.getClass().getSimpleName();
    }

    private static String buildMessage(String prefix, String format, Object ... args) {
        String msg;
        try {
            msg = args == null || args.length == 0 ? format : String.format(Locale.US, format, args);
        }
        catch (IllegalFormatException ife) {
            Log.wtf("Log", (Throwable)ife, "IllegalFormatException: formatString='%s' numArgs=%d", format, args.length);
            msg = format + " (An error occurred while formatting the message.)";
        }
        return String.format(Locale.US, "%s: %s", prefix, msg);
    }

    static {
        sMessageDigestLock = new Object();
    }
}

