/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.Parcelable;

public class PatternMatcher
implements Parcelable {
    public static final int PATTERN_LITERAL = 0;
    public static final int PATTERN_PREFIX = 1;
    public static final int PATTERN_SIMPLE_GLOB = 2;
    private final String mPattern;
    private final int mType;
    public static final Parcelable.Creator<PatternMatcher> CREATOR = new Parcelable.Creator<PatternMatcher>(){

        @Override
        public PatternMatcher createFromParcel(Parcel source) {
            return new PatternMatcher(source);
        }

        public PatternMatcher[] newArray(int size) {
            return new PatternMatcher[size];
        }
    };

    public PatternMatcher(String pattern, int type) {
        this.mPattern = pattern;
        this.mType = type;
    }

    public String getPath() {
        return this.mPattern;
    }

    public int getType() {
        return this.mType;
    }

    public boolean match(String str) {
        return PatternMatcher.matchPattern(this.mPattern, str, this.mType);
    }

    public String toString() {
        String type = "? ";
        switch (this.mType) {
            case 0: {
                type = "LITERAL: ";
                break;
            }
            case 1: {
                type = "PREFIX: ";
                break;
            }
            case 2: {
                type = "GLOB: ";
            }
        }
        return "PatternMatcher{" + type + this.mPattern + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mPattern);
        dest.writeInt(this.mType);
    }

    public PatternMatcher(Parcel src) {
        this.mPattern = src.readString();
        this.mType = src.readInt();
    }

    static boolean matchPattern(String pattern, String match, int type) {
        if (match == null) {
            return false;
        }
        if (type == 0) {
            return pattern.equals(match);
        }
        if (type == 1) {
            return match.startsWith(pattern);
        }
        if (type != 2) {
            return false;
        }
        int NP = pattern.length();
        if (NP <= 0) {
            return match.length() <= 0;
        }
        int NM = match.length();
        int ip = 0;
        int im = 0;
        char nextChar = pattern.charAt(0);
        while (ip < NP && im < NM) {
            boolean escaped;
            char c = nextChar;
            nextChar = ++ip < NP ? pattern.charAt(ip) : (char)'\u0000';
            boolean bl = escaped = c == '\\';
            if (escaped) {
                c = nextChar;
                char c2 = nextChar = ++ip < NP ? pattern.charAt(ip) : (char)'\u0000';
            }
            if (nextChar == '*') {
                if (!escaped && c == '.') {
                    if (ip >= NP - 1) {
                        return true;
                    }
                    if ((nextChar = pattern.charAt(++ip)) == '\\') {
                        char c3 = nextChar = ++ip < NP ? pattern.charAt(ip) : (char)'\u0000';
                    }
                    while (match.charAt(im) != nextChar && ++im < NM) {
                    }
                    if (im == NM) {
                        return false;
                    }
                    nextChar = ++ip < NP ? pattern.charAt(ip) : (char)'\u0000';
                    ++im;
                    continue;
                }
                while (match.charAt(im) == c && ++im < NM) {
                }
                nextChar = ++ip < NP ? pattern.charAt(ip) : (char)'\u0000';
                continue;
            }
            if (c != '.' && match.charAt(im) != c) {
                return false;
            }
            ++im;
        }
        if (ip >= NP && im >= NM) {
            return true;
        }
        return ip == NP - 2 && pattern.charAt(ip) == '.' && pattern.charAt(ip + 1) == '*';
    }
}

